/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ocf.tizen.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tizen.ocf.core.model.json.Meta;
import org.tizen.ocf.core.model.json.PropDesc;
import org.tizen.ocf.core.model.json.ResDesc;
import org.tizen.ocf.core.model.json.Restriction;

public class MetaMap {
    private Meta meta;
    private HashMap<String, ResDesc> resDescMap;
    private HashMap<String, HashMap<String, PropDesc>> propDescMap;
    private HashMap<String, HashMap<String, List<Restriction>>> restrictionsMap;

    public MetaMap(Meta meta) {
        this.meta = meta;
        this.resDescMap = this.makeResDescMap();
        this.propDescMap = this.makePropDescMap();
        this.restrictionsMap = this.makeRestrictionsMap();
    }

    private HashMap<String, ResDesc> makeResDescMap() {
        HashMap<String, ResDesc> resourceDescMap = new HashMap<String, ResDesc>();
        for (ResDesc resDesc : this.meta.getResDesc()) {
            resourceDescMap.put(resDesc.getResourceUri(), resDesc);
        }
        return resourceDescMap;
    }

    private HashMap<String, HashMap<String, PropDesc>> makePropDescMap() {
        HashMap<String, HashMap<String, PropDesc>> propertyDescMap = new HashMap<String, HashMap<String, PropDesc>>();
        for (PropDesc propDesc : this.meta.getPropDesc()) {
            HashMap<Object, Object> innerMap;
            String uri = propDesc.getResourceUri();
            String prop = propDesc.getProperty();
            if (!propertyDescMap.containsKey(uri)) {
                innerMap = new HashMap();
                propertyDescMap.put(uri, innerMap);
            } else {
                innerMap = propertyDescMap.get(uri);
            }
            innerMap.put(prop, propDesc);
        }
        return propertyDescMap;
    }

    private HashMap<String, HashMap<String, List<Restriction>>> makeRestrictionsMap() {
        HashMap<String, HashMap<String, List<Restriction>>> restrictionMap = new HashMap<String, HashMap<String, List<Restriction>>>();
        for (Restriction restriction : this.meta.getRestrictions()) {
            List<Restriction> restrictions;
            HashMap<Object, Object> innerMap;
            String uri = restriction.getResourceUri();
            String prop = restriction.getProperty();
            if (!restrictionMap.containsKey(uri)) {
                innerMap = new HashMap();
                restrictionMap.put(uri, innerMap);
            } else {
                innerMap = restrictionMap.get(uri);
            }
            if (!innerMap.containsKey(prop)) {
                restrictions = new ArrayList();
                innerMap.put(prop, restrictions);
            } else {
                restrictions = (List)innerMap.get(prop);
            }
            restrictions.add(restriction);
        }
        return restrictionMap;
    }

    public String getResDesc(String uri) {
        if (this.resDescMap.get(uri) != null) {
            return this.resDescMap.get(uri).getDesc();
        }
        return null;
    }

    public String getPropDesc(String uri, String prop) {
        if (this.propDescMap.get(uri) != null && this.propDescMap.get(uri).get(prop) != null) {
            return this.propDescMap.get(uri).get(prop).getDesc();
        }
        return null;
    }

    public List<Restriction> getRestrictions(String uri, String prop) {
        if (this.restrictionsMap.get(uri) != null && this.restrictionsMap.get(uri).get(prop) != null) {
            return this.restrictionsMap.get(uri).get(prop);
        }
        return null;
    }
}

