/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ocf.tizen.codegen;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FilenameUtil;
import org.tizen.ocf.core.codegen.ICodeGeneratorNew;
import org.tizen.ocf.core.model.json.DeviceModel;
import org.tizen.ocf.core.model.json.FilePath;
import org.tizen.ocf.core.model.json.MasterModel;
import org.tizen.ocf.core.model.json.ResourceModel;
import org.tizen.ocf.core.util.ResourceUtil;
import org.tizen.ocf.tizen.codegen.DeviceDataProxy;
import org.tizen.ocf.tizen.codegen.LeaveDeviceDefinition;
import org.tizen.ocf.tizen.codegen.template.datamodel.CFileData;
import org.tizen.ocf.tizen.codegen.template.datamodel.DeviceData;
import org.tizen.ocf.tizen.codegen.template.datamodel.ResourceData;
import org.tizen.ocf.tizen.exception.UnknownPropertyTypeException;

public class TizenCodeGeneratorNew
implements ICodeGeneratorNew {
    private static final Logger logger = LoggerFactory.getLogger(TizenCodeGeneratorNew.class);

    public Map<IFile, Boolean> generateCode(IProject project, DeviceModel deviceModel, IProgressMonitor monitor) {
        LinkedHashMap<IFile, Boolean> generatedFileMap = new LinkedHashMap<IFile, Boolean>();
        if (project != null && project.exists()) {
            IFolder incFolder;
            try {
                this.processBackup(project, monitor);
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage());
            }
            IFolder srcFolder = project.getFolder("src");
            if (srcFolder == null || !srcFolder.exists()) {
                try {
                    srcFolder.create(true, true, monitor);
                    monitor.worked(1);
                }
                catch (CoreException coreException) {
                    return generatedFileMap;
                }
            }
            if ((incFolder = project.getFolder("inc")) == null || !incFolder.exists()) {
                try {
                    incFolder.create(true, true, monitor);
                    monitor.worked(1);
                }
                catch (CoreException coreException) {
                    return generatedFileMap;
                }
            }
            this.ensureFilename(project, deviceModel);
            try {
                String[] filenames;
                generatedFileMap.putAll(this.generateDeviceDefJsonFile(project, deviceModel, monitor));
                Configuration conf = new Configuration(Configuration.VERSION_2_3_26);
                conf.setClassForTemplateLoading(TizenCodeGeneratorNew.class, "/org/tizen/ocf/tizen/codegen/templates_new/");
                conf.setDefaultEncoding("UTF-8");
                conf.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
                conf.setLogTemplateExceptions(false);
                DeviceDataProxy templateDataProxy = new DeviceDataProxy("device_def.json", deviceModel);
                DeviceData deviceData = templateDataProxy.get();
                String[] stringArray = filenames = new String[]{"main.c", "thing_master_user.h", "thing_master_user.c", "thing_resource_user.h", "thing_resource_user.c", "log.h"};
                int n = filenames.length;
                int n2 = 0;
                while (n2 < n) {
                    String filename = stringArray[n2];
                    String mainFilename = null;
                    mainFilename = filename == "main.c" ? String.valueOf(project.getName().toLowerCase()) + ".c" : filename;
                    IFile out_file = srcFolder.getFile(mainFilename);
                    String ext = FilenameUtil.getExtension((String)filename);
                    if (ext.equals("h")) {
                        out_file = incFolder.getFile(mainFilename);
                    }
                    this.ensureEmptyFile(out_file, monitor);
                    Template tpl = conf.getTemplate(String.valueOf(filename) + ".tpl");
                    String filecomment = this.getFilecomment(out_file);
                    CFileData cFileData = new CFileData(deviceData, filecomment);
                    this.processTemplate(tpl, cFileData, out_file, monitor);
                    ++n2;
                }
                Template tpl = conf.getTemplate("resource.c.tpl");
                for (ResourceData resourceData : deviceData.getResourceDatas()) {
                    if (!resourceData.needHandlers()) continue;
                    String filename = resourceData.getResourceHandlerFilename();
                    IFile out_file = srcFolder.getFile(filename);
                    this.ensureEmptyFile(out_file, monitor);
                    String filecomment = this.getFilecomment(out_file);
                    CFileData cFileData = new CFileData(resourceData, filecomment);
                    this.processTemplate(tpl, cFileData, out_file, monitor);
                    generatedFileMap.put(out_file, true);
                }
            }
            catch (CoreException coreException) {
                return generatedFileMap;
            }
            catch (TemplateException e) {
                e.printStackTrace();
                return generatedFileMap;
            }
            catch (IOException e) {
                e.printStackTrace();
                return generatedFileMap;
            }
            monitor.done();
        }
        return generatedFileMap;
    }

    public Map<IFile, Boolean> generateDeviceDefJsonFile(IProject project, DeviceModel deviceModel, IProgressMonitor monitor) {
        LinkedHashMap<IFile, Boolean> generatedFileMap;
        block20: {
            generatedFileMap = new LinkedHashMap<IFile, Boolean>();
            IFile masterJsonFile = this.getGeneratedMasterJsonFile(project);
            IFile resourceJsonFile = this.getGeneratedResourceJsonFile(project);
            if (masterJsonFile == null) {
                logger.error("Master json file does not exist.");
                return generatedFileMap;
            }
            if (resourceJsonFile == null) {
                logger.error("Resource json file does not exist.");
                return generatedFileMap;
            }
            Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new LeaveDeviceDefinition()}).setPrettyPrinting().create();
            MasterModel masterModel = new MasterModel();
            ResourceUtil.generateMasterFromDeviceModel((MasterModel)masterModel, (DeviceModel)deviceModel);
            ResourceModel resourceModel = new ResourceModel();
            ResourceUtil.generateResourceFromDeviceModel((ResourceModel)resourceModel, (DeviceModel)deviceModel);
            ByteArrayInputStream is = null;
            try {
                try {
                    is = new ByteArrayInputStream(gson.toJson((Object)deviceModel).getBytes());
                    is = new ByteArrayInputStream(gson.toJson((Object)masterModel).getBytes());
                    if (masterJsonFile.exists()) {
                        masterJsonFile.setContents((InputStream)is, true, true, monitor);
                    } else {
                        masterJsonFile.create((InputStream)is, true, monitor);
                    }
                    generatedFileMap.put(masterJsonFile, false);
                    is = new ByteArrayInputStream(gson.toJson((Object)resourceModel).getBytes());
                    if (resourceJsonFile.exists()) {
                        resourceJsonFile.setContents((InputStream)is, true, true, monitor);
                    } else {
                        resourceJsonFile.create((InputStream)is, true, monitor);
                    }
                    generatedFileMap.put(resourceJsonFile, false);
                }
                catch (CoreException e) {
                    logger.error(e.getLocalizedMessage());
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return generatedFileMap;
    }

    private boolean processBackup(IProject project, IProgressMonitor monitor) throws UnknownPropertyTypeException {
        IFile masterJsonFile = this.getGeneratedMasterJsonFile(project);
        IFile resourceJsonFile = this.getGeneratedResourceJsonFile(project);
        if (masterJsonFile != null && masterJsonFile.exists() && resourceJsonFile != null && resourceJsonFile.exists()) {
            IFolder appFolder;
            DeviceDataProxy templateDataProxy;
            DeviceData deviceData;
            ResourceModel resourceModel;
            MasterModel masterModel;
            DeviceModel deviceModel;
            File masterFile = ResourceUtil.iFileToFile((IFile)masterJsonFile);
            File resourceFile = ResourceUtil.iFileToFile((IFile)resourceJsonFile);
            if (masterFile != null && resourceFile != null && (deviceModel = ResourceUtil.genrateDeviceModelFromMasterAndResource((MasterModel)(masterModel = ResourceUtil.masterModelFromJson((File)masterFile)), (ResourceModel)(resourceModel = ResourceUtil.resourceModelFromJson((File)resourceFile)))) != null && (deviceData = (templateDataProxy = new DeviceDataProxy("device_def.json", deviceModel)).get()) != null && (appFolder = project.getFolder("src")) != null && appFolder.exists()) {
                ArrayList<String> buf = new ArrayList<String>();
                String main = deviceData.getMainFilename();
                buf.add(main);
                String master = deviceData.getMasterJsonFilename();
                buf.add(master);
                String rsrc = deviceData.getResourceJsonFilename();
                buf.add(rsrc);
                ArrayList<ResourceData> resourceDatas = deviceData.getResourceDatas();
                for (ResourceData resourceData : resourceDatas) {
                    String resource = resourceData.getResourceHandlerFilename();
                    buf.add(resource);
                }
                for (String fileName : buf) {
                    IFile file = appFolder.getFile(fileName);
                    if (file == null || !file.exists()) continue;
                    IPath path = file.getFullPath();
                    path = path.addFileExtension("bak");
                    IFile bakFile = project.getWorkspace().getRoot().getFile(path);
                    InputStream is = null;
                    try {
                        try {
                            if (bakFile != null && bakFile.exists()) {
                                is = file.getContents();
                                bakFile.setContents(is, true, true, monitor);
                            } else {
                                file.move(path, true, true, monitor);
                            }
                        }
                        catch (CoreException e) {
                            logger.error(e.getLocalizedMessage());
                            if (is == null) continue;
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return true;
        }
        return false;
    }

    private void ensureEmptyFile(IFile file, IProgressMonitor monitor) throws CoreException {
        ByteArrayInputStream is = new ByteArrayInputStream("".getBytes());
        if (file.exists()) {
            file.setContents((InputStream)is, true, true, monitor);
        } else {
            file.create((InputStream)is, true, monitor);
        }
    }

    private String getFilecomment(IFile file) throws CoreException {
        ITranslationUnit tu = CoreModelUtil.findTranslationUnit((IFile)file);
        return CodeGeneration.getFileComment((ITranslationUnit)tu, (String)"\n");
    }

    private void processTemplate(Template tpl, Object data, IFile file, IProgressMonitor monitor) throws TemplateException, IOException, CoreException {
        StringWriter out = new StringWriter();
        tpl.process(data, (Writer)out);
        ByteArrayInputStream is = new ByteArrayInputStream(((Object)out).toString().getBytes());
        if (file.exists()) {
            file.setContents((InputStream)is, true, true, monitor);
        } else {
            file.create((InputStream)is, true, monitor);
        }
    }

    public IFile getGeneratedDeviceDefJsonFile(IProject project) {
        if (project == null) {
            return null;
        }
        return project.getFile("res" + File.separator + "device_def.json");
    }

    private void ensureFilename(IProject project, DeviceModel deviceModel) {
        FilePath filepath = deviceModel.getConfiguration().getFilePath();
        deviceModel.getConfiguration().setFilePath(filepath);
    }

    public IFile getGeneratedMasterJsonFile(IProject project) {
        if (project == null) {
            return null;
        }
        return project.getFile("shared/res" + File.separator + "master.json");
    }

    public IFile getGeneratedResourceJsonFile(IProject project) {
        if (project == null) {
            return null;
        }
        return project.getFile("shared/res" + File.separator + "resource.json");
    }
}

