/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ocf.tizen.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.tizen.ocf.core.ui.dialog.util.SWTUtil;
import org.tizen.ocf.core.util.EclipseResourceUtil;
import org.tizen.ocf.tizen.ui.wizard.TizenCodeGenerationWizard;

public class SmartThingsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IProject project = EclipseResourceUtil.getCurrentProject();
        if (project == null) {
            throw new ExecutionException("Selected project is null");
        }
        final IWorkbench workbench = EclipseResourceUtil.getWorkbench();
        if (workbench == null) {
            throw new ExecutionException("Active workbench is null");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell activeShell = SWTUtil.getActiveShell();
                try {
                    TizenCodeGenerationWizard wizard = new TizenCodeGenerationWizard(activeShell, project);
                    wizard.init(workbench, (IStructuredSelection)new StructuredSelection((Object[])new IProject[]{project}));
                    WizardDialog dialog = new WizardDialog(activeShell, (IWizard)wizard);
                    dialog.create();
                    dialog.open();
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)activeShell, (String)"Error", (String)e.getLocalizedMessage());
                }
            }
        };
        SWTUtil.syncExec((Runnable)runnable);
        return null;
    }
}

