/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.DownloadProgressMonitor;
import org.tizen.manager.util.Downloader;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PathUtil;

public class SnapshotLog {
    private static final Logger logger = Log.getLogger(SnapshotLog.class);
    private String snapshotLog;
    private String SNAPSHOT_LOG_FILE_SUFFIX = ".log";
    private String SNAPSHOT_LOG_FILE_DIRECTORY = "changes";
    private String repository = null;

    public SnapshotLog(String repo) {
        this.repository = repo;
    }

    public String getSnapshotLog(String snapshot) throws UMException {
        String snapshotLogFileName = snapshot + this.SNAPSHOT_LOG_FILE_SUFFIX;
        if (this.downloadSnapshotLog(snapshotLogFileName)) {
            logger.trace("\tSuccess to load " + snapshotLogFileName);
            return this.snapshotLog;
        }
        logger.error("Fail to load " + snapshotLogFileName + "(Ignore it)");
        return null;
    }

    private boolean downloadSnapshotLog(String snapshotLogFileName) throws UMException {
        long size;
        File tmp = null;
        try {
            tmp = File.createTempFile("snapshotLog", ".log");
            tmp.deleteOnExit();
        }
        catch (IOException e) {
            logger.throwing(e);
            return false;
        }
        URL distInfoFileURL = this.getSnapshotLogFilePath(this.repository, snapshotLogFileName);
        try {
            Downloader downloader = new Downloader(distInfoFileURL);
            size = downloader.download(tmp.getAbsolutePath(), new DownloadProgressMonitor());
        }
        catch (UMException e) {
            logger.throwing(e);
            return false;
        }
        if (size <= 0L) {
            return false;
        }
        String snapshotLogText = PathUtil.readAllTextFromFile(tmp.getAbsolutePath(), true);
        if (snapshotLogText.isEmpty()) {
            this.snapshotLog = "Thers is no log information about " + snapshotLogFileName;
            logger.trace("\tThers is no log information about " + snapshotLogFileName);
        } else {
            this.snapshotLog = snapshotLogText;
        }
        if (tmp.exists() && !tmp.delete()) {
            logger.error("Fail to delete file ==> " + tmp);
        }
        return true;
    }

    private URL getSnapshotLogFilePath(String repo, String snapshotName) {
        String snapshotLogFilePath = NetworkUtil.getURL(repo, this.SNAPSHOT_LOG_FILE_DIRECTORY, snapshotName);
        try {
            return new URL(snapshotLogFilePath);
        }
        catch (MalformedURLException e) {
            logger.error("Cannot connect snapshot log file in repository(" + snapshotLogFilePath + ")");
            return null;
        }
    }
}

