/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.pkg;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.model.Property;
import org.tizen.manager.pkg.PackageVersion;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PlatformUtil;

public class Package {
    static final String FIELD_PACKAGE = "Package";
    static final String FIELD_VERSION = "Version";
    static final String FIELD_LABEL = "Label";
    private static final String FIELD_OS = "OS";
    private static final String FIELD_BUILD_HOST_OS = "Build-host-os";
    private static final String FIELD_BUILD_DEPENDENCY = "Build-dependency";
    private static final String FIELD_SOURCE_DEPENDENCY = "Source-dependency";
    private static final String FIELD_MAINTAINER = "Maintainer";
    private static final String FIELD_DESCRIPTION = "Description";
    private static final String FIELD_DEPENDS = "Install-dependency";
    private static final String FIELD_CONFLICTS = "Conflicts";
    static final String FIELD_PACKAGE_SIZE = "Size";
    static final String FIELD_UNCOMPRESSED_SIZE = "Uncompressed-size";
    static final String FIELD_ATTRIBUTE = "Attribute";
    private static final String FIELD_SHA256 = "SHA256";
    private static final String FIELD_FILE_PATH = "Path";
    private static final String FIELD_ORDER = "C-Order";
    private static final String FIELD_DEFAULT = "C-Default";
    private static final String FIELD_LICENSE = "C-License-Text";
    private static final String FIELD_VISIBLE = "C-Visible";
    private static final String FIELD_FORMATTED_DESC = "C-Formatted-Description";
    private static final String FIELD_EXT_NAME = "C-ExtName";
    private static final String FIELD_EXT_PLATFORM = "C-Platform";
    private static final String FIELD_EXT_PROFILE = "C-Profile";
    private static final String FIELD_EXT_DEVENV = "C-DevelopEnv";
    private static final String FIELD_EXT_PATH = "C-ExtPath";
    private static final String INSTALL_SCRIPT_LINUX = "install.sh";
    private static final String REMOVE_SCRIPT_LINUX = "remove.sh";
    private static final String INSTALL_SCRIPT_WINDOWS = "Install.bat";
    private static final String REMOVE_SCRIPT_WINDOWS = "Remove.bat";
    private static final String FIELD_EXTENSION_SERVER = "Extension-server";
    private static final String ATTRIBUTE_ROOT_META = "root";
    private static final String ATTRIBUTE_EXTRA_META = "extra";
    private static final String ATTRIBUTE_INSTALL_META = "install";
    private static final String ATTRIBUTE_TEST_META = "test";
    private static final String ATTRIBUTE_PROFILE = "profile";
    private static final String START_OF_OS_DEPENDENCY = "[";
    private ArrayList<Property> mProperties;
    private URL baseURL = null;
    private URL url;
    private static final int LOWEST_ORDER = 100;
    private static final String FIELD_PREREQUISITES = "C-Prerequisites";
    private static final Logger logger = Log.getLogger(Package.class);
    private static final String FIELD_SELECTED_GROUP = "C-SelectedGroup";
    private static final String FIELD_UNSELECTED_GROUP = "C-UnSelectedGroup";
    private static final String FIELD_PROFILE_TYPE = "C-Profile-Type";
    private static final String PROFILE_TYPE_MOBILE = "mobile";
    private static final String PROFILE_TYPE_WEARABLE = "wearable";
    private static final String PROFILE_TYPE_TV = "tv";
    private static final String FIELD_ADVANCED = "C-Advanced";
    private static final String ADVANCED_TRUE = "true";
    private static final String FIELD_EXTENSION_PARENT = "C-Extension-Parent";

    Package(ArrayList<Property> properties) {
        this.mProperties = properties;
    }

    Package(ArrayList<Property> properties, String repoBaseUrl) {
        this(properties);
        try {
            this.baseURL = new URL(repoBaseUrl);
            this.url = new URL(NetworkUtil.getURL(repoBaseUrl, this.getValue(FIELD_FILE_PATH)));
        }
        catch (MalformedURLException e) {
            logger.error("Invalid package url: " + NetworkUtil.getURL(repoBaseUrl, this.getValue(FIELD_FILE_PATH)));
        }
    }

    public void setProperties(ArrayList<Property> properties) {
        this.mProperties = properties;
    }

    public PackageVersion getVersion() {
        String version = this.getValue(FIELD_VERSION);
        if (version == null || version.isEmpty()) {
            List<Property> props = this.getProperties();
            for (Property p : props) {
                if (!p.getName().equalsIgnoreCase(FIELD_VERSION)) continue;
                p.setValue("0.0.0");
            }
        }
        return new PackageVersion(this.getValue(FIELD_VERSION));
    }

    public String getPackageName() {
        return this.getValue(FIELD_PACKAGE);
    }

    public String getLabel() {
        return this.getValue(FIELD_LABEL);
    }

    public String getMaintainer() {
        return this.getValue(FIELD_MAINTAINER);
    }

    public String getLicense() {
        return this.getValue(FIELD_LICENSE);
    }

    public Long getPackageSize() {
        long result = 0L;
        try {
            result = Long.parseLong(this.getValue(FIELD_PACKAGE_SIZE));
        }
        catch (NumberFormatException e) {
            logger.error(this.toString() + " size does not exist.");
        }
        return result;
    }

    public Long getUncompressedPackageSize() {
        long result = 0L;
        try {
            result = Long.parseLong(this.getValue(FIELD_UNCOMPRESSED_SIZE));
        }
        catch (NumberFormatException e) {
            result = 0L;
        }
        return result;
    }

    public String getFileName() {
        return this.getValue(FIELD_FILE_PATH);
    }

    public String getDescription() {
        return this.getValue(FIELD_DESCRIPTION);
    }

    public String getSHA256() {
        return this.getValue(FIELD_SHA256);
    }

    public URL getURL() {
        return this.url;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public String getExtensionServer() {
        return this.getValue(FIELD_EXTENSION_SERVER);
    }

    public void setExtensionServer(String extensionServer) {
        Property property = this.getProperty(FIELD_EXTENSION_SERVER);
        if (property != null) {
            property.setValue(extensionServer);
        } else {
            property = new Property();
            property.setName(FIELD_EXTENSION_SERVER);
            property.setValue(extensionServer);
            this.mProperties.add(property);
        }
    }

    public int getOrder() {
        String order = this.getValue(FIELD_ORDER);
        if (order.equals("")) {
            return 100;
        }
        int nOrder = 0;
        try {
            nOrder = Integer.parseInt(order);
        }
        catch (NumberFormatException e) {
            logger.error("C-Order field value is not a integer format.");
            return 100;
        }
        return nOrder;
    }

    public String getRemoveScript() {
        if (PlatformUtil.CURRENT_PLATFORM == 1 || PlatformUtil.CURRENT_PLATFORM == 4 || PlatformUtil.CURRENT_PLATFORM == 64 || PlatformUtil.CURRENT_PLATFORM == 32) {
            return REMOVE_SCRIPT_LINUX;
        }
        if (PlatformUtil.CURRENT_PLATFORM == 8 || PlatformUtil.CURRENT_PLATFORM == 16) {
            return REMOVE_SCRIPT_WINDOWS;
        }
        if (PlatformUtil.CURRENT_PLATFORM == 64) {
            return "";
        }
        return null;
    }

    public String getInstallScript() {
        if (PlatformUtil.isUbuntu() || PlatformUtil.isMacOS()) {
            return INSTALL_SCRIPT_LINUX;
        }
        if (PlatformUtil.isWindows()) {
            return INSTALL_SCRIPT_WINDOWS;
        }
        return null;
    }

    public List<Property> getProperties() {
        return this.mProperties;
    }

    private Property getProperty(String key) {
        if (this.mProperties != null && key != null) {
            for (int i = 0; i < this.mProperties.size(); ++i) {
                if (key.compareTo(this.mProperties.get(i).getName()) != 0) continue;
                return this.mProperties.get(i);
            }
        }
        return null;
    }

    private String getValue(String propertyName) {
        for (Property prop : this.mProperties) {
            if (!prop.getName().equalsIgnoreCase(propertyName)) continue;
            return prop.getValue();
        }
        return "";
    }

    public String getAttribute() {
        return this.getValue(FIELD_ATTRIBUTE);
    }

    public String getFormattedDescription() {
        return this.getValue(FIELD_FORMATTED_DESC);
    }

    public String getExtensionName() {
        return this.getValue(FIELD_EXT_NAME);
    }

    public String getExtensionPlatform() {
        return this.getValue(FIELD_EXT_PLATFORM);
    }

    public String getExtensionProfile() {
        return this.getValue(FIELD_EXT_PROFILE);
    }

    public String getExtensionDevEnv() {
        return this.getValue(FIELD_EXT_DEVENV);
    }

    public String getExtensionPath() {
        return this.getValue(FIELD_EXT_PATH);
    }

    public boolean isMeta() {
        return this.isRootMeta() || this.isInstallMeta() || this.isExtraMeta() || this.isProfileMeta();
    }

    public boolean isRootMeta() {
        String attributeValue = this.getAttribute().trim();
        return attributeValue.equalsIgnoreCase(ATTRIBUTE_ROOT_META);
    }

    public boolean isExtraMeta() {
        String attributeValue = this.getAttribute().trim();
        return attributeValue.equalsIgnoreCase(ATTRIBUTE_EXTRA_META);
    }

    public boolean isInstallMeta() {
        String attributeValue = this.getAttribute().trim();
        return attributeValue.equalsIgnoreCase(ATTRIBUTE_INSTALL_META);
    }

    public boolean isTestMeta() {
        String attributeValue = this.getAttribute().trim();
        return attributeValue.equalsIgnoreCase(ATTRIBUTE_TEST_META);
    }

    public boolean isProfileMeta() {
        String attributeValue = this.getAttribute().trim();
        return attributeValue.equalsIgnoreCase(ATTRIBUTE_PROFILE);
    }

    public boolean isDefault() {
        if (this.getValue(FIELD_DEFAULT).equalsIgnoreCase(ADVANCED_TRUE)) {
            return true;
        }
        if (this.getValue(FIELD_DEFAULT).equalsIgnoreCase("false")) {
            return false;
        }
        return false;
    }

    public boolean isVisible() {
        if (this.getValue(FIELD_VISIBLE).equalsIgnoreCase(ADVANCED_TRUE)) {
            return true;
        }
        return !this.getValue(FIELD_VISIBLE).equalsIgnoreCase("false");
    }

    boolean hasLicense() {
        return !this.getValue(FIELD_LICENSE).isEmpty() && !this.getValue(FIELD_LICENSE).equals("");
    }

    public boolean isExtensionPackage() {
        String extensionServer = this.getExtensionServer();
        return extensionServer != null && !extensionServer.isEmpty();
    }

    public Collection<String> getDependentPackageNames() {
        HashSet<String> depends = new HashSet<String>();
        String dependsStr = this.getValue(FIELD_DEPENDS);
        String[] deps = dependsStr.split(",");
        for (int i = 0; i < deps.length; ++i) {
            String dep = this.removeOSInformationOfDepends(deps[i]);
            if (dep.isEmpty()) continue;
            depends.add(dep);
        }
        return depends;
    }

    public Collection<String> getDefaultDependentPackageNames() {
        HashSet<String> depends = new HashSet<String>();
        String dependsStr = this.getValue(FIELD_DEFAULT);
        String[] deps = dependsStr.split(",");
        for (int i = 0; i < deps.length; ++i) {
            String dep = this.removeOSInformationOfDepends(deps[i]);
            if (dep.isEmpty()) continue;
            depends.add(dep);
        }
        return depends;
    }

    public boolean hasDependencyOn(Package pkg) {
        for (String depPkgName : this.getDependentPackageNames()) {
            if (!pkg.getPackageName().equals(depPkgName)) continue;
            return true;
        }
        return false;
    }

    private String removeOSInformationOfDepends(String info) {
        if (info.contains(START_OF_OS_DEPENDENCY)) {
            int index = info.indexOf(START_OF_OS_DEPENDENCY);
            String pkgInfo = info.substring(0, index).trim();
            return pkgInfo;
        }
        return info.trim();
    }

    public Collection<String> getOS() {
        HashSet<String> osSet = new HashSet<String>();
        String osStr = this.getValue(FIELD_OS);
        String[] osSplit = osStr.split(",");
        for (int i = 0; i < osSplit.length; ++i) {
            String os = osSplit[i].trim();
            if (os.isEmpty()) continue;
            osSet.add(os);
        }
        return osSet;
    }

    public String getBuildHostOS() {
        return this.getValue(FIELD_BUILD_HOST_OS).trim();
    }

    public Collection<String> getBuildDependency() {
        HashSet<String> buildDependencySet = new HashSet<String>();
        String buildDependencyStr = this.getValue(FIELD_BUILD_DEPENDENCY);
        String[] buildDependencySplit = buildDependencyStr.split(",");
        for (int i = 0; i < buildDependencySplit.length; ++i) {
            String dependency = buildDependencySplit[i].trim();
            if (dependency.isEmpty()) continue;
            buildDependencySet.add(dependency);
        }
        return buildDependencySet;
    }

    public Collection<String> getSourcedDependency() {
        HashSet<String> sourceDependencySet = new HashSet<String>();
        String sourceDependencyStr = this.getValue(FIELD_SOURCE_DEPENDENCY);
        String[] sourceDependencySplit = sourceDependencyStr.split(",");
        for (int i = 0; i < sourceDependencySplit.length; ++i) {
            String dependency = sourceDependencySplit[i].trim();
            if (dependency.isEmpty()) continue;
            sourceDependencySet.add(dependency);
        }
        return sourceDependencySet;
    }

    public Collection<String> getConflictPackageNames() {
        HashSet<String> conflicts = new HashSet<String>();
        String conflictsStr = this.getValue(FIELD_CONFLICTS);
        String[] confs = conflictsStr.split(",");
        for (int i = 0; i < confs.length; ++i) {
            conflicts.add(confs[i].trim());
        }
        return conflicts;
    }

    public String toString() {
        return this.getPackageName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Package) {
            Package pkg2 = (Package)obj;
            return this.getPackageName().equals(pkg2.getPackageName());
        }
        return false;
    }

    public int hashCode() {
        return this.getPackageName().hashCode();
    }

    public String getPrerequisites() {
        return this.getValue(FIELD_PREREQUISITES);
    }

    public ArrayList<String> getSelectedGroupNames() {
        String[] split;
        ArrayList<String> result = new ArrayList<String>();
        String value = this.getValue(FIELD_SELECTED_GROUP);
        if (value != null && !value.isEmpty() && (split = value.split(",")) != null && split.length > 0) {
            for (String pkgName : split) {
                result.add(pkgName.trim());
            }
        }
        return result;
    }

    public String getUnSelectedGroup() {
        return this.getValue(FIELD_UNSELECTED_GROUP);
    }

    public ProfileType getProfileType() {
        String value = this.getValue(FIELD_PROFILE_TYPE);
        if (value != null) {
            if (value.equalsIgnoreCase(PROFILE_TYPE_MOBILE)) {
                return ProfileType.MOBILE;
            }
            if (value.equalsIgnoreCase(PROFILE_TYPE_WEARABLE)) {
                return ProfileType.WEARABLE;
            }
            if (value.equalsIgnoreCase(PROFILE_TYPE_TV)) {
                return ProfileType.TV;
            }
            return ProfileType.NONE;
        }
        return ProfileType.NONE;
    }

    public boolean isAdvanced() {
        String value = this.getValue(FIELD_ADVANCED);
        if (value != null) {
            return value.equalsIgnoreCase(ADVANCED_TRUE);
        }
        return false;
    }

    public String getExtensionParent() {
        return this.getValue(FIELD_EXTENSION_PARENT);
    }

    public static enum ProfileType {
        MOBILE,
        WEARABLE,
        TV,
        NONE;

    }
}

