/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.core.RepositoryManager;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.ConfigFile;
import org.tizen.manager.core.config.ProxyConfigFile;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.core.model.Distribution;
import org.tizen.manager.core.model.ImageInformation;
import org.tizen.manager.core.model.Snapshot;
import org.tizen.manager.core.model.SnapshotList;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.ComponentManager;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.svc.sdkutils.PackageInfoJSON;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.ZipLibrary;
import org.tizen.packagemanager.cli.CLIExtensions;
import org.tizen.packagemanager.cli.CLIInstallUpdateProcess;
import org.tizen.packagemanager.cli.CLIMessages;
import org.tizen.packagemanager.cli.CLIOptionUtil;
import org.tizen.packagemanager.cli.CLIOptions;
import org.tizen.packagemanager.cli.CLIUninstallProcess;
import org.tizen.packagemanager.cli.CLIUtil;

class CLICommandExecutor {
    private static final String PACKAGE_FORMAT_STATUS = "%-5s";
    private static final String PACKAGE_FORMAT_PACKAGENAME = "\t%-40s";
    private static final String PACKAGE_FORMAT_OTHER = "\t%-15s\t%-20s";
    private static String SDK_INFO_TOOLTIP = "Installed Path     : %s\nData Path          : %s\nRepository URL     : %s\nDistribution       : %s\nDistribution ID    : %s\nTarget Snapshot    : %s\nInstalled Snapshot : %s\nAuto Update        : %s";

    public void doShowHelp() {
        String readFile = "/res/document/HELP";
        StringBuilder sb = CLICommandExecutor.makeViewString(readFile);
        System.out.println();
        System.out.println(sb.toString());
    }

    public void doShowSoftwareLicenseAgreement() {
        String readFile = "/res/document/COPYING";
        StringBuilder sb = CLICommandExecutor.makeViewString(readFile);
        System.out.println();
        System.out.println(sb.toString());
    }

    public void doShowComponentLicenseAgreement(ArrayList<String> targetList, CLIOptions options) throws UMException {
        Config.getInstance().init();
        CLIUtil.loadProxySettings(options);
        RepositoryManager.getInstance().init();
        InstallController instance = InstallController.getInstance();
        instance.init();
        instance.setCLIMode(true);
        ExtRepositoryManager.getInstance().init(true);
        PackageManager pm = PackageManager.getInstance();
        pm.init(true);
        ComponentManager compMgr = ComponentManager.getInstance();
        compMgr.init();
        ArrayList<String> notPackageList = new ArrayList<String>();
        ArrayList<String> checkPackageList = new ArrayList<String>();
        for (String pkgName : targetList) {
            Package packageByName = pm.getPackageByName(pkgName);
            if (packageByName != null) {
                checkPackageList.add(pkgName);
                continue;
            }
            notPackageList.add(pkgName);
        }
        if (!notPackageList.isEmpty()) {
            System.out.println("Invalid package name : " + notPackageList);
        }
        if (!checkPackageList.isEmpty()) {
            List<String> licenseAgreementList = this.getLicenseAgreementList(pm, checkPackageList, compMgr.getComponentList());
            if (licenseAgreementList.isEmpty()) {
                System.out.println("No license agreements for " + checkPackageList);
            } else {
                for (String license : licenseAgreementList) {
                    System.out.println(license);
                    System.out.println("");
                }
            }
        }
    }

    public void doShowPackages(CLIOptions options) throws UMException {
        Config.getInstance().init();
        CLIUtil.loadProxySettings(options);
        RepositoryManager.getInstance().init();
        InstallController instance = InstallController.getInstance();
        instance.init();
        instance.setCLIMode(true);
        ExtRepositoryManager.getInstance().init(true);
        PackageManager.getInstance().init(true);
        ComponentManager.getInstance().init();
        this.displayAllPackagesDefault(true, options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.TREE));
    }

    public void doRunExtra(CLIOptions options, ArrayList<String> installList) throws UMException {
        CLIExtensions cliExtensions = new CLIExtensions();
        cliExtensions.doRunExtra(options, installList);
    }

    public void doShowInformation() throws UMException {
        Config.getInstance().init();
        if (Config.getInstance().getConfigFile().getDistributionId() == null || Config.getInstance().getConfigFile().getDistributionId().isEmpty()) {
            RepositoryManager.getInstance().init();
            InstallController instance = InstallController.getInstance();
            instance.init();
        }
        String msg = String.format(SDK_INFO_TOOLTIP, SDKInfo.getInstalledPath(), SDKInfo.getSdkDataPath(), Config.getInstance().getConfigFile().getRepository(), Config.getInstance().getConfigFile().getDistribution(), Config.getInstance().getConfigFile().getDistributionId(), Config.getInstance().getSnapshotPath(), Config.getInstance().getInstalledSnapshot(), Config.getInstance().isAutoUpdate() ? "Activated" : "Deactivated") + "\n";
        ProxyConfigFile proxyConfFile = Config.getInstance().getProxyConfig();
        if (proxyConfFile != null) {
            msg = msg + "Proxy type         : " + proxyConfFile.getProxyType() + "\n";
            if (ProxyConfigFile.ProxyType.MANUAL.toString().equals(proxyConfFile.getProxyType())) {
                msg = msg + "Proxy host         : " + proxyConfFile.getProxyHost() + "\n";
                msg = msg + "Proxy port         : " + proxyConfFile.getProxyPort() + "\n";
            }
        }
        System.out.println(msg);
    }

    public void doShowRepositoryInfo(CLIOptions options) throws Exception {
        String selectedRepository = CLIOptionUtil.getRepositoryFromOptions(options);
        String selectedFileRepository = CLIOptionUtil.getFileRepositoryFromOptions(options);
        String selectedDistribution = CLIOptionUtil.getDistributionFromOptions(options);
        String selectedSnapShot = CLIOptionUtil.getSnapshotFromOptions(options);
        boolean latest = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.LATEST);
        String limitString = options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.LIMIT);
        int limit = -1;
        boolean showTree = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.TREE);
        if (limitString != null && !limitString.isEmpty()) {
            limit = Integer.valueOf(limitString);
        }
        if (selectedRepository != null && !selectedRepository.isEmpty()) {
            System.out.println("Selected repository :" + selectedRepository);
            System.out.println("Selected distribution :" + selectedDistribution);
            System.out.println("Selected snapshot :" + selectedSnapShot);
            this.showRepositoryInfoByNetwork(selectedRepository, selectedDistribution, selectedSnapShot, latest, limit, showTree);
        } else if (selectedFileRepository != null && !selectedFileRepository.isEmpty()) {
            System.out.println("Selected repository :" + selectedFileRepository);
            selectedFileRepository = this.removeFileUrl(selectedFileRepository);
            File imageFile = new File(selectedFileRepository);
            if (imageFile.exists()) {
                String unzipTargetDir = this.unzipPackageInfo(imageFile);
                Config.getInstance().setServerType(Config.ServerType.LOCAL);
                PackageManager packageManager = PackageManager.getInstance();
                packageManager.reloadPackageInfo(NetworkUtil.getFileURL(unzipTargetDir), true);
                ComponentManager.getInstance().init();
                this.displayAllPackagesDefault(false, showTree);
                Config.getInstance().setServerType(Config.ServerType.SNAPSHOT);
            } else {
                System.out.println("Image file not exits.");
                System.out.println("File =>  " + imageFile.getAbsolutePath());
            }
        } else {
            System.out.println("Error : No selected repository.");
            System.out.println("Usage: show-repo-info -r <address> [-d <distribution>] [--limit <number>|--latest|-s <snapshot>] [--proxy <value>]");
        }
    }

    public void doRunUninstall(CLIOptions options, ArrayList<String> installList) throws Exception {
        Config.getInstance().init();
        CLIUtil.loadProxySettings(options);
        RepositoryManager.getInstance().init();
        InstallController instance = InstallController.getInstance();
        instance.init();
        instance.setCLIMode(true);
        ExtRepositoryManager.getInstance().init(true);
        PackageManager.getInstance().init(true);
        ComponentManager.getInstance().init();
        PackageSet installedMetaPackageList = PackageManager.getInstance().getInstalledMetaPackagesSync();
        if (installedMetaPackageList != null && !installedMetaPackageList.isEmpty()) {
            CLIUninstallProcess cliUninstallProcess = new CLIUninstallProcess();
            if (options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.PACKAGE_ALL)) {
                boolean removeAllOnConsole = cliUninstallProcess.removeAllOnConsole(false);
                if (removeAllOnConsole) {
                    InstallController.getInstance().removeSDKLegacyCLI(false);
                    InstallController.removeShortcutMenu();
                    if (SDKInfo.isExistKeystoreDirectory()) {
                        String dataName = PathUtil.getFileName(SDKInfo.getSdkDataPath());
                        System.out.println("\n" + String.format("* info : Except \"%s\" which contains the certificate files,\nall the other directories and files have been deleted in \"%s\".\nWe recommend you to back up the certificate files for future use.", PathUtil.get("..", dataName, "keystore"), PathUtil.get("..", dataName)));
                    }
                    System.out.println("Thank you for using Tizen Studio!");
                }
            } else {
                cliUninstallProcess.removeOnConsole(installList);
            }
        } else {
            System.out.println("Installed packages does not exist.");
        }
    }

    public void doRunUpdate(CLIOptions options) throws Exception {
        String selectedFileRepository = CLIOptionUtil.getFileRepositoryFromOptions(options);
        Config.getInstance().init();
        InstallController instance = InstallController.getInstance();
        instance.init();
        instance.setCLIMode(true);
        if (options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.PASSWORD) != null) {
            instance.setUserPassword(options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.PASSWORD));
        } else if (options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.PASSWORD_SHORT) != null) {
            instance.setUserPassword(options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.PASSWORD_SHORT));
        }
        if (selectedFileRepository != null && !selectedFileRepository.isEmpty()) {
            File imageFile = new File(selectedFileRepository = this.removeFileUrl(selectedFileRepository));
            if (!imageFile.exists()) {
                throw new UMException(ErrorController.ErrorCode.SDK_IMAGE_FILE_NOT_FOUND, selectedFileRepository);
            }
            String unzipTargetDir = this.extractImageInfoFile(imageFile);
            ImageInformation imgInfo = new ImageInformation(unzipTargetDir);
            imgInfo.loadImageInfo();
            String repoURL = imgInfo.getValue("origin");
            String distName = imgInfo.getValue("distribution");
            String distID = imgInfo.getValue("distribution_id");
            String installedDistID = Config.getInstance().getConfigFile().getDistributionId();
            URL installedUrl = new URL(NetworkUtil.getURL(Config.getInstance().getConfigFile().getRepository(), Config.getInstance().getConfigFile().getDistribution()));
            URL inputUrl = new URL(NetworkUtil.getURL(repoURL, distName));
            if (inputUrl.equals(installedUrl)) {
                this.validateUpdateImage(selectedFileRepository, unzipTargetDir);
            } else if (!distID.isEmpty() && !installedDistID.isEmpty() && distID.equals(installedDistID)) {
                this.validateUpdateImage(selectedFileRepository, unzipTargetDir);
            } else {
                System.out.println("Selected SDK Image is not from installed Repository.");
                System.out.println("Installed : " + inputUrl);
                System.out.println("Installed : " + installedUrl);
                return;
            }
            this.reloadPackageInfoFromImage(imageFile, unzipTargetDir, repoURL, distName, distID);
        } else {
            CLIUtil.loadProxySettings(options);
            ConfigFile configFile = Config.getInstance().getConfigFile();
            this.validateUpdateNetwork(options);
            boolean isAutoUpdate = true;
            isAutoUpdate = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.LATEST) ? true : configFile.isAutoUpdate();
            ExtRepositoryManager.getInstance().init(true);
            this.reloadPackageInfoFromServer(configFile.getRepository(), configFile.getDistribution(), configFile.getSnapshotPath(), isAutoUpdate);
        }
        ComponentManager.getInstance().init();
        CLIInstallUpdateProcess cliInstallProcess = new CLIInstallUpdateProcess(options);
        cliInstallProcess.updateAllOnConsole();
    }

    private void validateUpdateNetwork(CLIOptions options) throws MalformedURLException, UMException {
        URL installedUrl;
        URL inputUrl;
        String selectedRepository = CLIOptionUtil.getRepositoryFromOptions(options);
        String selectedDistribution = CLIOptionUtil.getDistributionFromOptions(options);
        String selectedSnapshots = CLIOptionUtil.getSnapshotFromOptions(options);
        if (selectedRepository == null || selectedRepository.isEmpty()) {
            selectedRepository = Config.getInstance().getConfigFile().getRepository();
        }
        if (selectedDistribution == null || selectedDistribution.isEmpty()) {
            selectedDistribution = Config.getInstance().getConfigFile().getDistribution();
        }
        if (!(inputUrl = new URL(NetworkUtil.getURL(selectedRepository, selectedDistribution))).equals(installedUrl = new URL(NetworkUtil.getURL(Config.getInstance().getConfigFile().getRepository(), Config.getInstance().getConfigFile().getDistribution())))) {
            ConfigFile configFile = Config.getInstance().getConfigFile();
            String installedDistributionID = configFile.getDistributionId();
            if (installedDistributionID == null || installedDistributionID.isEmpty()) {
                RepositoryManager.getInstance().refresh();
                Distribution installedDistribution = RepositoryManager.getInstance().getDistributionByName(configFile.getDistribution());
                installedDistributionID = installedDistribution.getID();
            }
            PackageManager.getInstance().init(false);
            PackageSet installedPackages = (PackageSet)PackageManager.getInstance().getInstalledPackages().clone();
            this.getSnapshotFromRemote(selectedRepository, selectedDistribution, selectedSnapshots);
            Distribution targetDistribution = RepositoryManager.getInstance().getDistributionByName(configFile.getDistribution());
            String targetDistributionID = targetDistribution.getID();
            if (installedDistributionID != null && !installedDistributionID.isEmpty() && targetDistributionID != null && !targetDistributionID.isEmpty()) {
                if (targetDistributionID.equals(installedDistributionID)) {
                    for (Package installedPkg : installedPackages) {
                        Package destPackage = PackageManager.getInstance().getPackageByName(installedPkg.getPackageName());
                        if (destPackage.getVersion().compareTo(installedPkg.getVersion()) >= 0) continue;
                        throw new UMException(ErrorController.ErrorCode.INVALID_REPOSITORY_VERSION);
                    }
                }
            } else {
                throw new UMException(ErrorController.ErrorCode.DIFFERENT_REPOSITORY_USED);
            }
        }
    }

    private void validateUpdateImage(String selectedFileRepository, String unzipTargetDir) throws UMException {
        PackageManager packageManager = PackageManager.getInstance();
        packageManager.init(false);
        PackageSet installedPackages = (PackageSet)packageManager.getInstalledPackages().clone();
        packageManager.reloadPackageInfo(NetworkUtil.getFileURL(unzipTargetDir), true);
        for (Package installedPkg : installedPackages) {
            Package destPackage = packageManager.getPackageByName(installedPkg.getPackageName());
            if (destPackage.getVersion().compareTo(installedPkg.getVersion()) >= 0) continue;
            System.out.println("Can not update SDK using => " + selectedFileRepository);
            throw new UMException(ErrorController.ErrorCode.INVALID_IMAGE_FILE_VERSION);
        }
    }

    public void doRunInstall(CLIOptions options, ArrayList<String> installList) throws Exception {
        String selectedFileRepository = CLIOptionUtil.getFileRepositoryFromOptions(options);
        Config.getInstance().init();
        CLIUtil.loadProxySettings(options);
        InstallController instance = InstallController.getInstance();
        instance.init();
        instance.setCLIMode(true);
        if (options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.PASSWORD) != null) {
            instance.setUserPassword(options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.PASSWORD));
        } else if (options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.PASSWORD_SHORT) != null) {
            instance.setUserPassword(options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.PASSWORD_SHORT));
        }
        if (selectedFileRepository != null && !selectedFileRepository.isEmpty()) {
            File imageFile = new File(selectedFileRepository = this.removeFileUrl(selectedFileRepository));
            if (!imageFile.exists()) {
                throw new UMException(ErrorController.ErrorCode.SDK_IMAGE_FILE_NOT_FOUND, selectedFileRepository);
            }
            String unzipTargetDir = this.extractImageInfoFile(imageFile);
            ImageInformation imgInfo = new ImageInformation(unzipTargetDir);
            imgInfo.loadImageInfo();
            String repoURL = imgInfo.getValue("origin");
            String distName = imgInfo.getValue("distribution");
            String distID = imgInfo.getValue("distribution_id");
            String installedDistID = Config.getInstance().getConfigFile().getDistributionId();
            URL installedUrl = new URL(NetworkUtil.getURL(Config.getInstance().getConfigFile().getRepository(), Config.getInstance().getConfigFile().getDistribution()));
            URL inputUrl = new URL(NetworkUtil.getURL(repoURL, distName));
            if (inputUrl.equals(installedUrl)) {
                this.validateVersionImage(options, installList, unzipTargetDir);
            } else if (!distID.isEmpty() && !installedDistID.isEmpty() && distID.equals(installedDistID)) {
                this.validateVersionImage(options, installList, unzipTargetDir);
            } else {
                if (!options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.REMOVE_INSTALLED_SDK)) {
                    this.printUseRemoveOldSDKOption();
                    return;
                }
                int count = this.getPackageCountFromImage(installList, unzipTargetDir, true);
                if (count == 0) {
                    System.out.println(installList + " are not in selected respository.");
                    throw new UMException(ErrorController.ErrorCode.INVALID_OPTION_USED);
                }
                ComponentManager.getInstance().init();
                this.removeOldSDK();
            }
            this.reloadPackageInfoFromImage(imageFile, unzipTargetDir, repoURL, distName, distID);
        } else {
            URL installedUrl;
            String selectedRepository = CLIOptionUtil.getRepositoryFromOptions(options);
            String selectedDistribution = CLIOptionUtil.getDistributionFromOptions(options);
            String selectedSnapshots = CLIOptionUtil.getSnapshotFromOptions(options);
            if (selectedRepository == null || selectedRepository.isEmpty()) {
                selectedRepository = Config.getInstance().getConfigFile().getRepository();
            }
            if (selectedDistribution == null || selectedDistribution.isEmpty()) {
                selectedDistribution = Config.getInstance().getConfigFile().getDistribution();
            }
            Snapshot selectedSnapshot = null;
            URL inputUrl = new URL(NetworkUtil.getURL(selectedRepository, selectedDistribution));
            if (inputUrl.equals(installedUrl = new URL(NetworkUtil.getURL(Config.getInstance().getConfigFile().getRepository(), Config.getInstance().getConfigFile().getDistribution())))) {
                String installedSnapshot = Config.getInstance().getConfigFile().getInstalledSnapshot();
                PackageManager.getInstance().init(false);
                PackageSet installedPackages = (PackageSet)PackageManager.getInstance().getInstalledPackages().clone();
                selectedSnapshot = this.getSnapshotFromRemote(selectedRepository, selectedDistribution, selectedSnapshots);
                if (!(selectedSnapshots == null || selectedSnapshots.isEmpty() || installedSnapshot == null || installedSnapshot.isEmpty() || installedSnapshot.contains(selectedSnapshots))) {
                    boolean refreshOnly = true;
                    for (Package installedPkg : installedPackages) {
                        Package destPackage = PackageManager.getInstance().getPackageByName(installedPkg.getPackageName());
                        if (destPackage.getVersion().compareTo(installedPkg.getVersion()) >= 0) continue;
                        refreshOnly = false;
                        break;
                    }
                    if (!refreshOnly) {
                        if (!options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.REMOVE_INSTALLED_SDK)) {
                            this.printUseRemoveOldSDKOption();
                            return;
                        }
                        this.checkAndUninstallOldSDK(installList);
                    }
                }
            } else {
                ConfigFile configFile = Config.getInstance().getConfigFile();
                String installedDistributionID = configFile.getDistributionId();
                if (installedDistributionID == null || installedDistributionID.isEmpty()) {
                    RepositoryManager.getInstance().refresh();
                    Distribution installedDistribution = RepositoryManager.getInstance().getDistributionByName(configFile.getDistribution());
                    installedDistributionID = installedDistribution.getID();
                }
                PackageManager.getInstance().init(false);
                PackageSet installedPackages = (PackageSet)PackageManager.getInstance().getInstalledPackages().clone();
                Config.getInstance().getConfigFile().setRepository(selectedRepository);
                Config.getInstance().getConfigFile().setDistribution(selectedDistribution);
                selectedSnapshot = this.getSnapshotFromRemote(selectedRepository, selectedDistribution, selectedSnapshots);
                Distribution targetDistribution = RepositoryManager.getInstance().getDistributionByName(configFile.getDistribution());
                String targetDistributionID = targetDistribution.getID();
                if (installedDistributionID != null && !installedDistributionID.isEmpty() && targetDistributionID != null && !targetDistributionID.isEmpty()) {
                    if (!targetDistributionID.equals(installedDistributionID)) {
                        if (!options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.REMOVE_INSTALLED_SDK)) {
                            this.printUseRemoveOldSDKOption();
                            return;
                        }
                        this.checkAndUninstallOldSDK(installList);
                    } else {
                        boolean refreshOnly = true;
                        for (Package installedPkg : installedPackages) {
                            Package destPackage = PackageManager.getInstance().getPackageByName(installedPkg.getPackageName());
                            if (destPackage.getVersion().compareTo(installedPkg.getVersion()) >= 0) continue;
                            refreshOnly = false;
                            break;
                        }
                        if (!refreshOnly) {
                            if (!options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.REMOVE_INSTALLED_SDK)) {
                                this.printUseRemoveOldSDKOption();
                                return;
                            }
                            this.checkAndUninstallOldSDK(installList);
                        }
                    }
                } else {
                    if (!options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.REMOVE_INSTALLED_SDK)) {
                        this.printUseRemoveOldSDKOption();
                        return;
                    }
                    this.checkAndUninstallOldSDK(installList);
                }
            }
            ExtRepositoryManager.getInstance().init(true);
            this.reloadPackageInfoFromServer(selectedRepository, selectedDistribution, selectedSnapshot.getPath(), Config.getInstance().getConfigFile().isAutoUpdate());
        }
        ComponentManager.getInstance().init();
        CLIInstallUpdateProcess cliInstallProcess = new CLIInstallUpdateProcess(options);
        cliInstallProcess.installOnConsole(installList);
    }

    private void validateVersionImage(CLIOptions options, ArrayList<String> installList, String unzipTargetDir) throws UMException, Exception {
        boolean refreshOnly = true;
        PackageManager packageManager = PackageManager.getInstance();
        packageManager.init(false);
        PackageSet installedPackages = (PackageSet)packageManager.getInstalledPackages().clone();
        packageManager.reloadPackageInfo(NetworkUtil.getFileURL(unzipTargetDir), true);
        for (Package installedPkg : installedPackages) {
            Package destPackage = packageManager.getPackageByName(installedPkg.getPackageName());
            if (destPackage.getVersion().compareTo(installedPkg.getVersion()) >= 0) continue;
            refreshOnly = false;
            break;
        }
        if (!refreshOnly) {
            if (!options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.REMOVE_INSTALLED_SDK)) {
                this.printUseRemoveOldSDKOption();
                throw new UMException(ErrorController.ErrorCode.INVALID_OPTION_USED);
            }
            int count = this.getPackageCountFromImage(installList, unzipTargetDir, false);
            if (count == 0) {
                System.out.println(installList + " are not in selected respository.");
                throw new UMException(ErrorController.ErrorCode.INVALID_OPTION_USED);
            }
            ComponentManager.getInstance().init();
            this.removeOldSDK();
        }
    }

    private void checkAndUninstallOldSDK(ArrayList<String> installList) throws UMException, Exception {
        this.validateRemoteRepoContainsPackages(installList);
        ComponentManager.getInstance().init();
        this.removeOldSDK();
    }

    private void validateRemoteRepoContainsPackages(ArrayList<String> installList) throws UMException {
        int count = 0;
        for (String pNameInList : installList) {
            Package packageByName = PackageManager.getInstance().getPackageByName(pNameInList);
            if (packageByName == null) continue;
            ++count;
            break;
        }
        if (count == 0) {
            throw new UMException(ErrorController.ErrorCode.INTERNAL_ERROR, installList + " are not in respository.");
        }
    }

    private Snapshot getSnapshotFromRemote(String selectedRepository, String selectedDistribution, String selectedSnapshots) throws UMException {
        Snapshot selectedSnapshot = null;
        RepositoryManager repositoryController = RepositoryManager.getInstance();
        repositoryController.refresh();
        SnapshotList snapshotList = repositoryController.getSnapshotList(selectedDistribution);
        if (snapshotList != null && !snapshotList.isEmpty()) {
            if (selectedSnapshots != null && !selectedSnapshots.isEmpty()) {
                for (Snapshot snapshot : snapshotList) {
                    if (!selectedSnapshots.trim().equals(snapshot.getName())) continue;
                    selectedSnapshot = snapshot;
                    break;
                }
            }
            if (selectedSnapshot == null) {
                selectedSnapshot = repositoryController.getLatestSnapshot(selectedDistribution);
                Config.getInstance().getConfigFile().setAutoUpdate(true);
            } else {
                Config.getInstance().getConfigFile().setAutoUpdate(false);
            }
        } else {
            String errorMessage = "Selected repository  : " + selectedRepository + ", " + "Selected distribution  : " + selectedDistribution;
            errorMessage = errorMessage + "\nis not avaliable.";
            throw new UMException(ErrorController.ErrorCode.INTERNAL_ERROR, errorMessage);
        }
        Config.getInstance().getConfigFile().setSnapshotPath(selectedSnapshot.getPath());
        Config.getInstance().getConfigFile().setRepository(selectedRepository);
        Config.getInstance().getConfigFile().setDistribution(selectedDistribution);
        PackageManager.getInstance().reloadPackageInfo(NetworkUtil.getURL(selectedRepository, selectedDistribution), true);
        return selectedSnapshot;
    }

    private int getPackageCountFromImage(ArrayList<String> installList, String unzipTargetDir, boolean reload) {
        int count = 0;
        PackageManager packageManager = PackageManager.getInstance();
        if (reload) {
            packageManager.reloadPackageInfo(NetworkUtil.getFileURL(unzipTargetDir), true);
        }
        for (String pNameInList : installList) {
            Package packageByName = packageManager.getPackageByName(pNameInList);
            if (packageByName == null) continue;
            ++count;
            break;
        }
        return count;
    }

    private String extractImageInfoFile(File imageFile) throws UMException {
        String unzipTargetDir = PathUtil.get(Config.getManagerConfigHome(), "image-cache", imageFile.getName());
        ZipLibrary zlpLibrary = null;
        try {
            zlpLibrary = new ZipLibrary(imageFile.getAbsolutePath(), null);
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add("image.info");
            fileNames.add(PackageManager.getPackageListFileName());
            zlpLibrary.unzipSelectedList(unzipTargetDir, fileNames);
        }
        catch (Exception e) {
            throw new UMException(ErrorController.ErrorCode.FAIL_TO_EXTRACT_SDK_IMAGE_FILE);
        }
        finally {
            if (zlpLibrary != null) {
                zlpLibrary.close();
            }
        }
        return unzipTargetDir;
    }

    private String removeFileUrl(String selectedFileRepository) {
        if (selectedFileRepository.startsWith("file://")) {
            selectedFileRepository = selectedFileRepository.replace("file://", "");
        }
        return selectedFileRepository;
    }

    private void printUseRemoveOldSDKOption() {
        System.out.println("Please, set the same repository, distribution and snapshot.");
        System.out.println(CLIMessages.ASK_TO_USER_SERVER_CHANGE);
    }

    private void reloadPackageInfoFromImage(File imageFile, String unzipTargetDir, String repoURL, String distName, String distId) throws UMException {
        RepositoryManager.getInstance().setImageFileName(imageFile.getAbsolutePath());
        RepositoryManager.getInstance().setCurrentDistribution(distName);
        RepositoryManager.getInstance().setServerType(Config.ServerType.LOCAL);
        Config.getInstance().setServerType(Config.ServerType.LOCAL);
        Config.getInstance().saveSnapshotSettings(unzipTargetDir, distName, "", repoURL, distId, true);
        Config.getInstance().saveConfig();
        SDKInfo.save(false);
        String repositoryURL = Config.getInstance().getDistributionURL();
        PackageManager.getInstance().reloadPackageInfo(repositoryURL, true);
    }

    private void reloadPackageInfoFromServer(String repository, String distribution, String snapshot, boolean isUpdateRequired) throws UMException {
        Config.getInstance().setServerType(Config.ServerType.SNAPSHOT);
        Config.getInstance().saveSnapshotSettings(repository, distribution, snapshot, null, null, isUpdateRequired);
        Config.getInstance().saveConfig();
        SDKInfo.save(false);
        String repositoryURL = Config.getInstance().getDistributionURL();
        PackageManager.getInstance().reloadPackageInfo(repositoryURL, true);
    }

    private void removeOldSDK() throws Exception {
        System.out.println("Remove old sdk start.");
        CLIUninstallProcess cup = new CLIUninstallProcess();
        cup.removeAllOnConsole(true);
        InstallController.getInstance().removeSDKLegacyCLI(true);
        System.out.println("Remove old sdk end.");
    }

    void displayAllPackagesDefault(boolean displayStatus, boolean showTree) {
        ComponentManager compMgr = ComponentManager.getInstance();
        List<Component> mainTreeComponents = compMgr.getComponentList();
        if (mainTreeComponents != null && !mainTreeComponents.isEmpty()) {
            String secondTab = "";
            if (showTree) {
                secondTab = "\t\t";
            }
            System.out.println();
            String title = String.format("%-5s\t%-40s" + secondTab + PACKAGE_FORMAT_OTHER, "Status", "Package Name", "Package Version", "Component Name");
            System.out.println(title);
            System.out.println("------------------------------------------------------------------------------------------------------------------------");
            for (Component component : mainTreeComponents) {
                if (!component.hasChildren() || component.getParent() != null) continue;
                this.displayChildPackageDefault(component, displayStatus, showTree, 0);
            }
        } else {
            System.out.println("No Packages.");
        }
    }

    private void displayChildPackageDefault(Component component, boolean displayStatus, boolean usingTab, int count) {
        this.displayPackage(component, displayStatus, usingTab, count);
        int currentCount = ++count;
        ArrayList<Component> children = component.getChildren();
        for (Component childItem : children) {
            if (childItem.hasChildren()) {
                this.displayChildPackageDefault(childItem, displayStatus, usingTab, currentCount);
                continue;
            }
            this.displayPackage(childItem, displayStatus, usingTab, currentCount);
        }
    }

    private void displayPackage(Component component, boolean displayStatus, boolean usingTab, int count) {
        String status = "";
        if (displayStatus) {
            switch (component.getInstallState()) {
                case INSTALL: {
                    status = "ni";
                    break;
                }
                case UPDATE: {
                    status = "u";
                    break;
                }
                case UNINSTALL: {
                    status = "i";
                    break;
                }
            }
        }
        String tab = "";
        String secondTab = "";
        if (usingTab && count > 0) {
            for (int i = 0; i < count; ++i) {
                tab = tab + "\t";
            }
        }
        if (usingTab && count == 0) {
            secondTab = "\t\t";
        }
        if (usingTab && count == 1) {
            secondTab = "\t";
        }
        if (usingTab && count == 2) {
            secondTab = "";
        }
        String format = String.format(PACKAGE_FORMAT_STATUS + tab + PACKAGE_FORMAT_PACKAGENAME + secondTab + PACKAGE_FORMAT_OTHER, status, component.getPackageName(), component.getRecentPackage().getVersion(), component.getDisplayName());
        System.out.println(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder makeViewString(String resourceNameToRead) {
        StringBuilder sb = new StringBuilder();
        String read = "";
        BufferedReader bufferedReader = null;
        try {
            int width = 240;
            bufferedReader = new BufferedReader(new InputStreamReader(CLICommandExecutor.class.getResourceAsStream(resourceNameToRead), "UTF-8"));
            while ((read = bufferedReader.readLine()) != null) {
                int lineLength = read.length();
                if (lineLength > width) {
                    int currentStart = 0;
                    int currentEnd = width;
                    while (currentStart != currentEnd) {
                        String substring = read.substring(currentStart, currentEnd);
                        sb.append(substring + "\n");
                        currentStart = currentEnd;
                        currentEnd = lineLength - currentEnd >= width ? currentStart + width : lineLength;
                    }
                    continue;
                }
                sb.append(read + "\n");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String unzipPackageInfo(File imageFile) {
        String unzipTargetDir = PathUtil.get(Config.getManagerConfigHome(), "image-cache", imageFile.getName());
        ZipLibrary zlpLibrary = null;
        try {
            zlpLibrary = new ZipLibrary(imageFile.getAbsolutePath(), null);
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add("image.info");
            fileNames.add(PackageManager.getPackageListFileName());
            zlpLibrary.unzipSelectedList(unzipTargetDir, fileNames);
        }
        catch (UMException uMException) {
        }
        finally {
            if (zlpLibrary != null) {
                zlpLibrary.close();
            }
        }
        return unzipTargetDir;
    }

    private void showRepositoryInfoByNetwork(String selectedRepository, String selectedDistribution, String selectedSnapShot, boolean latest, int limit, boolean showTree) {
        Config.getInstance().getConfigFile().setRepository(selectedRepository);
        RepositoryManager repositoryController = RepositoryManager.getInstance();
        repositoryController.refresh();
        if (selectedDistribution != null && !selectedDistribution.isEmpty()) {
            if (selectedSnapShot != null && !selectedSnapShot.isEmpty()) {
                this.displayAllComponentWithSelectedSnapShot(selectedDistribution, selectedRepository, selectedSnapShot, repositoryController, showTree);
            } else if (latest) {
                this.displayLatestSnapshots(selectedDistribution, repositoryController);
            } else {
                this.displayAllSnapshots(selectedDistribution, repositoryController, limit);
            }
        } else {
            this.displayDistribution(repositoryController);
        }
    }

    private void displayAllComponentWithSelectedSnapShot(String selectedDistribution, String selectedRepository, String selectedSnapShot, RepositoryManager repositoryController, boolean showTree) {
        SnapshotList snapshotList = repositoryController.getSnapshotList(selectedDistribution);
        if (snapshotList != null && !snapshotList.isEmpty()) {
            boolean isInDistribution = false;
            String snapshotPath = "";
            for (Snapshot snapshot : snapshotList) {
                if (!snapshot.getName().equals(selectedSnapShot)) continue;
                isInDistribution = true;
                snapshotPath = snapshot.getPath();
            }
            if (isInDistribution) {
                Config.getInstance().getConfigFile().setRepository(selectedRepository);
                Config.getInstance().getConfigFile().setDistribution(selectedDistribution);
                Config.getInstance().getConfigFile().setSnapshotPath(snapshotPath);
                Config.getInstance().getConfigFile().setAutoUpdate(false);
                PackageManager packageManager = PackageManager.getInstance();
                packageManager.reloadPackageInfo(NetworkUtil.getURL(selectedRepository, selectedDistribution), true);
                ComponentManager.getInstance().init();
                this.displayAllPackagesDefault(false, showTree);
            } else {
                System.out.println("Selected snapshot is not exists.");
            }
        } else {
            System.out.println("Selected distribution is not exists.");
        }
    }

    private void displayLatestSnapshots(String selectedDistribution, RepositoryManager repositoryController) {
        Snapshot latestSnapshot = repositoryController.getLatestSnapshot(selectedDistribution);
        System.out.println("* " + latestSnapshot);
    }

    private void displayAllSnapshots(String selectedDistribution, RepositoryManager repositoryController, int limit) {
        SnapshotList allSnapshots = repositoryController.getSnapshotList(selectedDistribution);
        if (allSnapshots != null && !allSnapshots.isEmpty()) {
            if (limit <= 0) {
                System.out.println("#### Snapshot List ####");
                for (Snapshot snapshot : allSnapshots) {
                    System.out.println("* " + snapshot);
                }
            } else {
                for (int i = 0; i < limit; ++i) {
                    System.out.println("* " + allSnapshots.get(i));
                }
            }
        } else {
            System.out.println("Error : There are no snapshots. Please, check your options.");
        }
    }

    private void displayDistribution(RepositoryManager instance) {
        List<String> distributions = instance.getDistributionList();
        if (distributions != null && !distributions.isEmpty()) {
            System.out.println("#### Distribution List ####");
            for (String distribution : distributions) {
                System.out.println("* " + distribution);
            }
        } else {
            System.out.println("Error : Invalid repository.\nPlease, check your option.");
        }
    }

    private List<String> getLicenseAgreementList(PackageManager pm, List<String> installNames, List<Component> mainTreeComponents) {
        ArrayList<String> requiredLicenseAgreementList = new ArrayList<String>();
        ArrayList<String> noLicenseAgreementList = new ArrayList<String>();
        if (installNames == null || mainTreeComponents == null) {
            return requiredLicenseAgreementList;
        }
        if (!installNames.isEmpty()) {
            block0: for (String pName : installNames) {
                for (Component component : mainTreeComponents) {
                    if (!pName.equals(component.getPackageName())) continue;
                    if (component.hasLicense()) {
                        requiredLicenseAgreementList.add("License for " + pName + "\n" + component.getLicense());
                        continue block0;
                    }
                    noLicenseAgreementList.add(pName);
                    continue block0;
                }
            }
        }
        if (!requiredLicenseAgreementList.isEmpty() && !noLicenseAgreementList.isEmpty()) {
            System.out.println("No license agreements for " + noLicenseAgreementList + "\n");
        }
        return requiredLicenseAgreementList;
    }

    public void doSdkUtilsSaveCache(CLIOptions options) throws UMException {
        String savePath = null;
        if (options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.SDK_UTILS_SAVE_CAHCE_FROM_REPOSIOTRY)) {
            savePath = PackageInfoJSON.getRecentPackageInfo();
            System.out.println(savePath);
        } else if (options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.SDK_UTILS_SAVE_CAHCE_FROM_INSTALLED)) {
            savePath = PackageInfoJSON.getInstalledPackageInfo();
            System.out.println(savePath);
        } else {
            System.out.println("Invalid option.\nUsing \"" + CLIOptions.OPTIONS_BOOLEAN.SDK_UTILS_SAVE_CAHCE_FROM_REPOSIOTRY.command() + "\" or \"" + CLIOptions.OPTIONS_BOOLEAN.SDK_UTILS_SAVE_CAHCE_FROM_INSTALLED.command() + "\".");
        }
    }
}

