/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.core.Install.InstallPackageManager;
import org.tizen.manager.core.Install.InstallProcess;
import org.tizen.manager.core.Install.InstallProcessQueue;
import org.tizen.manager.core.Install.InstallUninstallPackageProgressMonitor;
import org.tizen.manager.core.Install.PackageInstaller;
import org.tizen.manager.core.Install.PackageUninstaller;
import org.tizen.manager.core.Install.UninstallPackageManager;
import org.tizen.manager.core.Install.UninstallProcess;
import org.tizen.manager.core.RepositoryManager;
import org.tizen.manager.core.UMNullProgressMonitor;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.core.download.DownloadManager;
import org.tizen.manager.core.download.DownloadPackageProgressMonitor;
import org.tizen.manager.core.download.IDownloadPackageProgressMonitor;
import org.tizen.manager.core.model.Distribution;
import org.tizen.manager.core.model.ImageInformation;
import org.tizen.manager.core.nullmonitor.NullDownloadManagerMonitor;
import org.tizen.manager.core.nullmonitor.NullDownloadProgressMonitor;
import org.tizen.manager.core.nullmonitor.NullInstallUninstallPackageProgressMonitor;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.exception.ProgressLog;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.ComponentManager;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.pkg.PackageUtil;
import org.tizen.manager.util.Downloader;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ShellParser;
import org.tizen.manager.util.ShellUtil;
import org.tizen.manager.util.ZipLibrary;

public class InstallController {
    private static final Logger logger = Log.getLogger(InstallController.class);
    private static final int DOWNLOAD_FACTOR_LINUX = 84;
    private static final int EXTRACT_FACTOR_LINUX = 7;
    private static final int COPY_FACTOR_LINUX = 1;
    private static final int SCRIPT_FACTOR_LINUX = 5;
    private static final int REMOVE_FACTOR_LINUX = 0;
    private static final int SUM_OF_FACTORS_LINUX = 97;
    private static final int DOWNLOAD_FACTOR_WINDOWS = 60;
    private static final int EXTRACT_FACTOR_WINDOWS = 22;
    private static final int COPY_FACTOR_WINDOWS = 0;
    private static final int SCRIPT_FACTOR_WINDOWS = 16;
    private static final int REMOVE_FACTOR_WINDOWS = 12;
    private static final int SUM_OF_FACTORS_WINDOWS = 110;
    private static final int DOWNLOAD_FACTOR_MACOS = 63;
    private static final int EXTRACT_FACTOR_MACOS = 13;
    private static final int COPY_FACTOR_MACOS = 10;
    private static final int SCRIPT_FACTOR_MACOS = 13;
    private static final int REMOVE_FACTOR_MACOS = 2;
    private static final int SUM_OF_FACTORS_MACOS = 101;
    private static InstallController myInstance = null;
    private PackageManager packageManager;
    private static String WINDOWS_INSTALL_MANAGER_REMOVE_SCRIPT = "/res/desktop_directory/remove.vbs";
    private static String WINDOWS_MAKE_SHORTCUT_PATH = "/res/desktop_directory/makeshortcut.vbs";
    private static String WINDOWS_REMOVE_SHORTCUT_PATH = "/res/desktop_directory/removeshortcut.vbs";
    private static String LINUX_INSTALL_MANAGER_REMOVE_SCRIPT = "/res/desktop_directory/remove.sh";
    private static String LINUX_MAKE_SHORTCUT_PATH = "/res/desktop_directory/makeshortcut.sh";
    private static String LINUX_REMOVE_SHORTCUT_PATH = "/res/desktop_directory/removeshortcut.sh";
    private static String LINUX_TSUDO_PATH = "/res/desktop_directory/tsudo.sh";
    private static String MACOS_MAKE_SHORTCUT_PATH = "/res/desktop_directory/makeshortcut_macos.sh";
    private static String MACOS_REMOVE_SHORTCUT_PATH = "/res/desktop_directory/removeshortcut_macos.sh";
    private File makeShortCutFile = null;
    private File removeShortCutFile = null;
    private File tSudoFile = null;
    private String baseScriptDir = null;
    private boolean isCLIMode = false;
    private String userPassword = null;
    public static final int MAX_WORKING_THREADS = 15;
    private static ExecutorService mainInstallThreadExecutor = Executors.newFixedThreadPool(15);
    private InstallProcessQueue processQueue = new InstallProcessQueue();
    private ArrayList<String> untouchablePackageList = new ArrayList();

    private InstallController() {
        this.packageManager = PackageManager.getInstance();
        this.baseScriptDir = PathUtil.get(Config.getManagerConfigHome(), "builtin-scripts", Long.toString((long)SDKInfo.getInstalledPath().hashCode() & 0xFFFFFFFFL));
        this.untouchablePackageList.add("package-manager");
        this.untouchablePackageList.add("uninstaller");
        this.untouchablePackageList.add("package-manager-cli");
    }

    public static synchronized InstallController getInstance() {
        if (myInstance == null) {
            myInstance = new InstallController();
        }
        return myInstance;
    }

    public void init() throws UMException {
        this.deleteTempFile();
        this.prepareBuiltInScriptFiles();
        this.refreshConfig();
    }

    private void refreshConfig() throws UMException {
        String id;
        RepositoryManager instance;
        Distribution distributionByName;
        String distributionId = Config.getInstance().getConfigFile().getDistributionId();
        if ((distributionId == null || distributionId.isEmpty()) && (distributionByName = (instance = RepositoryManager.getInstance()).getDistributionByName(Config.getInstance().getConfigFile().getDistribution())) != null && (id = distributionByName.getID()) != null && !id.isEmpty()) {
            Config.getInstance().getConfigFile().setDistributionId(id);
            Config.getInstance().saveConfig();
        }
    }

    private void prepareBuiltInScriptFiles() throws UMException {
        logger.info("Copying Built-In scripts to " + this.baseScriptDir);
        this.copyMakeShortCutFile();
        this.copyRemoveShortCutFile();
        if (PlatformUtil.isLinux()) {
            this.copyTizenSudoFile();
        }
    }

    private void deleteTempFile() throws UMException {
        File tmpDir;
        try {
            tmpDir = new File(PathUtil.getTempFileParent());
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.CANNOT_CREATE_TEMP_FILE);
        }
        File[] tmpFiles = tmpDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String[] prefix;
                boolean found = false;
                for (String pref : prefix = new String[]{"makeshortcut", "removeshortcut", "installmanager.repository", "Packages", "tizen_installmanager", "checkJavaInstallation", "install"}) {
                    found = name.startsWith(pref);
                    if (!found) continue;
                    return true;
                }
                return found;
            }
        });
        if (tmpFiles != null) {
            for (File f : tmpFiles) {
                if (f.delete()) continue;
                logger.error("Fail to delete file ==> " + f);
            }
        }
    }

    private void copyMakeShortCutFile() throws UMException {
        String scriptResourcePath = null;
        if (PlatformUtil.isLinux()) {
            this.makeShortCutFile = new File(PathUtil.get(this.baseScriptDir, "makeshortcut.sh"));
            scriptResourcePath = LINUX_MAKE_SHORTCUT_PATH;
        } else if (PlatformUtil.isWindows()) {
            this.makeShortCutFile = new File(PathUtil.get(this.baseScriptDir, "makeshortcut.vbs"));
            scriptResourcePath = WINDOWS_MAKE_SHORTCUT_PATH;
        } else if (PlatformUtil.isMacOS()) {
            this.makeShortCutFile = new File(PathUtil.get(this.baseScriptDir, "makeshortcut.sh"));
            scriptResourcePath = MACOS_MAKE_SHORTCUT_PATH;
        } else {
            this.makeShortCutFile = new File(PathUtil.get(this.baseScriptDir, "makeshortcut.sh"));
            scriptResourcePath = LINUX_MAKE_SHORTCUT_PATH;
        }
        this.createScriptFileFromJarResourcePath(this.makeShortCutFile, scriptResourcePath);
    }

    private void copyRemoveShortCutFile() throws UMException {
        String scriptResourcePath = null;
        if (PlatformUtil.isLinux()) {
            this.removeShortCutFile = new File(PathUtil.get(this.baseScriptDir, "removeshortcut.sh"));
            scriptResourcePath = LINUX_REMOVE_SHORTCUT_PATH;
        } else if (PlatformUtil.isWindows()) {
            this.removeShortCutFile = new File(PathUtil.get(this.baseScriptDir, "removeshortcut.vbs"));
            scriptResourcePath = WINDOWS_REMOVE_SHORTCUT_PATH;
        } else if (PlatformUtil.isMacOS()) {
            this.removeShortCutFile = new File(PathUtil.get(this.baseScriptDir, "removeshortcut.sh"));
            scriptResourcePath = MACOS_REMOVE_SHORTCUT_PATH;
        } else {
            this.removeShortCutFile = new File(PathUtil.get(this.baseScriptDir, "removeshortcut.sh"));
            scriptResourcePath = LINUX_REMOVE_SHORTCUT_PATH;
        }
        this.createScriptFileFromJarResourcePath(this.removeShortCutFile, scriptResourcePath);
    }

    private void copyTizenSudoFile() throws UMException {
        this.tSudoFile = new File(PathUtil.get(this.baseScriptDir, "tsudo.sh"));
        this.createScriptFileFromJarResourcePath(this.tSudoFile, LINUX_TSUDO_PATH);
    }

    private void createScriptFileFromJarResourcePath(File outputFile, String resourcePath) throws UMException {
        if (outputFile.exists() && !PathUtil.remove(outputFile)) {
            logger.warn("Failed to remove old script file. Skipped creating script file. " + outputFile.getPath());
            return;
        }
        File parentDir = outputFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try {
            PathUtil.writeFileFromInputStream(PathUtil.getResourceAsStream(resourcePath), outputFile);
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_CREATE_SHORTCUT_SCRIPT_FILE, (Throwable)e);
        }
        if (!outputFile.exists()) {
            logger.error("Output script file does not exist! : " + outputFile.getPath());
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_CREATE_SHORTCUT_SCRIPT_FILE, outputFile.getPath());
        }
        outputFile.setExecutable(true);
    }

    public String getTSudoPath() {
        if (this.tSudoFile == null) {
            return "";
        }
        return this.tSudoFile.getAbsolutePath();
    }

    public String getMakeShortCutPath() {
        if (this.makeShortCutFile == null) {
            return "";
        }
        return this.makeShortCutFile.getAbsolutePath();
    }

    public String getRemoveShortCutPath() {
        if (this.removeShortCutFile == null) {
            return "";
        }
        return this.removeShortCutFile.getAbsolutePath();
    }

    public boolean install(String selectedItemKey, List<String> metaPkgNames, ICommonProgressMonitor monitor) throws UMException {
        logger.info("======== Start Installing ========");
        logger.info("Selected package list => " + metaPkgNames);
        logger.info("target path => " + SDKInfo.getInstalledPath());
        if (metaPkgNames == null || metaPkgNames.size() == 0) {
            logger.trace("\tNothing to install.");
            return true;
        }
        PackageSet installablePackages = this.packageManager.getInstallablePackagesOfMetaPackageNames(metaPkgNames);
        Package mainMetaPkg = this.packageManager.getPackageByName(selectedItemKey);
        if (mainMetaPkg != null && mainMetaPkg.isExtensionPackage()) {
            PackageSet installedPkgs = this.packageManager.getInstalledPackages();
            for (Package iPkg : (PackageSet)installablePackages.clone()) {
                if (iPkg.isExtensionPackage() || !installedPkgs.hasPackageByName(iPkg.getPackageName())) continue;
                installablePackages.remove(iPkg);
            }
        }
        return this.install(selectedItemKey, installablePackages, monitor);
    }

    public void install(Component component, ICommonProgressMonitor monitor) throws UMException {
        monitor.beginTask("Installing", 100);
        logger.info("======== Start Installing ========");
        logger.info("Target Component => " + component.getPackageName());
        PackageSet targetPkgs = ComponentManager.getInstance().getInstallablePackagesOfComponent(component);
        boolean bResult = true;
        try {
            monitor.setProgress("The target packages to install:\n" + targetPkgs);
            this.install(component.getPackageName(), targetPkgs, monitor);
            monitor.setProgress("Updating the installed snapshot information...");
            InstallController.updateConfiguration();
        }
        catch (UMException e) {
            bResult = false;
            throw e;
        }
        finally {
            if (bResult) {
                component.setInstallState(Component.InstallState.UNINSTALL);
            } else {
                component.setError(monitor.getError());
                monitor.setProgress("Recalculating the install state by failure...");
                component.setInstallState(ComponentManager.getInstance().calculateInstallState(component));
            }
            monitor.setProgress("Refreshing the install state of other packages...");
            ComponentManager.getInstance().refresh();
        }
    }

    private UMException wrapExceptionWithGeneralInstallException(UMException e, boolean isUpdate) {
        ErrorController.ErrorCode errCode = e.getErrorCode();
        if (!isUpdate) {
            if (errCode == ErrorController.ErrorCode.INSTALLATION_CANCELED_BY_USER || errCode == ErrorController.ErrorCode.INSTALLATION_CANCELED_BY_FAILURE) {
                return e;
            }
            if (e.isCancelException()) {
                return new UMException(ErrorController.ErrorCode.INSTALLATION_CANCELED_BY_FAILURE, (Throwable)e);
            }
            return new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL, (Throwable)e);
        }
        if (errCode == ErrorController.ErrorCode.INSTALLATION_CANCELED_BY_USER) {
            return new UMException(ErrorController.ErrorCode.UPDATING_CANCELED_BY_USER, e.getAdditionalMessage());
        }
        if (errCode == ErrorController.ErrorCode.INSTALLATION_CANCELED_BY_FAILURE) {
            return new UMException(ErrorController.ErrorCode.UPDATING_CANCELED_BY_FAILURE, e.getAdditionalMessage());
        }
        if (e.isCancelException()) {
            return new UMException(ErrorController.ErrorCode.UPDATING_CANCELED_BY_FAILURE, (Throwable)e);
        }
        return new UMException(ErrorController.ErrorCode.FAILED_TO_UPDATE, (Throwable)e);
    }

    private boolean install(String selectedItemKey, PackageSet targetPkgs, final ICommonProgressMonitor monitor) throws UMException {
        boolean isUpdate = false;
        try {
            this.checkCancelInstallation(selectedItemKey, monitor, null);
            long totalDownloadSize = PackageManager.getTotalDownloadSize(targetPkgs);
            long totalInstallSize = PackageManager.getTotalInstallSize(targetPkgs);
            monitor.setProgress("Start to download the target packages.");
            HashMap<Package, IDownloadPackageProgressMonitor> pkgToMonitor = this.requestToDownloadInstallablePackages(targetPkgs, monitor);
            monitor.setProgress("Waiting for finishing the downloads of the packages...");
            this.waitForDownloadingPackagesDone(selectedItemKey, monitor, pkgToMonitor, totalDownloadSize);
            this.processQueue.waitForProcessQueue(selectedItemKey, monitor);
            this.checkCancelInstallation(selectedItemKey, monitor, null);
            monitor.setCancelable(false);
            for (Package pkg : targetPkgs) {
                if (!this.packageManager.isInstalledPackage(pkg) || !this.packageManager.isUpdatable(pkg)) continue;
                isUpdate = true;
                monitor.setProgress("Removing the existing package for update.");
                PackageUninstaller pu = new PackageUninstaller();
                InstallUninstallPackageProgressMonitor iupm = new InstallUninstallPackageProgressMonitor(pkg, new UMNullProgressMonitor(){

                    @Override
                    public void setProgress(String msg, ProgressLog.LogType type) {
                        monitor.setProgress(msg);
                    }
                });
                pu.uninstall(pkg, iupm);
            }
            monitor.setProgress("Start to install the target packages.");
            HashMap<Package, InstallUninstallPackageProgressMonitor> pkgToInstallMonitor = this.requestToInstallInstallablePackages(targetPkgs, monitor);
            monitor.setProgress("Waiting for finishing the installations of the packages...");
            this.waitForInstallingPackagesDone(monitor, pkgToInstallMonitor, totalInstallSize);
        }
        catch (UMException e) {
            UMException ex = this.wrapExceptionWithGeneralInstallException(e, isUpdate);
            monitor.setError(ex);
            throw ex;
        }
        finally {
            if (monitor.getError() != null) {
                monitor.setProgress(monitor.getError().getMessage(), ProgressLog.LogType.ERROR);
                StringWriter sw = new StringWriter();
                monitor.getError().printStackTrace(new PrintWriter(sw));
                monitor.setProgress(sw.toString(), ProgressLog.LogType.ERROR);
            }
            PackageUtil.uninstallDisconnectedPackages();
            this.processQueue.removeProcessQueue();
        }
        return true;
    }

    private ArrayList<ICommonProgressMonitor> getDependentMonitorsToCancelInstalling(String selectedItemKey, ICommonProgressMonitor monitor) {
        ArrayList<ICommonProgressMonitor> result = new ArrayList<ICommonProgressMonitor>();
        for (ICommonProgressMonitor monitor1 : this.processQueue.getReverseDependentInstallingProgressMonitors(selectedItemKey)) {
            if (result.contains(monitor1)) continue;
            result.add(monitor1);
        }
        if (monitor.getMonitorGroup() != null && monitor.getError() == null) {
            for (ICommonProgressMonitor monitor1 : monitor.getMonitorGroup()) {
                if (monitor1 == monitor || result.contains(monitor1) || monitor1.isCanceled()) continue;
                boolean existExternalDep = false;
                ArrayList<ICommonProgressMonitor> depMonitors = this.processQueue.getReverseDependentInstallingProgressMonitors(monitor1);
                for (ICommonProgressMonitor depMonitor : depMonitors) {
                    if (monitor.getMonitorGroup().contains(depMonitor)) continue;
                    existExternalDep = true;
                    break;
                }
                if (existExternalDep) continue;
                result.add(monitor1);
            }
        }
        return result;
    }

    public String getCancelListFromInstalling(String selectedItemKey, ICommonProgressMonitor monitor) throws UMException {
        String componentNames = "";
        ArrayList<ICommonProgressMonitor> cancelMonitors = this.getDependentMonitorsToCancelInstalling(selectedItemKey, monitor);
        if (!cancelMonitors.isEmpty()) {
            for (ICommonProgressMonitor monitor1 : cancelMonitors) {
                if (monitor == monitor1 || !monitor1.isCancelable() || monitor1.isCanceled()) continue;
                if (!componentNames.isEmpty()) {
                    componentNames = componentNames + ", ";
                }
                componentNames = componentNames + this.processQueue.getProcessDisplayNameByMonitor(monitor1);
            }
        }
        return componentNames;
    }

    public ArrayList<Component> getCancelComponentListFromInstalling(String selectedItemKey, ICommonProgressMonitor monitor) throws UMException {
        ArrayList<Component> list = new ArrayList<Component>();
        ArrayList<ICommonProgressMonitor> cancelMonitors = this.getDependentMonitorsToCancelInstalling(selectedItemKey, monitor);
        if (!cancelMonitors.isEmpty()) {
            for (ICommonProgressMonitor monitor1 : cancelMonitors) {
                if (monitor == monitor1 || !monitor1.isCancelable() || monitor1.isCanceled()) continue;
                list.add(monitor1.getComponent());
            }
        }
        return list;
    }

    public String getCancelListFromUninstalling(String selectedItemKey, ICommonProgressMonitor monitor) throws UMException {
        String componentNames = "";
        ArrayList<ICommonProgressMonitor> cancelMonitors = this.getDependentMonitorsToCancelUninstalling(selectedItemKey, monitor);
        if (!cancelMonitors.isEmpty()) {
            for (ICommonProgressMonitor monitor1 : cancelMonitors) {
                if (monitor == monitor1 || !monitor1.isCancelable() || monitor1.isCanceled()) continue;
                if (!componentNames.isEmpty()) {
                    componentNames = componentNames + ", ";
                }
                componentNames = componentNames + this.processQueue.getProcessDisplayNameByMonitor(monitor1);
            }
        }
        if (monitor.getError() != null && monitor.getError() instanceof UMException) {
            throw (UMException)monitor.getError();
        }
        return componentNames;
    }

    public ArrayList<Component> getCancelComponentListFromUninstalling(String selectedItemKey, ICommonProgressMonitor monitor) throws UMException {
        ArrayList<Component> list = new ArrayList<Component>();
        ArrayList<ICommonProgressMonitor> cancelMonitors = this.getDependentMonitorsToCancelUninstalling(selectedItemKey, monitor);
        if (!cancelMonitors.isEmpty()) {
            for (ICommonProgressMonitor monitor1 : cancelMonitors) {
                if (monitor == monitor1 || !monitor1.isCancelable() || monitor1.isCanceled()) continue;
                list.add(monitor1.getComponent());
            }
        }
        if (monitor.getError() != null && monitor.getError() instanceof UMException) {
            throw (UMException)monitor.getError();
        }
        return list;
    }

    private void checkCancelInstallation(String selectedItemKey, ICommonProgressMonitor monitor, HashMap<Package, IDownloadPackageProgressMonitor> pkgToMonitor) throws UMException {
        if (monitor.isCanceled()) {
            ArrayList<ICommonProgressMonitor> cancelMonitors = this.getDependentMonitorsToCancelInstalling(selectedItemKey, monitor);
            if (!cancelMonitors.isEmpty()) {
                String componentNames = "";
                for (ICommonProgressMonitor monitor1 : cancelMonitors) {
                    if (monitor == monitor1 || !monitor1.isCancelable() || monitor1.isCanceled()) continue;
                    if (!componentNames.isEmpty()) {
                        componentNames = componentNames + ", ";
                    }
                    componentNames = componentNames + this.processQueue.getProcessKeyByMonitor(monitor1);
                    monitor1.setCanceled(true);
                    monitor1.setError(new UMException(ErrorController.ErrorCode.INSTALLATION_CANCELED_BY_FAILURE, selectedItemKey));
                }
                if (!componentNames.isEmpty()) {
                    monitor.setProgress("Sent 'cancel' signal to other working processes... " + componentNames);
                }
            }
            if (pkgToMonitor != null) {
                IDownloadPackageProgressMonitor dmProgressMonitor;
                for (Package pkg : pkgToMonitor.keySet()) {
                    dmProgressMonitor = pkgToMonitor.get(pkg);
                    dmProgressMonitor.setCanceled(true);
                }
                for (Package pkg : pkgToMonitor.keySet()) {
                    dmProgressMonitor = pkgToMonitor.get(pkg);
                    while (!dmProgressMonitor.getDone()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            logger.throwing(e);
                        }
                    }
                }
            }
            if (monitor.getError() != null && monitor.getError() instanceof UMException) {
                throw (UMException)monitor.getError();
            }
            throw new UMException(ErrorController.ErrorCode.INSTALLATION_CANCELED_BY_USER);
        }
    }

    private int checkPauseInstallation(String selectedItemKey, ICommonProgressMonitor monitor, HashMap<Package, IDownloadPackageProgressMonitor> pkgToMonitor) throws UMException {
        int retCnt = 0;
        if (monitor.isPause()) {
            ArrayList<ICommonProgressMonitor> cancelMonitors = this.getDependentMonitorsToCancelInstalling(selectedItemKey, monitor);
            if (!cancelMonitors.isEmpty()) {
                String componentNames = "";
                for (ICommonProgressMonitor monitor1 : cancelMonitors) {
                    if (monitor == monitor1 || !monitor1.isCancelable() || monitor1.isCanceled()) continue;
                    if (!componentNames.isEmpty()) {
                        componentNames = componentNames + ", ";
                    }
                    ++retCnt;
                    componentNames = componentNames + this.processQueue.getProcessKeyByMonitor(monitor1);
                }
            }
            if (monitor.getError() != null && monitor.getError() instanceof UMException) {
                throw (UMException)monitor.getError();
            }
        }
        return retCnt;
    }

    private HashMap<Package, IDownloadPackageProgressMonitor> requestToDownloadInstallablePackages(PackageSet targetPkgs, ICommonProgressMonitor monitor) {
        HashMap<Package, IDownloadPackageProgressMonitor> result = new HashMap<Package, IDownloadPackageProgressMonitor>();
        DownloadManager downloadManager = DownloadManager.getInstance();
        for (Package pkg : targetPkgs) {
            DownloadPackageProgressMonitor dmProgressMonitor = new DownloadPackageProgressMonitor(pkg, monitor);
            result.put(pkg, dmProgressMonitor);
            downloadManager.requestDownloadPackage(pkg, targetPkgs, SDKInfo.getInstalledPath(), dmProgressMonitor, Config.getInstance());
        }
        return result;
    }

    private void waitForDownloadingPackagesDone(String selectedItemKey, ICommonProgressMonitor monitor, HashMap<Package, IDownloadPackageProgressMonitor> pkgToMonitor, long totalDownloadSize) throws UMException {
        try {
            int monitorCount = pkgToMonitor.values().size();
            while (true) {
                this.checkCancelInstallation(selectedItemKey, monitor, pkgToMonitor);
                int pauseCnt = this.checkPauseInstallation(selectedItemKey, monitor, pkgToMonitor);
                int successCount = 0;
                double progress = 0.0;
                for (Package pkg : pkgToMonitor.keySet()) {
                    IDownloadPackageProgressMonitor dmProgressMonitor = pkgToMonitor.get(pkg);
                    if (dmProgressMonitor.getDone()) {
                        Exception err = dmProgressMonitor.getError();
                        if (err != null) {
                            throw err;
                        }
                        ++successCount;
                    }
                    progress += this.calculateProgressValueOfDownloadExtract(pkg, totalDownloadSize, dmProgressMonitor);
                }
                int percent = (int)Math.floor(progress);
                monitor.worked(percent);
                if (monitorCount == successCount && pauseCnt == 0) {
                    logger.trace("Download done");
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            for (Package pkg : pkgToMonitor.keySet()) {
                IDownloadPackageProgressMonitor dmProgressMonitor = pkgToMonitor.get(pkg);
                if (dmProgressMonitor.getDone()) continue;
                dmProgressMonitor.setCanceled(true);
            }
            if (e instanceof UMException) {
                throw (UMException)e;
            }
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)e);
        }
    }

    private HashMap<Package, InstallUninstallPackageProgressMonitor> requestToInstallInstallablePackages(PackageSet targetPkgs, ICommonProgressMonitor monitor) {
        HashMap<Package, InstallUninstallPackageProgressMonitor> result = new HashMap<Package, InstallUninstallPackageProgressMonitor>();
        InstallPackageManager installPackageManager = InstallPackageManager.getInstance();
        for (Package pkg : targetPkgs) {
            InstallUninstallPackageProgressMonitor dmProgressMonitor = new InstallUninstallPackageProgressMonitor(pkg, monitor);
            result.put(pkg, dmProgressMonitor);
            installPackageManager.requestInstallPackage(pkg, SDKInfo.getInstalledPath(), dmProgressMonitor, Config.getInstance());
        }
        return result;
    }

    private void waitForInstallingPackagesDone(ICommonProgressMonitor monitor, HashMap<Package, InstallUninstallPackageProgressMonitor> pkgToInstallMonitor, long totalInstallSize) throws UMException {
        int monitorCount = pkgToInstallMonitor.values().size();
        int prevProgress = monitor.getWorked();
        Exception err = null;
        while (true) {
            int successCount = 0;
            double progress = 0.0;
            for (Package pkg : pkgToInstallMonitor.keySet()) {
                InstallUninstallPackageProgressMonitor installPackageProgressMonitor = pkgToInstallMonitor.get(pkg);
                if (installPackageProgressMonitor.getDone()) {
                    err = installPackageProgressMonitor.getError();
                    if (err != null) break;
                    ++successCount;
                    DownloadManager.getInstance().packageIsInstalled(pkg);
                }
                progress += this.calculateProgressValueOfInstall(pkg, totalInstallSize, installPackageProgressMonitor);
            }
            if (err != null) break;
            int percent = (int)Math.floor(progress);
            monitor.worked(prevProgress + percent);
            if (monitorCount == successCount) {
                logger.trace("Install done");
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (err != null) {
            for (Package pkg : pkgToInstallMonitor.keySet()) {
                InstallUninstallPackageProgressMonitor installPackageProgressMonitor = pkgToInstallMonitor.get(pkg);
                if (installPackageProgressMonitor.getDone()) continue;
                installPackageProgressMonitor.setCanceled(true);
            }
            if (err instanceof UMException) {
                throw (UMException)err;
            }
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL, (Throwable)err);
        }
    }

    private double calculateProgressValueOfDownloadExtract(Package pkg, long totalDownloadSize, IDownloadPackageProgressMonitor downloadMonitor) {
        int downloadFactor = 0;
        int extractFactor = 0;
        int sumOfFactors = 0;
        if (PlatformUtil.isWindows()) {
            downloadFactor = 60;
            extractFactor = 22;
            sumOfFactors = 110;
        } else if (PlatformUtil.isMacOS()) {
            downloadFactor = 63;
            extractFactor = 13;
            sumOfFactors = 101;
        } else {
            downloadFactor = 84;
            extractFactor = 7;
            sumOfFactors = 97;
        }
        double pkgRatio = 1.0 * (double)pkg.getPackageSize().longValue() / (double)totalDownloadSize;
        double downloadRatio = 1.0 * (double)downloadFactor / (double)sumOfFactors * (double)downloadMonitor.getDownloadWorked();
        double extractRatio = 1.0 * (double)extractFactor / (double)sumOfFactors * (double)downloadMonitor.getExtractWorked();
        double result = pkgRatio * (downloadRatio + extractRatio);
        return result;
    }

    private double calculateProgressValueOfInstall(Package pkg, long totalInstallSize, InstallUninstallPackageProgressMonitor installPackageProgressMonitor) {
        int copyFactor = 0;
        int scriptFactor = 0;
        int removeFactor = 0;
        int sumOfFactors = 0;
        if (PlatformUtil.isWindows()) {
            copyFactor = 0;
            scriptFactor = 16;
            removeFactor = 12;
            sumOfFactors = 110;
        } else if (PlatformUtil.isMacOS()) {
            copyFactor = 10;
            scriptFactor = 13;
            removeFactor = 2;
            sumOfFactors = 101;
        } else {
            copyFactor = 1;
            scriptFactor = 5;
            removeFactor = 0;
            sumOfFactors = 97;
        }
        double pkgRatio = 1.0 * (double)pkg.getUncompressedPackageSize().longValue() / (double)totalInstallSize;
        double moveRatio = 1.0 * (double)copyFactor / (double)sumOfFactors * (double)installPackageProgressMonitor.getmoveFilesWorked();
        double scriptRatio = 1.0 * (double)scriptFactor / (double)sumOfFactors * (double)installPackageProgressMonitor.getRunScriptWorked();
        double removeRatio = 1.0 * (double)removeFactor / (double)sumOfFactors * (double)installPackageProgressMonitor.getRemoveOlddWorked();
        double result = pkgRatio * (moveRatio + scriptRatio + removeRatio);
        return result;
    }

    public String getDownloadTargetPath(Package pkg) {
        String repository = pkg.getBaseURL().toString();
        String encodeRepository = null;
        try {
            encodeRepository = URLEncoder.encode(repository, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.throwing(e);
            return encodeRepository;
        }
        return PathUtil.get(Config.getTempDownloadDirectory(), encodeRepository, pkg.getFileName());
    }

    public static void removeShortcutMenu() {
        File removeScript;
        try {
            removeScript = InstallController.getRemoveScript();
        }
        catch (IOException e1) {
            logger.throwing(e1);
            return;
        }
        if (removeScript == null) {
            return;
        }
        removeScript.setExecutable(true);
        try {
            ShellUtil.executeScript(removeScript, null, new ShellParser());
        }
        catch (IMShellCommandFail e) {
            logger.error("Cannot execute InstallManager's remove script.");
            logger.throwing(e);
        }
        catch (UMException e) {
            logger.throwing(e);
        }
    }

    private static File getRemoveScript() throws IOException {
        if (PlatformUtil.isLinux()) {
            return PathUtil.getTempFileFromResource(LINUX_INSTALL_MANAGER_REMOVE_SCRIPT, "im_remove", ".sh");
        }
        if (PlatformUtil.isWindows()) {
            return PathUtil.getTempFileFromResource(WINDOWS_INSTALL_MANAGER_REMOVE_SCRIPT, "im_remove", ".vbs");
        }
        if (PlatformUtil.isMacOS()) {
            return null;
        }
        return PathUtil.getTempFileFromResource(LINUX_INSTALL_MANAGER_REMOVE_SCRIPT, "im_remove", ".sh");
    }

    public void uninstall(Component component, boolean doCleanUp, ICommonProgressMonitor monitor) throws UMException {
        monitor.beginTask("Uninstalling", 100);
        logger.info("======== Start Uninstalling ========");
        logger.info("Target Component => " + component.getPackageName());
        logger.info("target path => " + SDKInfo.getInstalledPath());
        boolean bResult = true;
        try {
            PackageSet targetMetaPkgs = new PackageSet();
            targetMetaPkgs.add(component.getInstalledPackage());
            this.uninstall(targetMetaPkgs, doCleanUp, monitor, component.getPackageName());
        }
        catch (UMException e) {
            bResult = false;
            throw e;
        }
        finally {
            if (bResult) {
                component.setInstallState(Component.InstallState.INSTALL);
            } else {
                component.setError(monitor.getError());
                component.setInstallState(ComponentManager.getInstance().calculateInstallState(component));
            }
            ComponentManager.getInstance().refresh();
        }
    }

    private UMException wrapExceptionWithGeneralUninstallException(UMException e) {
        ErrorController.ErrorCode errCode = e.getErrorCode();
        if (errCode == ErrorController.ErrorCode.UNINSTALLATION_CANCELED_BY_USER || errCode == ErrorController.ErrorCode.UNINSTALLATION_CANCELED_BY_FAILURE) {
            return e;
        }
        if (e.isCancelException()) {
            return new UMException(ErrorController.ErrorCode.UNINSTALLATION_CANCELED_BY_FAILURE, (Throwable)e);
        }
        return new UMException(ErrorController.ErrorCode.FAILED_TO_UNINSTALL, (Throwable)e);
    }

    private void uninstall(PackageSet targetMetaPkgs, boolean doCleanUp, ICommonProgressMonitor monitor, String selectedItemKey) throws UMException {
        try {
            this.checkCancelUninstallation(selectedItemKey, monitor);
            this.processQueue.waitForProcessQueue(selectedItemKey, monitor);
            this.checkCancelUninstallation(selectedItemKey, monitor);
            monitor.setCancelable(false);
            PackageSet targetPkgs = this.packageManager.getRemovablePackagesOfMetaPackages(targetMetaPkgs);
            monitor.setProgress("The target packages to uninstall:\n" + targetPkgs);
            monitor.setProgress("Start to uninstall the target packages.");
            this.removeUntouchablePackages(targetPkgs);
            HashMap<Package, InstallUninstallPackageProgressMonitor> pkgToMonitors = this.requestToUninstallRemovablePackages(targetPkgs, monitor);
            monitor.setProgress("Waiting for finishing the uninstallation of the packages...");
            long totalInstallSize = PackageManager.getTotalInstallSize(targetPkgs);
            this.waitForRemovingPackagesDone(monitor, pkgToMonitors, totalInstallSize);
            if (doCleanUp) {
                monitor.setProgress("Cleaning the garbage files...");
                PackageUtil.deletePackageFilesWhichIsNotInInstalledList();
                monitor.setProgress("Cleaning the files of disconnected packages...");
                PackageUtil.uninstallDisconnectedPackages();
            }
        }
        catch (UMException e) {
            UMException ex = this.wrapExceptionWithGeneralUninstallException(e);
            monitor.setError(ex);
            throw ex;
        }
        finally {
            if (monitor.getError() != null) {
                monitor.setProgress(monitor.getError().getMessage(), ProgressLog.LogType.ERROR);
                StringWriter sw = new StringWriter();
                monitor.getError().printStackTrace(new PrintWriter(sw));
                monitor.setProgress(sw.toString(), ProgressLog.LogType.ERROR);
            }
            this.processQueue.removeProcessQueue();
        }
    }

    public ArrayList<String> getUntouchablePackageList() {
        return this.untouchablePackageList;
    }

    private void removeUntouchablePackages(PackageSet targetPkgs) {
        for (String pname : this.untouchablePackageList) {
            Package pkg = this.packageManager.getPackageByName(pname);
            if (pkg == null || !targetPkgs.contains(pkg)) continue;
            targetPkgs.remove(pkg);
            logger.trace("Remove untouchable package from target : " + pkg);
        }
    }

    private void checkCancelUninstallation(String selectedItemKey, ICommonProgressMonitor monitor) throws UMException {
        if (monitor.isCanceled()) {
            ArrayList<ICommonProgressMonitor> cancelMonitors = this.getDependentMonitorsToCancelUninstalling(selectedItemKey, monitor);
            if (!cancelMonitors.isEmpty()) {
                String componentNames = "";
                for (ICommonProgressMonitor monitor1 : cancelMonitors) {
                    if (monitor == monitor1 || !monitor1.isCancelable() || monitor1.isCanceled()) continue;
                    if (!componentNames.isEmpty()) {
                        componentNames = componentNames + ", ";
                    }
                    componentNames = componentNames + this.processQueue.getProcessKeyByMonitor(monitor1);
                    monitor1.setCanceled(true);
                    monitor1.setError(new UMException(ErrorController.ErrorCode.UNINSTALLATION_CANCELED_BY_FAILURE, selectedItemKey));
                }
                if (!componentNames.isEmpty()) {
                    monitor.setProgress("Sent 'cancel' signal to other working processes... " + componentNames);
                }
            }
            if (monitor.getError() != null && monitor.getError() instanceof UMException) {
                throw (UMException)monitor.getError();
            }
            throw new UMException(ErrorController.ErrorCode.UNINSTALLATION_CANCELED_BY_USER);
        }
    }

    private HashMap<Package, InstallUninstallPackageProgressMonitor> requestToUninstallRemovablePackages(PackageSet targetPkgs, ICommonProgressMonitor monitor) {
        HashMap<Package, InstallUninstallPackageProgressMonitor> result = new HashMap<Package, InstallUninstallPackageProgressMonitor>();
        UninstallPackageManager uninstallPackageManager = UninstallPackageManager.getInstance();
        for (Package pkg : targetPkgs) {
            InstallUninstallPackageProgressMonitor dmProgressMonitor = new InstallUninstallPackageProgressMonitor(pkg, monitor);
            result.put(pkg, dmProgressMonitor);
            uninstallPackageManager.requestUninstallPackage(pkg, dmProgressMonitor);
        }
        return result;
    }

    private void waitForRemovingPackagesDone(ICommonProgressMonitor monitor, HashMap<Package, InstallUninstallPackageProgressMonitor> pkgToMonitors, long totalInstallSize) throws UMException {
        int monitorCount = pkgToMonitors.values().size();
        int prevProgress = monitor.getWorked();
        Exception err = null;
        while (true) {
            int successCount = 0;
            int progress = 0;
            for (Package pkg : pkgToMonitors.keySet()) {
                InstallUninstallPackageProgressMonitor installPackageProgressMonitor = pkgToMonitors.get(pkg);
                if (installPackageProgressMonitor.getDone()) {
                    err = installPackageProgressMonitor.getError();
                    if (err != null) break;
                    ++successCount;
                    UninstallPackageManager.getInstance().removePackage(pkg);
                }
                progress += this.calculateProgressValueOfUninstall(pkg, totalInstallSize, installPackageProgressMonitor);
            }
            if (err != null) break;
            monitor.worked(prevProgress + progress);
            if (monitorCount == successCount) {
                logger.trace("Uninstall done");
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (err != null) {
            for (Package pkg : pkgToMonitors.keySet()) {
                InstallUninstallPackageProgressMonitor installPackageProgressMonitor = pkgToMonitors.get(pkg);
                if (installPackageProgressMonitor.getDone()) continue;
                installPackageProgressMonitor.setCanceled(true);
            }
            if (err instanceof UMException) {
                throw (UMException)err;
            }
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_UNINSTALL, (Throwable)err);
        }
    }

    private ArrayList<ICommonProgressMonitor> getDependentMonitorsToCancelUninstalling(String selectedItemKey, ICommonProgressMonitor monitor) {
        ArrayList<ICommonProgressMonitor> result = new ArrayList<ICommonProgressMonitor>();
        for (ICommonProgressMonitor monitor1 : this.processQueue.getDependentUninstallingProgressMonitors(selectedItemKey)) {
            if (result.contains(monitor1)) continue;
            result.add(monitor1);
        }
        return result;
    }

    private int calculateProgressValueOfUninstall(Package pkg, long totalInstallSize, InstallUninstallPackageProgressMonitor progressMonitor) {
        return (int)(1.0 * (double)pkg.getUncompressedPackageSize().longValue() / (double)totalInstallSize * (double)progressMonitor.getRemoveOlddWorked());
    }

    public void removeSDKLegacyCLI(boolean isRefreshRepository) {
        String targetDir = Config.getInstance().getTargetDir();
        if (targetDir == null || targetDir.isEmpty()) {
            return;
        }
        File targetDirFile = new File(targetDir);
        if (!targetDirFile.exists()) {
            return;
        }
        if (isRefreshRepository) {
            PathUtil.removeExceptDirectory(targetDir, ".info");
        } else {
            PathUtil.remove(targetDir);
            PathUtil.removeExceptDirectory(SDKInfo.getSdkDataPath(), "keystore");
        }
    }

    public static boolean removeSDKLegacy(boolean isRefreshRepository) {
        String targetDir = Config.getInstance().getTargetDir();
        if (targetDir == null || targetDir.isEmpty()) {
            return true;
        }
        if (!PathUtil.remove(targetDir)) {
            return false;
        }
        if (!isRefreshRepository) {
            PathUtil.removeExceptDirectory(SDKInfo.getSdkDataPath(), "keystore");
            logger.warn("Remove trash shortcuts.");
            InstallController.removeShortcutMenu();
        }
        return true;
    }

    public boolean isCLIMode() {
        return this.isCLIMode;
    }

    public void setCLIMode(boolean isCLIMode) {
        this.isCLIMode = isCLIMode;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public static InstallProcess createInstallProcess(Component component, ICommonProgressMonitor monitor) {
        return new InstallProcess(component, monitor);
    }

    private static void updateConfiguration() throws UMException {
        Config config = Config.getInstance();
        RepositoryManager repoMgr = RepositoryManager.getInstance();
        String snapshotPath = config.getSnapshotPath();
        if (config.isAutoUpdate() || snapshotPath == null || snapshotPath.isEmpty() || snapshotPath.equalsIgnoreCase("null")) {
            if (!repoMgr.isLocalServerType() && repoMgr.getLatestSnapshot() != null) {
                config.setInstalledSnapshot(repoMgr.getLatestSnapshot().getPath());
            }
        } else {
            config.setInstalledSnapshot(snapshotPath);
        }
        if (Config.fromWhere == Config.ConfDialog.LOCAL_IMAGE) {
            ImageInformation info = new ImageInformation();
            config.setSDKImageOrigin(info.getSDKImageInfo());
        }
        config.saveConfig();
    }

    public static UninstallProcess createUninstallProcess(Component component, ICommonProgressMonitor monitor) {
        return new UninstallProcess(component, monitor);
    }

    public boolean existsWorkingProcesses() {
        return this.processQueue.getProcessCount() > 0;
    }

    public void submitInstallProcess(InstallProcess installProcess) {
        this.processQueue.addProcessQueue(installProcess.getComponent().getPackageName(), installProcess.getMonitor());
        mainInstallThreadExecutor.submit(installProcess);
    }

    public void submitUninstallProcess(UninstallProcess uninstallProcess) {
        this.processQueue.addProcessQueue(uninstallProcess.getComponent().getPackageName(), uninstallProcess.getMonitor());
        mainInstallThreadExecutor.submit(uninstallProcess);
    }

    public void addComponentToProcessQueue(Component component, ICommonProgressMonitor monitor) {
        this.processQueue.addProcessQueue(component.getPackageName(), monitor);
    }

    public void threadForceShutdown() {
        while (!mainInstallThreadExecutor.isTerminated() || !mainInstallThreadExecutor.isShutdown()) {
            mainInstallThreadExecutor.shutdownNow();
            mainInstallThreadExecutor.shutdown();
        }
        DownloadManager.getInstance().shutdown();
        InstallPackageManager.getInstance().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> uninstallAll(IProgressMonitor monitor, boolean isRefreshServer) {
        HashMap<String, String> errorMap;
        block12: {
            errorMap = new HashMap<String, String>();
            try {
                File[] listFiles;
                PackageManager pm = PackageManager.getInstance();
                PackageSet installedPackages = pm.getInstalledPackages();
                PackageSet removablePackages = this.getOrderedRemovePackageSet(installedPackages);
                ArrayList<Package> removalList = new ArrayList<Package>();
                removalList.addAll(removablePackages);
                Collections.reverse(removalList);
                for (Package pkg : removalList) {
                    monitor.subTask(String.format("Running remove script - [%s]", pkg.getPackageName()));
                    InstallController.getInstance().executeRemoveScriptOnly(pkg);
                }
                String targetDir = Config.getInstance().getTargetDir();
                File tempFile = new File(targetDir);
                if (targetDir == null || targetDir.isEmpty() || !tempFile.exists() || (listFiles = tempFile.listFiles()) == null) break block12;
                for (File file : listFiles) {
                    if (!file.isDirectory()) continue;
                    int exitCode = 0;
                    monitor.subTask(String.format("Removing - [%s]", file.getName()));
                    ShellParser sparser = new ShellParser();
                    try {
                        exitCode = PlatformUtil.isWindows() ? ShellUtil.execute("cmd /c rmdir /s /q " + file.getAbsolutePath(), sparser) : ShellUtil.execute("rm -rf " + file.getAbsolutePath(), sparser);
                    }
                    catch (IMShellCommandFail e) {
                        exitCode = -1;
                    }
                    catch (Exception e) {
                        exitCode = -1;
                    }
                    if (exitCode == 0) {
                        logger.trace("Deleted -> " + file.getAbsolutePath());
                        continue;
                    }
                    logger.error("Delete failed -> " + file.getAbsolutePath());
                    logger.trace(sparser.getOutputMessage());
                    errorMap.put(file.getAbsolutePath(), sparser.getOutputMessage());
                }
            }
            catch (Exception e) {
                logger.throwing(e);
                HashMap<String, String> hashMap = errorMap;
                return hashMap;
            }
            finally {
                String targetDir = Config.getInstance().getTargetDir();
                if (targetDir != null && !targetDir.isEmpty() && new File(targetDir).exists()) {
                    InstallController.removeSDKLegacy(isRefreshServer);
                }
            }
        }
        return errorMap;
    }

    private PackageSet getOrderedRemovePackageSet(PackageSet original) {
        PackageSet returnSet = new PackageSet();
        do {
            PackageSet clone = (PackageSet)original.clone();
            for (Package pkg : clone) {
                Collection<String> dependentPackageNames = pkg.getDependentPackageNames();
                if (dependentPackageNames != null && !dependentPackageNames.isEmpty()) {
                    int dependentCount = dependentPackageNames.size();
                    int currentCount = 0;
                    for (String pkgName : dependentPackageNames) {
                        Package packageFromOrignial = original.getPackageByName(pkgName);
                        if (packageFromOrignial != null) continue;
                        Package packageFromReturn = returnSet.getPackageByName(pkgName);
                        if (packageFromReturn != null) {
                            ++currentCount;
                        }
                        if (packageFromReturn != null || packageFromOrignial != null) continue;
                        ++currentCount;
                    }
                    if (dependentCount != currentCount) continue;
                    returnSet.add(pkg);
                    original.remove(pkg);
                    continue;
                }
                returnSet.add(pkg);
                original.remove(pkg);
            }
        } while (!original.isEmpty());
        return returnSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeRemoveScriptOnly(Package pkg) {
        logger.info("[" + pkg + "] uninstall start");
        int resultRemoveScript = 0;
        try {
            resultRemoveScript = this.executeRemoveScript(pkg);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            resultRemoveScript = 1;
        }
        if (resultRemoveScript == 0) {
            logger.info("Execute remove script success.");
        } else if (resultRemoveScript == 1) {
            logger.error("Execute remove script fail.");
        } else if (resultRemoveScript == 2) {
            logger.info("This package does not need a remove script.");
        }
        return true;
    }

    private int executeRemoveScript(Package pkg) throws UMException {
        logger.info("executeRemoveScript => " + pkg.getRemoveScript());
        String script = PathUtil.get(PackageUtil.getRemoveScriptLocalPath(pkg));
        File scriptFile = new File(script);
        if (scriptFile.exists()) {
            try {
                ShellParser parser = new ShellParser();
                boolean result = ShellUtil.executeScript(scriptFile, pkg.getPackageName(), parser);
                if (result) {
                    return 0;
                }
                return 1;
            }
            catch (IMShellCommandFail e) {
                logger.throwing(e);
                throw new UMException(ErrorController.ErrorCode.REMOVE_SCRIPT_ERROR, pkg.getPackageName());
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndInstallUntouchablePackage() throws UMException {
        PackageSet installedPackages = PackageManager.getInstance().getInstalledPackages();
        if (installedPackages.isEmpty()) {
            ArrayList<String> untouchablePackageList = InstallController.getInstance().getUntouchablePackageList();
            for (String pName : untouchablePackageList) {
                Package pkg = PackageManager.getInstance().getPackageByName(pName);
                if (pkg == null) continue;
                String targetDir = SDKInfo.getInstalledPath();
                String downloadTargetPath = InstallController.getInstance().getDownloadTargetPath(pkg);
                URL downloadFileURL = pkg.getURL();
                Downloader mDownloader = new Downloader(downloadFileURL, 3);
                mDownloader.download(downloadTargetPath, 0L, -1L, new NullDownloadProgressMonitor());
                String tempDir = PathUtil.get(targetDir, "temp", pkg.getPackageName());
                File tmpDir = new File(tempDir);
                if (tmpDir.exists() && !PathUtil.remove(tmpDir)) {
                    logger.error("Fail to delete " + tmpDir);
                }
                String filePath = InstallController.getInstance().getDownloadTargetPath(pkg);
                String installedFileListPath = PathUtil.get(tmpDir.getAbsolutePath(), pkg.getPackageName() + ".list");
                ZipLibrary zlib = null;
                try {
                    zlib = new ZipLibrary(filePath, installedFileListPath);
                }
                catch (UMException e) {
                    logger.throwing(e);
                    throw e;
                }
                try {
                    zlib.unzip(tempDir, new NullDownloadManagerMonitor(), pkg.getUncompressedPackageSize());
                }
                catch (IOException e) {
                    logger.throwing(e);
                }
                catch (Exception e) {
                    logger.throwing(e);
                }
                finally {
                    zlib.close();
                }
                PackageInstaller.moveToTargetDirectoryFromTempDirectory(tempDir, targetDir);
                if (!PackageInstaller.movePackageInstalledList(tempDir, pkg)) {
                    throw new UMException(ErrorController.ErrorCode.FAILED_TO_WRITE_PACKAGE_INSTALL_LIST_FILE, pkg.getPackageName() + ".list");
                }
                PackageInstaller.checkAllFilesAreInstalledProperly(pkg, InstallController.getInstance(), new NullInstallUninstallPackageProgressMonitor());
                try {
                    if (!PackageInstaller.executeInstallScript(pkg, tempDir)) {
                        logger.error("Fail to execute install script.");
                        PathUtil.remove(tempDir);
                        throw new UMException(ErrorController.ErrorCode.INSTALL_SCRIPT_ERROR, pkg.getPackageName());
                    }
                }
                catch (UMException E) {
                    throw new UMException(ErrorController.ErrorCode.INSTALL_SCRIPT_ERROR, pkg.getPackageName());
                }
                if (!PackageInstaller.moveRemoveScript(tempDir, pkg, new NullInstallUninstallPackageProgressMonitor())) {
                    PathUtil.remove(tempDir);
                    throw new UMException(ErrorController.ErrorCode.SAVING_REMOVE_SCRIPT_FAILED, pkg.getPackageName());
                }
                PathUtil.remove(tempDir);
                PackageManager.getInstance().addPackageToInstalledPackages(pkg);
                PackageManager.getInstance().saveInstalledList();
            }
        }
    }
}

