/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.Install;

import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.util.Log;

public class UninstallProcess
extends Thread {
    private Component component;
    private ICommonProgressMonitor monitor;
    private Logger logger;

    public UninstallProcess(Component component, ICommonProgressMonitor monitor) {
        this.component = component;
        this.monitor = monitor;
        this.logger = Log.getLogger(UninstallProcess.class);
        this.component.resetProgressLogs();
        monitor.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.logger.info("****** Partial uninstallation ******");
            this.monitor.setProgress("Start to uninstall '" + this.component.getPackageName() + "'.");
            InstallController.getInstance().uninstall(this.component, true, this.monitor);
        }
        catch (Exception e) {
            this.logger.throwing(e);
        }
        finally {
            this.monitor.done();
        }
        this.logger.info(this.component.getPackageName() + " => finish uninstall thread");
    }

    public Component getComponent() {
        return this.component;
    }

    public ICommonProgressMonitor getMonitor() {
        return this.monitor;
    }
}

