/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.download;

import java.net.URL;
import java.util.concurrent.Callable;
import org.tizen.manager.core.download.DownloadResult;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.DownloadProgressMonitor;
import org.tizen.manager.util.Downloader;

public class DownloaderCallable
implements Callable<DownloadResult> {
    private URL downloadFileURL;
    private String downloadTargetPath;
    private long maxDownloadSize;
    private long skipBytes;
    private DownloadProgressMonitor downloadProgressMonitor;
    private int MAX_RETRY_COUNT = 5;

    public DownloaderCallable(URL downloadFileURL, String downloadTargetPath, long skipBytes, long maxDownloadSize, DownloadProgressMonitor downloadProgressMonitor) {
        this.downloadFileURL = downloadFileURL;
        this.downloadTargetPath = downloadTargetPath;
        this.maxDownloadSize = maxDownloadSize;
        this.skipBytes = skipBytes;
        this.downloadProgressMonitor = downloadProgressMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadResult call() throws Exception {
        Downloader mDownloader = new Downloader(this.downloadFileURL, this.MAX_RETRY_COUNT);
        DownloadResult dr = null;
        long download = -1L;
        UMException exception = null;
        try {
            download = mDownloader.download(this.downloadTargetPath, this.skipBytes, this.maxDownloadSize, this.downloadProgressMonitor);
        }
        catch (Exception e) {
            exception = e instanceof UMException ? (UMException)e : new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE, (Throwable)e);
            download = -1L;
        }
        finally {
            dr = new DownloadResult(this.downloadFileURL, this.downloadTargetPath, download, download, this.downloadProgressMonitor, download);
            if (exception != null) {
                dr.setError(exception);
            }
        }
        return dr;
    }
}

