/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import com.btr.proxy.search.ProxySearch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ResourceUtil;

public class NetworkUtil {
    private static final Logger logger = Log.getLogger(NetworkUtil.class);
    public static final String URL_SEPARATOR = "/";
    private static final String ENVIRONMENT = "/etc/environment";
    private static final String HTTP_PROXY_PREFIX = "http_proxy";
    public static final int CONNECT_TIMEOUT = 15000;
    public static final int READ_TIMEOUT = 20000;
    private static ProxySelector systemProxySelector = null;

    public static boolean isURL(String strURL) {
        try {
            if (strURL != null) {
                new URL(strURL);
                return true;
            }
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isSameURL(String strURL1, String strURL2) {
        if (NetworkUtil.isURL(strURL1) && NetworkUtil.isURL(strURL2)) {
            return NetworkUtil.normalizeURL(strURL1).equalsIgnoreCase(NetworkUtil.normalizeURL(strURL2));
        }
        return false;
    }

    public static String normalizeURL(String strURL) {
        if (NetworkUtil.isURL(strURL)) {
            strURL = strURL.trim();
            return NetworkUtil.removeTailingSeparators(strURL);
        }
        return strURL;
    }

    private static String removeTailingSeparators(String strURL) {
        if (strURL.endsWith(URL_SEPARATOR)) {
            while (strURL.endsWith(URL_SEPARATOR)) {
                strURL = strURL.substring(0, strURL.length() - 1);
            }
        }
        return strURL;
    }

    public static String getURL(String ... urlComponents) {
        if (urlComponents == null) {
            return "";
        }
        String result = "";
        for (int i = 0; i < urlComponents.length; ++i) {
            if (urlComponents[i] == null || urlComponents[i].isEmpty()) continue;
            String urlPart = NetworkUtil.removeStartingSeparators(NetworkUtil.removeTailingSeparators(urlComponents[i]));
            result = result.isEmpty() ? urlPart : result + URL_SEPARATOR + urlPart;
        }
        if (NetworkUtil.isURL(result)) {
            return NetworkUtil.normalizeURL(result);
        }
        if (NetworkUtil.isURL("http://" + result)) {
            return NetworkUtil.normalizeURL("http://" + result);
        }
        return result;
    }

    private static String removeStartingSeparators(String strURL) {
        if (strURL.startsWith(URL_SEPARATOR)) {
            while (strURL.startsWith(URL_SEPARATOR)) {
                strURL = strURL.substring(1, strURL.length());
            }
        }
        return strURL;
    }

    public static String getFileURL(String filePath) {
        if (PlatformUtil.isWindows()) {
            return NetworkUtil.normalizeURL("file:///" + new File(filePath).getAbsolutePath().replace(File.separator, URL_SEPARATOR));
        }
        return NetworkUtil.normalizeURL("file://" + new File(filePath).getAbsolutePath());
    }

    public static String getPathFromURL(String fileURL) {
        if (NetworkUtil.isURL(fileURL)) {
            try {
                URL url = new URL(fileURL);
                String urlPath = url.getPath();
                if (PlatformUtil.isWindows()) {
                    if (urlPath.startsWith(URL_SEPARATOR)) {
                        return url.getPath().substring(1).replace(URL_SEPARATOR, File.separator);
                    }
                    return url.getPath().replace(URL_SEPARATOR, File.separator);
                }
                return url.getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return fileURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Proxy> getSystemProxyList(URL url) {
        List<Proxy> proxyList = null;
        try {
            if (systemProxySelector == null) {
                ProxySearch proxySearch = new ProxySearch();
                proxySearch.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
                proxySearch.addStrategy(ProxySearch.Strategy.JAVA);
                proxySearch.addStrategy(ProxySearch.Strategy.BROWSER);
                proxySearch.addStrategy(ProxySearch.Strategy.ENV_VAR);
                systemProxySelector = proxySearch.getProxySelector();
                if (systemProxySelector == null) {
                    systemProxySelector = ProxySelector.getDefault();
                }
            }
            proxyList = systemProxySelector.select(url.toURI());
        }
        catch (Exception e) {
            logger.throwing(e);
        }
        finally {
            if (proxyList == null || proxyList.isEmpty() || proxyList.size() == 1 && proxyList.get(0) == Proxy.NO_PROXY) {
                proxyList = new ArrayList<Proxy>();
                if (PlatformUtil.isUbuntu()) {
                    Proxy systemProxy = NetworkUtil.getSystemProxyOnLinux();
                    if (systemProxy != null) {
                        logger.trace("\tUse the proxy from Ubuntu environment variables");
                        proxyList.add(systemProxy);
                    } else {
                        logger.trace("\tUse the direct connection because of no Ubuntu environment variables");
                        proxyList.add(Proxy.NO_PROXY);
                    }
                } else {
                    logger.trace("\tUse the direct connection by exceptions");
                    proxyList.add(Proxy.NO_PROXY);
                }
            }
        }
        return proxyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Proxy getSystemProxyOnLinux() {
        Proxy systemProxy;
        block7: {
            File envFile = new File(ENVIRONMENT);
            if (!envFile.exists()) {
                logger.trace("Cannot find environment file. So, manager cannot get system proxy.   path : /etc/environment");
                return null;
            }
            systemProxy = null;
            InetAddress addr = null;
            InetSocketAddress sa = null;
            FileInputStream is = null;
            BufferedReader in = null;
            try {
                is = new FileInputStream(ENVIRONMENT);
                in = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                String line = "";
                while ((line = in.readLine()) != null) {
                    if (!line.startsWith(HTTP_PROXY_PREFIX)) continue;
                    line = line.replace("\"", "");
                    line = line.replace(URL_SEPARATOR, "");
                    String[] split = line.split("=");
                    String[] split2 = split[1].split(":");
                    addr = InetAddress.getByName(split2[1]);
                    sa = new InetSocketAddress(addr, Integer.parseInt(split2[2]));
                    systemProxy = new Proxy(Proxy.Type.HTTP, sa);
                }
                ResourceUtil.closeObjectSilently(in);
            }
            catch (IOException e) {
                logger.throwing(e);
                break block7;
            }
            finally {
                ResourceUtil.closeObjectSilently(in);
                ResourceUtil.closeObjectSilently(is);
            }
            ResourceUtil.closeObjectSilently(is);
        }
        return systemProxy;
    }

    public static Proxy getManualProxy(String host, int port) throws UnknownHostException {
        InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(host), port);
        return new Proxy(Proxy.Type.HTTP, addr);
    }

    public static boolean isAvailableURL(URL url) {
        if (url.getProtocol().equalsIgnoreCase("file")) {
            return true;
        }
        int port = url.getPort();
        if (port < 0) {
            port = url.getDefaultPort();
        }
        return NetworkUtil.isAvailableURL(url.getHost(), port);
    }

    public static boolean isAvailableURL(String host, int port) {
        try {
            new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException e) {
            logger.throwing(e);
            return false;
        }
        catch (IllegalArgumentException e) {
            logger.throwing(e);
            return false;
        }
        catch (SecurityException e) {
            logger.throwing(e);
            return false;
        }
        return true;
    }

    public static URLConnection connectToURL(URL url, Proxy proxy, long skipBytes, int connectTimeout, int readTimeout) throws IOException {
        URLConnection conn = url.openConnection(proxy);
        conn.setUseCaches(false);
        if (conn != null) {
            if (connectTimeout > 0) {
                conn.setConnectTimeout(connectTimeout);
            } else {
                conn.setConnectTimeout(15000);
            }
            if (readTimeout > 0) {
                conn.setReadTimeout(readTimeout);
            } else {
                conn.setReadTimeout(20000);
            }
            if (skipBytes > 0L) {
                conn.setRequestProperty("Range", "bytes=" + String.valueOf(skipBytes) + '-');
            }
            conn.connect();
        }
        return conn;
    }
}

