/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.ComponentManager;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.PrerequisitesUtil;
import org.tizen.manager.util.ProgramController;
import org.tizen.packagemanager.cli.CLIInstallUpdateProcessMonitor;
import org.tizen.packagemanager.cli.CLIMessages;
import org.tizen.packagemanager.cli.CLIOptions;

class CLIInstallUpdateProcess {
    private Logger logger = null;
    private CLIOptions options;

    CLIInstallUpdateProcess(CLIOptions options) {
        this.options = options;
        this.logger = Log.getLogger(CLIInstallUpdateProcess.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateAllOnConsole() throws Exception {
        this.killRunningProcess();
        if (PackageManager.getInstance().areRepoPackagesOutdated()) {
            System.out.println("Installation cannot proceed because the SDK you want to install(update) is a lower version than the SDK on your computer.");
            return true;
        }
        System.out.println("");
        System.out.println("****************************************");
        System.out.println("******* Start SDK Update *******");
        System.out.println("****************************************");
        List<Component> componentList = ComponentManager.getInstance().getComponentList();
        ArrayList<Component> updateComponentList = new ArrayList<Component>();
        if (componentList != null && !componentList.isEmpty()) {
            for (Component component : componentList) {
                if (component.getInstallState() != Component.InstallState.UPDATE || component.getParent() == null) continue;
                updateComponentList.add(component);
            }
            if (updateComponentList.isEmpty()) {
                System.out.println("Nothing to update.");
                return true;
            }
        } else {
            System.out.println("Nothing to update.");
            return true;
        }
        ArrayList<Component> allComponents = new ArrayList<Component>();
        for (Component subComponent : updateComponentList) {
            ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToInstall(subComponent);
            for (Component selComp : selGroupComps) {
                if (allComponents.contains(selComp)) continue;
                allComponents.add(selComp);
            }
            if (allComponents.contains(subComponent)) continue;
            allComponents.add(subComponent);
        }
        ArrayList<Component> sortedComponents = ComponentManager.getSortedComponentsByInstallOrder(allComponents);
        if (PlatformUtil.isLinux()) {
            this.checkPrerequsites(sortedComponents);
        }
        System.out.println("Under packages are will be updated.");
        for (Component component : sortedComponents) {
            System.out.println("\t * " + component.getPackageName());
        }
        boolean installResult = true;
        try {
            for (Component installComponent : sortedComponents) {
                CLIInstallUpdateProcessMonitor monitor = new CLIInstallUpdateProcessMonitor(installComponent, ICommonProgressMonitor.ProgressMonitorType.UPDATE);
                InstallController.getInstance().addComponentToProcessQueue(installComponent, monitor);
                InstallController.getInstance().install(installComponent, monitor);
                monitor.done();
            }
        }
        catch (Exception e) {
            this.logger.throwing(e);
            System.out.println(e);
            installResult = false;
        }
        finally {
            if (installResult) {
                System.out.println("Updating has been completed.");
            } else {
                System.out.println("Updating has been failed.");
            }
        }
        return installResult;
    }

    boolean installOnConsole(List<String> packageNames) throws Exception {
        if (PackageManager.getInstance().areRepoPackagesOutdated()) {
            System.out.println("Installation cannot proceed because the SDK you want to install(update) is a lower version than the SDK on your computer.");
            return true;
        }
        PackageSet installedPackages = PackageManager.getInstance().getInstalledPackages();
        if (installedPackages != null && !installedPackages.isEmpty()) {
            this.updateAllOnConsole();
        } else {
            this.killRunningProcess();
        }
        System.out.println("");
        System.out.println("****************************************");
        System.out.println("******* Start SDK Installation *******");
        System.out.println("****************************************");
        ArrayList<Component> installComponentList = new ArrayList<Component>();
        List<Component> componentList = ComponentManager.getInstance().getComponentList();
        if (componentList != null && !componentList.isEmpty()) {
            block0: for (String pkgname : packageNames) {
                for (Component component : componentList) {
                    if (!component.getPackageName().equals(pkgname) || component.getInstallState() != Component.InstallState.INSTALL) continue;
                    installComponentList.add(component);
                    continue block0;
                }
            }
            if (installComponentList.isEmpty()) {
                System.out.println("Nothing to install.");
                return true;
            }
        } else {
            System.out.println("Nothing to install.");
            return true;
        }
        for (Component component : installComponentList) {
            if (component == null || component.getInstallState() != Component.InstallState.INSTALL || !(!component.hasChildren() ? !this.startToInstallSingleTreeItem(component) : !this.startToInstallAllSubTreeItem(component))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startToInstallSingleTreeItem(Component component) throws Exception {
        ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToInstall(component);
        if (!selGroupComps.isEmpty() && !this.checkInstallSelectedGroup(selGroupComps)) {
            return false;
        }
        ArrayList<Component> checkLicense = new ArrayList<Component>();
        checkLicense.add(component);
        if (!this.checkAgreeEULA(checkLicense)) {
            return false;
        }
        ArrayList<Component> targetComponents = new ArrayList<Component>();
        targetComponents.add(component);
        for (Component selCompo : selGroupComps) {
            if (targetComponents.contains(selCompo)) continue;
            targetComponents.add(selCompo);
        }
        if (PlatformUtil.isLinux()) {
            this.checkPrerequsites(targetComponents);
        }
        System.out.println("Under packages are will be installed.");
        for (Component targetComponent : targetComponents) {
            System.out.println("\t * " + targetComponent.getPackageName());
        }
        boolean installResult = true;
        try {
            for (Component installComponent : targetComponents) {
                CLIInstallUpdateProcessMonitor monitor = new CLIInstallUpdateProcessMonitor(installComponent, ICommonProgressMonitor.ProgressMonitorType.INSTALL);
                InstallController.getInstance().addComponentToProcessQueue(installComponent, monitor);
                InstallController.getInstance().install(installComponent, monitor);
                monitor.done();
            }
        }
        catch (Exception e) {
            this.logger.throwing(e);
            System.out.println(e);
            installResult = false;
        }
        finally {
            if (installResult) {
                System.out.println("Installation has been completed.");
            } else {
                System.out.println("Installation has been failed.");
            }
        }
        return installResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startToInstallAllSubTreeItem(Component component) throws Exception {
        ArrayList<Component> targetComponents = new ArrayList<Component>();
        for (Component subComponent : component.getLeafDecendents()) {
            if (targetComponents.contains(subComponent) || subComponent.getInstallState() != Component.InstallState.INSTALL) continue;
            targetComponents.add(subComponent);
        }
        if (targetComponents.isEmpty()) {
            return false;
        }
        ArrayList<Component> tempComponents = new ArrayList<Component>();
        ArrayList<Component> sortedComponents = new ArrayList<Component>();
        tempComponents = new ArrayList();
        for (Component comp : targetComponents) {
            ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToInstall(comp);
            for (Component selComp : selGroupComps) {
                if (tempComponents.contains(selComp)) continue;
                tempComponents.add(selComp);
            }
            if (tempComponents.contains(comp)) continue;
            tempComponents.add(comp);
        }
        for (Component comp : ComponentManager.getSortedComponentsByInstallOrder(tempComponents)) {
            if (sortedComponents.contains(comp)) continue;
            sortedComponents.add(comp);
        }
        if (!this.checkAgreeEULA(sortedComponents)) {
            return false;
        }
        if (PlatformUtil.isLinux()) {
            this.checkPrerequsites(sortedComponents);
        }
        System.out.println("Under packages are will be installed.");
        for (Component targetComponent : sortedComponents) {
            System.out.println("\t * " + targetComponent.getPackageName());
        }
        boolean installResult = true;
        try {
            for (Component installComponent : sortedComponents) {
                CLIInstallUpdateProcessMonitor monitor = new CLIInstallUpdateProcessMonitor(installComponent, ICommonProgressMonitor.ProgressMonitorType.INSTALL);
                InstallController.getInstance().addComponentToProcessQueue(installComponent, monitor);
                InstallController.getInstance().install(installComponent, monitor);
                monitor.done();
            }
        }
        catch (Exception e) {
            this.logger.throwing(e);
            System.out.println(e);
            installResult = false;
        }
        finally {
            if (installResult) {
                System.out.println("Installation has been completed.");
            } else {
                System.out.println("Installation has been failed.");
            }
        }
        return installResult;
    }

    private boolean checkInstallSelectedGroup(ArrayList<Component> selGroupComps) {
        String strCompNames = "";
        for (Component comp : selGroupComps) {
            if (!strCompNames.isEmpty()) {
                strCompNames = strCompNames + ", ";
            }
            strCompNames = strCompNames + "'" + comp.getDisplayName() + "'";
        }
        return true;
    }

    private boolean checkAgreeEULA(ArrayList<Component> components) {
        ArrayList<Component> needLicenseComps = new ArrayList<Component>();
        for (Component comp : components) {
            if (comp.hasLicense() && !comp.isLicenseAgreed() && !needLicenseComps.contains(comp)) {
                needLicenseComps.add(comp);
            }
            ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToInstall(comp);
            for (Component selGroupComp : selGroupComps) {
                if (!selGroupComp.hasLicense() || selGroupComp.isLicenseAgreed() || needLicenseComps.contains(selGroupComp)) continue;
                needLicenseComps.add(selGroupComp);
            }
        }
        String strNeedLicenseCompNames = "";
        for (Component comp : needLicenseComps) {
            if (!strNeedLicenseCompNames.isEmpty()) {
                strNeedLicenseCompNames = strNeedLicenseCompNames + ", ";
            }
            strNeedLicenseCompNames = strNeedLicenseCompNames + "'" + comp.getDisplayName() + "'";
        }
        if (!needLicenseComps.isEmpty() && !this.options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.ACCEPT_LICENSE)) {
            System.out.println("The following dependent package(s) need license agreement according to dependency:");
            System.out.println(needLicenseComps);
            System.out.println(CLIMessages.AGREEMENT_LICENSE);
            return false;
        }
        return true;
    }

    private void killRunningProcess() throws Exception {
        ProgramController controller = ProgramController.createProgramController();
        List<String> sdkProcessList = controller.getSDKProcessList();
        if (sdkProcessList != null && sdkProcessList.size() > 0) {
            String msg = "";
            for (String processString : sdkProcessList) {
                msg = msg + "\t" + processString + "\n";
            }
            throw new Exception(String.format("SDK programs are running under installed location.\n%sClose the running programs.", msg));
        }
    }

    public void checkPrerequsites(ArrayList<Component> componentList) throws Exception {
        Map<String, List<String>> checkPrerequisities = PrerequisitesUtil.checkPrerequisities(componentList);
        if (checkPrerequisities != null && checkPrerequisities.size() > 0) {
            String msg = "Required prerequisite packages are not installed.\nPlease install the packages using following command(s).\n";
            this.logger.trace("\tUnder libraries are not installed");
            this.logger.trace("\t##############################################");
            Set<String> keySet = checkPrerequisities.keySet();
            Iterator<String> i$ = keySet.iterator();
            while (i$.hasNext()) {
                String key;
                String pkgName = key = i$.next();
                if (key.endsWith("*")) {
                    pkgName = key.substring(0, key.lastIndexOf("*"));
                }
                String msgValue = "sudo apt-get install " + pkgName;
                msg = msg + msgValue + "\n";
                this.logger.trace("\t" + msgValue);
            }
            this.logger.trace("\t##############################################");
            throw new Exception(msg);
        }
    }
}

