/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.Install;

import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.util.Log;

public class InstallProcess
extends Thread {
    private Component component;
    private ICommonProgressMonitor monitor;
    private Logger logger;

    public InstallProcess(Component component, ICommonProgressMonitor monitor) {
        this.component = component;
        this.monitor = monitor;
        this.logger = Log.getLogger(InstallProcess.class);
        this.component.resetProgressLogs();
        monitor.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bResult = true;
        try {
            this.monitor.setProgress("Start to install '" + this.component.getPackageName() + "'.");
            InstallController.getInstance().install(this.component, this.monitor);
        }
        catch (Exception e) {
            this.logger.error("Exception => " + e.getMessage());
            this.logger.throwing(e);
            bResult = false;
        }
        finally {
            if (!bResult) {
                this.monitor.setProgress("Failed to install... " + this.component.getPackageName());
            }
            this.monitor.done();
        }
        this.logger.info(this.component.getPackageName() + " => finish install thread");
    }

    public Component getComponent() {
        return this.component;
    }

    public ICommonProgressMonitor getMonitor() {
        return this.monitor;
    }
}

