/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.ComponentManager;
import org.tizen.manager.svc.sdkutils.PackageInfoJSON;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ProgramController;
import org.tizen.packagemanager.cli.CLIUninstallProcessMonitor;
import org.tizen.packagemanager.cli.CLIUninstallProgressMonitor;

class CLIUninstallProcess {
    private Logger logger = Log.getLogger(CLIUninstallProcess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeAllOnConsole(boolean isRefreshServer) throws Exception {
        this.killRunningProcess();
        boolean installResult = true;
        System.out.println("");
        System.out.println("****************************************");
        System.out.println("******* Start SDK uninstallation *******");
        System.out.println("****************************************");
        try {
            InstallController.getInstance().uninstallAll(new CLIUninstallProgressMonitor(), isRefreshServer);
        }
        catch (Exception e) {
            try {
                this.logger.throwing(e);
                System.out.println(e);
                installResult = false;
            }
            catch (Throwable throwable) {
                InstallController.removeSDKLegacy(isRefreshServer);
                InstallController.getInstance().removeSDKLegacyCLI(isRefreshServer);
                System.out.println("Uninstall has been completed");
                PackageInfoJSON.removeAllCaches();
                if (!isRefreshServer && PlatformUtil.isWindows()) {
                    String format = "Could not delete \"%s\" because of the directory open in console.\nPlease delete directory \"%s\" manually.";
                    String removePath = SDKInfo.getInstalledPath();
                    System.out.println(String.format(format, removePath, removePath));
                }
                throw throwable;
            }
            InstallController.removeSDKLegacy(isRefreshServer);
            InstallController.getInstance().removeSDKLegacyCLI(isRefreshServer);
            System.out.println("Uninstall has been completed");
            PackageInfoJSON.removeAllCaches();
            if (!isRefreshServer && PlatformUtil.isWindows()) {
                String format = "Could not delete \"%s\" because of the directory open in console.\nPlease delete directory \"%s\" manually.";
                String removePath = SDKInfo.getInstalledPath();
                System.out.println(String.format(format, removePath, removePath));
            }
        }
        InstallController.removeSDKLegacy(isRefreshServer);
        InstallController.getInstance().removeSDKLegacyCLI(isRefreshServer);
        System.out.println("Uninstall has been completed");
        PackageInfoJSON.removeAllCaches();
        if (!isRefreshServer && PlatformUtil.isWindows()) {
            String format = "Could not delete \"%s\" because of the directory open in console.\nPlease delete directory \"%s\" manually.";
            String removePath = SDKInfo.getInstalledPath();
            System.out.println(String.format(format, removePath, removePath));
        }
        return installResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeOnConsole(List<String> packageNames) throws Exception {
        this.killRunningProcess();
        boolean installResult = true;
        System.out.println("");
        System.out.println("****************************************");
        System.out.println("******* Start SDK uninstallation *******");
        System.out.println("****************************************");
        try {
            List<Component> componentList = ComponentManager.getInstance().getComponentList();
            ArrayList<Component> removeComponenetList = new ArrayList<Component>();
            block6: for (String pkgName : packageNames) {
                for (Component component : componentList) {
                    if (!component.getPackageName().equals(pkgName) || component.getInstallState() == Component.InstallState.INSTALL) continue;
                    removeComponenetList.add(component);
                    continue block6;
                }
            }
            if (removeComponenetList.isEmpty()) {
                System.out.println("Nothing to uninstall.");
                boolean i$ = true;
                return i$;
            }
            for (Component component : removeComponenetList) {
                if (!component.hasChildren()) {
                    this.startToUninstallSingleTreeItem(component);
                    continue;
                }
                this.startToUninstallAllSubTreeItem(component);
            }
        }
        catch (Exception e) {
            this.logger.throwing(e);
            System.out.println(e);
            installResult = false;
        }
        finally {
            System.out.println("Uninstall has been completed");
        }
        return installResult;
    }

    private void startToUninstallSingleTreeItem(Component component) throws UMException {
        ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToUninstall(component);
        if (!selGroupComps.isEmpty()) {
            String strCompNames = "";
            for (Component comp : selGroupComps) {
                if (!strCompNames.isEmpty()) {
                    strCompNames = strCompNames + ", ";
                }
                strCompNames = strCompNames + "'" + comp.getDisplayName() + "'";
            }
        }
        this.createUninstallProcess(component, selGroupComps);
    }

    private void startToUninstallAllSubTreeItem(Component component) throws UMException {
        ArrayList<Component> targetComponents = new ArrayList<Component>();
        for (Component subComponent : component.getLeafDecendents()) {
            if (targetComponents.contains(subComponent) || subComponent.getInstallState() != Component.InstallState.UNINSTALL && subComponent.getInstallState() != Component.InstallState.UPDATE) continue;
            targetComponents.add(subComponent);
        }
        if (targetComponents.isEmpty()) {
            return;
        }
        ArrayList<Component> tempComponents = new ArrayList<Component>();
        tempComponents = new ArrayList();
        for (Component comp : targetComponents) {
            ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToUninstall(comp);
            for (Component selComp : selGroupComps) {
                if (tempComponents.contains(selComp)) continue;
                tempComponents.add(selComp);
            }
            if (tempComponents.contains(comp)) continue;
            tempComponents.add(comp);
        }
        ArrayList<Component> sortedComponents = ComponentManager.getSortedComponentsByInstallOrder(tempComponents);
        Collections.reverse(sortedComponents);
        this.createGroupUninstallProcess(sortedComponents);
    }

    private void createUninstallProcess(Component component, ArrayList<Component> selGroupComps) throws UMException {
        ArrayList<Component> dependentComps = new ArrayList<Component>();
        dependentComps.addAll(selGroupComps);
        component.setDependentComponents(dependentComps);
        ArrayList<Component> sortedDepComps = ComponentManager.getSortedComponentsByInstallOrder(component.getDependentComponents());
        Collections.reverse(sortedDepComps);
        sortedDepComps.add(component);
        for (Component removeComponent : sortedDepComps) {
            if (removeComponent.getInstallState() == Component.InstallState.INSTALL) continue;
            CLIUninstallProcessMonitor monitor = new CLIUninstallProcessMonitor(removeComponent);
            InstallController.getInstance().addComponentToProcessQueue(removeComponent, monitor);
            InstallController.getInstance().uninstall(removeComponent, false, monitor);
            removeComponent.setInstallState(Component.InstallState.INSTALL);
            monitor.done();
        }
    }

    private void createGroupUninstallProcess(ArrayList<Component> components) throws UMException {
        for (Component removeComponent : components) {
            if (removeComponent.getInstallState() == Component.InstallState.INSTALL) continue;
            CLIUninstallProcessMonitor monitor = new CLIUninstallProcessMonitor(removeComponent);
            InstallController.getInstance().addComponentToProcessQueue(removeComponent, monitor);
            InstallController.getInstance().uninstall(removeComponent, false, monitor);
            removeComponent.setInstallState(Component.InstallState.INSTALL);
            monitor.done();
        }
    }

    private void killRunningProcess() throws Exception {
        ProgramController controller = ProgramController.createProgramController();
        List<String> sdkProcessList = controller.getSDKProcessList();
        if (sdkProcessList != null && sdkProcessList.size() > 0) {
            String msg = "";
            for (String processString : sdkProcessList) {
                msg = msg + "\t" + processString + "\n";
            }
            throw new Exception(String.format("SDK programs are running under installed location.\n%sClose the running programs.", msg));
        }
    }
}

