/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.pkg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.FileImageInputStream;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.Install.InstallUninstallPackageProgressMonitor;
import org.tizen.manager.core.Install.PackageUninstaller;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.core.RepositoryUtil;
import org.tizen.manager.core.UMNullProgressMonitor;
import org.tizen.manager.core.config.PropertyParser;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.core.model.PropertySection;
import org.tizen.manager.core.model.Snapshot;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.ComponentManager;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.util.DownloadProgressMonitor;
import org.tizen.manager.util.Downloader;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;

public class PackageUtil {
    private static final Logger logger = Log.getLogger(PackageUtil.class);

    static PackageSet readPackageListFromRepository(String repoURL) throws UMException {
        return PackageUtil.readPackageListFromRepository(repoURL, null, false, null);
    }

    static PackageSet readPackageListFromRepository(String repoURL, boolean isExtServer, String repoId) throws UMException {
        return PackageUtil.readPackageListFromRepository(repoURL, null, isExtServer, repoId);
    }

    public static PackageSet readPackageListFromRepository(String repoURL, String snapshotPath) throws UMException {
        return PackageUtil.readPackageListFromRepository(repoURL, snapshotPath, false, null);
    }

    private static PackageSet readPackageListFromRepository(String repoURL, String snapshotPath, boolean isExtServer, String repoId) throws UMException {
        PackageSet result = new PackageSet();
        try {
            URL packageListURL = PackageUtil.getPackageListURL(repoURL, snapshotPath);
            File packageListFile = PackageUtil.downloadPackageListFile(packageListURL);
            PropertyParser parser = new PropertyParser();
            List<PropertySection> propertySectionList = parser.readFromFile(packageListFile);
            for (PropertySection sect : propertySectionList) {
                Package pkg = new Package(sect.getProperties(), repoURL);
                if (isExtServer) {
                    pkg.setExtensionServer(repoId);
                }
                result.add(pkg);
            }
        }
        catch (UMException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_LOAD_PACKAGE_INFO_FILE, (Throwable)e);
        }
        return result;
    }

    private static URL getPackageListURL(String repoURL, String snapshotPath) throws UMException {
        assert (repoURL != null && !repoURL.isEmpty());
        if (snapshotPath == null || snapshotPath.isEmpty() || snapshotPath.equalsIgnoreCase("null")) {
            Snapshot latestSnapshot = null;
            try {
                latestSnapshot = RepositoryUtil.readLatestSnapshot(repoURL);
            }
            catch (UMException e) {
                logger.throwing(e);
            }
            snapshotPath = latestSnapshot != null ? latestSnapshot.getPath() : null;
        }
        String pkgListURL = NetworkUtil.getURL(repoURL, PackageUtil.getPackageListFileName());
        if (snapshotPath != null) {
            pkgListURL = NetworkUtil.getURL(repoURL, snapshotPath, PackageUtil.getPackageListFileName());
        }
        try {
            return new URL(pkgListURL);
        }
        catch (MalformedURLException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.INVALID_REPO_URL_FORMAT, pkgListURL);
        }
    }

    private static String getPackageListFileName() {
        if (PlatformUtil.isMacOS()) {
            return "pkg_list_macos-64";
        }
        if (PlatformUtil.isLinux()) {
            if (PlatformUtil.CURRENT_PLATFORM == 1) {
                return "pkg_list_ubuntu-32";
            }
            return "pkg_list_ubuntu-64";
        }
        if (PlatformUtil.isWindows()) {
            if (PlatformUtil.CURRENT_PLATFORM == 8) {
                return "pkg_list_windows-32";
            }
            return "pkg_list_windows-64";
        }
        return null;
    }

    private static File downloadPackageListFile(URL packageListURL) throws UMException {
        File tmp;
        assert (packageListURL != null);
        try {
            tmp = File.createTempFile("Packages", ".list");
            tmp.deleteOnExit();
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.CANNOT_CREATE_TEMP_FILE, (Throwable)e);
        }
        Downloader dl = new Downloader(packageListURL);
        long size = dl.download(tmp.getAbsolutePath(), new DownloadProgressMonitor());
        if (size < 0L) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE);
        }
        return tmp;
    }

    public static String getInstalledFileListPath(Package pkg) {
        return PathUtil.get(PathUtil.getFromInstalledPath(".info"), pkg.getPackageName(), pkg.getPackageName() + ".list");
    }

    public static String getRemoveScriptLocalPath(Package pkg) {
        return PathUtil.get(PathUtil.getFromInstalledPath(".info"), pkg.getPackageName(), pkg.getRemoveScript());
    }

    public static void deletePackageFilesWhichIsNotInInstalledList() {
        File[] listFiles;
        List<String> list = PackageManager.getInstance().getInstalledPkgNames();
        String infoHome = PathUtil.get(SDKInfo.getInstalledPath(), ".info");
        File infoHomeFile = new File(infoHome);
        if (!infoHomeFile.exists() || !infoHomeFile.isDirectory()) {
            return;
        }
        for (File file : listFiles = infoHomeFile.listFiles()) {
            if (!file.isDirectory()) continue;
            if (!list.contains(file.getName())) {
                PackageUtil.deletePackageInfoDirectory(file.getName());
                continue;
            }
            logger.trace("Package is in installed list => " + file.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deletePackageInfoDirectory(String pkgName) {
        String pkgDirPath = PathUtil.get(SDKInfo.getInstalledPath(), ".info", pkgName);
        File installedListPkg = new File(pkgDirPath, pkgName + ".list");
        if (installedListPkg.exists()) {
            FileImageInputStream fiis = null;
            try {
                fiis = new FileImageInputStream(installedListPkg);
                String line = "";
                while ((line = fiis.readLine()) != null) {
                    File tempFile = new File(PathUtil.get(SDKInfo.getInstalledPath(), line));
                    if (!tempFile.exists()) continue;
                    logger.trace("\tPackage : " + pkgName + " File is exists => " + tempFile.getAbsolutePath());
                    tempFile.delete();
                }
            }
            catch (FileNotFoundException e) {
                logger.throwing(e);
            }
            catch (IOException e) {
                logger.throwing(e);
            }
            finally {
                try {
                    if (fiis != null) {
                        fiis.close();
                    }
                }
                catch (IOException e) {
                    logger.throwing(e);
                }
                try {
                    PathUtil.remove(pkgDirPath);
                }
                catch (Exception e) {
                    logger.throwing(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstallDisconnectedPackages() {
        boolean existsRemoved;
        PackageManager packageManager = PackageManager.getInstance();
        ArrayList<String> untouchablePackageList = InstallController.getInstance().getUntouchablePackageList();
        block27: do {
            existsRemoved = false;
            PackageSet installedPkgs = packageManager.getInstalledPackages();
            PackageSet recentPkgs = packageManager.getRecentPackages();
            for (Package pkg : installedPkgs) {
                if (untouchablePackageList.contains(pkg.getPackageName())) {
                    logger.trace("Skip delete untouchable package when clean up ==> " + pkg);
                    continue;
                }
                if (!pkg.isMeta()) {
                    boolean existsDepPkg = false;
                    for (Package pkg2 : installedPkgs) {
                        if (pkg == pkg2) continue;
                        Package pkg3 = recentPkgs.getPackageByName(pkg2.getPackageName());
                        if (pkg3.isMeta()) {
                            pkg2 = pkg3;
                        }
                        if (!pkg2.hasDependencyOn(pkg)) continue;
                        existsDepPkg = true;
                        break;
                    }
                    if (existsDepPkg) continue;
                    logger.trace("\t* Removing the package which has no parent => " + pkg.getPackageName());
                    PackageUninstaller pu = new PackageUninstaller();
                    InstallUninstallPackageProgressMonitor iupm = new InstallUninstallPackageProgressMonitor(pkg, new UMNullProgressMonitor());
                    try {
                        pu.uninstall(pkg, iupm);
                    }
                    catch (UMException e) {
                        logger.throwing(e);
                        iupm.setError(e);
                    }
                    finally {
                        iupm.done();
                    }
                    existsRemoved = true;
                    continue block27;
                }
                Package pkg3 = recentPkgs.getPackageByName(pkg.getPackageName());
                if (pkg3.isMeta()) {
                    pkg = pkg3;
                }
                boolean existsChild = false;
                for (Package pkg2 : installedPkgs) {
                    if (pkg == pkg2 || !pkg.hasDependencyOn(pkg2)) continue;
                    existsChild = true;
                    break;
                }
                if (existsChild) continue;
                String installedFileListPath = PackageUtil.getInstalledFileListPath(pkg);
                File installedFile = new File(installedFileListPath);
                if (installedFile.exists()) {
                    FileImageInputStream fiis = null;
                    try {
                        fiis = new FileImageInputStream(installedFile);
                        String readLine = "";
                        boolean isRealPackage = false;
                        while ((readLine = fiis.readLine()) != null) {
                            if (readLine.trim().isEmpty()) continue;
                            logger.trace(pkg + " has installed file.");
                            isRealPackage = true;
                            break;
                        }
                        if (isRealPackage) {
                            logger.trace(pkg + " ==> is real package.");
                            continue;
                        }
                    }
                    catch (FileNotFoundException e) {
                        logger.error(e);
                    }
                    catch (IOException e) {
                        logger.error(e);
                    }
                    finally {
                        if (fiis == null) continue;
                        try {
                            fiis.close();
                        }
                        catch (IOException e) {
                            logger.error(e);
                        }
                        continue;
                    }
                }
                logger.trace("\t* Removing the meta package which has no child. => " + pkg.getPackageName());
                Component comp = ComponentManager.getInstance().getComponentByName(pkg.getPackageName());
                PackageUninstaller pu = new PackageUninstaller();
                InstallUninstallPackageProgressMonitor iupm = new InstallUninstallPackageProgressMonitor(pkg, new UMNullProgressMonitor());
                try {
                    pu.uninstall(pkg, iupm);
                }
                catch (UMException e) {
                    logger.throwing(e);
                    iupm.setError(e);
                }
                finally {
                    comp.setInstallState(ComponentManager.getInstance().calculateInstallState(comp));
                    ComponentManager.getInstance().refresh();
                    iupm.done();
                }
                existsRemoved = true;
                continue block27;
            }
        } while (existsRemoved);
    }
}

