/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.ResourceUtil;

public class SDKInfo {
    private static final Logger logger = Log.getLogger(SDKInfo.class);
    public static final String SDK_INFORMATION_FILE_NAME = "sdk.info";
    private static final String INSTALLED_PATH_KEY = "TIZEN_SDK_INSTALLED_PATH";
    private static final String SDK_DATA_PATH_KEY = "TIZEN_SDK_DATA_PATH";
    public static final String KEYSTORE = "keystore";
    private static String sdkDataPath = "";
    private static String installedPath = "";

    public void init() throws UMException {
        String executableDir = PathUtil.getExecutableDir();
        String executablePath = null;
        try {
            executablePath = new File(executableDir).getCanonicalPath();
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.EXECUTABLE_PATH_INVALID, (Throwable)e);
        }
        logger.trace("Executable path => " + executablePath);
        File managerDir = new File(executablePath);
        String sdkInfoPath = PathUtil.get(managerDir.getParent(), SDK_INFORMATION_FILE_NAME);
        File sdkInfoFile = new File(sdkInfoPath);
        if (!sdkInfoFile.exists()) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_FIND_INSTALLED_SDK);
        }
        HashMap<String, String> result = this.loadSdkInfoFile(sdkInfoPath);
        installedPath = new File(result.get(INSTALLED_PATH_KEY)).getAbsolutePath();
        sdkDataPath = new File(result.get(SDK_DATA_PATH_KEY)).getAbsolutePath();
    }

    public void save(boolean overwrite) throws UMException {
        String executableDir = PathUtil.getExecutableDir();
        String executablePath = null;
        try {
            executablePath = new File(executableDir).getCanonicalPath();
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.EXECUTABLE_PATH_INVALID, executableDir);
        }
        logger.trace("Executable path(Canonical) => " + executablePath);
        File managerDir = new File(executablePath);
        String sdkInfoPath = PathUtil.get(managerDir.getParent(), SDK_INFORMATION_FILE_NAME);
        File sdkInfoFile = new File(sdkInfoPath);
        if (!sdkInfoFile.exists()) {
            this.writePaths(sdkInfoFile);
        } else if (overwrite) {
            sdkInfoFile.delete();
            this.writePaths(sdkInfoFile);
        }
    }

    private void writePaths(File sdkInfoFile) throws UMException {
        BufferedWriter fw = null;
        try {
            sdkInfoFile.getParentFile().mkdirs();
            String NEW_LINE = System.getProperty("line.separator");
            fw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sdkInfoFile)));
            fw.write(String.format("%s=%s", INSTALLED_PATH_KEY, installedPath));
            fw.write(NEW_LINE);
            fw.write(String.format("%s=%s", SDK_DATA_PATH_KEY, sdkDataPath));
            fw.write(NEW_LINE);
        }
        catch (IOException e) {
            try {
                logger.throwing(e);
                throw new UMException(ErrorController.ErrorCode.FAILED_TO_CREATE_CONFIG_FILE, sdkInfoFile.getAbsolutePath());
            }
            catch (Throwable throwable) {
                ResourceUtil.closeObjectSilently(fw);
                throw throwable;
            }
        }
        ResourceUtil.closeObjectSilently(fw);
    }

    public String getSdkDataPath() {
        return sdkDataPath;
    }

    public String getInstalledPath() {
        return installedPath;
    }

    public String readInstallPathFromSdkInfo(String path) throws UMException {
        HashMap<String, String> map = this.loadSdkInfoFile(path);
        return map.get(INSTALLED_PATH_KEY);
    }

    private HashMap<String, String> loadSdkInfoFile(String path) throws UMException {
        HashMap<String, String> result = new HashMap<String, String>();
        File file = new File(path);
        if (!file.exists()) {
            throw new UMException(ErrorController.ErrorCode.FAILTED_TO_LOAD_SDK_INFO_FILE, "The 'sdk.info' file not found! " + path);
        }
        BufferedReader br = null;
        try {
            String readLine;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            logger.info("Reading sdk.info...");
            while ((readLine = br.readLine()) != null) {
                logger.info("\t" + readLine);
                int startChar = readLine.indexOf("=");
                if (startChar < 0) continue;
                String key = readLine.substring(0, startChar).trim();
                String value = readLine.substring(startChar + 1).trim();
                result.put(key, value);
            }
        }
        catch (IOException e) {
            try {
                logger.throwing(e);
                throw new UMException(ErrorController.ErrorCode.FAILTED_TO_LOAD_SDK_INFO_FILE, (Throwable)e);
            }
            catch (Throwable throwable) {
                ResourceUtil.closeObjectSilently(br);
                throw throwable;
            }
        }
        ResourceUtil.closeObjectSilently(br);
        if (result.get(INSTALLED_PATH_KEY) == null) {
            throw new UMException(ErrorController.ErrorCode.FAILTED_TO_LOAD_SDK_INFO_FILE, "No 'TIZEN_SDK_INSTALLED_PATH'");
        }
        if (result.get(SDK_DATA_PATH_KEY) == null) {
            throw new UMException(ErrorController.ErrorCode.FAILTED_TO_LOAD_SDK_INFO_FILE, "No 'TIZEN_SDK_DATA_PATH'");
        }
        return result;
    }

    public boolean isExistKeystoreDirectory() {
        File[] listFiles;
        File dataDir;
        boolean isRemain = false;
        String dataPath = this.getSdkDataPath();
        if (dataPath != null && dataPath.length() > 0 && (dataDir = new File(dataPath)).isDirectory() && dataDir.exists() && (listFiles = dataDir.listFiles()) != null && listFiles.length > 0) {
            for (File file : listFiles) {
                if (!file.isDirectory() || !file.getName().toLowerCase().equals(KEYSTORE)) continue;
                return true;
            }
        }
        return isRemain;
    }
}

