/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.RepositoryUtil;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.ConfigFile;
import org.tizen.manager.core.model.Distribution;
import org.tizen.manager.core.model.Snapshot;
import org.tizen.manager.core.model.SnapshotList;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;

public class RepositoryManager
implements Cloneable {
    private static final Logger logger = Log.getLogger(RepositoryManager.class);
    private String MARKED_SNAPSHOT = "manual";
    private ArrayList<Distribution> dists = new ArrayList();
    private HashMap<String, SnapshotList> distributionSnapshotSet = new HashMap();
    private String currentDistName = "";
    private String imageFileName = null;
    private Config.ServerType serverType = Config.ServerType.SNAPSHOT;
    private boolean isNetworkOK = true;
    private boolean pNetworkOK = true;
    private ContentProvider contentProvier;

    public RepositoryManager(ContentProvider contentProvier) {
        this.contentProvier = contentProvier;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public RepositoryManager clone(ContentProvider contentProvider) throws CloneNotSupportedException {
        RepositoryManager repoMgr = (RepositoryManager)this.clone();
        repoMgr.dists = new ArrayList();
        for (int i = 0; i < this.dists.size(); ++i) {
            repoMgr.dists.add(i, (Distribution)this.dists.get(i).clone());
        }
        repoMgr.distributionSnapshotSet = new HashMap();
        for (String key : this.distributionSnapshotSet.keySet()) {
            repoMgr.distributionSnapshotSet.put(key, (SnapshotList)this.distributionSnapshotSet.get(key).cloneList());
        }
        repoMgr.contentProvier = contentProvider;
        return repoMgr;
    }

    public void init() throws UMException {
        try {
            this.reload();
        }
        catch (UMException e) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_REPOSITORY);
        }
    }

    public void clearData() {
        if (!this.dists.isEmpty()) {
            this.dists.clear();
        }
        if (!this.distributionSnapshotSet.isEmpty()) {
            this.distributionSnapshotSet.clear();
        }
    }

    public void reload() throws UMException {
        ConfigFile configFile = this.contentProvier.getConfig().getConfigFile();
        assert (configFile != null);
        this.setCurrentDistribution(configFile.getDistribution());
        String repository = configFile.getRepository();
        if (!this.dists.isEmpty()) {
            this.dists.clear();
        }
        try {
            this.dists.addAll(RepositoryUtil.readDistributionListFromRepository(this.contentProvier.getConfig(), repository));
        }
        catch (UMException e) {
            throw new UMException(e.getErrorCode());
        }
        this.distributionSnapshotSet.clear();
        if (!this.dists.isEmpty()) {
            for (Distribution dist : this.dists) {
                if (dist.getName() == null || dist.getName().isEmpty()) {
                    logger.error("Cannot get distribution names because it is null. Check remote or downloaded distribution info file.");
                    throw new UMException(ErrorController.ErrorCode.FAIL_TO_LOAD_DISTRIBUTON_INFORMATION);
                }
                if (!dist.getName().equals(this.currentDistName)) continue;
                this.loadSnapshot(dist);
                break;
            }
        }
    }

    public List<String> getDistributionList() {
        ArrayList<String> distList = new ArrayList<String>();
        for (Distribution dist : this.dists) {
            if (dist.getName() == null) continue;
            distList.add(dist.getName());
        }
        return distList;
    }

    public Distribution getDistributionByName(String name) {
        for (Distribution dist : this.dists) {
            if (!dist.getName().equals(name)) continue;
            return dist;
        }
        return null;
    }

    public SnapshotList getSnapshotList(String distName) {
        SnapshotList list = this.distributionSnapshotSet.get(distName);
        if (list == null) {
            Distribution dist = this.getDistributionByName(distName);
            if (dist != null) {
                try {
                    this.loadSnapshot(dist);
                    list = this.distributionSnapshotSet.get(distName);
                    if (list == null) {
                        list = SnapshotList.EMPTY;
                    }
                }
                catch (Exception e) {
                    logger.throwing(e);
                    list = SnapshotList.EMPTY;
                }
            } else {
                list = SnapshotList.EMPTY;
            }
        }
        return list;
    }

    public SnapshotList getManualSnapshotList(String distribution) {
        SnapshotList manualSnapshotList = new SnapshotList();
        SnapshotList snapshotList = this.getSnapshotList(distribution);
        for (Snapshot snapshot : snapshotList) {
            if (snapshot.getType() == null || !snapshot.getType().equals(this.MARKED_SNAPSHOT)) continue;
            manualSnapshotList.add(snapshot);
        }
        return manualSnapshotList;
    }

    private void loadSnapshot(Distribution distribution) throws UMException {
        String snapshotRepo = NetworkUtil.getURL(distribution.getRepository(), distribution.getName());
        SnapshotList list = new SnapshotList();
        list.addAll(RepositoryUtil.readSnapshotListFromRepository(this.contentProvier.getConfig(), snapshotRepo));
        Collections.sort(list);
        this.distributionSnapshotSet.put(distribution.getName(), list);
    }

    public Snapshot getLatestSnapshot(String distribution) {
        Snapshot latestSnapshot = null;
        SnapshotList snapshotList = this.getSnapshotList(distribution);
        if (!snapshotList.isEmpty()) {
            for (Snapshot snapshot : snapshotList) {
                String type = snapshot.getType();
                if (type == null || type.toLowerCase().contains("temp")) continue;
                latestSnapshot = snapshot;
                break;
            }
            if (latestSnapshot == null) {
                latestSnapshot = (Snapshot)snapshotList.get(0);
            }
        } else {
            logger.error("There are not snapshots in distribution. : " + distribution);
            return null;
        }
        logger.trace("\tThe latest snapshot name: " + latestSnapshot.getName());
        return latestSnapshot;
    }

    public Snapshot getLatestSnapshot() {
        if (this.currentDistName != null) {
            return this.getLatestSnapshot(this.currentDistName);
        }
        return null;
    }

    public void setCurrentDistribution(String distribution) {
        this.currentDistName = distribution;
    }

    public String getCurrentDistribution() {
        return this.currentDistName;
    }

    public boolean isDistributionChanged() {
        return !this.currentDistName.equalsIgnoreCase(this.contentProvier.getConfig().getConfigFile().getDistribution());
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
    }

    public void setServerType(Config.ServerType serverType) {
        this.serverType = serverType;
    }

    public boolean isLocalServerType() {
        return this.serverType == Config.ServerType.LOCAL;
    }

    public boolean isNetworkOK() {
        return this.isNetworkOK;
    }

    public void setNetworkOK(boolean isNetworkOK) {
        this.isNetworkOK = isNetworkOK;
    }

    public boolean ispNetworkOK() {
        return this.pNetworkOK;
    }

    public void setpNetworkOK(boolean pNetworkOK) {
        this.pNetworkOK = pNetworkOK;
    }

    public boolean refresh() {
        boolean initResult = true;
        try {
            this.reload();
            logger.trace("\tInit Distribution result => " + initResult);
        }
        catch (UMException e) {
            logger.throwing(e);
            initResult = false;
        }
        return initResult;
    }
}

