/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.PropertyParser;
import org.tizen.manager.core.model.Property;
import org.tizen.manager.core.model.PropertySection;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;

public class ConfigFile
implements Cloneable {
    private static final Logger logger = Log.getLogger(ConfigFile.class);
    private static final String FIELD_REPOSITORY = "Repository";
    private static final String FIELD_DISTRIBUTION = "Distribution";
    private static final String FIELD_SERVER_TYPE = "Server-Type";
    private static final String FIELD_PACKAGE_SERVER = "Package-Server";
    private static final String FIELD_EXTENSION_SERVER = "Extension-Server";
    private static final String FIELD_BUILT_IN_EXTENSION_SERVER = "Built-in-Extension-Server";
    private static final String FIELD_MANAGER_VERSION = "Manager-Version";
    private static final String FIELD_SNAPSHOT_PATH = "Target-Snapshot";
    private static final String FIELD_RELEASE_NOTE = "Release-Note";
    private static final String FIELD_SDK_PATH = "SDK-Path";
    private static final String FIELD_SDK_WORKSPACE_PATH = "SDK-Workspace";
    private static final String FIELD_SDK_IMAGE_ORIGIN = "Image-Origin";
    private static final String FIELD_INSTALLED_SNAPSHOT = "Installed-Snapshot";
    private static final String FIELD_ORIGIN_REPOSITORY = "Origin-Repository-URL";
    private static final String FIELD_AUTO_UPDATE = "Auto-Update";
    private static final String FIELD_DISTRIBUTION_ID = "Distribution-ID";
    private ArrayList<Property> mProperties;
    private String mConfigFilePath;

    ConfigFile(String confPath) {
        this.mConfigFilePath = confPath;
        this.mProperties = new ArrayList();
    }

    public ConfigFile() {
        this.mConfigFilePath = "";
        this.mProperties = new ArrayList();
    }

    public Object clone() throws CloneNotSupportedException {
        ConfigFile configFile = (ConfigFile)super.clone();
        configFile.mProperties = new ArrayList();
        for (int i = 0; i < this.mProperties.size(); ++i) {
            configFile.mProperties.add(i, (Property)this.mProperties.get(i).clone());
        }
        return configFile;
    }

    void load(String confPath) throws UMException {
        List<PropertySection> propertySections = null;
        this.mConfigFilePath = confPath;
        File configFile = new File(this.mConfigFilePath);
        if (!configFile.exists()) {
            throw new UMException(ErrorController.ErrorCode.CONFIG_FILE_NOT_FOUND, this.mConfigFilePath);
        }
        PropertyParser parser = new PropertyParser();
        propertySections = parser.readFromFile(this.mConfigFilePath, true);
        if (propertySections == null || propertySections.size() == 0) {
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_LOAD_CONFIG_FILE, this.mConfigFilePath);
        }
        this.setProperties(propertySections.get(0).getProperties());
        Property property = this.getProperty(FIELD_AUTO_UPDATE);
        if (property == null) {
            property = new Property();
            property.setName(FIELD_AUTO_UPDATE);
            property.setValue("true");
            this.mProperties.add(property);
        }
    }

    public String getRepository() {
        return this.getValue(FIELD_REPOSITORY);
    }

    public String getOriginRepository() {
        return this.getValue(FIELD_ORIGIN_REPOSITORY);
    }

    public String getDistribution() {
        return this.getValue(FIELD_DISTRIBUTION);
    }

    public String getDistributionId() {
        return this.getValue(FIELD_DISTRIBUTION_ID);
    }

    public String getManagerVersion() {
        return this.getValue(FIELD_MANAGER_VERSION);
    }

    public String getReleaseNoteUrl() {
        return this.getValue(FIELD_RELEASE_NOTE);
    }

    public String getPackageServer() {
        return this.getValue(FIELD_PACKAGE_SERVER);
    }

    public void setPackageServer(String packageServer) {
        Property property = this.getProperty(FIELD_PACKAGE_SERVER);
        if (property != null) {
            property.setValue(packageServer);
        } else {
            property = new Property();
            property.setName(FIELD_PACKAGE_SERVER);
            property.setValue(packageServer);
            this.mProperties.add(property);
        }
    }

    public String getSnapshotPath() {
        return this.getValue(FIELD_SNAPSHOT_PATH);
    }

    public void setSnapshotPath(String snapshotPath) {
        Property property = this.getProperty(FIELD_SNAPSHOT_PATH);
        if (property != null) {
            property.setValue(snapshotPath);
        } else {
            property = new Property();
            property.setName(FIELD_SNAPSHOT_PATH);
            property.setValue(snapshotPath);
            this.mProperties.add(property);
        }
    }

    public String getInstalledSnapshot() {
        return this.getValue(FIELD_INSTALLED_SNAPSHOT);
    }

    public void setInstalledSnapshot(String snapshotPath) {
        Property property = this.getProperty(FIELD_INSTALLED_SNAPSHOT);
        if (property != null) {
            property.setValue(snapshotPath);
        } else {
            property = new Property();
            property.setName(FIELD_INSTALLED_SNAPSHOT);
            property.setValue(snapshotPath);
            this.mProperties.add(property);
        }
    }

    public String getSDKImageOrigin() {
        return this.getValue(FIELD_SDK_IMAGE_ORIGIN);
    }

    public void setSDKImageOrigin(String imageOrigin) {
        Property property = this.getProperty(FIELD_SDK_IMAGE_ORIGIN);
        if (property != null) {
            property.setValue(imageOrigin);
        } else {
            property = new Property();
            property.setName(FIELD_SDK_IMAGE_ORIGIN);
            property.setValue(imageOrigin);
            this.mProperties.add(property);
        }
    }

    public String getBuiltInExtensionServer() {
        return this.getValue(FIELD_BUILT_IN_EXTENSION_SERVER);
    }

    public String getExtensionServer() {
        return this.getValue(FIELD_EXTENSION_SERVER);
    }

    public void setExtensionServer(String extensionServer) {
        Property property = this.getProperty(FIELD_EXTENSION_SERVER);
        if (property != null) {
            property.setValue(extensionServer);
        } else {
            property = new Property();
            property.setName(FIELD_EXTENSION_SERVER);
            property.setValue(extensionServer);
            this.mProperties.add(property);
        }
    }

    public String getSDKWorkSpace() {
        return this.getValue(FIELD_SDK_WORKSPACE_PATH);
    }

    public void setSDKWorkSpace(String sdkWorkSpacePath) {
        Property property = this.getProperty(FIELD_SDK_WORKSPACE_PATH);
        if (property != null) {
            property.setValue(sdkWorkSpacePath);
        } else {
            property = new Property();
            property.setName(FIELD_SDK_WORKSPACE_PATH);
            property.setValue(sdkWorkSpacePath);
            this.mProperties.add(property);
        }
    }

    public String getSDKPath() {
        return this.getValue(FIELD_SDK_PATH);
    }

    public void setSDKPath(String sdkPath) {
        Property property = this.getProperty(FIELD_SDK_PATH);
        if (property != null) {
            property.setValue(sdkPath);
        } else {
            property = new Property();
            property.setName(FIELD_SDK_PATH);
            property.setValue(sdkPath);
            this.mProperties.add(property);
        }
    }

    public boolean isAutoUpdate() {
        String val = this.getValue(FIELD_AUTO_UPDATE);
        return val == null || val.isEmpty() || val.equalsIgnoreCase("null") || val.equalsIgnoreCase("true");
    }

    public void setAutoUpdate(boolean val) {
        Property property = this.getProperty(FIELD_AUTO_UPDATE);
        if (property != null) {
            if (val) {
                property.setValue("true");
            } else {
                property.setValue("false");
            }
        } else {
            property = new Property();
            property.setName(FIELD_AUTO_UPDATE);
            if (val) {
                property.setValue("true");
            } else {
                property.setValue("false");
            }
            this.mProperties.add(property);
        }
    }

    private Property getProperty(String key) {
        if (this.mProperties != null && key != null) {
            for (int i = 0; i < this.mProperties.size(); ++i) {
                if (key.compareTo(this.mProperties.get(i).getName()) != 0) continue;
                return this.mProperties.get(i);
            }
        }
        return null;
    }

    private String getValue(String key) {
        Property property = this.getProperty(key);
        if (property != null) {
            return property.getValue();
        }
        return "";
    }

    public ArrayList<Property> getProperties() {
        return this.mProperties;
    }

    public void setProperties(ArrayList<Property> properties) {
        this.mProperties = properties;
    }

    public void setManagerVersion(String version) {
        Property property = this.getProperty(FIELD_MANAGER_VERSION);
        if (property != null) {
            property.setValue(version);
        } else {
            property = new Property();
            property.setName(FIELD_MANAGER_VERSION);
            property.setValue(version);
            this.mProperties.add(property);
        }
    }

    public void setRepository(String repository) {
        Property property = this.getProperty(FIELD_REPOSITORY);
        if (property != null) {
            property.setValue(repository);
        } else {
            property = new Property();
            property.setName(FIELD_REPOSITORY);
            property.setValue(repository);
            this.mProperties.add(property);
        }
    }

    public void setDistribution(String distribution) {
        Property property = this.getProperty(FIELD_DISTRIBUTION);
        if (property != null) {
            property.setValue(distribution);
        } else {
            property = new Property();
            property.setName(FIELD_DISTRIBUTION);
            property.setValue(distribution);
            this.mProperties.add(property);
        }
    }

    public void setDistributionId(String distributionID) {
        Property property = this.getProperty(FIELD_DISTRIBUTION_ID);
        if (property != null) {
            property.setValue(distributionID);
        } else {
            property = new Property();
            property.setName(FIELD_DISTRIBUTION_ID);
            property.setValue(distributionID);
            this.mProperties.add(property);
        }
    }

    public void setServerType(Config.ServerType type) {
        String serverType = null;
        serverType = type == null ? Config.ServerType.SNAPSHOT.toString() : type.toString();
        Property property = this.getProperty(FIELD_SERVER_TYPE);
        if (property != null) {
            property.setValue(serverType);
        } else {
            property = new Property();
            property.setName(FIELD_SERVER_TYPE);
            property.setValue(serverType);
            this.mProperties.add(property);
        }
    }

    public void saveConfig(String configFilePath) throws UMException {
        File parentDir;
        logger.trace("\tConfig save config start => " + configFilePath);
        if (configFilePath == null || configFilePath.equals("")) {
            logger.error("Invalid config file path");
            return;
        }
        File configFile = new File(configFilePath);
        if (configFile.exists()) {
            if (configFile.delete()) {
                logger.trace("\tSuccess to delete configuration file ==> " + configFile);
            } else {
                logger.error("Fail to delete configuration file ==> " + configFile);
            }
        }
        if (!(parentDir = configFile.getParentFile()).exists()) {
            if (parentDir.mkdirs()) {
                logger.trace("\tSuccess to create parent directory of configuration file ==> " + parentDir);
            } else {
                logger.error("Fail to create parent directory of configuration file ==> " + parentDir);
            }
        }
        try {
            configFile.createNewFile();
        }
        catch (IOException e1) {
            logger.error("Cannot create config file => " + configFilePath);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_SAVE_CONFIG_FILE);
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), "UTF-8"));
            ArrayList<Property> repoProperties = this.getProperties();
            for (int i = 0; i < repoProperties.size(); ++i) {
                writer.write(repoProperties.get(i).getName() + ": " + repoProperties.get(i).getValue() + "\n");
            }
            writer.write("\n");
        }
        catch (IOException e) {
            logger.error("Cannot write config file");
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_SAVE_CONFIG_FILE);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                logger.error("close fileoutput fail");
            }
        }
        logger.trace("\tConfig save config end");
    }

    public String getConfigPath() {
        return this.mConfigFilePath;
    }
}

