/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.pkg;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.tizen.manager.pkg.Package;

public class PackageSet
implements Collection<Package> {
    private LinkedHashSet<Package> circularPackage = new LinkedHashSet();
    private LinkedHashMap<String, Package> hashMap = new LinkedHashMap();

    public int getSize() {
        return this.size();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Package) {
            Package pkg = (Package)o;
            return this.hashMap.values().contains(pkg);
        }
        return false;
    }

    @Override
    public Iterator<Package> iterator() {
        return this.hashMap.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.hashMap.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.hashMap.values().toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.hashMap.values().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Package> c) {
        if (c != null) {
            for (Package package_ : c) {
                this.add(package_);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c != null) {
            for (Object o : c) {
                if (!(o instanceof Package)) continue;
                Package pkg = (Package)o;
                this.hashMap.remove(pkg.getPackageName());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c != null) {
            for (Package pkg : this.hashMap.values()) {
                if (c.contains(pkg)) continue;
                this.hashMap.remove(pkg.getPackageName());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean add(Package pkg) {
        if (pkg != null && !this.hashMap.containsKey(pkg.getPackageName())) {
            this.hashMap.put(pkg.getPackageName(), pkg);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.hashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hashMap.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Package) {
            return this.hashMap.remove(((Package)o).getPackageName()) != null;
        }
        return false;
    }

    @Override
    public void clear() {
        this.hashMap.clear();
    }

    public Object clone() {
        PackageSet newObj = new PackageSet();
        newObj.addAll(this);
        return newObj;
    }

    Package getPackage(Package p0) {
        if (p0 != null) {
            return this.hashMap.get(p0.getPackageName());
        }
        return null;
    }

    public Package getPackageByName(String packageName) {
        if (packageName == null) {
            return null;
        }
        return this.hashMap.get(packageName);
    }

    public boolean hasPackageByName(String packageName) {
        if (packageName != null) {
            return this.hashMap.containsKey(packageName);
        }
        return false;
    }

    boolean hasPackage(Package pkg) {
        if (pkg != null) {
            return this.hashMap.containsKey(pkg.getPackageName());
        }
        return false;
    }

    PackageSet getPackagesByNames(Collection<String> names) {
        PackageSet result = new PackageSet();
        for (String name : names) {
            Package pkg = this.getPackageByName(name);
            if (pkg == null) continue;
            result.add(pkg);
        }
        return result;
    }

    public LinkedHashSet<Package> getCircularPackage() {
        return this.circularPackage;
    }

    public void setCircularPackage(LinkedHashSet<Package> circularPackage) {
        this.circularPackage = circularPackage;
    }

    public String toString() {
        return this.hashMap.keySet() + "";
    }
}

