/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;

public class PlatformUtil {
    public static final int LINUX_32 = 1;
    public static final int LINUX_64 = 4;
    public static final int WINDOWS_32 = 8;
    public static final int WINDOWS_64 = 16;
    public static final int MACOS_32 = 32;
    public static final int MACOS_64 = 64;
    private static final int UBUNTU_32 = 128;
    private static final int UBUNTU_64 = 256;
    private static final int GENERIC_LINUX = 389;
    private static final int GENERIC_WINDOWS = 24;
    private static final int GENERIC_MACOS = 96;
    private static final String DATA_MODEL_32 = "32";
    public static final int CURRENT_PLATFORM = PlatformUtil.getCurrentPlatform();
    public static final String CURRENT_CHARSET = PlatformUtil.getCurrentCharset();
    private static final String JRE_NAME = System.getProperty("java.runtime.name").toLowerCase();
    private static final String JVM_NAME = System.getProperty("java.vm.name").toLowerCase();
    private static final String JAVA_VERSION = System.getProperty("java.specification.version").toLowerCase();
    private static final String JAVA_SIX = "1.6";
    private static final String JAVA_EIGHT = "1.8";
    private static final String SUPPORT_JAVA_VERSION = "1.8";
    private static final String CHECK_OPENJDK = "openjdk";
    private static final Logger logger = Log.getLogger(PlatformUtil.class);

    private static int getCurrentPlatform() {
        String os = System.getProperty("os.name");
        String dataModel = System.getProperty("sun.arch.data.model");
        if (os.startsWith("Linux")) {
            if (dataModel.equals(DATA_MODEL_32)) {
                return 1;
            }
            return 4;
        }
        if (os.startsWith("Windows")) {
            if (dataModel.equals(DATA_MODEL_32)) {
                return 8;
            }
            return 16;
        }
        if (os.startsWith("Mac OS")) {
            return 64;
        }
        if (dataModel.equals(DATA_MODEL_32)) {
            return 1;
        }
        return 4;
    }

    private static String getCurrentCharset() {
        return System.getProperty("sun.jnu.encoding");
    }

    public static String getPlatformInfo() {
        StringBuilder info = new StringBuilder();
        info.append("\n");
        info = info.append("OS Name      : ").append(System.getProperty("os.name")).append("\n");
        info = info.append("OS Version   : ").append(System.getProperty("os.version")).append("\n");
        info = info.append("Data Model   : ").append(System.getProperty("sun.arch.data.model")).append("\n");
        if (CURRENT_PLATFORM == 1) {
            String filePath = "/etc/lsb-release";
            try {
                info = info.append(PathUtil.readAllTextFromFile(filePath, true)).append("\n");
            }
            catch (UMException e) {
                logger.throwing(e);
            }
        }
        info = info.append("java vm name : ").append(System.getProperty("java.vm.name")).append("\n");
        info = info.append("vm version   : ").append(System.getProperty("java.vm.version")).append("\n");
        info = info.append("java version : ").append(System.getProperty("java.version")).append("\n");
        info = info.append("java runtime name: ").append(System.getProperty("java.runtime.name")).append("\n");
        return info.toString();
    }

    public static boolean isInstalledOpenJDK() {
        if (JRE_NAME.contains(CHECK_OPENJDK)) {
            return true;
        }
        return JVM_NAME.contains(CHECK_OPENJDK);
    }

    public static boolean isLinux() {
        return (CURRENT_PLATFORM & 0x185) > 0;
    }

    public static boolean isUbuntu() {
        return PlatformUtil.isLinux();
    }

    public static boolean isMacOS() {
        return (CURRENT_PLATFORM & 0x60) > 0;
    }

    public static boolean isWindows() {
        return (CURRENT_PLATFORM & 0x18) > 0;
    }

    public static boolean isUnderJava8() {
        try {
            double currentJava = Double.parseDouble(JAVA_VERSION);
            double target = Double.parseDouble("1.8");
            return currentJava < target;
        }
        catch (Exception e) {
            logger.throwing(e);
            logger.warn("Java version format is not correct");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUbuntuVersion() {
        if (PlatformUtil.isLinux()) {
            String cmd = "cat /etc/lsb-release | grep DISTRIB_RELEASE | sed 's/\"//g' | awk -F= '{print $2}'";
            ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", cmd);
            Process proc = null;
            try {
                proc = pb.start();
                BufferedReader read = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                line = read.readLine();
                if (line != null) {
                    String string = line.trim();
                    return string;
                }
                proc.waitFor();
                proc.destroy();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
            }
            finally {
                if (proc != null) {
                    proc.destroy();
                }
            }
        } else {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String isCorrectJavaSystemPath() {
        String returnMessage = "";
        String specificationVersion = "1.8";
        String message = "The environment variables for your default Java Development Kit (JDK, %s) are not properly set to run Tizen Studio.\nPlease, change the PATH or the symlink of the default JDK for running proper Java.\n";
        if (PlatformUtil.isWindows()) {
            String[] cmd = new String[]{"cmd", "/c", "java", "-version"};
            ProcessBuilder pb = new ProcessBuilder(cmd);
            Process proc = null;
            try {
                String trim;
                String substring;
                String line = null;
                pb.redirectError();
                proc = pb.start();
                BufferedReader read = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while ((line = read.readLine()) != null) {
                    if (!line.toLowerCase().startsWith("java version") || (substring = (trim = line.toLowerCase().replace("java version", "").replace("\"", "").trim()).substring(0, 3)).compareTo(specificationVersion) != -1) continue;
                    returnMessage = String.format(message, substring);
                }
                read = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                while ((line = read.readLine()) != null) {
                    if (!line.toLowerCase().startsWith("java version") || (substring = (trim = line.toLowerCase().replace("java version", "").replace("\"", "").trim()).substring(0, 3)).compareTo(specificationVersion) != -1) continue;
                    returnMessage = String.format(message, substring);
                }
                proc.waitFor();
                proc.destroy();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                System.out.println(e.getMessage());
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
            }
            catch (Exception exception) {
            }
            finally {
                if (proc != null) {
                    proc.destroy();
                }
            }
        }
        return returnMessage;
    }
}

