/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ManagerConstants;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;

public class Performance {
    private static final Logger logger = Log.getLogger(Performance.class);
    private static final String INSTALL_TEST_FILE_NAME = "installtime";
    private static final String REMOVE_TEST_FILE_NAME = "removetime";
    private static Date imStartTime = null;
    private static Date imEndTime = null;
    private static Date initializeStartTime = null;
    private static Date initializeEndTime = null;
    private static Date downloadStartTime = null;
    private static Date downloadEndTime = null;
    private static Date installationStartTime = null;
    private static Date installationEndTime = null;
    private static Date removalStartTime = null;
    private static Date removalEndTime = null;
    private static long sdkPackageSize = 0L;
    private static ArrayList<PerformanceLog> performanceLogs = new ArrayList();

    public static void setIMStartTime() {
        imStartTime = new Date();
    }

    public static void setIMEndTime() {
        imEndTime = new Date();
    }

    public static void setInitializeStartTime() {
        initializeStartTime = new Date();
    }

    public static void setInitializeEndTime() {
        initializeEndTime = new Date();
    }

    public static void setDownloadStartTime() {
        downloadStartTime = new Date();
    }

    public static boolean existDownloadStartTime() {
        return downloadStartTime != null;
    }

    public static void setDownloadEndTime() {
        downloadEndTime = new Date();
    }

    public static void setInstallationStartTime() {
        installationStartTime = new Date();
    }

    public static void setInstallationEndTime() {
        installationEndTime = new Date();
    }

    public static void setRemovalStartTime() {
        removalStartTime = new Date();
    }

    static void setRemovalEndTime() {
        removalEndTime = new Date();
    }

    public static void printToLogFile() {
        logger.info("The installmanager start time : " + imStartTime);
        logger.info("The installmanager end time : " + imEndTime);
        logger.info("The installation start time : " + installationStartTime);
        logger.info("The installation end time : " + installationEndTime);
        long progressSecond = Performance.getInstallationTime() / 1000L;
        if (progressSecond >= 0L) {
            logger.info("The progress time of the installation : About " + progressSecond / 60L + " minutes" + "(" + progressSecond + " seconds)");
        } else {
            logger.info("The progress time of the installation : Installation fail");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTestResult(Config config) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String testFileName = formatter.format(imStartTime) + "_result" + ".txt";
        String testResultFilePath = PathUtil.get(ManagerConstants.getInstallManagerTestResultPath(config), "result", testFileName);
        File testResultFile = new File(testResultFilePath);
        if (testResultFile.getParentFile() != null && !testResultFile.getParentFile().exists()) {
            testResultFile.getParentFile().mkdirs();
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(testResultFile));
            out.write("***  InstallManager performance test ***");
            out.newLine();
            out.write("Sdk package size\t: " + sdkPackageSize);
            out.newLine();
            out.write("The initialization time\t: " + Performance.getInitializeTime() + "sec");
            out.write("(" + Performance.getBitPerSecond(sdkPackageSize / 8L, Performance.getInitializeTime()) + "byte/sec)");
            out.newLine();
            out.write("The download time\t: " + Performance.getDownloadTime() + "sec");
            out.write("(" + Performance.getBitPerSecond(sdkPackageSize / 8L, Performance.getDownloadTime()) + "byte/sec)");
            out.newLine();
            out.write("The installation time\t: " + Performance.getInstallationTime() + "sec");
            out.write("(" + Performance.getBitPerSecond(sdkPackageSize / 8L, Performance.getInstallationTime()) + "byte/sec)");
            out.newLine();
            out.write("The removal time\t: " + Performance.getRemovalTime() + "sec");
            out.write("(" + Performance.getBitPerSecond(sdkPackageSize / 8L, Performance.getRemovalTime()) + "byte/sec)");
            out.newLine();
            out.write("The install-manager start time\t: " + imStartTime);
            out.newLine();
            out.write("The install-manager end time\t: " + imEndTime);
            out.newLine();
            out.newLine();
            long progressSecond = Performance.getTotalTime();
            if (progressSecond >= 0L) {
                out.write("* Total time to install : About " + progressSecond / 60L + " minutes" + "(" + progressSecond + " seconds)");
                out.newLine();
            } else {
                out.write("* Total time to install : Installation fail");
                out.newLine();
            }
        }
        catch (IOException e) {
            logger.throwing(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.throwing(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTestResultXmlFormat(boolean isForAutomation, Config config) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String testFileName = formatter.format(imStartTime) + ".xml";
        String testResultFilePath = "";
        testResultFilePath = isForAutomation ? PathUtil.get(ManagerConstants.getInstallManagerTestResultPath(config), "result", testFileName) : PathUtil.get(ManagerConstants.getInstallManagerTestResultPath(config), testFileName);
        File testResultFile = new File(testResultFilePath);
        if (testResultFile.getParentFile() != null && !testResultFile.getParentFile().exists()) {
            testResultFile.getParentFile().mkdirs();
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(testResultFile));
            out.write(Performance.getTestSuiteXml("InstallManager performance test", 4, Performance.getTotalTime()));
            out.newLine();
            out.write(Performance.getTestCaseXml("InitTest", "The initialization time", Performance.getInitializeTime()));
            out.newLine();
            out.write(Performance.getTestCaseXml("DownloadTest", "The download time", Performance.getDownloadTime()));
            out.newLine();
            out.write(Performance.getTestCaseXml("InstallTest", "The installation time", Performance.getInstallationTime()));
            out.newLine();
            out.write(Performance.getTestCaseXml("RemoveTest", "The removal time", Performance.getRemovalTime()));
            out.newLine();
            out.write("</testsuite>");
        }
        catch (IOException e) {
            logger.throwing(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.throwing(e);
                }
            }
        }
    }

    public static void printTestResultXmlFormat2(boolean isForAutomation, Config config) {
        if (installationStartTime != null) {
            Performance.printInstallTestResultXmlFormat(isForAutomation, config);
        } else {
            Performance.printRemoveTestResultXmlFormat(isForAutomation, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printInstallTestResultXmlFormat(boolean isForAutomation, Config config) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String testFileName = "installtime_" + formatter.format(imStartTime) + ".xml";
        String testResultFilePath = "";
        testResultFilePath = isForAutomation ? PathUtil.get(ManagerConstants.getInstallManagerTestResultPath(config), "result", testFileName) : PathUtil.get(ManagerConstants.getInstallManagerTestResultPath(config), testFileName);
        File testResultFile = new File(testResultFilePath);
        if (testResultFile.getParentFile() != null && !testResultFile.getParentFile().exists()) {
            testResultFile.getParentFile().mkdirs();
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(testResultFile));
            out.write(Performance.getTestSuiteXml("InstallManager performance test", 3, Performance.getTotalTime()));
            out.newLine();
            out.write(Performance.getTestCaseXml("InitTest", "The initialization time", Performance.getInitializeTime()));
            out.newLine();
            out.write(Performance.getTestCaseXml("DownloadTest", "The download time", Performance.getDownloadTime()));
            out.newLine();
            out.write(Performance.getTestCaseXml("DownloadRetry", "Download retry count", 0L));
            out.newLine();
            out.write(Performance.getTestCaseXml("InstallTest", "The installation time", Performance.getInstallationTime()));
            out.newLine();
            out.write("</testsuite>");
        }
        catch (IOException e) {
            logger.throwing(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.throwing(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printRemoveTestResultXmlFormat(boolean isForAutomation, Config config) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String testFileName = "removetime_" + formatter.format(imStartTime) + ".xml";
        String testResultFilePath = PathUtil.get(ManagerConstants.getInstallManagerTestResultPath(config), testFileName);
        testResultFilePath = isForAutomation ? PathUtil.get(ManagerConstants.getInstallManagerTestResultPath(config), "result", testFileName) : PathUtil.get(ManagerConstants.getInstallManagerTestResultPath(config), testFileName);
        File testResultFile = new File(testResultFilePath);
        if (testResultFile.getParentFile() != null && !testResultFile.getParentFile().exists()) {
            testResultFile.getParentFile().mkdirs();
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(testResultFile));
            out.write(Performance.getTestSuiteXml("InstallManager performance test", 1, Performance.getTotalTime()));
            out.newLine();
            out.write(Performance.getTestCaseXml("RemoveTest", "The removal time", Performance.getRemovalTime()));
            out.newLine();
            out.write("</testsuite>");
        }
        catch (IOException e) {
            logger.throwing(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.throwing(e);
                }
            }
        }
    }

    private static String getTestSuiteXml(String testName, int testNum, long time) {
        return "<testsuite errors=\"\" failures=\"\" name=\"" + testName + "\" skips=\"\" tests=\"" + testNum + "\" time=\"" + time + "\">";
    }

    private static String getTestCaseXml(String testClass, String testName, long time) {
        return "<testcase classname=\"" + testClass + "\" name=\"" + testName + "\" time=\"" + time + "\"/>";
    }

    private static long getInitializeTime() {
        if (initializeStartTime == null || initializeEndTime == null) {
            return 0L;
        }
        long interval = (initializeEndTime.getTime() - initializeStartTime.getTime()) / 1000L;
        return interval;
    }

    private static long getDownloadTime() {
        if (downloadStartTime == null || downloadEndTime == null) {
            return 0L;
        }
        long interval = (downloadEndTime.getTime() - downloadStartTime.getTime()) / 1000L;
        return interval;
    }

    private static long getTotalTime() {
        if (imStartTime == null || imEndTime == null) {
            return 0L;
        }
        long interval = (imEndTime.getTime() - imStartTime.getTime()) / 1000L;
        return interval;
    }

    private static long getInstallationTime() {
        if (installationStartTime == null || installationEndTime == null) {
            return 0L;
        }
        long interval = (installationEndTime.getTime() - installationStartTime.getTime()) / 1000L;
        return interval;
    }

    private static long getRemovalTime() {
        if (removalStartTime == null || removalEndTime == null) {
            return 0L;
        }
        long interval = (removalEndTime.getTime() - removalStartTime.getTime()) / 1000L;
        return interval;
    }

    private static long getBitPerSecond(long size, long seconds) {
        if (seconds == 0L) {
            return 0L;
        }
        return size / seconds;
    }

    static void setSDKPackageSize(long totalSizeOfRemovablePackages) {
        sdkPackageSize = totalSizeOfRemovablePackages;
    }

    public static void addPerformanceLog(String name, String action, long time) {
        performanceLogs.add(new PerformanceLog(name, action, time));
    }

    public static void summarize() {
        HashMap<String, Long> data;
        HashMap<String, HashMap<String, Long>> summary = new HashMap<String, HashMap<String, Long>>();
        for (PerformanceLog log : performanceLogs) {
            data = (HashMap<String, Long>)summary.get(log.getName());
            if (data == null) {
                data = new HashMap<String, Long>();
                data.put(log.getAction(), log.getElapsedTime());
                summary.put(log.getName(), data);
                continue;
            }
            if (data.get(log.getAction()) != null || log.getAction().equals("download") || log.getAction().equals("rscript") && data.get("copy") != null) {
                logger.info(String.format("[%s] - %d, %d, %d, %d, %d, %d", log.getName(), data.get("download") != null ? (Long)data.get("download") : 0L, data.get("extract") != null ? (Long)data.get("extract") : 0L, data.get("copy") != null ? (Long)data.get("copy") : 0L, data.get("iscript") != null ? (Long)data.get("iscript") : 0L, data.get("delete") != null ? (Long)data.get("delete") : 0L, data.get("rscript") != null ? (Long)data.get("rscript") : 0L));
                data = new HashMap<String, Long>();
                data.put(log.getAction(), log.getElapsedTime());
                summary.put(log.getName(), data);
                continue;
            }
            data.put(log.getAction(), log.getElapsedTime());
        }
        for (String pkgName : summary.keySet()) {
            data = (HashMap<String, Long>)summary.get(pkgName);
            logger.info(String.format("[%s] - %d, %d, %d, %d, %d, %d", pkgName, data.get("download") != null ? (Long)data.get("download") : 0L, data.get("extract") != null ? (Long)data.get("extract") : 0L, data.get("copy") != null ? (Long)data.get("copy") : 0L, data.get("iscript") != null ? (Long)data.get("iscript") : 0L, data.get("delete") != null ? (Long)data.get("delete") : 0L, data.get("rscript") != null ? (Long)data.get("rscript") : 0L));
        }
    }

    public static class PerformanceLog {
        private String name;
        private String action;
        private long elapsedTime = 0L;

        public PerformanceLog(String name, String action, long elapsedTime) {
            this.name = name;
            this.action = action;
            this.elapsedTime = elapsedTime;
        }

        public String getName() {
            return this.name;
        }

        public String getAction() {
            return this.action;
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }
    }
}

