/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.SelfUpdater;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.cli.CLICommandExecutor;
import org.tizen.packagemanager.cli.CLIMessages;
import org.tizen.packagemanager.cli.CLIOptionUtil;
import org.tizen.packagemanager.cli.CLIOptions;
import org.tizen.packagemanager.cli.CLIUtil;

public class CLIMain {
    private static Logger logger = null;
    private static CLIOptions options = new CLIOptions();
    private static boolean result = false;
    private static ContentProvider contentProvider;
    private static boolean isInitialized;

    public static void main(String[] args) {
        int exitCode = 0;
        Log.open();
        Log.logTitle("Package Manager CLI mode start");
        Log.logInfo("\n" + PlatformUtil.getPlatformInfo());
        Log.logInfo("Directory of running Installer : " + PathUtil.getCurrentDir());
        logger = Log.getLogger(CLIMain.class);
        logger.trace(" ** Initializing start.");
        logger.info("Load options....");
        result = CLIMain.loadCmdArgs(args, options);
        if (!result) {
            logger.error(ErrorController.getErrorMessage());
            System.out.println(ErrorController.getErrorMessage());
            exitCode = 4;
        } else {
            logger.trace(" ** Initializing End.");
            String exePath = options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.PATH);
            if (exePath != null && !exePath.isEmpty()) {
                Config.executablePath = exePath;
            }
            CLIMain.printOptionValues();
            logger.info("Execute Commands....");
            logger.info("######################################################################");
            try {
                contentProvider = new ContentProvider();
                contentProvider.getSDKInfo().init();
                contentProvider.getConfig().init();
                isInitialized = true;
                if (options.getRuncommand().equals((Object)CLIOptions.RUN_COMMAND.SELF_UPDATE)) {
                    try {
                        System.out.println("Checking if there is a new version of Package Manager");
                        CLIUtil.loadProxySettings(contentProvider.getConfig(), options);
                        contentProvider.getRepoMgr().init();
                        contentProvider.getPkgMgr().init(true);
                        SelfUpdater selfUpdater = new SelfUpdater(contentProvider);
                        if (selfUpdater.canCliManagerUpdate()) {
                            selfUpdater.updateCliManager(args);
                            System.exit(exitCode);
                        } else {
                            System.out.println("Already up-to-date.");
                            System.exit(exitCode);
                        }
                    }
                    catch (Exception selfUpdater) {
                        // empty catch block
                    }
                }
                PathUtil.cleanUpTempFilesAndDirectory(contentProvider.getSDKInfo());
                logger.trace("*** Case run : " + options.getRuncommand().command());
                switch (options.getRuncommand()) {
                    case RUN_INSTALL: {
                        String filePath = CLIOptionUtil.getFileRepositoryFromOptions(options);
                        String repository = CLIOptionUtil.getRepositoryFromOptions(options);
                        if (repository != null && filePath != null) {
                            String msg = "Cannot use " + CLIOptions.OPTIONS_HAS_VALUE.REPOSITORY.command() + " and " + CLIOptions.OPTIONS_HAS_VALUE.FILE_PATH.command() + " at the same time.";
                            throw new UMException(ErrorController.ErrorCode.INVALID_OPTION_USED, msg);
                        }
                        CLIMain.doRunInstall();
                        break;
                    }
                    case RUN_UPDATE: {
                        CLIMain.doRunUpdate();
                        break;
                    }
                    case RUN_UNINSTALL: {
                        CLIMain.doRunUninstall();
                        break;
                    }
                    case RUN_HELP: 
                    case RUN_HELP_SHORT: {
                        CLIMain.doRunHelp();
                        break;
                    }
                    case RUN_VIEW_LICENSE: {
                        CLIMain.doRunShowLicense();
                        break;
                    }
                    case SHOW_REPOSITORY_INFO: {
                        System.out.println("Display repository information");
                        CLIMain.doRunShowRepositoryInformation();
                        break;
                    }
                    case SHOW_INSTALLED_INFORMATION: {
                        System.out.println("Display installed Tizen Studio's information");
                        CLIMain.doRunShowInstalledInformation();
                        break;
                    }
                    case SHOW_PACKAGES: {
                        System.out.println("Display installed packages' information");
                        CLIMain.doRunShowPackages();
                        break;
                    }
                    case SDK_UTILS_SAVE_CACHE: {
                        CLIMain.doRunSdkUtilsSaveCache();
                        break;
                    }
                    case RUN_EXTRA: {
                        CLIMain.doRunExtension();
                        break;
                    }
                    default: {
                        System.out.println("Command : " + options.getRuncommand().command());
                        break;
                    }
                }
            }
            catch (UMException e) {
                System.out.println("**   Error  **\n" + e.getMessage());
                logger.trace(e.getMessage());
                logger.throwing(e);
                exitCode = 4;
            }
            catch (Exception e) {
                System.out.println("**   Error  **\n" + e.getMessage());
                logger.trace(e.getMessage());
                logger.throwing(e);
                exitCode = 4;
            }
            logger.info("######################################################################");
            logger.trace("Installation result : " + (ErrorController.getErrorMessage().isEmpty() ? "true" : "false"));
        }
        CLIMain.finalizeCliMain();
        logger.trace("Package Manager is finished.");
        System.exit(exitCode);
    }

    private static void doRunExtension() throws Exception {
        ArrayList<String> installList = CLIMain.parsePackageList();
        CLIMain.showVersion();
        CLICommandExecutor cliCommandExecutor = new CLICommandExecutor(contentProvider);
        cliCommandExecutor.doRunExtra(contentProvider, options, installList);
    }

    private static void doRunInstall() throws Exception {
        ArrayList<String> installList = CLIMain.parsePackageList();
        if (installList != null && !installList.isEmpty()) {
            CLIMain.checkPrerequisties();
            CLIMain.showVersion();
            CLICommandExecutor cliCommandExecutor = new CLICommandExecutor(contentProvider);
            cliCommandExecutor.doRunInstall(options, installList);
        } else if (installList == null || installList.isEmpty()) {
            throw new Exception("Please, set the package name.");
        }
    }

    private static void doRunUpdate() throws Exception {
        CLIMain.checkPrerequisties();
        CLIMain.showVersion();
        CLICommandExecutor cliCommandExecutor = new CLICommandExecutor(contentProvider);
        cliCommandExecutor.doRunUpdate(options);
    }

    private static void doRunUninstall() throws Exception {
        ArrayList<String> installList = CLIMain.parsePackageList();
        if (installList != null && !installList.isEmpty() || options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.PACKAGE_ALL)) {
            CLIMain.showVersion();
            CLICommandExecutor cliCommandExecutor = new CLICommandExecutor(contentProvider);
            cliCommandExecutor.doRunUninstall(options, installList);
        } else if (installList == null || installList.isEmpty()) {
            throw new Exception("Please, set the package name.");
        }
    }

    private static void doRunShowPackages() throws Exception {
        CLIMain.showVersion();
        CLICommandExecutor cliUpdater = new CLICommandExecutor(contentProvider);
        cliUpdater.doShowPackages(options);
    }

    private static void doRunShowInstalledInformation() throws Exception {
        CLIMain.showVersion();
        CLICommandExecutor cliUpdater = new CLICommandExecutor(contentProvider);
        cliUpdater.doShowInformation();
    }

    private static void doRunShowRepositoryInformation() throws Exception {
        CLIMain.showVersion();
        CLICommandExecutor cliUpdater = new CLICommandExecutor(contentProvider);
        cliUpdater.doShowRepositoryInfo(options);
    }

    private static void doRunHelp() {
        CLIMain.showVersion();
        CLICommandExecutor executor = new CLICommandExecutor(contentProvider);
        executor.doShowHelp();
    }

    private static void doRunShowLicense() throws Exception {
        ArrayList<String> installList = CLIMain.parsePackageList();
        if (installList != null && !installList.isEmpty() || options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.PACKAGE_ALL)) {
            CLIMain.showVersion();
            CLICommandExecutor executor = new CLICommandExecutor(contentProvider);
            executor.doShowComponentLicenseAgreement(installList, options);
        } else {
            CLICommandExecutor executor = new CLICommandExecutor(contentProvider);
            executor.doShowSoftwareLicenseAgreement();
        }
    }

    private static void doRunSdkUtilsSaveCache() throws Exception {
        CLICommandExecutor cliUpdater = new CLICommandExecutor(contentProvider);
        cliUpdater.doSdkUtilsSaveCache(options);
    }

    private static void checkPrerequisties() throws Exception {
        if (!options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.NO_JAVA_VERSION_CHECK) && !options.isInsideOptionNoJavaCheck()) {
            CLIMain.checkJavaRuntime();
        }
    }

    private static boolean loadCmdArgs(String[] args, CLIOptions options) {
        boolean result = true;
        Iterator<String> iter = Arrays.asList(args).iterator();
        ArrayList<CLIOptions.OPTIONS_HAS_VALUE> optionsHasValueList = new ArrayList<CLIOptions.OPTIONS_HAS_VALUE>();
        ArrayList<CLIOptions.OPTIONS_BOOLEAN> optionsBooleanList = new ArrayList<CLIOptions.OPTIONS_BOOLEAN>();
        while (iter.hasNext()) {
            CLIOptions.OPTIONS_BOOLEAN[] obValues;
            CLIOptions.OPTIONS_HAS_VALUE[] ohvValues;
            String arg = iter.next();
            arg = arg.trim();
            logger.trace("Current argument : " + arg);
            CLIOptions.RUN_COMMAND[] values = CLIOptions.RUN_COMMAND.values();
            boolean loopBreak = false;
            for (CLIOptions.RUN_COMMAND command : values) {
                if (!arg.equals(command.command())) continue;
                options.setRuncommand(command);
                logger.trace("Set run command is  : " + (Object)((Object)command));
                loopBreak = true;
                break;
            }
            if (loopBreak) continue;
            for (CLIOptions.OPTIONS_HAS_VALUE ohv : ohvValues = CLIOptions.OPTIONS_HAS_VALUE.values()) {
                if (!arg.equals(ohv.command())) continue;
                if (!iter.hasNext()) {
                    logger.error("Value is not described. ===> " + arg);
                    ErrorController.setErrorMessage("* Value is not described. ===> " + arg);
                    result = false;
                    return false;
                }
                String value = iter.next();
                value = value.trim();
                ohv.setValue(value);
                logger.trace("Set options[" + arg + "] to " + (arg.startsWith(CLIOptions.OPTIONS_HAS_VALUE.PASSWORD.command()) || arg.startsWith(CLIOptions.OPTIONS_HAS_VALUE.PASSWORD_SHORT.command()) ? "****" : value));
                optionsHasValueList.add(ohv);
                loopBreak = true;
                break;
            }
            if (loopBreak) continue;
            for (CLIOptions.OPTIONS_BOOLEAN ob : obValues = CLIOptions.OPTIONS_BOOLEAN.values()) {
                if (!arg.equals(ob.command())) continue;
                ob.setValue(true);
                logger.trace("Set options[" + arg + "] to true");
                optionsBooleanList.add(ob);
                loopBreak = true;
                break;
            }
            if (loopBreak) continue;
            String extraOptions = options.getExtraOptions();
            if (extraOptions != null) {
                if (arg.isEmpty()) continue;
                if (arg.startsWith(",")) {
                    arg = arg.replaceFirst(",", "");
                }
                if (arg.endsWith(",")) {
                    arg = arg.substring(0, arg.length() - 1);
                }
                if (arg.isEmpty()) continue;
                options.setExtraOptions(extraOptions + "," + arg);
                continue;
            }
            if (arg.isEmpty()) continue;
            if (arg.endsWith(",")) {
                arg = arg.substring(0, arg.length() - 1);
            }
            options.setExtraOptions(arg);
        }
        if (options.getRuncommand() == null) {
            logger.trace("There is no command.");
            logger.trace("Set run command to " + (Object)((Object)CLIOptions.RUN_COMMAND.RUN_HELP));
            System.out.println("Error : Invalid command usage.");
            options.setRuncommand(CLIOptions.RUN_COMMAND.RUN_HELP);
        }
        options.setOptionsHasValueList(optionsHasValueList);
        options.setOptionsBooleanList(optionsBooleanList);
        return result;
    }

    private static void printOptionValues() {
        logger.info("Print options has value");
        List<CLIOptions.OPTIONS_HAS_VALUE> optionsHasValueList = options.getOptionsHasValueList();
        for (CLIOptions.OPTIONS_HAS_VALUE ohv : optionsHasValueList) {
            logger.trace(" * " + ohv.name() + " : " + (ohv.name().toLowerCase().contains("pass") ? "*****" : ohv.getValue()));
        }
        logger.info("Print options has no value");
        List<CLIOptions.OPTIONS_BOOLEAN> optionsBooleanList = options.getOptionsBooleanList();
        for (CLIOptions.OPTIONS_BOOLEAN ob : optionsBooleanList) {
            logger.trace(" * " + ob.name() + " : " + ob.getValue());
        }
    }

    private static void showVersion() {
        String version = contentProvider.getConfig().getManagerVersion();
        if (version == null || version.isEmpty()) {
            version = "0.0.1";
        }
        System.out.println("Package Manager (" + version + ")");
    }

    private static void finalizeCliMain() {
        if (isInitialized) {
            PathUtil.cleanUpTempDownloadDirectory(contentProvider.getSDKInfo());
            if (contentProvider.getInstController() != null) {
                contentProvider.getInstController().threadForceShutdown();
            }
            String tempDir = PathUtil.get(contentProvider.getSDKInfo().getInstalledPath(), "temp");
            PathUtil.remove(tempDir);
        }
    }

    private static void checkJavaRuntime() throws Exception {
        logger.trace("Checking java");
        String correctJavaSystemPath = PlatformUtil.isCorrectJavaSystemPath();
        if (!correctJavaSystemPath.isEmpty()) {
            System.out.println(correctJavaSystemPath);
            throw new UMException(ErrorController.ErrorCode.JAVA_PATH_IS_NOT_VALID);
        }
        if (PlatformUtil.isInstalledOpenJDK()) {
            System.out.println("Found OpenJDK is installed.\nBut, Tizen Studio supports only Oracle JDK.\nPlease, install the Oracle JDK 8 or later.\nPlease go to http://www.oracle.com/technetwork/java/javase/downloads and download a JDK.");
            throw new UMException(ErrorController.ErrorCode.JAVA_JDK_NOT_VALID);
        }
        logger.trace("Current java is working java - not open jdk");
        if (PlatformUtil.isUnderJava8()) {
            logger.trace("Installed java version is under 1.8.");
            System.out.println("Tizen Studio supports only Java '1.8' or later, but Your Java version is lower than '1.8'.\nPlease, go to http://www.oracle.com/technetwork/java/javase/downloads and download a JDK.");
            System.out.println(CLIMessages.USE_NO_JAVA_OPTION);
            throw new UMException(ErrorController.ErrorCode.JAVA_IS_NOT_VALID);
        }
        logger.trace("Current java is working java version - not java 1.6");
    }

    private static ArrayList<String> parsePackageList() {
        ArrayList<String> returnList = new ArrayList<String>();
        String packageList = CLIOptionUtil.getComponentFromOptions(options);
        if (packageList != null && !packageList.isEmpty()) {
            if (packageList.contains(",")) {
                String[] splitedPackages = packageList.split(",");
                if (splitedPackages != null && splitedPackages.length > 0) {
                    for (String packageName : splitedPackages) {
                        returnList.add(packageName.trim());
                    }
                }
            } else {
                returnList.add(packageList.trim());
            }
        }
        return returnList;
    }

    static {
        isInitialized = false;
    }
}

