/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import org.tizen.manager.core.download.IDownloadManagerMonitor;
import org.tizen.manager.util.IDownloadProgressMonitor;

public class DownloadProgressMonitor
implements IDownloadProgressMonitor {
    private IDownloadManagerMonitor parent = null;
    private int totalWorks = 100;
    private int currentWorks = 0;
    private long totalBytes = 0L;
    private long currentBytes = 0L;
    private boolean isCanceled = false;
    private double rate = 0.0;

    public DownloadProgressMonitor() {
    }

    public DownloadProgressMonitor(IDownloadManagerMonitor parent, double rate) {
        this.parent = parent;
        this.rate = rate;
    }

    @Override
    public void downloadBegin(long totalBytes) {
        this.totalBytes = totalBytes;
        this.beginTask("", 100);
    }

    @Override
    public void downloadDone() {
    }

    @Override
    public boolean isCanceled() {
        if (this.parent != null) {
            return this.parent.isCanceled();
        }
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    @Override
    public void downloaded(long downloadBytes, long downloadRate) {
        this.currentBytes = downloadBytes;
        if (this.totalBytes > 0L) {
            this.worked((int)((long)this.totalWorks * this.currentBytes / this.totalBytes));
        } else {
            this.worked(0);
        }
    }

    @Override
    public void downloadStatus(IDownloadProgressMonitor.Status status) {
        this.subTask(status.name());
    }

    @Override
    public void beginTask(String arg0, int totalWorks) {
        this.totalWorks = totalWorks;
        if (this.parent != null) {
            this.parent.downloadWorked(0);
        }
    }

    @Override
    public void done() {
        if (this.parent != null) {
            this.currentWorks = 100;
            this.parent.updateDownloadWorked();
        }
    }

    @Override
    public void internalWorked(double arg0) {
    }

    @Override
    public void setTaskName(String arg0) {
    }

    @Override
    public void subTask(String taskName) {
        if (this.parent != null) {
            // empty if block
        }
    }

    @Override
    public void worked(int currentWorks) {
        this.currentWorks = currentWorks;
        if (this.parent != null) {
            this.parent.updateDownloadWorked();
        }
    }

    @Override
    public int getCurrentWork() {
        return this.currentWorks;
    }

    @Override
    public double getRate() {
        return this.rate;
    }
}

