/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.ComponentManager;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.PrerequisitesUtil;
import org.tizen.manager.util.ProgramController;
import org.tizen.packagemanager.cli.CLIInstallUpdateProcessMonitor;
import org.tizen.packagemanager.cli.CLIMessages;
import org.tizen.packagemanager.cli.CLIOptions;

class CLIInstallUpdateProcess {
    private Logger logger = null;
    private CLIOptions options;
    private ContentProvider contentProvider;

    CLIInstallUpdateProcess(ContentProvider contentProvider, CLIOptions options) {
        this.contentProvider = contentProvider;
        this.options = options;
        this.logger = Log.getLogger(CLIInstallUpdateProcess.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateAllOnConsole() throws Exception {
        this.killRunningProcess();
        if (this.contentProvider.getPkgMgr().areRepoPackagesOutdated()) {
            throw new Exception("Installation cannot be proceeded because the SDK you want to install(update) is a lower version than the SDK on your computer.");
        }
        System.out.println("");
        System.out.println("****************************************");
        System.out.println("******* Start to update packages *******");
        System.out.println("****************************************");
        List<Component> componentList = this.contentProvider.getCompMgr().getComponentList();
        ArrayList<Component> updateComponentList = new ArrayList<Component>();
        if (componentList != null && !componentList.isEmpty()) {
            for (Component component : componentList) {
                if (component.getInstallState() != Component.InstallState.UPDATE || component.getParent() == null) continue;
                updateComponentList.add(component);
            }
            if (updateComponentList.isEmpty()) {
                System.out.println("Nothing to update.");
                return true;
            }
        } else {
            System.out.println("Nothing to update.");
            return true;
        }
        ArrayList<Component> allComponents = new ArrayList<Component>();
        for (Object subComponent : updateComponentList) {
            ArrayList<Component> arrayList = this.contentProvider.getCompMgr().getSelectGroupComponentsToInstall((Component)subComponent);
            for (Component selComp : arrayList) {
                if (allComponents.contains(selComp)) continue;
                allComponents.add(selComp);
            }
            if (allComponents.contains(subComponent)) continue;
            allComponents.add((Component)subComponent);
        }
        ArrayList<Component> arrayList = ComponentManager.getSortedComponentsByInstallOrder(allComponents);
        if (PlatformUtil.isLinux()) {
            this.checkPrerequsites(arrayList);
        }
        System.out.println("Under packages will be updated.");
        for (Component component : arrayList) {
            System.out.println("\t * " + component.getPackageName());
        }
        boolean installResult = true;
        try {
            for (Component installComponent : arrayList) {
                CLIInstallUpdateProcessMonitor monitor = new CLIInstallUpdateProcessMonitor(installComponent, ICommonProgressMonitor.ProgressMonitorType.UPDATE);
                this.contentProvider.getInstController().addComponentToProcessQueue(installComponent, monitor);
                this.contentProvider.getInstController().install(installComponent, monitor);
                monitor.done();
            }
        }
        catch (Exception exception) {
            this.logger.throwing(exception);
            System.out.println(exception);
            installResult = false;
        }
        finally {
            if (!installResult) {
                throw new Exception("Updating has been failed.");
            }
            System.out.println("Updating has been completed.");
        }
        return installResult;
    }

    boolean installOnConsole(List<String> packageNames) throws Exception {
        if (this.contentProvider.getPkgMgr().areRepoPackagesOutdated()) {
            throw new Exception("Installation cannot be proceeded because the SDK you want to install(update) is a lower version than the SDK on your computer.");
        }
        PackageSet installedPackages = this.contentProvider.getPkgMgr().getInstalledPackages();
        if (installedPackages != null && !installedPackages.isEmpty()) {
            this.updateAllOnConsole();
        } else {
            this.killRunningProcess();
        }
        if (installedPackages.isEmpty()) {
            System.out.println("There is no default components. So, Package Manager will install those components first");
            System.out.println("Please, wait for installing default components.");
            try {
                this.contentProvider.getInstController().checkAndInstallUntouchablePackage();
            }
            catch (Exception e) {
                this.logger.throwing(e);
            }
            System.out.println("Installing default components has been completed.");
        }
        System.out.println("");
        System.out.println("****************************************");
        System.out.println("****** Start to install packages *******");
        System.out.println("****************************************");
        ArrayList<Component> installComponentList = new ArrayList<Component>();
        List<Component> componentList = this.contentProvider.getCompMgr().getComponentList();
        if (componentList != null && !componentList.isEmpty()) {
            block2: for (String pkgname : packageNames) {
                for (Component component : componentList) {
                    if (!component.getPackageName().equals(pkgname) || component.getInstallState() != Component.InstallState.INSTALL) continue;
                    installComponentList.add(component);
                    continue block2;
                }
            }
            if (installComponentList.isEmpty()) {
                System.out.println("Nothing to install.");
                return true;
            }
        } else {
            System.out.println("Nothing to install.");
            return true;
        }
        for (Component component : installComponentList) {
            if (component == null || component.getInstallState() != Component.InstallState.INSTALL || !(!component.hasChildren() ? !this.startToInstallSingleTreeItem(component) : !this.startToInstallAllSubTreeItem(component))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startToInstallSingleTreeItem(Component component) throws Exception {
        String errStr;
        ArrayList<Component> selGroupComps = this.contentProvider.getCompMgr().getSelectGroupComponentsToInstall(component);
        if (!selGroupComps.isEmpty() && !this.checkInstallSelectedGroup(selGroupComps)) {
            return false;
        }
        this.contentProvider.getCompMgr();
        selGroupComps = ComponentManager.getSortedComponentsByInstallOrder(selGroupComps);
        ArrayList<Component> checkLicense = new ArrayList<Component>();
        checkLicense.add(component);
        if (!this.checkAgreeEULA(checkLicense)) {
            return false;
        }
        ArrayList<Component> targetComponents = new ArrayList<Component>();
        for (Component component2 : selGroupComps) {
            if (targetComponents.contains(component2)) continue;
            targetComponents.add(component2);
        }
        targetComponents.add(component);
        if (PlatformUtil.isLinux()) {
            this.checkPrerequsites(targetComponents);
        }
        System.out.println("Under packages will be installed.");
        for (Component component3 : targetComponents) {
            System.out.println("\t * " + component3.getPackageName());
        }
        if (PathUtil.isInstalledMBCSPath(this.contentProvider) && !targetComponents.isEmpty() && (errStr = this.checkPreventInstall(targetComponents)) != null && !errStr.isEmpty() && !errStr.equals("")) {
            throw new Exception(errStr);
        }
        boolean installResult = true;
        try {
            for (Component installComponent : targetComponents) {
                CLIInstallUpdateProcessMonitor monitor = new CLIInstallUpdateProcessMonitor(installComponent, ICommonProgressMonitor.ProgressMonitorType.INSTALL);
                this.contentProvider.getInstController().addComponentToProcessQueue(installComponent, monitor);
                this.contentProvider.getInstController().install(installComponent, monitor);
                monitor.done();
            }
        }
        catch (Exception exception) {
            this.logger.throwing(exception);
            System.out.println(exception);
            installResult = false;
        }
        finally {
            if (!installResult) {
                throw new Exception("Installation has been failed.");
            }
            System.out.println("Installation has been completed.");
        }
        return installResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startToInstallAllSubTreeItem(Component component) throws Exception {
        String errStr;
        ArrayList<Component> targetComponents = new ArrayList<Component>();
        for (Component subComponent : component.getLeafDecendents()) {
            if (targetComponents.contains(subComponent) || subComponent.getInstallState() != Component.InstallState.INSTALL) continue;
            targetComponents.add(subComponent);
        }
        if (targetComponents.isEmpty()) {
            return false;
        }
        ArrayList<Component> tempComponents = new ArrayList<Component>();
        ArrayList<Component> sortedComponents = new ArrayList<Component>();
        tempComponents = new ArrayList();
        for (Component component2 : targetComponents) {
            ArrayList<Component> selGroupComps = this.contentProvider.getCompMgr().getSelectGroupComponentsToInstall(component2);
            for (Component selComp : selGroupComps) {
                if (tempComponents.contains(selComp)) continue;
                tempComponents.add(selComp);
            }
            if (tempComponents.contains(component2)) continue;
            tempComponents.add(component2);
        }
        for (Component component3 : ComponentManager.getSortedComponentsByInstallOrder(tempComponents)) {
            if (sortedComponents.contains(component3)) continue;
            sortedComponents.add(component3);
        }
        if (!this.checkAgreeEULA(sortedComponents)) {
            return false;
        }
        if (PlatformUtil.isLinux()) {
            this.checkPrerequsites(sortedComponents);
        }
        System.out.println("Under packages will be installed.");
        for (Component component4 : sortedComponents) {
            System.out.println("\t * " + component4.getPackageName());
        }
        if (PathUtil.isInstalledMBCSPath(this.contentProvider) && !sortedComponents.isEmpty() && (errStr = this.checkPreventInstall(sortedComponents)) != null && !errStr.isEmpty() && !errStr.equals("")) {
            throw new Exception(errStr);
        }
        boolean installResult = true;
        try {
            for (Component installComponent : sortedComponents) {
                CLIInstallUpdateProcessMonitor monitor = new CLIInstallUpdateProcessMonitor(installComponent, ICommonProgressMonitor.ProgressMonitorType.INSTALL);
                this.contentProvider.getInstController().addComponentToProcessQueue(installComponent, monitor);
                this.contentProvider.getInstController().install(installComponent, monitor);
                monitor.done();
            }
        }
        catch (Exception exception) {
            this.logger.throwing(exception);
            System.out.println(exception);
            installResult = false;
        }
        finally {
            if (!installResult) {
                throw new Exception("Installation has been failed.");
            }
            System.out.println("Installation has been completed.");
        }
        return installResult;
    }

    private boolean checkInstallSelectedGroup(ArrayList<Component> selGroupComps) {
        String strCompNames = "";
        for (Component comp : selGroupComps) {
            if (!strCompNames.isEmpty()) {
                strCompNames = strCompNames + ", ";
            }
            strCompNames = strCompNames + "'" + comp.getDisplayName() + "'";
        }
        return true;
    }

    public boolean checkAgreeEULA(ArrayList<Component> components) {
        ArrayList<Component> needLicenseComps = new ArrayList<Component>();
        for (Component comp : components) {
            if (comp.hasLicense() && !comp.isLicenseAgreed() && !needLicenseComps.contains(comp)) {
                needLicenseComps.add(comp);
            }
            ArrayList<Component> selGroupComps = this.contentProvider.getCompMgr().getSelectGroupComponentsToInstall(comp);
            for (Component selGroupComp : selGroupComps) {
                if (!selGroupComp.hasLicense() || selGroupComp.isLicenseAgreed() || needLicenseComps.contains(selGroupComp)) continue;
                needLicenseComps.add(selGroupComp);
            }
        }
        String strNeedLicenseCompNames = "";
        for (Component comp : needLicenseComps) {
            if (!strNeedLicenseCompNames.isEmpty()) {
                strNeedLicenseCompNames = strNeedLicenseCompNames + ", ";
            }
            strNeedLicenseCompNames = strNeedLicenseCompNames + "'" + comp.getDisplayName() + "'";
        }
        if (!needLicenseComps.isEmpty() && !this.options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.ACCEPT_LICENSE)) {
            System.out.println("The following packages are also required license agreement due to dependencies:");
            System.out.println(needLicenseComps);
            System.out.println(CLIMessages.AGREEMENT_LICENSE);
            return false;
        }
        return true;
    }

    private String checkPreventInstall(ArrayList<Component> selGroupComps) {
        int i;
        String strCompNames = "";
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> msgList = new ArrayList<String>();
        int idx = 0;
        boolean isFirst = true;
        for (Component comp : selGroupComps) {
            String prevInstStr = comp.getPreventInstall();
            if (prevInstStr == null || prevInstStr.isEmpty() || prevInstStr.equals("")) continue;
            for (i = 0; i < idx; ++i) {
                String tmp = (String)msgList.get(i);
                if (!tmp.equals(prevInstStr)) continue;
                nameList.add(i, (String)nameList.get(i) + ", [" + comp.getDisplayName() + "]");
                break;
            }
            if (i < idx) continue;
            nameList.add(idx, "[" + comp.getDisplayName() + "]");
            msgList.add(idx++, prevInstStr);
        }
        for (i = 0; i < idx; ++i) {
            if (!isFirst) {
                strCompNames = strCompNames + "\n\n";
            } else {
                isFirst = false;
            }
            strCompNames = strCompNames + (String)nameList.get(i) + "\n" + (String)msgList.get(i);
        }
        if (isFirst) {
            return "";
        }
        strCompNames = "Installation is not allowed for the following reason.\n\n" + strCompNames;
        return strCompNames;
    }

    private void killRunningProcess() throws Exception {
        ProgramController controller = ProgramController.createProgramController(this.contentProvider.getSDKInfo());
        List<String> sdkProcessList = controller.getSDKProcessList();
        if (sdkProcessList != null && sdkProcessList.size() > 0) {
            String msg = "";
            for (String processString : sdkProcessList) {
                msg = msg + "\t" + processString + "\n";
            }
            throw new Exception(String.format("Tizen Studio programs are running under installed location.\n%sClose the running programs.", msg));
        }
    }

    public void checkPrerequsites(ArrayList<Component> componentList) throws Exception {
        Map<String, List<String>> checkPrerequisities = PrerequisitesUtil.checkPrerequisities(this.contentProvider.getPkgMgr(), componentList);
        if (checkPrerequisities != null && checkPrerequisities.size() > 0) {
            String msg = "Required prerequisite packages are not installed.\nPlease install the packages using following command(s).\n";
            this.logger.trace("\tUnder libraries are not installed");
            this.logger.trace("\t##############################################");
            Set<String> keySet = checkPrerequisities.keySet();
            Iterator<String> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                String key;
                String pkgName = key = iterator.next();
                if (key.endsWith("*")) {
                    pkgName = key.substring(0, key.lastIndexOf("*"));
                }
                String msgValue = "sudo apt-get install " + pkgName;
                msg = msg + msgValue + "\n";
                this.logger.trace("\t" + msgValue);
            }
            this.logger.trace("\t##############################################");
            throw new Exception(msg);
        }
    }
}

