/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.linux.ProcessInformation;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ShellParser;

class LinuxShellRunningProgramParser
extends ShellParser {
    private List<ProcessInformation> processList = new ArrayList<ProcessInformation>();
    private static final Logger logger = Log.getLogger(LinuxShellRunningProgramParser.class);

    LinuxShellRunningProgramParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseStdOut(InputStream input, String packageName) {
        BufferedReader br = null;
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(input, PlatformUtil.CURRENT_CHARSET);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                ProcessInformation pInfo = this.parseProcessInfo(line);
                if (pInfo == null) continue;
                this.processList.add(pInfo);
            }
        }
        catch (IOException ioe) {
            logger.throwing(ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error("LinuxShellRunningProgramParser fail to close output stream");
                }
            }
        }
    }

    private ProcessInformation parseProcessInfo(String line) {
        String[] datas = line.split(" ");
        String[] processInfos = new String[5];
        int j = 0;
        for (int i = 0; i < datas.length; ++i) {
            if (datas[i].isEmpty()) continue;
            if (j < 5) {
                processInfos[j] = datas[i].trim();
                ++j;
                continue;
            }
            processInfos[4] = processInfos[4] + " " + datas[i].trim();
        }
        try {
            Integer.parseInt(processInfos[0]);
            return new ProcessInformation(processInfos);
        }
        catch (NumberFormatException e) {
            logger.info("Pid is not number." + line);
            return null;
        }
    }

    public List<ProcessInformation> getProcessInformation() {
        return this.processList;
    }
}

