/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.cli;

import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.ProxyConfigFile;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.packagemanager.cli.CLIOptions;

public class CLIUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadProxySettings(Config config, CLIOptions options) throws UMException {
        String proxyValue = options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.PROXY);
        if (proxyValue != null && !proxyValue.isEmpty()) {
            if (ProxyConfigFile.ProxyType.AUTOMATIC.toString().equals(proxyValue)) {
                config.saveProxySettings(ProxyConfigFile.ProxyType.AUTOMATIC, "", "");
                return;
            } else if (ProxyConfigFile.ProxyType.DIRECT.toString().equals(proxyValue)) {
                config.saveProxySettings(ProxyConfigFile.ProxyType.DIRECT, "", "");
                return;
            } else {
                String[] split = proxyValue.split(":");
                if (split == null || split.length <= 0) throw new UMException(ErrorController.ErrorCode.INVALID_PROXY_CONFIG_FOUND, proxyValue);
                String ip = null;
                String port = null;
                if (split.length == 2) {
                    ip = split[0].trim();
                    port = split[1].trim();
                } else if (split.length == 1) {
                    ip = split[0].trim();
                }
                config.saveProxySettings(ProxyConfigFile.ProxyType.MANUAL, ip, port);
            }
            return;
        }
        ProxyConfigFile configFile = config.getProxyConfig();
        if (configFile == null) return;
        if (ProxyConfigFile.ProxyType.AUTOMATIC.toString().equals(configFile.getProxyType())) {
            config.saveProxySettings(ProxyConfigFile.ProxyType.AUTOMATIC, "", "");
            return;
        }
        if (ProxyConfigFile.ProxyType.DIRECT.toString().equals(configFile.getProxyType())) {
            config.saveProxySettings(ProxyConfigFile.ProxyType.DIRECT, "", "");
            return;
        }
        try {
            config.saveProxySettings(ProxyConfigFile.ProxyType.MANUAL, configFile.getProxyHost(), String.valueOf(configFile.getProxyPort()));
            return;
        }
        catch (Exception e) {
            throw new UMException(ErrorController.ErrorCode.INVALID_PROXY_CONFIG_FOUND, proxyValue);
        }
    }
}

