/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.PropertyParser;
import org.tizen.manager.core.model.Property;
import org.tizen.manager.core.model.PropertySection;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PathUtil;

public class ImageInformation
implements Cloneable {
    public static final String SDK_IMAGE_INFO_FILE = "image.info";
    public static final String FIELD_SDK_IMAGE_ORIGIN = "origin";
    public static final String FIELD_SDK_IMAGE_DISTRIBUTION = "distribution";
    public static final String FIELD_SDK_IMAGE_DISTRIBUTION_ID = "distribution_id";
    private ArrayList<Property> mProperties;
    private String infoFilePath = null;
    private static String origin = null;
    private static String distribution = null;
    private static String distributionID = null;
    private static final Logger logger = Log.getLogger(ImageInformation.class);

    public ImageInformation() {
    }

    public ImageInformation(String path) {
        this.infoFilePath = path;
        this.mProperties = new ArrayList();
    }

    public Object clone() throws CloneNotSupportedException {
        ImageInformation imageInfo = (ImageInformation)super.clone();
        imageInfo.mProperties = new ArrayList();
        for (int i = 0; i < this.mProperties.size(); ++i) {
            imageInfo.mProperties.add(i, (Property)this.mProperties.get(i).clone());
        }
        return imageInfo;
    }

    public boolean loadImageInfo() {
        List<PropertySection> propertySections = null;
        File imageInfoFile = new File(PathUtil.get(this.infoFilePath, SDK_IMAGE_INFO_FILE));
        if (imageInfoFile.exists()) {
            PropertyParser parser = new PropertyParser();
            propertySections = parser.readFromFile(imageInfoFile);
        }
        return this.loadFromProperties(propertySections);
    }

    private boolean loadFromProperties(List<PropertySection> propertySections) {
        if (propertySections == null || propertySections.size() == 0) {
            logger.trace("\t(propertySections == null) || (propertySections.size() == 0)");
            return false;
        }
        this.setProperties(propertySections.get(0).getProperties());
        origin = this.getValue(FIELD_SDK_IMAGE_ORIGIN);
        distribution = this.getValue(FIELD_SDK_IMAGE_DISTRIBUTION);
        distributionID = this.getValue(FIELD_SDK_IMAGE_DISTRIBUTION_ID);
        return true;
    }

    public ArrayList<Property> getProperties() {
        return this.mProperties;
    }

    public void setProperties(ArrayList<Property> properties) {
        this.mProperties = properties;
    }

    public String getSDKImageInfo() {
        return NetworkUtil.getURL(origin, distribution);
    }

    public String getSDKImageOrigin() {
        return origin;
    }

    public String getSDKImageDistribution() {
        return distribution;
    }

    public String getSDKImageDistributionID() {
        return distributionID;
    }

    public String getValue(String key) {
        Property property = this.getProperty(key);
        if (property != null) {
            return property.getValue();
        }
        return "";
    }

    private Property getProperty(String key) {
        if (this.mProperties != null && key != null) {
            for (int i = 0; i < this.mProperties.size(); ++i) {
                if (key.compareTo(this.mProperties.get(i).getName()) != 0) continue;
                return this.mProperties.get(i);
            }
        }
        return null;
    }
}

