/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.exception;

import org.tizen.manager.exception.ErrorController;

public class UMException
extends Exception {
    private String additionalMsg = null;
    private String causeMsg = null;
    private String actionMsg = null;
    private ErrorController.ErrorCode errCode = null;
    private static final long serialVersionUID = 756412192330085351L;

    public UMException(ErrorController.ErrorCode e) {
        super(e.getErrorMessage());
        this.errCode = e;
        this.causeMsg = e.getCauseMessage();
        this.actionMsg = e.getActionMessage();
    }

    public UMException(ErrorController.ErrorCode e, String detailedMsg) {
        super(e.getErrorMessage());
        this.errCode = e;
        this.additionalMsg = detailedMsg;
        this.causeMsg = e.getCauseMessage();
        this.actionMsg = e.getActionMessage();
    }

    public UMException(ErrorController.ErrorCode e, String detailedMsg, Throwable inner) {
        super(e.getErrorMessage(), inner);
        this.errCode = e;
        this.additionalMsg = detailedMsg;
        this.causeMsg = e.getCauseMessage();
        this.actionMsg = e.getActionMessage();
    }

    public UMException(ErrorController.ErrorCode e, Throwable inner) {
        super(e.getErrorMessage(), inner);
        this.errCode = e;
        this.causeMsg = e.getCauseMessage();
        this.actionMsg = e.getActionMessage();
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public String getAdditionalMessage() {
        return this.additionalMsg;
    }

    public String getActionMessage() {
        return this.actionMsg;
    }

    public String getCauseMessage() {
        return this.causeMsg;
    }

    public String getFullMessage() {
        if (this.additionalMsg != null) {
            return super.getMessage() + " : " + this.additionalMsg;
        }
        if (super.getCause() != null) {
            return super.getMessage() + "\n => " + super.getCause().getMessage();
        }
        return super.getMessage();
    }

    public ErrorController.ErrorCode getErrorCode() {
        return this.errCode;
    }

    public boolean isCancelException() {
        return this.errCode == ErrorController.ErrorCode.CANCELED_DOWNLOADING_FILE || this.errCode == ErrorController.ErrorCode.CANCELED_UNPACKING_FILE || this.errCode == ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE || this.errCode == ErrorController.ErrorCode.INSTALLATION_CANCELED_BY_FAILURE || this.errCode == ErrorController.ErrorCode.INSTALLATION_CANCELED_BY_USER || this.errCode == ErrorController.ErrorCode.UNINSTALLATION_CANCELED_BY_FAILURE || this.errCode == ErrorController.ErrorCode.UNINSTALLATION_CANCELED_BY_USER || this.errCode == ErrorController.ErrorCode.UPDATING_CANCELED_BY_FAILURE || this.errCode == ErrorController.ErrorCode.UPDATING_CANCELED_BY_USER;
    }
}

