/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

public class TextUtil {
    public static String getLeftAlignedTextWithEllipsis(String origText, Control parent, int width) {
        String alignedText = origText;
        GC gc = new GC((Drawable)parent);
        int textWidth = gc.textExtent((String)alignedText).x;
        int parentWidth = width;
        while (textWidth > parentWidth) {
            int len = alignedText.length();
            alignedText = alignedText.contains("...") ? alignedText.substring(0, len - 4) + "..." : alignedText.substring(0, len - 1) + "...";
            textWidth = gc.textExtent((String)alignedText).x;
        }
        gc.dispose();
        return alignedText;
    }

    public static int getLinesFromText(String origText) {
        Matcher m = Pattern.compile("(\r\n)|(\n)|(\n)").matcher(origText);
        int lines = 1;
        while (m.find()) {
            ++lines;
        }
        return lines;
    }

    public static String getMultilinesText(String origText, Control comp, int width) {
        int i;
        StringBuilder singleline = new StringBuilder();
        StringBuilder multiline = new StringBuilder();
        String returnChar = "\n";
        GC gc = new GC((Drawable)comp);
        int textWidth = 0;
        int parentWidth = width;
        int tempWidth = 0;
        String[] splitTexts = origText.split(" ");
        int j = 0;
        for (i = 0; i < splitTexts.length - 1; ++i) {
            String tmp;
            String[] splitLineTexts;
            if (splitTexts[i].contains("\r") || splitTexts[i].contains("\n")) {
                splitLineTexts = splitTexts[i].split("\\r?\\n");
                for (j = 0; j < splitLineTexts.length - 1; ++j) {
                    singleline.append(splitLineTexts[j]);
                    multiline.append((CharSequence)singleline).append(returnChar);
                    singleline.delete(0, singleline.length());
                }
                singleline.append(splitLineTexts[j]).append(" ");
            } else {
                singleline.append(splitTexts[i]).append(" ");
            }
            textWidth = gc.textExtent((String)singleline.toString()).x - gc.textExtent((String)" ").x;
            if (splitTexts[i + 1].contains("\r") || splitTexts[i + 1].contains("\n")) {
                splitLineTexts = splitTexts[i].split("\\r?\\n");
                tmp = splitLineTexts[0];
            } else {
                tmp = splitTexts[i + 1];
            }
            tempWidth = gc.textExtent((String)new StringBuilder().append((String)tmp).append((String)" ").toString()).x;
            if (textWidth + tempWidth <= parentWidth) continue;
            multiline.append((CharSequence)singleline).append(returnChar);
            singleline.delete(0, singleline.length());
        }
        if (i < splitTexts.length) {
            singleline.append(splitTexts[i]);
            multiline.append((CharSequence)singleline);
        }
        gc.dispose();
        return multiline.toString();
    }

    public static String getMultilinesText2(String origText, Control comp, int width) {
        StringBuilder singleline = new StringBuilder();
        StringBuilder multiline = new StringBuilder();
        StringBuilder tmp = new StringBuilder();
        String returnChar = "\n";
        GC gc = new GC((Drawable)comp);
        int parentWidth = width;
        int tempWidth = 0;
        for (int i = 0; i < origText.length(); ++i) {
            tmp.append(origText.charAt(i));
            tempWidth = gc.textExtent((String)tmp.toString()).x;
            if (tempWidth > parentWidth) {
                multiline.append((CharSequence)singleline).append(returnChar);
                singleline.delete(0, singleline.length());
                tmp.delete(0, tmp.length());
                tmp.append(origText.charAt(i));
            }
            singleline.append(origText.charAt(i));
        }
        multiline.append((CharSequence)singleline).append(returnChar);
        gc.dispose();
        return multiline.toString();
    }
}

