/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.download.IDownloadManagerMonitor;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;

public class ZipLibrary {
    private static final String DATA_DIRECTORY = "data/";
    private static final int BUF_SIZE = 65536;
    private ZipFile zipFile;
    private File file;
    private FileWriter fw;
    private long totalUnzipTime = 0L;
    private static final Logger logger = Log.getLogger(ZipLibrary.class);

    public ZipLibrary(String fileName, String outputFile) throws UMException {
        this.file = new File(fileName);
        try {
            this.zipFile = new ZipFile(this.file);
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_UNPACK_FILE, (Throwable)e);
        }
        if (outputFile != null && !outputFile.isEmpty()) {
            File outFile = new File(outputFile);
            File parentFile = outFile.getParentFile();
            if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
                logger.error(parentFile + " Couldn't make directory.");
                return;
            }
            try {
                outFile.createNewFile();
            }
            catch (IOException e) {
                logger.throwing(e);
                throw new UMException(ErrorController.ErrorCode.FAILED_TO_UNPACK_FILE, (Throwable)e);
            }
            try {
                this.fw = new FileWriter(outputFile);
            }
            catch (IOException e) {
                logger.throwing(e);
                throw new UMException(ErrorController.ErrorCode.FAILED_TO_UNPACK_FILE, (Throwable)e);
            }
        }
        logger.trace("ZipLibrary load completed == > " + fileName);
    }

    public void close() {
        ZipFile.closeQuietly(this.zipFile);
        if (this.fw != null) {
            try {
                this.fw.flush();
                this.fw.close();
            }
            catch (IOException e) {
                logger.throwing(e);
            }
        }
    }

    public long unzip(String targetDirectory, IDownloadManagerMonitor ipm) throws Exception {
        return this.unzip(targetDirectory, ipm, 0L);
    }

    public long unzip(String targetDirectory, IDownloadManagerMonitor ipm, long packageUncompressedSize) throws Exception {
        File targetDir = new File(targetDirectory);
        logger.trace("Cleaning target Directory - start");
        logger.trace("Cleaning target Directory - finished");
        Boolean retVal = targetDir.mkdirs();
        if (!retVal.booleanValue() && !targetDir.exists()) {
            logger.error(targetDir + " Couldn't make directory.");
            return 0L;
        }
        long startTime = System.currentTimeMillis();
        Enumeration<ZipArchiveEntry> apZipEntries = this.zipFile.getEntries();
        long totalUnzipSize = 0L;
        int percent = 0;
        while (apZipEntries.hasMoreElements()) {
            if (ipm != null && ipm.isCanceled()) {
                logger.trace("Installation canceled by user");
                throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_FILE, this.zipFile.toString());
            }
            ZipArchiveEntry zaEntry = apZipEntries.nextElement();
            percent = (int)((double)(totalUnzipSize += zaEntry.getSize()) * 1.0 / (double)packageUncompressedSize * 100.0);
            if (this.fw != null) {
                this.fw.write(this.removeDataDirectory(zaEntry.getName()) + "\n");
            }
            if (!zaEntry.isDirectory()) {
                if (zaEntry.isUnixSymlink()) {
                    String unixSymlink = this.zipFile.getUnixSymlink(zaEntry);
                    if (unixSymlink != null && !unixSymlink.isEmpty()) {
                        File outputFile = new File(targetDir, zaEntry.getName());
                        File parentFile = outputFile.getParentFile();
                        if (parentFile != null && !parentFile.mkdirs()) {
                            logger.error("Counldn't make directory: " + parentFile);
                        }
                        if (outputFile.exists() && !outputFile.delete()) {
                            logger.error(outputFile + " couldn't be deleted.");
                        }
                        if (!PlatformUtil.isWindows()) {
                            String linkName = outputFile.getName();
                            String target = unixSymlink;
                            String command = "ln -s \"" + target + "\" \"" + linkName + "\"";
                            String[] commands = new String[]{"/bin/sh", "-c", command};
                            ProcessBuilder pb = new ProcessBuilder(commands);
                            pb.directory(outputFile.getParentFile());
                            pb.start();
                            continue;
                        }
                        this.writeZipEntryToFile(targetDir, zaEntry);
                        if (ipm == null || packageUncompressedSize <= 0L) continue;
                        ipm.extractWorked(percent);
                        continue;
                    }
                    this.writeZipEntryToFile(targetDir, zaEntry);
                    if (ipm == null || packageUncompressedSize <= 0L) continue;
                    ipm.extractWorked(percent);
                    continue;
                }
                this.writeZipEntryToFile(targetDir, zaEntry);
                if (ipm == null || packageUncompressedSize <= 0L) continue;
                ipm.extractWorked(percent);
                continue;
            }
            if (!zaEntry.isDirectory()) continue;
            this.createDirectory(targetDir, zaEntry);
            if (ipm == null || packageUncompressedSize <= 0L) continue;
            ipm.extractWorked(percent);
        }
        long endTime = System.currentTimeMillis();
        this.totalUnzipTime = endTime - startTime;
        logger.trace("Total Unzip Time : " + this.totalUnzipTime);
        ZipFile.closeQuietly(this.zipFile);
        return totalUnzipSize;
    }

    private void writeZipEntryToFile(File targetDir, ZipArchiveEntry zaEntry) throws Exception {
        try {
            this.writeToFile(targetDir, zaEntry);
        }
        catch (Exception e) {
            try {
                this.writeToFileWithStreamBuffer(targetDir, zaEntry);
            }
            catch (Exception e2) {
                throw new Exception(e2);
            }
        }
    }

    private void createDirectory(File targetDir, ZipArchiveEntry zaEntry) {
        File entryFile = new File(targetDir.getAbsolutePath() + File.separator + zaEntry.getName());
        File parentFile = entryFile.getParentFile();
        if (parentFile != null && !parentFile.mkdirs()) {
            logger.error("Couldn't make the directory: " + parentFile);
        }
        if (!entryFile.exists() && !entryFile.mkdirs()) {
            logger.error("Couldn't make the directory: " + entryFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File targetDir, ZipArchiveEntry zaEntry) throws Exception {
        int retryCount = 0;
        boolean isSucceed = true;
        Exception localException = null;
        do {
            isSucceed = true;
            File outputFile = new File(targetDir, zaEntry.getName());
            File parentFile = outputFile.getParentFile();
            if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
                logger.error("Couldn't make directory: " + parentFile);
                return;
            }
            if (outputFile.exists()) {
                if (!outputFile.delete()) {
                    logger.error("Couldn't delete file: " + outputFile);
                }
                if (!outputFile.createNewFile()) {
                    logger.error("Couldn't create new file: " + outputFile);
                }
            }
            FileOutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                outputStream = new FileOutputStream(outputFile);
                inputStream = this.zipFile.getInputStream(zaEntry);
                if (outputStream != null && inputStream != null) {
                    IOUtils.copy(inputStream, outputStream);
                }
                outputStream.flush();
            }
            catch (Exception e) {
                isSucceed = false;
                localException = e;
                logger.throwing(e);
            }
            finally {
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            try {
                String permission;
                int unixMode = zaEntry.getUnixMode();
                if (unixMode == 0 || (permission = String.format("%o", unixMode)) == null) continue;
                permission = permission.substring(permission.length() - 3, permission.length());
                if ((Integer.parseInt(permission = permission.substring(0, 1)) & 5) != 5) continue;
                outputFile.setExecutable(true);
            }
            catch (Exception e) {
                isSucceed = false;
                localException = e;
            }
        } while (!isSucceed && ++retryCount < 3);
        if (!isSucceed) {
            logger.error("Fail to extract file ==> " + zaEntry.getName());
            throw new Exception(localException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFileWithStreamBuffer(File targetDir, ZipArchiveEntry zaEntry) throws Exception {
        int retryCount = 0;
        boolean isSucceed = true;
        Exception localException = null;
        do {
            isSucceed = true;
            File outputFile = new File(targetDir, zaEntry.getName());
            File parentFile = outputFile.getParentFile();
            if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
                logger.error("Couldn't make directory at : " + parentFile);
                return;
            }
            if (outputFile.exists()) {
                if (!outputFile.delete()) {
                    logger.error("Couldn't delete file: " + outputFile);
                }
                if (!outputFile.createNewFile()) {
                    logger.error("Couldn't create new file:" + outputFile);
                }
            }
            InputStream is = null;
            FileOutputStream fos = null;
            int readByte = 0;
            try {
                is = this.zipFile.getInputStream(zaEntry);
                fos = new FileOutputStream(outputFile);
                if (is != null) {
                    byte[] buffer = new byte[65536];
                    while ((readByte = is.read(buffer)) != -1) {
                        fos.write(buffer, 0, readByte);
                    }
                }
            }
            catch (Exception e) {
                isSucceed = false;
                localException = e;
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            try {
                String permission;
                int unixMode = zaEntry.getUnixMode();
                if (unixMode == 0 || (permission = String.format("%o", unixMode)) == null) continue;
                permission = permission.substring(permission.length() - 3, permission.length());
                if ((Integer.parseInt(permission = permission.substring(0, 1)) & 5) != 5) continue;
                outputFile.setExecutable(true);
            }
            catch (Exception e) {
                isSucceed = false;
                localException = e;
            }
        } while (!isSucceed && ++retryCount < 3);
        if (!isSucceed) {
            logger.error("Fail to extract file with second way ==> " + zaEntry.getName());
            throw new Exception(localException);
        }
    }

    public long unzipSelectedList(String targetDirectory, List<String> fileNames) throws UMException {
        long size = 0L;
        File targetDir = new File(targetDirectory);
        if (targetDir != null && !targetDir.exists()) {
            if (!targetDir.mkdirs()) {
                logger.error("Couldn't make directory :" + targetDir);
                return size;
            }
            logger.trace("Create target directory => " + targetDir.getAbsolutePath());
        }
        if (fileNames != null && !fileNames.isEmpty()) {
            for (String name : fileNames) {
                ZipArchiveEntry entry;
                if (name.startsWith("/")) {
                    name = name.replaceFirst("/", "");
                }
                if ((entry = this.zipFile.getEntry(name)) != null) {
                    try {
                        this.writeZipEntryToFile(targetDir, entry);
                        size = entry.getSize();
                        continue;
                    }
                    catch (Exception e) {
                        logger.throwing(e);
                        throw new UMException(ErrorController.ErrorCode.FAILED_TO_UNPACK_FILE, name, e);
                    }
                }
                logger.error("Can not found file in image file => " + name);
                throw new UMException(ErrorController.ErrorCode.FAILED_TO_UNPACK_FILE, name);
            }
        }
        return size;
    }

    private String removeDataDirectory(String filePath) {
        if (filePath == null || filePath.equals("")) {
            return "";
        }
        if (!filePath.startsWith(DATA_DIRECTORY)) {
            return "";
        }
        filePath = filePath.substring(DATA_DIRECTORY.length());
        return filePath;
    }
}

