/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core;

import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.AlternativeManager;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.core.RepositoryManager;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.ComponentManager;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.util.Log;

public class ContentProvider {
    private static final Logger logger = Log.getLogger(ContentProvider.class);
    private SDKInfo sdkInfo = new SDKInfo();
    private Config config = new Config(this);
    private RepositoryManager repoMgr = new RepositoryManager(this);
    private ExtRepositoryManager extRepoMgr = new ExtRepositoryManager(this);
    private AlternativeManager alterMgr = new AlternativeManager(this);
    private PackageManager pkgMgr = new PackageManager(this);
    private ComponentManager compMgr = new ComponentManager(this);
    private InstallController instController = new InstallController(this);

    public void init(int option) throws UMException {
        if ((option | ClassOption.C_SDK_INFO.getOption()) > 0) {
            logger.trace("\tInitializing sdk path(info) file.");
            this.sdkInfo.init();
        }
        if ((option | ClassOption.C_CONFIG.getOption()) > 0) {
            logger.trace("\tInitializing configuration file.");
            this.config.init();
        }
        if ((option | ClassOption.C_REPO_MGR.getOption()) > 0) {
            logger.trace("\tInitializing repository manager.");
            this.repoMgr.init();
        }
        if ((option | ClassOption.C_EXT_MGR.getOption()) > 0) {
            logger.trace("\tInitializing extension repository controller.");
            this.extRepoMgr.init(true);
        }
        if ((option | ClassOption.C_ALTER_MGR.getOption()) > 0) {
            logger.trace("\tInitializing alternative manager controller.");
            this.alterMgr.init(true);
        }
        if ((option | ClassOption.C_PKG_MGR.getOption()) > 0) {
            logger.trace("\tInitializing package manager controller.");
            this.pkgMgr.init(true);
        }
        if ((option | ClassOption.C_COMP_MGR.getOption()) > 0) {
            logger.trace("\tInitializing component manager controller.");
            this.compMgr.init();
        }
        if ((option | ClassOption.C_INST_CTR.getOption()) > 0) {
            logger.trace("\tInitializing insall controller controller.");
            this.instController.init();
        }
    }

    public void init() throws UMException {
        logger.trace("\tInitializing sdk path(info) file.");
        this.sdkInfo.init();
        logger.trace("\tInitializing configuration file.");
        this.config.init();
        logger.trace("\tInitializing repository manager.");
        this.repoMgr.init();
        logger.trace("\tInitializing extension repository controller.");
        this.extRepoMgr.init(true);
        logger.trace("\tInitializing alternative manager controller.");
        this.alterMgr.init(true);
        logger.trace("\tInitializing package manager controller.");
        this.pkgMgr.init(true);
        logger.trace("\tInitializing component manager controller.");
        this.compMgr.init();
        logger.trace("\tInitializing insall controller controller.");
        this.instController.init();
    }

    public SDKInfo getSDKInfo() {
        return this.sdkInfo;
    }

    public void setSDKInfo(SDKInfo sdkInfo) {
        this.sdkInfo = sdkInfo;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public RepositoryManager getRepoMgr() {
        return this.repoMgr;
    }

    public void setRepoMgr(RepositoryManager repoMgr) {
        this.repoMgr = repoMgr;
    }

    public ExtRepositoryManager getExtRepoMgr() {
        return this.extRepoMgr;
    }

    public void setExtRepoMgr(ExtRepositoryManager extRepoMgr) {
        this.extRepoMgr = extRepoMgr;
    }

    public AlternativeManager getAlterMgr() {
        return this.alterMgr;
    }

    public void setAlterMgr(AlternativeManager alterMgr) {
        this.alterMgr = alterMgr;
    }

    public PackageManager getPkgMgr() {
        return this.pkgMgr;
    }

    public void setPkgMgr(PackageManager pkgMgr) {
        this.pkgMgr = pkgMgr;
    }

    public ComponentManager getCompMgr() {
        return this.compMgr;
    }

    public void setCompMgr(ComponentManager compMgr) {
        this.compMgr = compMgr;
    }

    public InstallController getInstController() {
        return this.instController;
    }

    public void setInstController(InstallController instController) {
        this.instController = instController;
    }

    public static enum ClassOption {
        C_SDK_INFO(1),
        C_CONFIG(2),
        C_REPO_MGR(4),
        C_EXT_MGR(8),
        C_ALTER_MGR(15),
        C_PKG_MGR(16),
        C_COMP_MGR(32),
        C_INST_CTR(64);

        private int option;

        private ClassOption(int option) {
            this.option = option;
        }

        public int getOption() {
            return this.option;
        }
    }
}

