/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.util.Log;

public class ChecksumUtil {
    public static final String SHA_256_TYPE = "SHA-256";
    private static final Logger logger = Log.getLogger(ChecksumUtil.class);
    private static final int BUF_SIZE = 65536;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageDigest getSHA256(String filePath) {
        MessageDigest mDigest = null;
        try {
            mDigest = MessageDigest.getInstance(SHA_256_TYPE);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("No such algorithem => " + filePath);
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
        }
        catch (FileNotFoundException fnfException) {
            logger.error("Checksum getSHA256 file not found => " + filePath);
            return null;
        }
        byte[] buf = new byte[65536];
        int readSize = 0;
        try {
            while ((readSize = ((InputStream)is).read(buf)) >= 0) {
                mDigest.update(buf, 0, readSize);
            }
        }
        catch (IOException e) {
            logger.error("Checksum getSHA256 IOException");
            MessageDigest messageDigest = null;
            return messageDigest;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    logger.error("checksum getSHA256 fail to close output stream");
                }
            }
        }
        return mDigest;
    }

    public static String messageDigestToString(MessageDigest digest) {
        byte[] bDigest = digest.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < bDigest.length; ++i) {
            hexString.append(ChecksumUtil.hexDigit(bDigest[i]));
        }
        return hexString.toString();
    }

    private static String hexDigit(byte x) {
        StringBuffer sb = new StringBuffer();
        char c = (char)(x >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        sb.append(c);
        c = (char)(x & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        sb.append(c);
        return sb.toString();
    }
}

