/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.Install;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.Install.IInstallUninstallPackageProgressMonitor;
import org.tizen.manager.core.Install.InstallManagerMonitor;
import org.tizen.manager.core.Install.InstallUninstallObject;
import org.tizen.manager.core.Install.ManagerableInstallerCallable;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.pkg.Package;

public class InstallPackageManager {
    private HashMap<String, InstallUninstallObject> installObjectMap = new HashMap();
    private ExecutorService installerThreadExecutor = Executors.newFixedThreadPool(1);
    private ContentProvider contentProvier;

    public InstallPackageManager(ContentProvider contentProvier) {
        this.contentProvier = contentProvier;
    }

    public synchronized void requestInstallPackage(Package pkg, String targetDir, IInstallUninstallPackageProgressMonitor monitor, Config mConfig) {
        if (this.installObjectMap.containsKey(pkg.getPackageName())) {
            monitor.setProgress("There already exists same install-process.");
            InstallUninstallObject installObject = this.installObjectMap.get(pkg.getPackageName());
            installObject.addMonitor(monitor);
            if (installObject.isCompleted()) {
                monitor.setProgress("The existing install-process is already done.");
                monitor.done();
            }
        } else {
            monitor.setProgress("Creating new install-progress... ");
            InstallUninstallObject doObject = new InstallUninstallObject(pkg.getPackageName());
            doObject.addMonitor(monitor);
            InstallManagerMonitor installMonitor = new InstallManagerMonitor(this, pkg);
            this.installObjectMap.put(pkg.getPackageName(), doObject);
            this.installerThreadExecutor.submit(new ManagerableInstallerCallable(this.contentProvier, pkg, targetDir, installMonitor));
        }
    }

    public synchronized void removePackage(Package pkg) {
        this.installObjectMap.remove(pkg.getPackageName());
    }

    public void shutdown() {
        while (!this.installerThreadExecutor.isTerminated() || !this.installerThreadExecutor.isShutdown()) {
            this.installerThreadExecutor.shutdownNow();
            this.installerThreadExecutor.shutdown();
        }
    }

    synchronized void setDone(Package pkg, Exception error) {
        InstallUninstallObject doObject = this.installObjectMap.get(pkg.getPackageName());
        doObject.setCompleted(true);
        ArrayList<IInstallUninstallPackageProgressMonitor> monitorListClone = new ArrayList<IInstallUninstallPackageProgressMonitor>();
        monitorListClone.addAll(doObject.getMonitorList());
        for (IInstallUninstallPackageProgressMonitor idmProgressMonitor : monitorListClone) {
            doObject.removeMonitor(idmProgressMonitor);
            idmProgressMonitor.setError(error);
            idmProgressMonitor.done();
        }
        if (doObject.getMonitorList().isEmpty()) {
            this.installObjectMap.remove(pkg.getPackageName());
        }
    }

    synchronized void setRemoveOldWorked(Package pkg, int work) {
        InstallUninstallObject doObject = this.installObjectMap.get(pkg.getPackageName());
        List<IInstallUninstallPackageProgressMonitor> monitorList = doObject.getMonitorList();
        for (IInstallUninstallPackageProgressMonitor idmProgressMonitor : monitorList) {
            idmProgressMonitor.removeOldWorked(work);
        }
    }

    synchronized void setMoveFilesWorked(Package pkg, int work) {
        InstallUninstallObject doObject = this.installObjectMap.get(pkg.getPackageName());
        List<IInstallUninstallPackageProgressMonitor> monitorList = doObject.getMonitorList();
        for (IInstallUninstallPackageProgressMonitor idmProgressMonitor : monitorList) {
            idmProgressMonitor.moveFilesWorked(work);
        }
    }

    synchronized void setRunScriptWorked(Package pkg, int work) {
        InstallUninstallObject doObject = this.installObjectMap.get(pkg.getPackageName());
        List<IInstallUninstallPackageProgressMonitor> monitorList = doObject.getMonitorList();
        for (IInstallUninstallPackageProgressMonitor idmProgressMonitor : monitorList) {
            idmProgressMonitor.runScriptWorked(work);
        }
    }

    synchronized void setProgress(Package pkg, String message) {
        InstallUninstallObject doObject = this.installObjectMap.get(pkg.getPackageName());
        List<IInstallUninstallPackageProgressMonitor> monitorList = doObject.getMonitorList();
        for (IInstallUninstallPackageProgressMonitor idmProgressMonitor : monitorList) {
            idmProgressMonitor.setProgress(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean existsPackageInInstallList(Package pkg) {
        HashMap<String, InstallUninstallObject> hashMap = this.installObjectMap;
        synchronized (hashMap) {
            return this.installObjectMap.containsKey(pkg.getPackageName());
        }
    }
}

