/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;

class RepoHistoryFile
implements Cloneable {
    private static final Logger logger = Log.getLogger(RepoHistoryFile.class);
    private static final String REPO_HISTORY_FILE_NAME = ".repo-history";
    private static final int REPO_HISTORY_COUNT = 5;
    private ArrayList<String> repoHistory = null;

    protected RepoHistoryFile() {
    }

    protected ArrayList<String> getRepoHistory() {
        if (this.repoHistory == null) {
            return new ArrayList<String>();
        }
        return this.repoHistory;
    }

    public Object clone() throws CloneNotSupportedException {
        RepoHistoryFile repoHistoryFile = (RepoHistoryFile)super.clone();
        repoHistoryFile.repoHistory = new ArrayList();
        for (int i = 0; i < this.repoHistory.size(); ++i) {
            repoHistoryFile.repoHistory.add(i, this.repoHistory.get(i));
        }
        return repoHistoryFile;
    }

    protected void load(SDKInfo sdkInfo) throws UMException {
        String repoHistoryFilePath = PathUtil.getFromInstalledPath(sdkInfo, ".info", REPO_HISTORY_FILE_NAME);
        File repoHistoryFile = new File(repoHistoryFilePath);
        if (!repoHistoryFile.exists()) {
            try {
                repoHistoryFile.createNewFile();
            }
            catch (IOException e) {
                throw new UMException(ErrorController.ErrorCode.FAILED_TO_CREATE_CONFIG_FILE, repoHistoryFilePath);
            }
        }
        this.repoHistory = new ArrayList();
        FileInputStream is = null;
        BufferedReader in = null;
        try {
            String sdkPath;
            is = new FileInputStream(repoHistoryFile);
            in = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            while ((sdkPath = in.readLine()) != null) {
                this.repoHistory.add(sdkPath);
            }
        }
        catch (IOException e) {
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_LOAD_CONFIG_FILE, repoHistoryFilePath);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.throwing(e);
            }
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.throwing(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRepoHistory(SDKInfo sdkInfo, String repository) {
        String repoHistoryFilePath = PathUtil.getFromInstalledPath(sdkInfo, ".info", REPO_HISTORY_FILE_NAME);
        if (repository == null || repository.isEmpty()) {
            logger.warn("Repository is invalid for registering : " + repository);
            return;
        }
        File repoHistoryFile = new File(repoHistoryFilePath);
        if (!repoHistoryFile.exists()) {
            try {
                repoHistoryFile = PathUtil.makeNewFile(repoHistoryFilePath);
            }
            catch (IOException e) {
                logger.throwing(e);
                return;
            }
        }
        if (this.repoHistory.contains(repository)) {
            return;
        }
        if (repoHistoryFile == null) {
            return;
        }
        this.removeOldRepoHistory();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(repoHistoryFile), "UTF-8"));
            if (!this.repoHistory.isEmpty()) {
                for (String repo : this.repoHistory) {
                    if (repo.equalsIgnoreCase("")) continue;
                    bw.write(repo);
                    bw.newLine();
                }
            }
            bw.write(repository);
            bw.newLine();
            bw.flush();
        }
        catch (IOException e) {
            logger.warn("Failed to write repo-history to file. " + repoHistoryFilePath);
            return;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                    this.repoHistory.add(repository);
                    logger.trace("\tPackage server address history. => " + this.repoHistory);
                }
                catch (IOException e) {
                    logger.throwing(e);
                }
            }
        }
    }

    private void removeOldRepoHistory() {
        while (this.repoHistory.size() >= 5) {
            this.repoHistory.remove(0);
        }
    }
}

