/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.custom;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.exception.ErrorController;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class CustomMessageDialog
extends MessageDialog {
    private WizardUIResourceHandler uiRsrcHandler;
    public static final int YES = 64;
    public static final int NO = 128;
    private static int result;
    private static boolean isOnlyOk;
    private static boolean isCopy;
    private static String checkMsg;
    private static boolean willLaunchTizenStudio;
    private static boolean isCountClose;
    private static int countMax;

    public static void setResult(int result) {
        CustomMessageDialog.result = result;
    }

    public static void setIsOnlyOk(boolean isOnlyOk) {
        CustomMessageDialog.isOnlyOk = isOnlyOk;
    }

    public static void setWillLaunchTizenStudio(boolean willLaunchTizenStudio) {
        CustomMessageDialog.willLaunchTizenStudio = willLaunchTizenStudio;
    }

    public static void setCheckMsg(String checkMsg) {
        CustomMessageDialog.checkMsg = checkMsg;
    }

    public static void setIsCountClose(boolean isCountClose) {
        CustomMessageDialog.isCountClose = isCountClose;
    }

    public static void setCountMax(int countMax) {
        CustomMessageDialog.countMax = countMax;
    }

    public static void setIsCopy(boolean isCopy) {
        CustomMessageDialog.isCopy = isCopy;
    }

    public CustomMessageDialog(Shell shell, DialogType dlgType, String title, String message, boolean onlyOk, boolean copy) {
        super(shell, title, null, message, CustomMessageDialog.getImageTypeFromDialogType(dlgType), CustomMessageDialog.getButtonsFromDialogType(dlgType, onlyOk), 0);
        CustomMessageDialog.setCheckMsg(null);
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        CustomMessageDialog.setIsOnlyOk(onlyOk);
        CustomMessageDialog.setIsCopy(copy);
        CustomMessageDialog.setWillLaunchTizenStudio(false);
    }

    public CustomMessageDialog(Shell shell, DialogType dlgType, String title, String message, String checkMessage, boolean onlyOk) {
        super(shell, title, null, message, CustomMessageDialog.getImageTypeFromDialogType(dlgType), CustomMessageDialog.getButtonsFromDialogType(dlgType, onlyOk), 0);
        CustomMessageDialog.setCheckMsg(checkMessage);
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        CustomMessageDialog.setIsOnlyOk(onlyOk);
        CustomMessageDialog.setIsCopy(false);
        CustomMessageDialog.setWillLaunchTizenStudio(false);
    }

    private static int getImageTypeFromDialogType(DialogType dlgType) {
        int style = 0;
        if (dlgType == DialogType.INFO) {
            style = 2;
        } else if (dlgType == DialogType.CONFIRM) {
            style = 5;
        } else if (dlgType == DialogType.WARNING) {
            style = 4;
        } else if (dlgType == DialogType.ERROR) {
            style = 1;
        } else if (dlgType == DialogType.CONFIRM_CHECK) {
            style = 5;
        }
        return style;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.uiRsrcHandler.isUninstaller()) {
            shell.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_UNINSTALLER));
        } else {
            shell.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        }
    }

    private static String[] getButtonsFromDialogType(DialogType dlgType, boolean onlyOk) {
        String[] result = null;
        if (dlgType == DialogType.INFO) {
            result = new String[]{"OK"};
        } else if (dlgType == DialogType.CONFIRM) {
            result = onlyOk ? new String[]{"OK"} : new String[]{"Yes", "No"};
        } else if (dlgType == DialogType.WARNING) {
            result = onlyOk ? new String[]{"OK"} : new String[]{"Yes", "No"};
        } else if (dlgType == DialogType.ERROR) {
            result = new String[]{"OK"};
        } else if (dlgType == DialogType.CONFIRM_CHECK) {
            result = new String[]{"OK", "Cancel"};
        }
        return result;
    }

    public static int showError(Shell shell, String title, ErrorController.ErrorCode errCode) {
        return CustomMessageDialog.showDlg(shell, title, errCode.getErrorMessage(), DialogType.ERROR, true);
    }

    public static int showDlg(final Shell shell, final String title, final String msg, final DialogType dlgType, final boolean onlyOk) {
        CustomMessageDialog.setResult(0);
        CustomMessageDialog.setIsOnlyOk(onlyOk);
        CustomMessageDialog.setIsCopy(false);
        CustomMessageDialog.setIsCountClose(false);
        CustomMessageDialog.setCountMax(0);
        if (shell == null) {
            return result;
        }
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CustomMessageDialog msgBox = new CustomMessageDialog(shell, dlgType, title, msg, onlyOk, false);
                CustomMessageDialog.setResult(msgBox.open());
            }
        });
        return CustomMessageDialog.getReturnCodeFromDialogType(dlgType, result);
    }

    public static int showDlg(final Shell shell, final String title, final String msg, final DialogType dlgType, final boolean onlyOk, boolean countClose, int count) {
        CustomMessageDialog.setResult(0);
        CustomMessageDialog.setIsOnlyOk(onlyOk);
        CustomMessageDialog.setIsCopy(false);
        CustomMessageDialog.setIsCountClose(countClose);
        CustomMessageDialog.setCountMax(count);
        if (shell == null) {
            return result;
        }
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CustomMessageDialog msgBox = new CustomMessageDialog(shell, dlgType, title, msg, onlyOk, false);
                CustomMessageDialog.setResult(msgBox.open());
            }
        });
        return CustomMessageDialog.getReturnCodeFromDialogType(dlgType, result);
    }

    public static int showDlg(final Shell shell, final String title, final String msg, final String checkMsg, final DialogType dlgType, final boolean onlyOk) {
        CustomMessageDialog.setResult(0);
        CustomMessageDialog.setIsOnlyOk(onlyOk);
        CustomMessageDialog.setIsCopy(false);
        CustomMessageDialog.setIsCountClose(false);
        CustomMessageDialog.setCountMax(0);
        if (shell == null) {
            return result;
        }
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CustomMessageDialog msgBox = new CustomMessageDialog(shell, dlgType, title, msg, checkMsg, onlyOk);
                CustomMessageDialog.setResult(msgBox.open());
            }
        });
        return CustomMessageDialog.getReturnCodeFromDialogType(dlgType, result);
    }

    public static int showDlg(final Shell shell, final String title, final String msg, final DialogType dlgType, final boolean onlyOk, final boolean copy) {
        CustomMessageDialog.setResult(0);
        CustomMessageDialog.setIsOnlyOk(onlyOk);
        CustomMessageDialog.setIsCopy(copy);
        CustomMessageDialog.setIsCountClose(false);
        CustomMessageDialog.setCountMax(0);
        if (shell == null) {
            return result;
        }
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CustomMessageDialog msgBox = new CustomMessageDialog(shell, dlgType, title, msg, onlyOk, copy);
                CustomMessageDialog.setResult(msgBox.open());
            }
        });
        return CustomMessageDialog.getReturnCodeFromDialogType(dlgType, result);
    }

    private static int getReturnCodeFromDialogType(DialogType dlgType, int originReturnCode) {
        int result = -1;
        if (dlgType == DialogType.INFO) {
            result = 32;
        } else if (dlgType == DialogType.CONFIRM) {
            result = isOnlyOk ? 32 : (originReturnCode == 0 ? 64 : 128);
        } else if (dlgType == DialogType.WARNING) {
            result = isOnlyOk ? 32 : (originReturnCode == 0 ? 64 : 128);
        } else if (dlgType == DialogType.ERROR) {
            result = 32;
        } else if (dlgType == DialogType.CONFIRM_CHECK) {
            result = originReturnCode == 0 ? 64 : 128;
            if (willLaunchTizenStudio) {
                result |= 0x20;
            }
        } else {
            result = 32;
        }
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button noBtn;
        Button yesBtn;
        Button cancelBtn;
        super.createButtonsForButtonBar(parent);
        Button okBtn = this.getButton(0);
        if (okBtn != null) {
            okBtn.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
            this.setButtonLayoutData(okBtn);
        }
        if ((cancelBtn = this.getButton(1)) != null) {
            cancelBtn.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
            this.setButtonLayoutData(cancelBtn);
        }
        if ((yesBtn = this.getButton(2)) != null) {
            yesBtn.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
            this.setButtonLayoutData(yesBtn);
        }
        if ((noBtn = this.getButton(3)) != null) {
            noBtn.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
            this.setButtonLayoutData(noBtn);
        }
    }

    private void createCheckboxButton(Composite composite) {
        int width;
        GridData gd = new GridData(16384, 4, true, false);
        Button launchTizenStudioBtn = new Button(composite, 32);
        launchTizenStudioBtn.setText(checkMsg);
        launchTizenStudioBtn.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
        launchTizenStudioBtn.setEnabled(true);
        launchTizenStudioBtn.setSelection(false);
        GC gc = new GC((Drawable)launchTizenStudioBtn);
        gd.widthHint = width = gc.textExtent((String)launchTizenStudioBtn.getText()).x + 30;
        gc.dispose();
        launchTizenStudioBtn.setLayoutData((Object)gd);
        launchTizenStudioBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.getSource();
                CustomMessageDialog.setWillLaunchTizenStudio(btn.getSelection());
            }
        });
    }

    protected Control createDialogArea(Composite composite) {
        if (isCopy) {
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                this.imageLabel.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
            }
            if (this.message != null) {
                StyledText msg = new StyledText(composite, 16448);
                msg.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
                msg.setEditable(false);
                msg.setEnabled(true);
                msg.setCaret(null);
                GridData data = new GridData(4, 128, true, false);
                data.widthHint = this.convertHorizontalDLUsToPixels(300);
                msg.setLayoutData((Object)data);
                msg.setText(this.message);
                msg.setBackground(this.uiRsrcHandler.getBackGroundColor());
            }
            return composite;
        }
        if (checkMsg != null) {
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                this.imageLabel.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
            }
            Composite cfmDlgComposite = new Composite(composite, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginWidth = 10;
            gl.marginHeight = 0;
            cfmDlgComposite.setLayout((Layout)gl);
            Label msg = new Label(cfmDlgComposite, 16448);
            msg.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
            msg.setEnabled(true);
            msg.setText(this.message);
            msg.setBackground(composite.getBackground());
            GridData data = new GridData(4, 128, true, false);
            GC gc = new GC((Drawable)msg);
            int width = gc.textExtent((String)this.message).x + 20;
            int height = gc.textExtent((String)this.message).y + 10;
            data.widthHint = width;
            data.heightHint = height;
            msg.setLayoutData((Object)data);
            this.createCheckboxButton(cfmDlgComposite);
            return cfmDlgComposite;
        }
        final Composite parent = (Composite)super.createDialogArea(composite);
        this.messageLabel.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
        if (isCountClose) {
            this.messageLabel.setText(this.message + String.valueOf(countMax) + " s.");
            parent.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent arg0) {
                    parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Thread t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                    parent.getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            countMax--;
                                            CustomMessageDialog.this.messageLabel.setText(CustomMessageDialog.this.message + String.valueOf(countMax) + " s.");
                                            parent.redraw();
                                            CustomMessageDialog.this.getShell().redraw();
                                            if (countMax == 0) {
                                                CustomMessageDialog.this.okPressed();
                                            }
                                        }
                                    });
                                }
                            });
                            t.start();
                        }
                    });
                }
            });
        }
        return parent;
    }

    static {
        isOnlyOk = false;
        isCopy = false;
        checkMsg = null;
        willLaunchTizenStudio = false;
        isCountClose = false;
        countMax = 0;
    }

    public static enum DialogType {
        INFO,
        CONFIRM,
        WARNING,
        ERROR,
        CONFIRM_CHECK;

    }
}

