/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;

public class SDKInfo {
    private static final Logger logger = Log.getLogger(SDKInfo.class);
    public static final String SDK_INFORMATION_FILE_NAME = "sdk.info";
    private static final String INSTALLED_PATH_KEY = "TIZEN_SDK_INSTALLED_PATH";
    private static final String SDK_DATA_PATH_KEY = "TIZEN_SDK_DATA_PATH";
    private static final String JDK_PATH_KEY = "JDK_PATH";
    public static final String KEYSTORE = "keystore";
    private static String sdkDataPath = "";
    private static String installedPath = "";
    private static String jdkPath = "";

    public void init() throws UMException {
        String executableDir = PathUtil.getExecutableDir();
        String executablePath = null;
        try {
            executablePath = new File(executableDir).getCanonicalPath();
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.EXECUTABLE_PATH_INVALID, (Throwable)e);
        }
        logger.trace("Executable path => " + executablePath);
        File managerDir = new File(executablePath);
        String sdkInfoPath = PathUtil.get(managerDir.getParent(), SDK_INFORMATION_FILE_NAME);
        File sdkInfoFile = new File(sdkInfoPath);
        if (sdkInfoFile.exists()) {
            HashMap<String, String> result = this.loadSdkInfoFile(sdkInfoPath);
            this.setInstalledPath(new File(result.get(INSTALLED_PATH_KEY)).getAbsolutePath());
            this.setSdkDataPath(new File(result.get(SDK_DATA_PATH_KEY)).getAbsolutePath());
            String extractedJdkPath = result.get(JDK_PATH_KEY);
            if (extractedJdkPath != null && !extractedJdkPath.isEmpty()) {
                this.setJdkPath(new File(result.get(JDK_PATH_KEY)).getAbsolutePath());
            }
        } else {
            throw new UMException(ErrorController.ErrorCode.CANNOT_FIND_INSTALLED_SDK);
        }
    }

    public void save(boolean overwrite) throws UMException {
        String executableDir = PathUtil.getExecutableDir();
        String executablePath = null;
        try {
            executablePath = new File(executableDir).getCanonicalPath();
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.EXECUTABLE_PATH_INVALID, executableDir);
        }
        logger.trace("Executable path(Canonical) => " + executablePath);
        File managerDir = new File(executablePath);
        String sdkInfoPath = PathUtil.get(managerDir.getParent(), SDK_INFORMATION_FILE_NAME);
        File sdkInfoFile = new File(sdkInfoPath);
        if (!sdkInfoFile.exists()) {
            this.writePaths(sdkInfoFile);
        } else if (overwrite) {
            if (!sdkInfoFile.delete()) {
                logger.error("Couldn't delete file :" + sdkInfoFile);
            }
            this.writePaths(sdkInfoFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePaths(File sdkInfoFile) throws UMException {
        block19: {
            BufferedWriter fw = null;
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            UMException umex = null;
            try {
                File parentFile = sdkInfoFile.getParentFile();
                if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
                    logger.error("Couldn't make directory: " + parentFile);
                    return;
                }
                String NEW_LINE = System.getProperty("line.separator");
                fos = new FileOutputStream(sdkInfoFile);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                fw = new BufferedWriter(osw);
                fw.write(String.format("%s=%s", INSTALLED_PATH_KEY, installedPath));
                fw.write(NEW_LINE);
                fw.write(String.format("%s=%s", SDK_DATA_PATH_KEY, sdkDataPath));
                fw.write(NEW_LINE);
                if (!jdkPath.isEmpty()) {
                    fw.write(String.format("%s=%s", JDK_PATH_KEY, jdkPath));
                    fw.write(NEW_LINE);
                }
            }
            catch (IOException e) {
                logger.throwing(e);
                umex = new UMException(ErrorController.ErrorCode.FAILED_TO_CREATE_CONFIG_FILE, sdkInfoFile.getAbsolutePath());
            }
            finally {
                try {
                    if (fw != null) {
                        fw.close();
                    }
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
                if (umex == null) break block19;
                throw umex;
            }
        }
    }

    public String getSdkDataPath() {
        return sdkDataPath;
    }

    public void setSdkDataPath(String sdkDataPath) {
        SDKInfo.sdkDataPath = sdkDataPath;
    }

    public String getInstalledPath() {
        return installedPath;
    }

    public void setInstalledPath(String installedPath) {
        SDKInfo.installedPath = installedPath;
    }

    public String readInstallPathFromSdkInfo(String path) throws UMException {
        HashMap<String, String> map = this.loadSdkInfoFile(path);
        return map.get(INSTALLED_PATH_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> loadSdkInfoFile(String path) throws UMException {
        HashMap<String, String> result;
        block18: {
            result = new HashMap<String, String>();
            File file = new File(path);
            if (!file.exists()) {
                throw new UMException(ErrorController.ErrorCode.FAILTED_TO_LOAD_SDK_INFO_FILE, "The 'sdk.info' file not found! " + path);
            }
            BufferedReader br = null;
            FileInputStream fis = null;
            InputStreamReader isr = null;
            UMException umex = null;
            try {
                String readLine;
                fis = new FileInputStream(file);
                isr = new InputStreamReader((InputStream)fis, "UTF-8");
                br = new BufferedReader(isr);
                logger.info("Reading sdk.info...");
                while ((readLine = br.readLine()) != null) {
                    logger.info("\t" + readLine);
                    int startChar = readLine.indexOf("=");
                    if (startChar < 0) continue;
                    String key = readLine.substring(0, startChar).trim();
                    String value = readLine.substring(startChar + 1).trim();
                    result.put(key, value);
                }
            }
            catch (IOException e) {
                logger.throwing(e);
                umex = new UMException(ErrorController.ErrorCode.FAILTED_TO_LOAD_SDK_INFO_FILE, (Throwable)e);
                return umex;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e1) {
                    logger.error(e1.getMessage());
                }
                if (umex == null) break block18;
                throw umex;
            }
        }
        if (result.get(INSTALLED_PATH_KEY) == null) {
            throw new UMException(ErrorController.ErrorCode.FAILTED_TO_LOAD_SDK_INFO_FILE, "No 'TIZEN_SDK_INSTALLED_PATH'");
        }
        if (result.get(SDK_DATA_PATH_KEY) == null) {
            throw new UMException(ErrorController.ErrorCode.FAILTED_TO_LOAD_SDK_INFO_FILE, "No 'TIZEN_SDK_DATA_PATH'");
        }
        return result;
    }

    public boolean isExistKeystoreDirectory() {
        File[] listFiles;
        File dataDir;
        boolean isRemain = false;
        String dataPath = this.getSdkDataPath();
        if (dataPath != null && dataPath.length() > 0 && (dataDir = new File(dataPath)).isDirectory() && dataDir.exists() && (listFiles = dataDir.listFiles()) != null && listFiles.length > 0) {
            for (File file : listFiles) {
                if (!file.isDirectory() || !file.getName().toLowerCase().equals(KEYSTORE)) continue;
                return true;
            }
        }
        return isRemain;
    }

    public String getJdkPath() {
        return jdkPath;
    }

    public void setJdkPath(String jdkPath) {
        SDKInfo.jdkPath = jdkPath;
    }
}

