/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ShellParser;
import org.tizen.manager.util.ShellUtil;
import org.tizen.manager.win.WindowsRegistry;

public class PathUtil {
    private static final Logger logger = Log.getLogger(PathUtil.class);
    private static final String FILE_EXTENSION_SEPERATOR = ".";
    private static final String DIRECTORY_SEPERATOR = File.separator;
    private static final int BUF_SIZE = 65536;

    private static String getLastNameFromLastSeperator(String path, String Seperator) {
        int lastIndex = path.lastIndexOf(Seperator);
        if (lastIndex < 0) {
            return path;
        }
        return path.substring(lastIndex + 1);
    }

    static String getFileExtension(String path) {
        int lastIndex = path.lastIndexOf(FILE_EXTENSION_SEPERATOR);
        if (lastIndex < 0) {
            return "";
        }
        return path.substring(lastIndex);
    }

    public static String getFileName(String path) {
        return PathUtil.getLastNameFromLastSeperator(path, DIRECTORY_SEPERATOR);
    }

    public static boolean copyHardLink(File fromFile, File toFile, boolean overwrite) {
        logger.trace("\tCopy from " + fromFile + " to " + toFile);
        if (overwrite) {
            logger.trace("\tSet overwrite flag.");
        }
        String fromPath = fromFile.getAbsolutePath();
        String[] command = PathUtil.getCopyShellCommand(fromPath, toFile.getAbsolutePath(), overwrite);
        try {
            ShellUtil.execute(command);
        }
        catch (IMShellCommandFail e) {
            logger.error("Failed to copy " + fromFile + "to" + toFile);
            logger.throwing(e);
            return false;
        }
        return true;
    }

    private static String[] getCopyShellCommand(String fromPath, String toPath, boolean overwrite) {
        if (overwrite) {
            if (PlatformUtil.CURRENT_PLATFORM == 1 || PlatformUtil.CURRENT_PLATFORM == 4) {
                String[] command = new String[]{"cp", "-rlf", fromPath, toPath};
                return command;
            }
            if (PlatformUtil.CURRENT_PLATFORM == 64) {
                String[] command = new String[]{"cp", "-af", fromPath, toPath};
                return command;
            }
            return null;
        }
        if (PlatformUtil.CURRENT_PLATFORM == 1 || PlatformUtil.CURRENT_PLATFORM == 4) {
            String[] command = new String[]{"cp", "-rl", fromPath, toPath};
            return command;
        }
        if (PlatformUtil.CURRENT_PLATFORM == 64) {
            String[] command = new String[]{"cp", "-a", fromPath, toPath};
            return command;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileCopy(String fromFilePath, String toFilePath) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        boolean ret = true;
        try {
            fis = new FileInputStream(fromFilePath);
            fos = new FileOutputStream(toFilePath);
            int data = 0;
            while ((data = fis.read()) != -1) {
                fos.write(data);
            }
            ret = true;
        }
        catch (IOException e) {
            logger.error("Failed to copy " + fromFilePath + "to" + toFilePath);
            logger.throwing(e);
            ret = false;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileFromInputStream(InputStream is, File to) throws IOException {
        logger.trace("\twrite file from input stream to : " + to);
        if (is == null) {
            return;
        }
        if (!to.exists()) {
            if (to.createNewFile()) {
                logger.trace("\tSuccess to create " + to + FILE_EXTENSION_SEPERATOR);
            } else {
                logger.error("Fail to create " + to + FILE_EXTENSION_SEPERATOR);
            }
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(to);
            int readSize = 0;
            byte[] buf = new byte[65536];
            while ((readSize = is.read(buf, 0, 65536)) != -1) {
                os.write(buf, 0, readSize);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.throwing(e);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                logger.throwing(e);
            }
        }
    }

    public static boolean moveFile(File fromFile, File toFile) {
        File parentDir = toFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            if (parentDir.mkdirs()) {
                logger.trace("\tSuccess to create parent directory ==> " + parentDir);
            } else {
                logger.error("Fail to create parent directory ==> " + parentDir);
            }
        }
        return PathUtil.move(fromFile, toFile);
    }

    public static boolean move(File fromFile, File toFile) {
        logger.trace("\tMove from " + fromFile + " to " + toFile);
        if (!fromFile.exists()) {
            logger.error(fromFile + " not exists");
            return false;
        }
        File parentFile = toFile.getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            logger.error(parentFile + " Couldn't make directory");
            return false;
        }
        if (toFile.exists()) {
            logger.trace("\t" + toFile + " exists already. InstallManager will delete it and move it.");
            if (toFile.isFile()) {
                Path fromPath = Paths.get(fromFile.getAbsolutePath(), new String[0]);
                Path toPath = Paths.get(toFile.getAbsolutePath(), new String[0]);
                try {
                    Files.move(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    logger.error("Fail to move file from " + fromFile + " to " + toFile);
                    return false;
                }
                logger.info("Success to move file from " + fromFile + " to " + toFile);
                return true;
            }
            logger.trace("\t" + toFile + " is directory case.");
            File[] files = fromFile.listFiles();
            if (files == null) {
                return true;
            }
            for (int i = 0; i < files.length; ++i) {
                File movedFile = new File(toFile, files[i].getName());
                if (PathUtil.move(files[i], movedFile)) continue;
                return false;
            }
            return true;
        }
        logger.trace("\t" + toFile + " does not exist. InstallManager will move it.");
        Path fromPath = Paths.get(fromFile.getAbsolutePath(), new String[0]);
        Path toPath = Paths.get(toFile.getAbsolutePath(), new String[0]);
        try {
            if (fromFile.isDirectory()) {
                Files.createDirectories(toPath, new FileAttribute[0]);
                logger.trace("\t" + toFile + "  Directory is created.");
                File[] files = fromFile.listFiles();
                if (files == null) {
                    return true;
                }
                for (int i = 0; i < files.length; ++i) {
                    File movedFile = new File(toFile, files[i].getName());
                    if (PathUtil.move(files[i], movedFile)) continue;
                    return false;
                }
            } else {
                Files.move(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING);
                logger.trace("\t" + toFile + " is movedfile.");
            }
        }
        catch (IOException e) {
            logger.error("Fail to move file/directory from " + fromFile + " to " + toFile);
            return false;
        }
        logger.info("Success to move file/directory from " + fromFile + " to " + toFile);
        return true;
    }

    public static boolean moveMac(File fromFile, File toFile) {
        logger.trace("\tMove from " + fromFile + " to " + toFile);
        if (!fromFile.exists()) {
            logger.error(fromFile + " not exists");
            return false;
        }
        File parentFile = toFile.getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            logger.error(parentFile + " Couldn't make directory");
            return false;
        }
        if (toFile.exists()) {
            logger.trace("\t" + toFile + " exists already. InstallManager will delete it and move it.");
            if (toFile.isFile()) {
                logger.trace("\t" + toFile + " is file case.");
                if (!toFile.delete()) {
                    logger.error("Fail to delete using File.delete() method. => " + toFile);
                    return false;
                }
                if (fromFile.renameTo(toFile)) {
                    return true;
                }
                logger.error("Fail to move file using File.renameTo() method from " + fromFile + " to " + toFile);
                return false;
            }
            logger.trace("\t" + toFile + " is directory case.");
            File[] files = fromFile.listFiles();
            if (files == null) {
                return true;
            }
            for (int i = 0; i < files.length; ++i) {
                File movedFile = new File(toFile, files[i].getName());
                if (PathUtil.moveMac(files[i], movedFile)) continue;
                return false;
            }
            return true;
        }
        logger.trace("\t" + toFile + " does not exist. InstallManager will move it.");
        if (PathUtil.renameTo(fromFile, toFile)) {
            logger.info("Success to move directory from " + fromFile + " to " + toFile);
            return true;
        }
        Path fromPath = Paths.get(fromFile.getAbsolutePath(), new String[0]);
        Path toPath = Paths.get(toFile.getAbsolutePath(), new String[0]);
        try {
            Files.move(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.error("Fail to move directory from " + fromFile + " to " + toFile);
            return false;
        }
        return true;
    }

    private static boolean renameTo(File fromFile, File toFile) {
        for (int i = 0; i < 20; ++i) {
            if (fromFile.renameTo(toFile)) {
                logger.info("Success to execute 'renameTo' method.(" + i + "times)");
                return true;
            }
            System.gc();
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                logger.throwing(e);
            }
        }
        return false;
    }

    public static boolean remove(String path) {
        return PathUtil.remove(new File(path));
    }

    public static boolean remove(File file) {
        if (PlatformUtil.isWindows()) {
            return PathUtil.removeForWindows(file);
        }
        return PathUtil.removeForLinux(file);
    }

    private static boolean removeForLinux(File filePath) {
        try {
            String[] cmd = new String[]{"rm", "-rf", filePath.getAbsolutePath()};
            int exitCode = ShellUtil.execute(cmd, new ShellParser());
            return exitCode == 0;
        }
        catch (IMShellCommandFail e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean removeForWindows(File filePath) {
        File[] listFile;
        boolean ret = true;
        if (!filePath.exists()) {
            return true;
        }
        if (filePath.isDirectory() && (listFile = filePath.listFiles()) != null) {
            for (File childFile : listFile) {
                ret = PathUtil.removeForWindows(childFile) && ret;
            }
        }
        System.gc();
        return filePath.delete() && ret;
    }

    public static File makeNewFile(String filePath) throws IOException {
        File parentDir;
        File file = new File(filePath);
        if (file.exists()) {
            logger.trace("\t<" + file + "> exists already. it will be removed.");
            if (!file.delete()) {
                logger.error("Fail to delete file. => " + file);
                return null;
            }
            logger.trace("\tSuccess to delete file. => " + file);
        }
        if ((parentDir = file.getParentFile()) != null && !parentDir.exists() && !parentDir.mkdirs()) {
            return null;
        }
        if (!file.createNewFile()) {
            logger.error("Fail to create file. => " + file);
            return null;
        }
        logger.trace("\tSuccess to create file. => " + file);
        return file;
    }

    public static String get(String ... path_components) {
        String path = "";
        for (int i = 0; i < path_components.length; ++i) {
            path = i == 0 ? path_components[0] : path + File.separator + path_components[i];
        }
        return path;
    }

    public static String getFromHome(String ... path_components) {
        return System.getProperty("user.home") + File.separator + PathUtil.get(path_components);
    }

    public static String getFromInstalledPath(SDKInfo sdkInfo, String ... path_components) {
        String installPath = sdkInfo.getInstalledPath();
        if (installPath.equals("")) {
            return "";
        }
        return installPath + File.separator + PathUtil.get(path_components);
    }

    public static String getCurrentDir() {
        return System.getProperty("user.dir");
    }

    public static String getExecutableJarParentDir() {
        URL url = PathUtil.class.getProtectionDomain().getCodeSource().getLocation();
        String jarPath = null;
        try {
            jarPath = URLDecoder.decode(url.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        File parentFile = new File(jarPath).getParentFile();
        if (parentFile != null) {
            return parentFile.getPath();
        }
        return "";
    }

    public static String getExecutableDir() {
        if (Config.executablePath == null) {
            return PathUtil.getCurrentDir();
        }
        return Config.executablePath;
    }

    private static String getLocalAppData() {
        if (PlatformUtil.isWindows()) {
            String path = System.getenv("LOCALAPPDATA");
            if (path == null) {
                path = WindowsRegistry.getRegistryValue("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "\"Local AppData\"");
            }
            return path;
        }
        return "";
    }

    public static String getFromAppData(String ... path_components) {
        return PathUtil.get(PathUtil.getLocalAppData() + File.separator + PathUtil.get(path_components));
    }

    public static String readAllTextFromResource(String resourcePath) throws UMException {
        InputStream is = null;
        StringBuffer txt = new StringBuffer();
        is = PathUtil.getResourceAsStream(resourcePath);
        if (is == null) {
            return null;
        }
        BufferedReader in = null;
        try {
            String strLicense;
            in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((strLicense = in.readLine()) != null) {
                txt.append(strLicense);
                txt.append("\n");
            }
        }
        catch (IOException e) {
            logger.error("Cannot read resource : => " + resourcePath);
            throw new UMException(ErrorController.ErrorCode.CANNOT_READ_RESOURCE);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.throwing(e);
            }
        }
        return txt.toString();
    }

    public static String readAllTextFromFile(String filePath, boolean carrageReturn) throws UMException {
        StringBuffer txt = new StringBuffer();
        FileInputStream is = null;
        BufferedReader in = null;
        try {
            String strLicense;
            is = new FileInputStream(filePath);
            in = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            while ((strLicense = in.readLine()) != null) {
                if (strLicense.isEmpty()) continue;
                txt.append(strLicense);
                if (!carrageReturn) continue;
                txt.append("\n");
            }
        }
        catch (IOException e) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_READ_TEXT_FILE, filePath);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.throwing(e);
            }
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.throwing(e);
            }
        }
        return txt.toString();
    }

    public static InputStream getResourceAsStream(String resourcePath) {
        return PathUtil.class.getResourceAsStream(resourcePath);
    }

    public static File getTempFileFromResource(String resourcePath, String prefix, String suffix) throws IOException {
        return PathUtil.getTempFileFromResource(resourcePath, prefix, suffix, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getTempFileFromResource(String resourcePath, String prefix, String suffix, boolean deleteOnExit) throws IOException {
        InputStream input = PathUtil.getResourceAsStream(resourcePath);
        if (input == null) {
            return null;
        }
        File file = null;
        try {
            file = File.createTempFile(prefix, suffix);
            PathUtil.writeFileFromInputStream(input, file);
            if (deleteOnExit) {
                file.deleteOnExit();
            }
        }
        finally {
            input.close();
        }
        return file;
    }

    public static String getTempFileParent() throws IOException {
        File tmp = File.createTempFile("tizen_installmanager", ".tmp");
        tmp.deleteOnExit();
        return tmp.getParent();
    }

    public static void cleanUpTempDownloadDirectory(SDKInfo sdkInfo) {
        File tempDirectory;
        String tempDir = Config.getTempDownloadDirectory(sdkInfo);
        if (tempDir != null && tempDir.length() > 0 && (tempDirectory = new File(tempDir)).exists()) {
            if (PathUtil.remove(tempDirectory)) {
                logger.info("Success to remove temp directory.");
            } else {
                logger.error("Fail to remove temp directory.");
            }
        }
    }

    public static void removeExceptDirectory(String targetDir, String exceptDirectory) {
        File[] listFiles;
        File targetFile = new File(targetDir);
        if (targetFile.exists() && targetFile.isDirectory() && (listFiles = targetFile.listFiles()) != null && listFiles.length > 0) {
            for (File file : listFiles) {
                if (file.isDirectory() && file.getName().toLowerCase().equals(exceptDirectory)) {
                    logger.trace("Skip remove delete file => " + file.getAbsolutePath());
                    continue;
                }
                PathUtil.remove(file);
            }
        }
        if (targetFile.exists() && targetFile.isDirectory() && ((listFiles = targetFile.listFiles()) == null || listFiles.length == 0)) {
            PathUtil.remove(targetFile);
        }
    }

    public static void removeExceptDirectorySafe(String targetDir, String exceptDirectory) {
        File[] listFiles;
        File targetFile = new File(targetDir);
        if (targetFile.exists() && targetFile.isDirectory() && (listFiles = targetFile.listFiles()) != null && listFiles.length > 0) {
            for (File file : listFiles) {
                if (file.isDirectory() && file.getName().toLowerCase().equals(exceptDirectory)) {
                    logger.trace("Skip remove delete file => " + file.getAbsolutePath());
                    continue;
                }
                PathUtil.removeForWindows(file);
            }
        }
        if (targetFile.exists() && targetFile.isDirectory() && ((listFiles = targetFile.listFiles()) == null || listFiles.length == 0)) {
            PathUtil.removeForWindows(targetFile);
        }
    }

    public static void writeFileFromString(String targetPath, String text) throws UMException {
        File targetFile = new File(targetPath);
        try {
            targetFile.createNewFile();
        }
        catch (IOException e1) {
            logger.error("Cannot create file => " + targetPath);
            throw new UMException(ErrorController.ErrorCode.CANNOT_CREATE_FILE);
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(targetFile));
            writer.write(text);
        }
        catch (IOException e) {
            logger.error("Cannot write config file");
            throw new UMException(ErrorController.ErrorCode.CANNOT_WRITE_FILE);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                logger.error("close fileoutput fail");
            }
        }
    }

    public static void deleteIfExists(File file) {
        try {
            if (!file.delete()) {
                logger.error("Failed to delete file -> " + file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.throwing(e);
            PathUtil.remove(file);
        }
    }

    public static void deleteSymbolicLink(File file) {
        if (!file.getAbsoluteFile().delete()) {
            logger.error("Failed to delete sym-link -> " + file.getAbsolutePath());
        }
    }

    public static void cleanUpTempFilesAndDirectory(SDKInfo sdkInfo) {
        String currentDir = PathUtil.getCurrentDir();
        String runTempFileParent = null;
        runTempFileParent = Config.getManagerConfigHome();
        File tempDir = new File(PathUtil.get(runTempFileParent, "run"));
        File[] listFiles = tempDir.listFiles();
        if (tempDir.exists() && listFiles != null) {
            for (File tmpDir : listFiles) {
                if (!tmpDir.getName().startsWith("tizenstudio") || tmpDir.getAbsolutePath().equals(currentDir)) continue;
                PathUtil.remove(tmpDir);
            }
        }
        PathUtil.cleanUpTempDownloadDirectory(sdkInfo);
    }

    public static boolean isInstalledMBCSPath(ContentProvider cp) {
        String instPath = cp.getSDKInfo().getInstalledPath();
        String dataPath = cp.getSDKInfo().getSdkDataPath();
        boolean instPathMBCS = false;
        boolean dataPathMBCS = false;
        try {
            String regx = "[`~!@$%^&*=?]+";
            Pattern pattern = Pattern.compile(regx);
            Matcher match = pattern.matcher(instPath);
            if (match.find() || instPath.length() != instPath.getBytes("UTF-8").length) {
                instPathMBCS = true;
            }
            if ((match = pattern.matcher(dataPath)).find() || dataPath.length() != dataPath.getBytes("UTF-8").length) {
                dataPathMBCS = true;
            }
            if (instPathMBCS || dataPathMBCS) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

