/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.mac;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.mac.ProcessInformation;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ShellParser;

class MacShellRunningProgramParser
extends ShellParser {
    private List<Integer> mPIDList = new ArrayList<Integer>();
    private List<ProcessInformation> processList = new ArrayList<ProcessInformation>();
    private static final Logger logger = Log.getLogger(MacShellRunningProgramParser.class);

    MacShellRunningProgramParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseStdOut(InputStream input, String packageName) {
        BufferedReader br = null;
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(input, PlatformUtil.CURRENT_CHARSET);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                try {
                    String pid2 = this.getPID(line);
                    int pid = Integer.parseInt(pid2);
                    this.mPIDList.add(pid);
                }
                catch (NumberFormatException e) {
                    logger.error("Pid is not number.");
                }
            }
        }
        catch (IOException ioe) {
            logger.throwing(ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error("MacShellRunningProgramParser fail to close output stream");
                }
            }
        }
    }

    private String getPID(String line) {
        String[] datas = line.split(" ");
        String[] processInfos = new String[5];
        int j = 0;
        for (int i = 0; i < datas.length; ++i) {
            if (datas[i].isEmpty()) continue;
            if (j < 5) {
                processInfos[j] = datas[i].trim();
                ++j;
                continue;
            }
            processInfos[4] = processInfos[4] + " " + datas[i].trim();
        }
        ProcessInformation processInfo = new ProcessInformation(processInfos);
        this.processList.add(processInfo);
        return processInfo.getPid();
    }

    public List<Integer> getPIDList() {
        return this.mPIDList;
    }

    public List<ProcessInformation> getProcessInformation() {
        return this.processList;
    }
}

