/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.ValidationResult;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.packagemanager.cli.CLIOptions;
import org.tizen.packagemanager.cli.CLIUtil;

public class CLIExtensions {
    private static final String ERROR_HEAD = "* Error : ";
    private static final String ERROR_INVALID_INDEX = "* Error : Invalid index ==> ";
    private static final String ERROR_CAN_NOT_REMOVE_DEFAULT_EXTRA_SERVER = "*Error : Can not remove default extra server : ";
    private static final String ERROR_CAN_NOT_MODIFY_DEFAULT_EXTENSION = "* Error : This modification is not allowed becaused the selection is default extra server.";
    private static final String ERROR_INVALID_OPTIONS = "* Error : Invalid options.";
    private static final String ERROR_PLEASE_USE_ONLY_ONE_INDEX = "* Error : Please, use only one index.";
    private static final String ERROR_NOTHING_TO_MODIFY = "* Error : Nothing to modify in your selection.";
    private static final String ERROR_INDEX_VALUE_IS_REQUIRED = "* Error : Index value is required.";
    private ContentProvider contentProvider;

    public CLIExtensions(ContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doRunExtra(CLIOptions options, ArrayList<String> installList) throws Exception {
        boolean showList = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.LIST);
        boolean showDetail = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.DETAIL);
        boolean addExtra = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.ADD_EXTRA);
        boolean modifyExtra = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.MODIFY_EXTRA);
        boolean activateExtra = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.ACTIVATE_EXTRA);
        boolean activateExtrashort = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.ACTIVATE_EXTRA_SHORT);
        boolean deactivateExtra = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.DEACTIVATE_EXTRA);
        boolean deactivateExtraShort = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.DEACTIVATE_EXTRA_SHORT);
        boolean removeExtra = options.getOptionsBoolean(CLIOptions.OPTIONS_BOOLEAN.REMOVE_EXTRA);
        if (showList) {
            this.initializeExtraCommand(options);
            this.displayExtraList(showDetail);
            return;
        } else if (activateExtra || activateExtrashort) {
            if (installList == null || installList.isEmpty()) throw new Exception(ERROR_INDEX_VALUE_IS_REQUIRED);
            this.initializeExtraCommand(options);
            this.doActivateExtra(installList, options, true);
            return;
        } else if (deactivateExtra || deactivateExtraShort) {
            if (installList == null || installList.isEmpty()) throw new Exception(ERROR_INDEX_VALUE_IS_REQUIRED);
            this.initializeExtraCommand(options);
            this.doActivateExtra(installList, options, false);
            return;
        } else if (addExtra) {
            this.initializeExtraCommand(options);
            this.doAddOrModifyExtra(options, true, installList);
            return;
        } else if (modifyExtra) {
            if (installList != null && !installList.isEmpty()) {
                this.initializeExtraCommand(options);
                ArrayList<ExtensionInformation> currentExtensions = this.contentProvider.getExtRepoMgr().getCurrentExtensions();
                installList = this.validateExtraIndexOption(installList, currentExtensions);
                if (installList.size() <= 0) {
                    throw new Exception(ERROR_NOTHING_TO_MODIFY);
                }
                if (installList.size() != 1) {
                    throw new Exception(ERROR_PLEASE_USE_ONLY_ONE_INDEX);
                }
            }
            if (installList != null && installList.size() <= 0) {
                throw new Exception(ERROR_NOTHING_TO_MODIFY);
            }
            if (installList != null && installList.size() != 1) {
                throw new Exception(ERROR_PLEASE_USE_ONLY_ONE_INDEX);
            }
            if (installList == null) {
                throw new Exception(ERROR_INDEX_VALUE_IS_REQUIRED);
            }
            this.doAddOrModifyExtra(options, false, installList);
            return;
        } else if (removeExtra) {
            if (installList == null || installList.isEmpty()) throw new Exception(ERROR_INDEX_VALUE_IS_REQUIRED);
            this.initializeExtraCommand(options);
            this.doRemoveExtra(installList, options);
            return;
        } else {
            if (installList == null || installList.isEmpty()) throw new Exception(ERROR_INDEX_VALUE_IS_REQUIRED);
            this.initializeExtraCommand(options);
            ArrayList<ExtensionInformation> currentExtensions = this.contentProvider.getExtRepoMgr().getCurrentExtensions();
            installList = this.validateExtraIndexOption(installList, currentExtensions);
            if (installList.size() <= 0) {
                throw new Exception(ERROR_INDEX_VALUE_IS_REQUIRED);
            }
            for (String index : installList) {
                try {
                    int parseInt = Integer.parseInt(index);
                    ExtensionInformation extensionInformation = currentExtensions.get(parseInt - 1);
                    this.displaySingleExtra(true, parseInt, extensionInformation);
                }
                catch (Exception e) {
                    System.out.println(ERROR_INVALID_INDEX + index);
                }
            }
        }
    }

    private void initializeExtraCommand(CLIOptions options) throws UMException {
        System.out.println("Preparing...");
        this.contentProvider.getConfig().init();
        CLIUtil.loadProxySettings(this.contentProvider.getConfig(), options);
        try {
            this.contentProvider.getRepoMgr().init();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.contentProvider.getInstController().init();
        this.contentProvider.getInstController().setCLIMode(true);
        this.contentProvider.getExtRepoMgr().init(true);
        this.contentProvider.getPkgMgr().init(true);
        System.out.println("Validating...");
    }

    private void doAddOrModifyExtra(CLIOptions options, boolean isAddRepository, ArrayList<String> installList) throws Exception {
        ArrayList<ExtensionInformation> newExtensionList;
        String fileRepo;
        String repoURL;
        String repoName = options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.NAME);
        if (repoName == null || repoName.isEmpty()) {
            repoName = options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.NAME_SHORT);
        }
        if ((repoURL = options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.REPOSITORY)) == null || repoURL.isEmpty()) {
            repoURL = options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.REPOSITORY_SHORT);
        }
        if ((fileRepo = options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.FILE_PATH)) == null || fileRepo.isEmpty()) {
            fileRepo = options.getOptionsValue(CLIOptions.OPTIONS_HAS_VALUE.FILE_PATH_SHORT);
        }
        if (fileRepo != null) {
            File repoFile;
            fileRepo = fileRepo.endsWith(".zip") ? NetworkUtil.getFileURL(fileRepo) : ((repoFile = new File(fileRepo)).isDirectory() ? NetworkUtil.getFileURL(repoFile.getAbsolutePath()) : NetworkUtil.getFileURL(repoFile.getParent()));
        }
        if (repoURL == null || repoURL.isEmpty()) {
            repoURL = fileRepo;
        }
        String repoId = null;
        int index = -1;
        ExtensionInformation modifyTargetExtension = null;
        if (!isAddRepository) {
            String getID = installList.get(0);
            index = Integer.parseInt(getID) - 1;
            ArrayList<ExtensionInformation> currentExtensions = this.contentProvider.getExtRepoMgr().getCurrentExtensions();
            modifyTargetExtension = currentExtensions.get(index);
            if (modifyTargetExtension != null) {
                repoId = modifyTargetExtension.getId();
                if (modifyTargetExtension.isDefaultExtension()) {
                    throw new Exception(ERROR_CAN_NOT_MODIFY_DEFAULT_EXTENSION);
                }
                if (repoURL == null && repoName == null) {
                    throw new Exception(ERROR_INVALID_OPTIONS);
                }
                if (repoURL != null && repoName != null && repoURL.isEmpty() && repoName.isEmpty()) {
                    throw new Exception(ERROR_INVALID_OPTIONS);
                }
                if (repoURL == null || repoURL.isEmpty()) {
                    repoURL = modifyTargetExtension.getRepository();
                }
                if (repoName == null || repoName.isEmpty()) {
                    repoName = modifyTargetExtension.getName();
                }
            } else {
                throw new Exception("Item not exists.");
            }
        }
        System.out.println("Extension name : " + repoName);
        System.out.println("Extension url  : " + repoURL);
        if (repoName == null || repoName.isEmpty()) {
            throw new Exception(ErrorController.ErrorCode.REPOSITORY_NAME_IS_EMPTY.getErrorMessage());
        }
        if (repoURL == null || repoURL.isEmpty()) {
            throw new Exception(ErrorController.ErrorCode.REPOSITORY_URL_IS_EMPTY.getErrorMessage());
        }
        if ((repoURL = NetworkUtil.normalizeURL(repoURL)) == null || repoURL.isEmpty()) {
            throw new Exception(ErrorController.ErrorCode.REPOSITORY_URL_IS_EMPTY.getErrorMessage());
        }
        if (isAddRepository) {
            for (ExtensionInformation extInfo : this.contentProvider.getExtRepoMgr().getCurrentExtensions()) {
                if (extInfo.getName().equals(repoName)) {
                    throw new Exception(ErrorController.ErrorCode.DUPLICATED_EXTENSION_REPOSITORY_NAME.getErrorMessage());
                }
                if (!NetworkUtil.isSameURL(extInfo.getRepository(), repoURL)) continue;
                throw new Exception(ErrorController.ErrorCode.DUPLICATED_EXTENSION_REPOSITORY.getErrorMessage());
            }
        }
        String targetURL = repoURL;
        if (isAddRepository) {
            repoId = UUID.randomUUID().toString();
        }
        ValidationResult result = this.contentProvider.getExtRepoMgr().validateRepository(targetURL, repoId);
        ArrayList<ExtensionInformation> currentExtensions = this.contentProvider.getExtRepoMgr().getCurrentExtensions();
        if (isAddRepository) {
            if (result.getCachePath() == null) {
                currentExtensions.add(ExtRepositoryManager.createNewRepository(repoId, repoName, repoURL, true, null));
            } else {
                currentExtensions.add(ExtRepositoryManager.createNewRepository(repoId, repoName, NetworkUtil.getFileURL(result.getCachePath()), true, result.getLastModifiedDate()));
            }
            this.contentProvider.getExtRepoMgr().updateRepositories(currentExtensions);
            this.contentProvider.getExtRepoMgr().writeToFile();
        } else {
            modifyTargetExtension.setName(repoName);
            if (result.getCachePath() == null) {
                modifyTargetExtension.setRepository(repoURL);
                modifyTargetExtension.setRepotype("server");
            } else {
                modifyTargetExtension.setRepository(NetworkUtil.getFileURL(result.getCachePath()));
                modifyTargetExtension.setRepotype("file");
                if (result.getLastModifiedDate() != null) {
                    modifyTargetExtension.setLastModifiedDate(result.getLastModifiedDate());
                }
            }
            this.contentProvider.getExtRepoMgr().writeToFile();
        }
        this.checkExtRepository();
        this.contentProvider.getExtRepoMgr().init(true);
        String repositoryURL = this.contentProvider.getConfig().getDistributionURL();
        this.contentProvider.getPkgMgr().reloadPackageInfo(repositoryURL, true);
        System.out.println("");
        for (ExtensionInformation repo : this.contentProvider.getExtRepoMgr().getCurrentExtensions()) {
            if (repo.getError() == null) continue;
            UMException e = (UMException)repo.getError();
            System.out.println("There is an error for auto activating.");
            System.out.println("################################################################################");
            String errorMessage = ERROR_HEAD + e.getMessage() + e.getAdditionalMessage();
            errorMessage = errorMessage.replace("Please, check your extension server.", "");
            System.out.println(errorMessage);
            System.out.println("################################################################################");
            System.out.println("\n");
        }
        System.out.println("Result");
        if (isAddRepository) {
            newExtensionList = this.contentProvider.getExtRepoMgr().getCurrentExtensions();
            if (newExtensionList != null && newExtensionList.size() > 0) {
                System.out.println("New extension is successfully added.");
                this.displaySingleExtra(true, newExtensionList.size(), newExtensionList.get(newExtensionList.size() - 1));
            }
        } else {
            newExtensionList = this.contentProvider.getExtRepoMgr().getCurrentExtensions();
            if (newExtensionList != null && newExtensionList.size() > 0) {
                this.displaySingleExtra(true, index + 1, newExtensionList.get(index));
            }
        }
    }

    private void doRemoveExtra(ArrayList<String> installList, CLIOptions options) {
        ArrayList<ExtensionInformation> currentExtensions = this.contentProvider.getExtRepoMgr().getCurrentExtensions();
        ArrayList<String> validateExtensionIndexOption = this.validateExtraIndexOption(installList, currentExtensions);
        ArrayList<ExtensionInformation> removeExtensions = new ArrayList<ExtensionInformation>();
        ArrayList<ExtensionInformation> defaultExtensions = new ArrayList<ExtensionInformation>();
        if (!validateExtensionIndexOption.isEmpty()) {
            for (String index : validateExtensionIndexOption) {
                int parseValue = Integer.parseInt(index) - 1;
                ExtensionInformation extensionInformation = currentExtensions.get(parseValue);
                if (!extensionInformation.isDefaultExtension()) {
                    if (removeExtensions.contains(extensionInformation)) continue;
                    removeExtensions.add(extensionInformation);
                    if (!this.contentProvider.getExtRepoMgr().isLocalFileExtRepo(extensionInformation)) continue;
                    this.contentProvider.getExtRepoMgr().removeFromCache(extensionInformation.getId());
                    continue;
                }
                if (defaultExtensions.contains(extensionInformation)) continue;
                defaultExtensions.add(extensionInformation);
            }
        }
        if (!defaultExtensions.isEmpty()) {
            System.out.println(ERROR_CAN_NOT_REMOVE_DEFAULT_EXTRA_SERVER);
            for (ExtensionInformation extensionInformation : defaultExtensions) {
                System.out.println("** " + extensionInformation.getName());
            }
            System.out.println();
        }
        if (!removeExtensions.isEmpty()) {
            for (ExtensionInformation extensionInformation : removeExtensions) {
                System.out.println(extensionInformation.getName() + " is removed.");
                currentExtensions.remove(extensionInformation);
            }
        }
        this.contentProvider.getExtRepoMgr().updateRepositories(currentExtensions);
        this.contentProvider.getExtRepoMgr().writeToFile();
    }

    private void displayExtraList(boolean showDetail) {
        ArrayList<ExtensionInformation> currentExtensions = this.contentProvider.getExtRepoMgr().getCurrentExtensions();
        if (!currentExtensions.isEmpty()) {
            int count = 1;
            for (ExtensionInformation extensionInformation : currentExtensions) {
                this.displaySingleExtra(showDetail, count, extensionInformation);
                ++count;
            }
        } else {
            System.out.println("No extension server exists.");
        }
    }

    private void displaySingleExtra(boolean showDetail, int count, ExtensionInformation extensionInformation) {
        String msg = "";
        msg = msg + "Index        : " + count;
        msg = msg + "\n";
        msg = msg + "Name         : " + extensionInformation.getName();
        msg = msg + "\n";
        msg = msg + "Repository   : " + extensionInformation.getRepository();
        msg = msg + "\n";
        if (showDetail) {
            msg = msg + "Id           : " + extensionInformation.getId();
            msg = msg + "\n";
            msg = msg + "Vendor       : " + (extensionInformation.getVendor() == null ? "none" : extensionInformation.getVendor());
            msg = msg + "\n";
            msg = msg + "Description  : " + (extensionInformation.getDescription() == null ? "none" : extensionInformation.getDescription());
            msg = msg + "\n";
        }
        msg = msg + "Default      : " + extensionInformation.isDefaultExtension();
        msg = msg + "\n";
        msg = msg + "Activate     : " + extensionInformation.getActivate();
        msg = msg + "\n";
        System.out.println(msg);
    }

    private void doActivateExtra(ArrayList<String> installList, CLIOptions options, boolean doActivate) throws UMException {
        ArrayList<ExtensionInformation> currentExtensions = this.contentProvider.getExtRepoMgr().getCurrentExtensions();
        installList = this.validateExtraIndexOption(installList, currentExtensions);
        int count = 1;
        for (ExtensionInformation repo : currentExtensions) {
            for (String number : installList) {
                try {
                    int parseInt = Integer.parseInt(number);
                    if (parseInt != count) continue;
                    repo.setActivateStatus(doActivate);
                    break;
                }
                catch (Exception parseInt) {
                }
            }
            ++count;
        }
        this.checkExtRepository();
        this.contentProvider.getExtRepoMgr().init(true);
        String repositoryURL = this.contentProvider.getConfig().getDistributionURL();
        this.contentProvider.getPkgMgr().reloadPackageInfo(repositoryURL, true);
        System.out.println("");
        for (ExtensionInformation repo : this.contentProvider.getExtRepoMgr().getCurrentExtensions()) {
            if (repo.getError() == null) continue;
            UMException e = (UMException)repo.getError();
            System.out.println("################################################################################");
            String errorMessage = ERROR_HEAD + e.getMessage() + e.getAdditionalMessage();
            errorMessage = errorMessage.replace("Please check your extension server.", "");
            System.out.println(errorMessage);
            System.out.println("################################################################################");
            System.out.println("\n");
        }
        count = 1;
        for (ExtensionInformation repo : this.contentProvider.getExtRepoMgr().getCurrentExtensions()) {
            for (String number : installList) {
                try {
                    int parseInt = Integer.parseInt(number);
                    if (parseInt != count) continue;
                    System.out.println("Extension         : " + repo.getName());
                    System.out.println("Activation status : " + repo.getActivate());
                    break;
                }
                catch (Exception exception) {
                }
            }
            ++count;
        }
    }

    private ArrayList<String> validateExtraIndexOption(ArrayList<String> installList, ArrayList<ExtensionInformation> currentExtensions) {
        ArrayList clone = (ArrayList)installList.clone();
        ArrayList<String> notExistsInIndex = new ArrayList<String>();
        for (String index : clone) {
            try {
                int parseInt = Integer.parseInt(index);
                if (parseInt <= currentExtensions.size() && parseInt > 0) continue;
                notExistsInIndex.add(index);
                installList.remove(index);
            }
            catch (Exception e) {
                notExistsInIndex.add(index);
                installList.remove(index);
            }
        }
        if (notExistsInIndex.size() > 0) {
            System.out.println("\n* Invalid index : " + notExistsInIndex + "\n");
        }
        Collections.sort(installList);
        return installList;
    }

    private void checkExtRepository() {
        this.contentProvider.getPkgMgr().resetExtensionPackages();
        for (ExtensionInformation repo : this.contentProvider.getExtRepoMgr().getCurrentExtensions()) {
            if (!repo.getActivateStatus()) continue;
            try {
                repo.setError(null);
                this.contentProvider.getPkgMgr().addExtensionPackagesFromRepository(repo);
            }
            catch (UMException e) {
                repo.setActivateStatus(false);
                repo.setError(e);
                System.out.println(e.getMessage());
            }
        }
        this.contentProvider.getExtRepoMgr().writeToFile();
    }
}

