/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.exception.InsideTroubleShootingDialog;
import org.tizen.packagemanager.ui.page.CommonTreeView;
import org.tizen.packagemanager.ui.page.ProgressItem;
import org.tizen.packagemanager.ui.page.ViewController;
import org.tizen.packagemanager.ui.page.custom.CustomTableIconButton;
import org.tizen.packagemanager.ui.provider.progresstab.ProgressCancelColumnLabelProvider;
import org.tizen.packagemanager.ui.provider.progresstab.ProgressColumnLabelProvider;
import org.tizen.packagemanager.ui.provider.progresstab.ProgressNameColumnLabelProvider;
import org.tizen.packagemanager.ui.provider.progresstab.ProgressStatusColumnLabelProvider;
import org.tizen.packagemanager.ui.provider.progresstab.ProgressTableContentProvider;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class ProgressTableView
extends Composite {
    private final int STATUS_COLUMN_INDEX = 1;
    private final int PROGRESS_COLUMN_INDEX = 2;
    private final int CANCEL_COLUMN_INDEX = 3;
    private WizardUIResourceHandler uiResHandler = WizardUIResourceHandler.getInstance();
    private static final Logger logger = Log.getLogger(ProgressTableView.class);
    private TableViewer tableViewer;
    private Table componentTable;
    private ProgressColumnLabelProvider pcProvider;
    private DefaultToolTip toolTip;
    private ArrayList<ProgressItem> progressItems;
    private TableItem oldItem;
    private TableItem currentItem;
    private TableItem selectedItem;
    private HashMap<Item, CustomTableIconButton> failMessageButtons;
    private HashMap<Item, CustomTableIconButton> cancelMessageButtons;
    private HashMap<Item, CustomTableIconButton> cancelButtons;
    private HashMap<Item, CustomTableIconButton> retryButtons;

    ProgressTableView(Composite parent) {
        super(parent, 0);
        assert (logger != null);
        this.failMessageButtons = new HashMap();
        this.cancelMessageButtons = new HashMap();
        this.cancelButtons = new HashMap();
        this.retryButtons = new HashMap();
        this.progressItems = new ArrayList();
        this.setBackground(this.uiResHandler.getBackGroundColor());
        this.createComponentTable();
        this.setButtonEventListener();
    }

    public Table getTable() {
        return this.componentTable;
    }

    private void createComponentTable() {
        int style = 68112;
        this.tableViewer = new TableViewer(this, style);
        this.toolTip = new DefaultToolTip(this.tableViewer.getControl());
        this.toolTip.setBackgroundColor(this.uiResHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.toolTip.setForegroundColor(this.uiResHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        this.toolTip.setFont(this.uiResHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider(new ProgressTableContentProvider());
        this.tableViewer.setInput(this.progressItems);
        this.componentTable = this.tableViewer.getTable();
        this.componentTable.setVisible(true);
        this.componentTable.setEnabled(true);
        this.componentTable.setHeaderVisible(false);
        this.setTableColumn();
    }

    private void setTableColumn() {
        TableColumnLayout columnLayout = new TableColumnLayout();
        TableViewerColumn componentClmn = new TableViewerColumn(this.tableViewer, 16384);
        componentClmn.setLabelProvider(new ProgressNameColumnLabelProvider(this));
        Rectangle nameBounds = this.uiResHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_NAME);
        componentClmn.getColumn().setWidth(nameBounds.width);
        columnLayout.setColumnData(componentClmn.getColumn(), new ColumnPixelData(nameBounds.width));
        TableViewerColumn statusClmn = new TableViewerColumn(this.tableViewer, 16384);
        statusClmn.setLabelProvider(new ProgressStatusColumnLabelProvider(this));
        Rectangle statusBounds = this.uiResHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_STATUS);
        statusClmn.getColumn().setWidth(statusBounds.width);
        columnLayout.setColumnData(statusClmn.getColumn(), new ColumnPixelData(statusBounds.width));
        TableViewerColumn progressClmn = new TableViewerColumn(this.tableViewer, 16384);
        this.pcProvider = new ProgressColumnLabelProvider(this.tableViewer);
        progressClmn.setLabelProvider(this.pcProvider);
        Rectangle progressBounds = this.uiResHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_PROGRESS);
        int additionalWitdh = 0;
        if (PlatformUtil.isLinux()) {
            additionalWitdh = progressBounds.x;
        } else if (PlatformUtil.isMacOS()) {
            additionalWitdh = progressBounds.y;
        }
        progressClmn.getColumn().setWidth(progressBounds.width + additionalWitdh);
        columnLayout.setColumnData(progressClmn.getColumn(), new ColumnPixelData(progressBounds.width + additionalWitdh));
        TableViewerColumn cancelClmn = new TableViewerColumn(this.tableViewer, 16384);
        cancelClmn.setLabelProvider(new ProgressCancelColumnLabelProvider(this));
        Rectangle cancelBounds = this.uiResHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_CANCEL);
        additionalWitdh = 0;
        if (PlatformUtil.isWindows()) {
            additionalWitdh = cancelBounds.x;
        } else if (PlatformUtil.isMacOS()) {
            additionalWitdh = cancelBounds.y;
        }
        cancelClmn.getColumn().setWidth(cancelBounds.width + additionalWitdh);
        columnLayout.setColumnData(cancelClmn.getColumn(), new ColumnWeightData(100, cancelBounds.width + additionalWitdh));
        this.setLayout(columnLayout);
    }

    protected List<TableItem> getTableItems() {
        return Arrays.asList(this.componentTable.getItems());
    }

    private void setButtonEventListener() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    TableItem selItem;
                    if (ProgressTableView.this.selectedItem != null && !ProgressTableView.this.selectedItem.isDisposed()) {
                        ProgressTableView.this.selectedItem.setData("isSelect", false);
                    }
                    if ((selItem = ProgressTableView.this.componentTable.getSelection()[0]) != null && !selItem.isDisposed()) {
                        selItem.setData("isSelect", true);
                        ProgressTableView.this.selectedItem = selItem;
                    }
                    ProgressTableView.this.tableViewer.setSelection(StructuredSelection.EMPTY);
                    ProgressTableView.this.tableViewer.refresh();
                }
            }
        });
        this.componentTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                for (CustomTableIconButton button : ProgressTableView.this.getAllTableIconButtons()) {
                    Rectangle bounds;
                    if (button.isDisposed() || (bounds = button.getBounds()) == null || !bounds.contains(pt)) continue;
                    button.handleMouseUpEvent(event);
                }
                ProgressTableView.this.currentItem = ProgressTableView.this.componentTable.getItem(pt);
            }

            @Override
            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                for (CustomTableIconButton button : ProgressTableView.this.getAllTableIconButtons()) {
                    Rectangle bounds;
                    if (button.isDisposed() || (bounds = button.getBounds()) == null || !bounds.contains(pt)) continue;
                    button.handleMouseDownEvent(event);
                }
                ProgressTableView.this.currentItem = ProgressTableView.this.componentTable.getItem(pt);
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.componentTable.addMouseMoveListener(new MouseMoveListener(){

            @Override
            public void mouseMove(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                for (CustomTableIconButton button : ProgressTableView.this.getAllTableIconButtons()) {
                    if (button.isDisposed()) continue;
                    button.handleMouseMoveEvent(pt);
                }
                ProgressTableView.this.currentItem = ProgressTableView.this.componentTable.getItem(pt);
                if (ProgressTableView.this.oldItem != null && !ProgressTableView.this.oldItem.isDisposed()) {
                    ProgressTableView.this.toolTip.deactivate();
                }
                ProgressTableView.this.oldItem = ProgressTableView.this.currentItem;
                if (ProgressTableView.this.currentItem == null || ProgressTableView.this.currentItem.getData() == null) {
                    return;
                }
                Component component = ((ProgressItem)ProgressTableView.this.currentItem.getData()).getComponent();
                if (!component.getChildren().isEmpty()) {
                    ProgressTableView.this.toolTip.deactivate();
                    return;
                }
                Rectangle statusColumnBounds = ProgressTableView.this.currentItem.getBounds(1);
                if (statusColumnBounds.contains(pt) && component.getError() != null) {
                    ProgressTableView.this.toolTip.activate();
                    ProgressTableView.this.toolTip.setText(component.getError().getMessage());
                } else {
                    ProgressTableView.this.toolTip.deactivate();
                }
            }
        });
        this.componentTable.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent arg0) {
            }

            @Override
            public void mouseExit(MouseEvent arg0) {
                ProgressTableView.this.emitMouseExitForAllButtons();
            }

            @Override
            public void mouseEnter(MouseEvent arg0) {
            }
        });
    }

    private void emitMouseExitForAllButtons() {
        if (this.oldItem != null && !this.oldItem.isDisposed()) {
            this.getCancelButton(this.oldItem).handleEvent(CustomTableIconButton.CustomMouseEvent.ICON_MOUSE_EXIT);
            this.getFailMessageButton(this.oldItem).handleEvent(CustomTableIconButton.CustomMouseEvent.ICON_MOUSE_EXIT);
            this.getCancelMessageButton(this.oldItem).handleEvent(CustomTableIconButton.CustomMouseEvent.ICON_MOUSE_EXIT);
            this.getRetryButton(this.oldItem).handleEvent(CustomTableIconButton.CustomMouseEvent.ICON_MOUSE_EXIT);
        }
    }

    public void setProgressText(TableItem currentItem, String msg) {
        if (currentItem != null && !currentItem.isDisposed()) {
            currentItem.setText(2, msg);
        }
    }

    public ArrayList<CustomTableIconButton> getAllTableIconButtons() {
        ArrayList<CustomTableIconButton> result = new ArrayList<CustomTableIconButton>();
        int count = this.tableViewer.getTable().getItemCount();
        for (int i = 0; i < count; ++i) {
            TableItem tableItem = this.tableViewer.getTable().getItem(i);
            result.add(this.getFailMessageButton(tableItem));
            result.add(this.getCancelMessageButton(tableItem));
            result.add(this.getCancelButton(tableItem));
            result.add(this.getRetryButton(tableItem));
        }
        return result;
    }

    public TableItem getTableItemByComponent(Component component) {
        for (TableItem tableItem : this.getTableItems()) {
            if (tableItem.isDisposed() || ((ProgressItem)tableItem.getData()).getComponent() != component) continue;
            return tableItem;
        }
        return null;
    }

    void refresh(boolean isInit) {
        if (isInit) {
            this.progressItems = new ArrayList();
            this.oldItem = null;
            this.currentItem = null;
            this.tableViewer.setInput(this.progressItems);
        } else {
            this.tableViewer.refresh();
        }
    }

    public CustomTableIconButton getCancelButton(Item tableItem) {
        CustomTableIconButton button = this.cancelButtons.get(tableItem);
        if (button == null) {
            button = new CustomTableIconButton(tableItem, 3, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CANCEL_NORAML, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CANCEL_OVER, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CANCEL_SELECT, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CANCEL_NORAML);
            button.removeAllMouseClickEventListeners();
            button.addMouseClickEventListener(new CustomTableIconButton.IClickEventListener(){

                @Override
                public void onClick(CustomTableIconButton parentBtn) {
                    ProgressTableView.this.onClickCancelButton(parentBtn);
                }
            });
            this.cancelButtons.put(tableItem, button);
        }
        return button;
    }

    protected void onClickCancelButton(CustomTableIconButton parentBtn) {
        ProgressItem progressItem = (ProgressItem)((TableItem)parentBtn.getParentItem()).getData();
        parentBtn.setDisabled(true);
        Component component = progressItem.getComponent();
        ViewController.getInstance().getProgressView().setCanceled(component);
    }

    public CustomTableIconButton getRetryButton(Item tableItem) {
        CustomTableIconButton button = this.retryButtons.get(tableItem);
        if (button == null) {
            button = new CustomTableIconButton(tableItem, 3, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_RESTART_NORAML, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_RESTART_OVER, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_RESTART_SELECT, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_RESTART_NORAML);
            button.removeAllMouseClickEventListeners();
            button.addMouseClickEventListener(new CustomTableIconButton.IClickEventListener(){

                @Override
                public void onClick(CustomTableIconButton parentBtn) {
                    ProgressTableView.this.onClickRetryButton(parentBtn);
                }
            });
            this.retryButtons.put(tableItem, button);
        }
        return button;
    }

    protected void onClickRetryButton(CustomTableIconButton parentBtn) {
        ProgressItem progressItem = (ProgressItem)((TableItem)parentBtn.getParentItem()).getData();
        parentBtn.setDisabled(true);
        Component.InstallState installState = progressItem.getComponent().getInstallState();
        if (installState == Component.InstallState.INSTALL) {
            CommonTreeView mainTreeView = ViewController.getInstance().getMainTabView().getTreeView();
            mainTreeView.onClickInstallButton(progressItem.getComponent());
        } else if (installState != Component.InstallState.UNINSTALL && installState == Component.InstallState.UPDATE) {
            ViewController.getInstance().getMainTabView().runUpdateAll();
        }
    }

    public CustomTableIconButton getFailMessageButton(Item tableItem) {
        CustomTableIconButton button = this.failMessageButtons.get(tableItem);
        if (button == null) {
            button = new CustomTableIconButton(tableItem, 1, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CAUTION_NORAML, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CAUTION_OVER, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CAUTION_SELECT, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CAUTION_NORAML);
            button.removeAllMouseClickEventListeners();
            button.addMouseClickEventListener(new CustomTableIconButton.IClickEventListener(){

                @Override
                public void onClick(CustomTableIconButton parentBtn) {
                    ProgressTableView.this.onClickFailMessageButton(parentBtn.getParentItem());
                }
            });
            this.failMessageButtons.put(tableItem, button);
        }
        return button;
    }

    public CustomTableIconButton getCancelMessageButton(Item tableItem) {
        CustomTableIconButton button = this.cancelMessageButtons.get(tableItem);
        if (button == null) {
            button = new CustomTableIconButton(tableItem, 1, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CAUTION_NORAML, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CAUTION_OVER, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CAUTION_SELECT, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_CAUTION_NORAML);
            button.removeAllMouseClickEventListeners();
            button.addMouseClickEventListener(new CustomTableIconButton.IClickEventListener(){

                @Override
                public void onClick(CustomTableIconButton parentBtn) {
                    ProgressTableView.this.onClickFailMessageButton(parentBtn.getParentItem());
                }
            });
            this.cancelMessageButtons.put(tableItem, button);
        }
        return button;
    }

    private void onClickFailMessageButton(Item tableItem) {
        Component component = ((ProgressItem)((TableItem)tableItem).getData()).getComponent();
        InsideTroubleShootingDialog.open(this.getShell(), component.getError(), component.getProgressLogs());
    }

    public void refreshTableItem(ProgressItem progressItem) {
        this.tableViewer.refresh(progressItem);
    }

    public void refreshTableItem(TableItem tableItem) {
        this.tableViewer.refresh(tableItem.getData());
    }

    public void setItemInstalled(TableItem tableItem) {
        this.tableViewer.refresh(tableItem.getData());
    }

    public void setItemUninstalled(TableItem tableItem) {
        this.tableViewer.refresh(tableItem.getData());
    }

    public void setItemCanceled(TableItem tableItem) {
        this.tableViewer.refresh(tableItem.getData());
    }

    public void setItemFailed(TableItem tableItem) {
        this.tableViewer.refresh(tableItem.getData());
    }

    public void setItemProgress(TableItem tableItem) {
        this.tableViewer.refresh(tableItem.getData());
    }

    public TableItem addNewTableItem(Component component) {
        ProgressItem progressItem = null;
        for (ProgressItem item : this.progressItems) {
            if (item.getComponent() == component) {
                progressItem = item;
                break;
            }
            if (!item.getComponent().equals(component)) continue;
            progressItem = item;
            break;
        }
        if (progressItem == null) {
            progressItem = new ProgressItem(component);
            this.progressItems.add(progressItem);
        } else {
            if (progressItem.getComponent() != component) {
                progressItem.setComponent(component);
            }
            progressItem.setWorkingState(ProgressItem.WorkType.NONE);
            progressItem.setCancelable(true);
            progressItem.setProgress(0);
            progressItem.setActive(true);
        }
        Collections.sort(this.progressItems, new ItemComparator());
        this.tableViewer.setInput(this.progressItems);
        return this.getTableItemByComponent(component);
    }

    public void setAllProgressItemsInactive() {
        for (ProgressItem item : this.progressItems) {
            item.setActive(false);
        }
        this.tableViewer.refresh();
    }

    public class ItemComparator
    implements Comparator<ProgressItem> {
        @Override
        public int compare(ProgressItem p1, ProgressItem p2) {
            if (p1.getWorkType().ordinal() > p2.getWorkType().ordinal()) {
                return 1;
            }
            if (p1.getWorkType().ordinal() == p2.getWorkType().ordinal()) {
                return 0;
            }
            return -1;
        }
    }
}

