/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.custom;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class CustomCheckBoxButton
extends Canvas {
    private boolean checked = false;
    private boolean enabled = true;
    private Image checkedImage;
    private Image unCheckedImage;
    private Image checkedDisImage;
    private Image unCheckedDisImage;
    private final CustomCheckBoxButton button = this;
    private String label;
    private int gap = 0;
    private Font font;
    private Color color;
    private Color bgColor;
    private Color disColor;
    private Color selColor;
    private Font boldFont;
    private boolean isReverse;

    public CustomCheckBoxButton(Composite parent, int style, boolean isChecked, Image checkImg, Image unCheckImage) {
        super(parent, style);
        this.checked = isChecked;
        this.enabled = true;
        this.checkedImage = checkImg;
        this.unCheckedImage = unCheckImage;
        this.checkedDisImage = checkImg;
        this.unCheckedDisImage = unCheckImage;
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                Image curImage = null;
                curImage = CustomCheckBoxButton.this.checked ? CustomCheckBoxButton.this.checkedImage : CustomCheckBoxButton.this.unCheckedImage;
                e.gc.drawImage(curImage, 0, 0);
                CustomCheckBoxButton.this.button.setSize(curImage.getBounds().width, curImage.getBounds().height);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                CustomCheckBoxButton.this.checked = !CustomCheckBoxButton.this.checked;
                CustomCheckBoxButton.this.redraw();
                super.mouseUp(e);
            }
        });
    }

    public CustomCheckBoxButton(Composite parent, int style, boolean isChecked, Image checkImg, Image unCheckImage, String labelStr, int aGap, Font aFont, Color aColor, Color aBgColor) {
        super(parent, style);
        this.drawCheckbox(parent, style, isChecked, checkImg, unCheckImage, labelStr, aGap, aFont, aColor, aBgColor, false);
    }

    public CustomCheckBoxButton(Composite parent, int style, boolean isChecked, Image checkImg, Image unCheckImage, String labelStr, int aGap, Font aFont, Color aColor, Color aBgColor, boolean isReverse) {
        super(parent, style);
        this.drawCheckbox(parent, style, isChecked, checkImg, unCheckImage, labelStr, aGap, aFont, aColor, aBgColor, isReverse);
    }

    public void drawCheckbox(Composite parent, int style, boolean isChecked, Image checkImg, Image unCheckImage, String labelStr, int aGap, Font aFont, Color aColor, Color aBgColor, boolean aReverse) {
        this.checked = isChecked;
        this.checkedImage = checkImg;
        this.unCheckedImage = unCheckImage;
        this.checkedDisImage = checkImg;
        this.unCheckedDisImage = unCheckImage;
        this.label = labelStr;
        this.gap = aGap;
        this.font = aFont;
        this.color = aColor;
        this.disColor = aColor;
        this.selColor = aColor;
        this.bgColor = aBgColor;
        this.isReverse = aReverse;
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                Color fColor;
                Image curImage = null;
                if (CustomCheckBoxButton.this.enabled) {
                    if (CustomCheckBoxButton.this.checked) {
                        fColor = CustomCheckBoxButton.this.selColor;
                        curImage = CustomCheckBoxButton.this.checkedImage;
                        if (CustomCheckBoxButton.this.boldFont != null) {
                            e.gc.setFont(CustomCheckBoxButton.this.boldFont);
                        } else {
                            e.gc.setFont(CustomCheckBoxButton.this.font);
                        }
                    } else {
                        fColor = CustomCheckBoxButton.this.color;
                        curImage = CustomCheckBoxButton.this.unCheckedImage;
                        e.gc.setFont(CustomCheckBoxButton.this.font);
                    }
                } else {
                    fColor = CustomCheckBoxButton.this.disColor;
                    if (CustomCheckBoxButton.this.checked) {
                        curImage = CustomCheckBoxButton.this.checkedDisImage;
                        if (CustomCheckBoxButton.this.boldFont != null) {
                            e.gc.setFont(CustomCheckBoxButton.this.boldFont);
                        } else {
                            e.gc.setFont(CustomCheckBoxButton.this.font);
                        }
                    } else {
                        curImage = CustomCheckBoxButton.this.unCheckedDisImage;
                        e.gc.setFont(CustomCheckBoxButton.this.font);
                    }
                }
                e.gc.setForeground(fColor);
                Point size = e.gc.textExtent(CustomCheckBoxButton.this.label);
                int y = (curImage.getBounds().height - size.y) / 2;
                int n = y = y < 0 ? 0 : y;
                if (CustomCheckBoxButton.this.isReverse) {
                    e.gc.drawText(CustomCheckBoxButton.this.label, 0, y, 1);
                    e.gc.drawImage(curImage, size.x + CustomCheckBoxButton.this.gap, 0);
                } else {
                    e.gc.drawImage(curImage, 0, 0);
                    e.gc.drawText(CustomCheckBoxButton.this.label, curImage.getBounds().width + CustomCheckBoxButton.this.gap, y, 1);
                }
                int bigY = size.y > curImage.getBounds().height ? size.y : curImage.getBounds().height;
                CustomCheckBoxButton.this.button.setSize(curImage.getBounds().width + size.x + CustomCheckBoxButton.this.gap, bigY);
                CustomCheckBoxButton.this.button.setBackground(CustomCheckBoxButton.this.bgColor);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                if (CustomCheckBoxButton.this.enabled) {
                    CustomCheckBoxButton.this.checked = !CustomCheckBoxButton.this.checked;
                    CustomCheckBoxButton.this.redraw();
                }
                super.mouseUp(e);
            }
        });
    }

    public void setDisableImage(Image checkedDisImage, Image unCheckedDisImage) {
        this.checkedDisImage = checkedDisImage;
        this.unCheckedDisImage = unCheckedDisImage;
    }

    public void setDisableColor(Color disColor) {
        this.disColor = disColor;
    }

    public void setSelectedColor(Color selColor) {
        this.selColor = selColor;
    }

    public boolean getSelection() {
        return this.checked;
    }

    public void setSelection(boolean isChecked) {
        if (this.enabled) {
            this.checked = isChecked;
            this.redraw();
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean isEnable) {
        this.enabled = isEnable;
        this.redraw();
    }

    public void setBoldFont(Font font) {
        this.boldFont = font;
    }
}

