/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.util;

import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class CircularGroupAnimationGraph
extends Composite {
    public static final int TYPE_PERCENT = 0;
    public static final int TYPE_CUSTOM = 1;
    public static final int TYPE_ROTATE = 21;
    private Canvas canvas;
    private Label label;
    private Label emptyLabel;
    private Font valueFont = this.getShell().getDisplay().getSystemFont();
    private Font measureFont = this.getShell().getDisplay().getSystemFont();
    private long max = 100L;
    private long value = 0L;
    public Color COLOR_LIGHT_BLUE = new Color(null, new RGB(131, 196, 218));
    public Color COLOR_LIGHT_GRAY = new Color(null, new RGB(189, 189, 189));
    public Color COLOR_WHITE = new Color(null, new RGB(255, 255, 255));
    private Color graphColor = this.COLOR_LIGHT_BLUE;
    private Color centerColor = this.COLOR_WHITE;
    private Color textColor = this.COLOR_LIGHT_BLUE;
    private String measure;
    private int type = 0;
    private Image centerImage;
    private Image progressRotate;
    private Image backgorundImage;
    private List<Image> groupImages;
    private int centerSize;
    int currentCount = 0;
    private PaintListener paintListener = new PaintListener(){

        @Override
        public void paintControl(PaintEvent e) {
            Rectangle rect = CircularGroupAnimationGraph.this.canvas.getBounds();
            int x = rect.x;
            int y = rect.y;
            int width = rect.width;
            int height = rect.height;
            e.gc.setAntialias(1);
            if (CircularGroupAnimationGraph.this.type == 21) {
                if (CircularGroupAnimationGraph.this.groupImages == null && CircularGroupAnimationGraph.this.groupImages.isEmpty()) {
                    Transform prevTransform = new Transform(e.display);
                    e.gc.getTransform(prevTransform);
                    Transform transform = new Transform(CircularGroupAnimationGraph.this.canvas.getDisplay());
                    transform.translate(x + width / 2, y + height / 2);
                    transform.rotate(CircularGroupAnimationGraph.this.value);
                    transform.translate(-x - width / 2, -y - height / 2);
                    e.gc.setTransform(transform);
                    e.gc.drawImage(CircularGroupAnimationGraph.this.progressRotate, x, y);
                    e.gc.setTransform(prevTransform);
                    prevTransform.dispose();
                    transform.dispose();
                } else {
                    int n;
                    List list = CircularGroupAnimationGraph.this.groupImages;
                    if (CircularGroupAnimationGraph.this.currentCount <= CircularGroupAnimationGraph.this.groupImages.size() - 1) {
                        int n2 = CircularGroupAnimationGraph.this.currentCount;
                        n = n2;
                        CircularGroupAnimationGraph.this.currentCount = n2 + 1;
                    } else {
                        n = CircularGroupAnimationGraph.this.currentCount = 0;
                    }
                    CircularGroupAnimationGraph.this.progressRotate = (Image)list.get(n);
                    e.gc.drawImage(CircularGroupAnimationGraph.this.progressRotate, x, y);
                }
            } else {
                e.gc.drawImage(CircularGroupAnimationGraph.this.backgorundImage, x, y);
            }
            e.gc.setBackground(CircularGroupAnimationGraph.this.centerColor);
            e.gc.fillOval(x + width / 2 - CircularGroupAnimationGraph.this.centerSize / 2, y + height / 2 - CircularGroupAnimationGraph.this.centerSize / 2, CircularGroupAnimationGraph.this.centerSize, CircularGroupAnimationGraph.this.centerSize);
            if (CircularGroupAnimationGraph.this.type == 0) {
                this.drawCenterPercent(e, rect, height);
            } else {
                this.drawCenterImage(e, width);
            }
        }

        private void drawCenterImage(PaintEvent e, int width) {
            e.gc.drawImage(CircularGroupAnimationGraph.this.centerImage, width / 2 - ((CircularGroupAnimationGraph)CircularGroupAnimationGraph.this).centerImage.getBounds().width / 2, width / 2 - ((CircularGroupAnimationGraph)CircularGroupAnimationGraph.this).centerImage.getBounds().height / 2);
        }

        private void drawCenterPercent(PaintEvent e, Rectangle rect, int height) {
            String centerText = CircularGroupAnimationGraph.this.getCenterText();
            e.gc.setFont(CircularGroupAnimationGraph.this.valueFont);
            Point textSize = e.gc.textExtent(centerText, 8);
            e.gc.setFont(CircularGroupAnimationGraph.this.measureFont);
            Point measureSize = e.gc.textExtent(CircularGroupAnimationGraph.this.measure, 8);
            int posX = rect.width / 2 - (textSize.x + measureSize.x) / 2;
            e.gc.setFont(CircularGroupAnimationGraph.this.valueFont);
            e.gc.setForeground(CircularGroupAnimationGraph.this.graphColor);
            e.gc.drawText(centerText, posX, height / 2 - textSize.y / 2, true);
            e.gc.setFont(CircularGroupAnimationGraph.this.measureFont);
            e.gc.setForeground(CircularGroupAnimationGraph.this.graphColor);
            e.gc.drawText(CircularGroupAnimationGraph.this.measure, posX + textSize.x, height / 2 - textSize.y / 2 + measureSize.y / 2, true);
        }
    };

    public CircularGroupAnimationGraph(Composite parent, int style, int type, Rectangle point, int centerSize) {
        super(parent, style);
        this.setLayout(new FormLayout());
        this.type = type;
        this.measure = type == 0 ? "%" : "";
        this.centerSize = centerSize;
        this.canvas = new Canvas(this, 0x20000000);
        this.canvas.addPaintListener(this.paintListener);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.height = point.height;
        data.width = point.width;
        this.canvas.setLayoutData(data);
    }

    public void setMax(long max) {
        this.max = max;
        this.canvas.redraw();
    }

    public void update(long max, long value) {
        this.max = max;
        this.value = value;
        this.canvas.redraw();
        this.canvas.update();
    }

    public void update(long value) {
        this.value = value;
        this.canvas.redraw();
    }

    public void setText(String text) {
        this.label.setForeground(this.textColor);
        this.label.setText(text);
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
    }

    public void setValueFont(Font font) {
        this.valueFont = font;
    }

    public void setMeasureFont(Font font) {
        this.measureFont = font;
    }

    public void setLabelBg(Color color) {
        this.label.setBackground(color);
        this.emptyLabel.setBackground(color);
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    private String getCenterText() {
        String str = null;
        if (this.type == 0) {
            int percent = (int)((float)this.value / (float)this.max * 100.0f);
            str = Integer.toString(percent);
        } else if (this.value >= 1024L) {
            double dValue = (double)this.value / 1024.0;
            if (dValue >= 1048576.0) {
                dValue = dValue / 1024.0 * 1024.0;
                this.setMeasure("GB");
            } else if (dValue >= 1024.0) {
                dValue /= 1024.0;
                this.setMeasure("MB");
            } else {
                this.setMeasure("KB");
            }
            str = CircularGroupAnimationGraph.toDoubleFormat1(Double.toString(dValue));
        } else {
            str = Long.toString(this.value);
        }
        return str;
    }

    public void setMeasure(String m) {
        this.measure = m;
    }

    public void setGraphColor(Color color) {
        this.graphColor = color;
    }

    public void setCenterColor(Color color) {
        this.centerColor = color;
    }

    public void setCanvasColor(Color color) {
        this.canvas.setBackground(color);
    }

    public void setCenterImage(Image image) {
        this.centerImage = image;
    }

    public void setProgressImage(Image image) {
        this.progressRotate = image;
    }

    public void setProgressGroupImage(List<Image> list) {
        this.groupImages = list;
    }

    @Override
    public void setBackgroundImage(Image image) {
        this.backgorundImage = image;
    }

    public static String toDoubleFormat1(String value) {
        if (null == value || value.isEmpty()) {
            return null;
        }
        try {
            double data = Double.parseDouble(value);
            return String.format("%.1f", data);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return value;
        }
    }
}

