/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core;

import org.tizen.manager.core.config.Config;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;

public class ManagerConstants {
    public static final String MANAGER_JAR_FILE_NAME = "PackageManager.jar";
    public static final String MANAGER_BINARY_PREFIX = "package-manager";
    public static final String MANAGERV2_JAR_FILE_NAME = "PackageManagerV2.jar";
    private static final String MANAGER_EXECUTALBE_FILE_NAME_FOR_LINUX = "package-manager.bin";
    private static final String MANAGER_EXECUTALBE_FILE_NAME_FOR_WINDOWS = "package-manager.exe";
    private static final String MANAGER_EXECUTALBE_DIR_NAME_FOR_MAC = "package-manager.app";
    public static final String MANAGER_BINARY_NAME = ManagerConstants.getInstallManagerBinaryName();
    public static final String MANAGER_DIRECTORY_NAME = "package-manager";
    public static final String WINDOWS_DEFAULT_DATA_PATH = "C:\\tizen-studio-data";
    private static final String SDK_DATA_DIR_NAME = "tizen-studio-data";
    public static final String MANAGER_TITLE = "Package Manager";
    public static final String SDK_PATCH_SCRIPT = ManagerConstants.getPatchScript();
    private static final String SDK_TEST_DIR_NAME = "test";

    private static String getInstallManagerBinaryName() {
        if (PlatformUtil.isLinux()) {
            return MANAGER_EXECUTALBE_FILE_NAME_FOR_LINUX;
        }
        if (PlatformUtil.isWindows()) {
            return MANAGER_EXECUTALBE_FILE_NAME_FOR_WINDOWS;
        }
        if (PlatformUtil.isMacOS()) {
            return MANAGER_EXECUTALBE_DIR_NAME_FOR_MAC;
        }
        return MANAGER_EXECUTALBE_FILE_NAME_FOR_LINUX;
    }

    static String getInstallManagerTestResultPath() {
        return PathUtil.get(ManagerConstants.getSDKDataPath(), SDK_TEST_DIR_NAME, "package-manager");
    }

    private static String getSDKDataPath() {
        if (Config.getInstance().getSdkDataDir().equalsIgnoreCase("")) {
            if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
                return PathUtil.getFromHome(SDK_DATA_DIR_NAME);
            }
            if (PlatformUtil.isWindows()) {
                return WINDOWS_DEFAULT_DATA_PATH;
            }
            return PathUtil.getFromHome(SDK_DATA_DIR_NAME);
        }
        return Config.getInstance().getSdkDataDir();
    }

    private static String getPatchScript() {
        if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
            return "patch.sh";
        }
        if (PlatformUtil.isWindows()) {
            return "patch.bat";
        }
        return "patch.sh";
    }
}

