/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.model.ImageFileInfo;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.configuration.InstallOptionConfigView;
import org.tizen.packagemanager.ui.configuration.ProxyConfigView;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class ConfigurationDialog
extends Dialog {
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private static final Logger logger = Log.getLogger(ConfigurationDialog.class);
    private int buttonBarHeight;
    private List<Composite> viewLists = new ArrayList<Composite>();
    private StackLayout stackLayout;
    private VIEWS currentTabView = VIEWS.INSTALL_OPTION;
    private Composite tab1;
    private Composite tab2;
    private Shell thisShell;
    private Composite menuComposite;
    private Composite bottomComposite;
    private Composite customComposite;
    private InstallOptionConfigView instOptionView;
    private boolean isServerChanged = false;
    private String selectedRepository = "";
    private String selectedDistribution = "";
    private String selectedSnapshotPath = "";
    private boolean isAutoUpdate = true;
    private Config.ServerType selectedServerType = null;
    private boolean isUninstallationNeeded = false;
    private boolean isRefreshNeeded = false;
    private boolean checkExtRepository = false;
    private boolean confirmed = false;
    private String originRepo = "";
    private String distributionId = "";
    private boolean isFileDialogOpened = false;
    private Label labelError;
    private Button btnConfirm;
    private Button btnCancel;
    private Button btnProxySettings;
    private ConfigurationDialog thisDialog = this;

    public boolean isServerChanged() {
        return this.isServerChanged;
    }

    public void setServerChanged(boolean isServerChanged) {
        this.isServerChanged = isServerChanged;
    }

    public String getSelectedRepository() {
        return this.selectedRepository;
    }

    public void setSelectedRepository(String selectedRepository) {
        this.selectedRepository = selectedRepository;
    }

    public String getSelectedDistribution() {
        return this.selectedDistribution;
    }

    public void setSelectedDistribution(String selectedDistribution) {
        this.selectedDistribution = selectedDistribution;
    }

    public String getSelectedSnapshotPath() {
        return this.selectedSnapshotPath;
    }

    public void setSelectedSnapshotPath(String selectedSnapshotPath) {
        this.selectedSnapshotPath = selectedSnapshotPath;
    }

    public boolean isAutoUpdate() {
        return this.isAutoUpdate;
    }

    public void setAutoUpdate(boolean val) {
        this.isAutoUpdate = val;
    }

    public Config.ServerType getSelectedServerType() {
        return this.selectedServerType;
    }

    public void setSelectedServerType(Config.ServerType selectedServerType) {
        this.selectedServerType = selectedServerType;
    }

    public boolean isUninstallationNeeded() {
        return this.isUninstallationNeeded;
    }

    void setUninstallation() {
        this.isUninstallationNeeded = true;
    }

    public boolean isRefreshNeeded() {
        return this.isRefreshNeeded;
    }

    public void setRefreshNeeded(boolean val) {
        this.isRefreshNeeded = val;
    }

    public boolean isCheckExtRepositoryNeeded() {
        return this.checkExtRepository;
    }

    public void setCheckExtRepository(boolean val) {
        this.checkExtRepository = val;
    }

    public ConfigurationDialog(Shell parent) {
        super(parent);
        this.setShellStyle(67680);
        parent.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
    }

    @Override
    protected Point getInitialSize() {
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_DIALOG_SIZE);
        return new Point(rect.width, rect.height + this.buttonBarHeight);
    }

    @Override
    protected void configureShell(Shell newShell) {
        newShell.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        newShell.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        newShell.setText(this.uiRsrcHandler.getStringFromResource(WizardUIResourceHandler.UITerms.CONFIGURATION_DIALOG_TITLE));
        this.thisShell = newShell;
        newShell.addListener(21, new Listener(){

            @Override
            public void handleEvent(Event event) {
                ConfigurationDialog.this.instOptionView.onClickCancel();
            }
        });
        super.configureShell(newShell);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
    }

    @Override
    protected void okPressed() {
        this.confirmed = true;
        if (this.instOptionView.getImageFilePath() != null && !this.instOptionView.getImageFilePath().isEmpty()) {
            Config.getInstance().setImageFileInfo(new ImageFileInfo(this.instOptionView.getImageFilePath(), this.instOptionView.getImgInfo()));
        }
        super.okPressed();
    }

    @Override
    protected void cancelPressed() {
        this.confirmed = false;
        super.cancelPressed();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.buttonBarHeight += parent.getShell().getBounds().height - (parent.getShell().getClientArea().height - parent.getShell().getBorderWidth());
        FormLayout formLayout = new FormLayout();
        formLayout.marginTop = 0;
        formLayout.marginRight = 0;
        formLayout.marginLeft = 0;
        formLayout.marginBottom = 0;
        container.setLayout(formLayout);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.setBottomComposite(container);
        this.setTabComposite(container);
        this.initDisplayView();
        return container;
    }

    private void setTabComposite(Composite container) {
        Composite tablComposite = new Composite(container, 0);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_TAB_AREA);
        FormData formData = new FormData();
        formData.left = new FormAttachment(container, rect.x);
        formData.top = new FormAttachment(container, rect.y);
        formData.width = rect.width;
        formData.height = rect.height;
        tablComposite.setLayoutData(formData);
        FormLayout formLayout = new FormLayout();
        formLayout.marginTop = 0;
        formLayout.marginRight = 0;
        formLayout.marginLeft = 0;
        formLayout.marginBottom = 0;
        tablComposite.setLayout(formLayout);
        tablComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.setCustomComposite(tablComposite);
    }

    private void setMenuComposite(Composite container) {
        this.menuComposite = new Composite(container, 0);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_MENU_AREA);
        FormData formData = new FormData();
        formData.left = new FormAttachment(container, 0);
        formData.top = new FormAttachment(container, 0);
        formData.width = rect.width;
        formData.height = rect.height;
        this.menuComposite.setLayoutData(formData);
        this.menuComposite.setLayout(new FormLayout());
        Rectangle tab1ButtonSize = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_TAB_INSTALL_OPTION_BUTTON);
        Rectangle tab2ButtonSize = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_TAB_NETWORK_OPTION_BUTTON);
        this.tab1 = new Composite(this.menuComposite, 8);
        this.createTabButton(this.menuComposite, tab1ButtonSize, this.tab1);
        this.tab2 = new Composite(this.menuComposite, 8);
        this.createTabButton(this.menuComposite, tab2ButtonSize, this.tab2);
        this.createTabEventListener(this.tab1, VIEWS.INSTALL_OPTION, tab1ButtonSize, "Install Option");
        this.createTabEventListener(this.tab2, VIEWS.NETWORK_OPTION, tab2ButtonSize, "Network Option");
    }

    private void createTabButton(Composite tabViewArea, Rectangle tabButtonSize, Composite tab1) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(tabViewArea, tabButtonSize.x, 0x1000000);
        formData.top = new FormAttachment(tabViewArea, tabButtonSize.y, 0x1000000);
        formData.width = tabButtonSize.width;
        formData.height = tabButtonSize.height;
        tab1.setLayoutData(formData);
        tab1.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
    }

    private void drawTabButton(Rectangle tabButtonBounds, VIEWS target, PaintEvent arg0, String textValue) {
        Image bufferedImage = new Image((Device)arg0.display, new Rectangle(0, 0, tabButtonBounds.width, tabButtonBounds.height));
        GC gc = new GC(bufferedImage);
        gc.setAntialias(1);
        if (this.currentTabView == target) {
            gc.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE));
            gc.drawLine(0, tabButtonBounds.height - 2, tabButtonBounds.width, tabButtonBounds.height - 2);
            gc.drawLine(0, tabButtonBounds.height - 1, tabButtonBounds.width, tabButtonBounds.height - 1);
            gc.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        } else {
            gc.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_46));
            gc.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        }
        Point textExtent = gc.textExtent(textValue);
        int textX = tabButtonBounds.width / 2 - textExtent.x / 2;
        int textY = tabButtonBounds.height / 2 - textExtent.y / 2;
        gc.drawText(textValue, textX, textY);
        arg0.gc.drawImage(bufferedImage, 0, 0);
        gc.dispose();
    }

    private void initDisplayView() {
        this.setSelectionButtons(ConfStatus.INSTALL_OPTION);
        this.enableViews(VIEWS.INSTALL_OPTION);
    }

    private void createTabEventListener(Composite tab, final VIEWS selectedValue, final Rectangle tabButtonSize, final String title) {
        tab.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                ConfigurationDialog.this.currentTabView = selectedValue;
                ConfigurationDialog.this.tab1.redraw();
                ConfigurationDialog.this.tab2.redraw();
                ConfigurationDialog.this.enableViews(selectedValue);
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        tab.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent arg0) {
                ConfigurationDialog.this.drawTabButton(tabButtonSize, selectedValue, arg0, title);
            }
        });
    }

    private void setCustomComposite(Composite container) {
        this.customComposite = new Composite(container, 0);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_CUSTOM_AREA);
        FormData formData = new FormData();
        formData.left = new FormAttachment(container, PlatformUtil.isWindows() ? rect.x : rect.x + 4);
        formData.top = new FormAttachment(container, rect.y);
        formData.width = rect.width - 4;
        formData.height = rect.height;
        this.customComposite.setLayoutData(formData);
        this.customComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.customComposite.setLayout(this.stackLayout);
        this.instOptionView = new InstallOptionConfigView(this.customComposite, this.uiRsrcHandler, this);
        this.viewLists.add(this.instOptionView);
    }

    private void setBottomComposite(Composite container) {
        this.bottomComposite = new Composite(container, 0);
        final Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_BOTTOM_AREA);
        FormData formData = new FormData();
        formData.left = new FormAttachment(container, 0);
        formData.top = new FormAttachment(container, rect.y);
        formData.width = rect.width;
        formData.height = rect.height;
        this.bottomComposite.setLayoutData(formData);
        this.bottomComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.bottomComposite.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ConfigurationDialog.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
                e.gc.drawLine(0, 0, rect.width, 0);
            }
        });
        this.setBottomButton(this.bottomComposite);
    }

    private void setBottomButton(Composite container) {
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        gridLayout.marginWidth = 0;
        container.setLayout(gridLayout);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_BUTTON_SIZE);
        this.btnProxySettings = new Button(container, 8);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.heightHint = rect.height;
        gd.widthHint = rect.width + 30;
        this.btnProxySettings.setLayoutData(gd);
        this.btnProxySettings.setText("Proxy Settings");
        this.btnProxySettings.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.btnProxySettings.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.btnProxySettings.addSelectionListener(new SelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ProxyConfigView proxyview = new ProxyConfigView(ConfigurationDialog.this.thisShell, ConfigurationDialog.this.thisDialog);
                ConfigurationDialog.this.thisShell.setEnabled(false);
                try {
                    proxyview.open();
                }
                catch (Exception e) {
                    logger.throwing(e);
                }
                finally {
                    if (!ConfigurationDialog.this.thisShell.isDisposed()) {
                        ConfigurationDialog.this.thisShell.setEnabled(true);
                    }
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label dummy = new Label(container, 64);
        gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = rect.x;
        gd.verticalIndent = 3;
        FormData parentForm = (FormData)container.getLayoutData();
        gd.heightHint = parentForm.height;
        dummy.setLayoutData(gd);
        dummy.setText("");
        dummy.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
        dummy.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE));
        dummy.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.btnConfirm = new Button(container, 8);
        gd = new GridData(4, 0x1000000, false, false);
        gd.heightHint = rect.height;
        gd.widthHint = rect.width;
        this.btnConfirm.setLayoutData(gd);
        this.btnConfirm.setText("OK");
        this.btnConfirm.setFocus();
        this.btnConfirm.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.btnConfirm.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.btnConfirm.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ConfigurationDialog.this.instOptionView.onClickConfirm();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.btnCancel = new Button(container, 8);
        gd = new GridData(4, 0x1000000, false, false);
        gd.heightHint = rect.height;
        gd.widthHint = rect.width;
        this.btnCancel.setLayoutData(gd);
        this.btnCancel.setText("Cancel");
        this.btnCancel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.btnCancel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.btnCancel.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ConfigurationDialog.this.instOptionView.onClickCancel();
                ConfigurationDialog.this.cancelPressed();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void enableViews(VIEWS targetView) {
        logger.trace("enable view start => " + targetView.name());
        switch (targetView) {
            case INSTALL_OPTION: {
                this.enableViewAndDisableOthers(this.instOptionView);
                break;
            }
            case NETWORK_OPTION: {
                break;
            }
        }
        logger.trace("enable view end => " + targetView.name());
    }

    private void enableViewAndDisableOthers(Composite exceptView) {
        this.stackLayout.topControl = exceptView;
        for (Composite item : this.viewLists) {
            logger.trace("enableViewAndDisableOthers : " + item.getClass().getName());
            if (item.equals(exceptView)) continue;
            item.setEnabled(false);
            item.setVisible(false);
            logger.trace("enableViewAndDisableOthers (set false) : " + item.getClass().getName());
        }
        exceptView.setVisible(true);
        exceptView.setEnabled(true);
    }

    public void setSelectionButtons(ConfStatus status) {
        switch (status) {
            case INSTALL_OPTION: {
                break;
            }
            case PROXY_SETTINGS: {
                break;
            }
        }
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public String getImageFilePath() {
        return this.instOptionView.getImageFilePath();
    }

    public String getOriginRepo() {
        return this.originRepo;
    }

    public void setOriginRepo(String originRepo) {
        this.originRepo = originRepo;
    }

    public String getDistributionId() {
        return this.distributionId;
    }

    public void setDistributionId(String distributionId) {
        this.distributionId = distributionId;
    }

    public boolean isFileDialogOpened() {
        return this.isFileDialogOpened;
    }

    public void setFileDialogOpened(boolean isFileDialogOpened) {
        this.isFileDialogOpened = isFileDialogOpened;
    }

    @Override
    protected boolean canHandleShellCloseEvent() {
        if (!this.isFileDialogOpened()) {
            return super.canHandleShellCloseEvent();
        }
        return false;
    }

    public Button getConfirmButton() {
        return this.btnConfirm;
    }

    public Label getErrerLabel() {
        return this.labelError;
    }

    public void refreshInstallOption() {
        if (this.instOptionView != null && !this.instOptionView.isDisposed()) {
            this.instOptionView.refreshRepository();
        }
    }

    private static enum VIEWS {
        INSTALL_OPTION,
        NETWORK_OPTION;

    }

    private static enum ConfStatus {
        INSTALL_OPTION,
        PROXY_SETTINGS;

    }
}

