/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.api.impl;

import java.util.Map;
import org.tizen.library.sdkutils.api.ISDKPackage;
import org.tizen.library.sdkutils.api.ISDKUtils;
import org.tizen.library.sdkutils.api.impl.SDKPackage;
import org.tizen.library.sdkutils.service.ExecutorService;
import org.tizen.library.sdkutils.service.PackageService;
import org.tizen.library.sdkutils.util.SDKInfoNotFoundException;
import org.tizen.library.sdkutils.util.SDKInfoUtil;

public class SDKUtils
implements ISDKUtils {
    private static final SDKUtils INSTANCE = new SDKUtils();

    private SDKUtils() {
    }

    public static SDKUtils getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean showUpdateNotiPopup() {
        boolean result = false;
        try {
            ISDKUtils.ExecuteResult ret = ExecutorService.execute(ISDKUtils.SdkTool.NOTIFICATION_POPUP, null);
            if (ISDKUtils.ExecuteResult.SUCCESS.equals((Object)ret)) {
                result = true;
            }
        }
        catch (SDKInfoNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean isUpdatable(boolean useCache) {
        boolean result = false;
        try {
            result = PackageService.isPackageUpdatable(useCache);
        }
        catch (SDKInfoNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Map<String, ISDKPackage> getPackages(ISDKPackage.Profile profile, ISDKPackage.PlatformVersion version, ISDKPackage.Extension extensionType, ISDKPackage.SearchPackageType searchPkgType, boolean installedOnly, boolean useCache) {
        Map<String, SDKPackage> pkgMap = null;
        try {
            pkgMap = PackageService.getSDKPackageInfos(profile, version, extensionType, searchPkgType, installedOnly, useCache);
        }
        catch (SDKInfoNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pkgMap;
    }

    @Override
    public Map<String, ISDKPackage> getPackages(String packageName, boolean useCache) {
        Map<String, ISDKPackage> pkgMap = null;
        try {
            pkgMap = PackageService.getSDKPackageInfos(packageName, useCache);
        }
        catch (SDKInfoNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pkgMap;
    }

    @Override
    @Deprecated
    public boolean executePackageManager() {
        boolean result = false;
        try {
            ISDKUtils.ExecuteResult ret = ExecutorService.execute(ISDKUtils.SdkTool.PACKAGE_MANAGER, null);
            if (ISDKUtils.ExecuteResult.SUCCESS.equals((Object)ret)) {
                result = true;
            }
        }
        catch (SDKInfoNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getInstalledSDKPath() {
        String sdkPath = null;
        try {
            sdkPath = SDKInfoUtil.findSDKInstallPath(SDKUtils.class);
        }
        catch (SDKInfoNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sdkPath;
    }

    @Override
    public String getInstalledSDKDataPath() {
        String sdkDataPath = null;
        try {
            sdkDataPath = SDKInfoUtil.findSDKDataPath(SDKUtils.class);
        }
        catch (SDKInfoNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sdkDataPath;
    }

    @Override
    public ISDKUtils.ExecuteResult executeSDKTools(ISDKUtils.SdkTool tool) {
        ISDKUtils.ExecuteResult result = ISDKUtils.ExecuteResult.FAIL;
        try {
            result = ExecutorService.execute(tool, null);
        }
        catch (SDKInfoNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getSDKToolPath(ISDKUtils.SdkTool tool) {
        String result = null;
        try {
            result = ExecutorService.getSDKToolPath(tool);
        }
        catch (SDKInfoNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

