/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolTip;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.core.RepositoryManager;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.ComponentManager;
import org.tizen.manager.pkg.Package;
import org.tizen.packagemanager.ui.page.CommonTabView;
import org.tizen.packagemanager.ui.page.CommonTreeView;
import org.tizen.packagemanager.ui.page.ComponentDetailView;
import org.tizen.packagemanager.ui.page.ExtendedTreeView;
import org.tizen.packagemanager.ui.page.MainTreeView;
import org.tizen.packagemanager.ui.page.PackageManagerMainWindow;
import org.tizen.packagemanager.ui.page.TopButtonComposite;
import org.tizen.packagemanager.ui.page.ViewController;
import org.tizen.packagemanager.ui.page.custom.CustomCheckBoxButton;
import org.tizen.packagemanager.ui.page.custom.CustomImageButton;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class BaseTabView
extends CommonTabView {
    private static final String PROFILE_BUTTON_KEY = "profile_button_key";
    protected PackageManagerMainWindow mainPage;
    protected Composite topContainer;
    protected Composite titleContainer;
    protected Composite mainContainer;
    protected CommonTreeView componentTreeView;
    protected ComponentDetailView componentDetailView;
    private Composite profileButtonContainer;
    protected TopButtonComposite topButtonComposite;
    protected ToolTip toolTip;
    PackageManagerMainWindow.TabViewType viewType;
    private CustomCheckBoxButton checkViewInstalled;

    public BaseTabView(PackageManagerMainWindow mainPage, Composite parentComposite, int swtOption, ViewController pageMaster, PackageManagerMainWindow.TabViewType tabViewType) {
        super(parentComposite, swtOption, mainPage);
        this.mainPage = mainPage;
        this.viewType = tabViewType;
        this.toolTip = new ToolTip(this.getShell(), 2048);
        this.toolTip.setAutoHide(false);
        this.setDefaultLayout();
        this.createTopComposites();
        this.createMainComposites();
        this.createBottomComposites();
        this.createTreeViewComposite();
        this.createTopItems();
        this.componentTreeView.showInstalledComponents(false);
        this.componentTreeView.removeExtraComponents();
    }

    private void setDefaultLayout() {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout(gridLayout);
        this.setBackground(this.uiRsrcHandler.getBackGroundColor());
    }

    private void createTopComposites() {
        Rectangle topBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TAB_VIEW_TOP);
        this.topContainer = new Composite(this, 0);
        GridData gridData = new GridData(topBounds.width, topBounds.height);
        this.topContainer.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        this.topContainer.setLayout(gridLayout);
        this.topContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
    }

    private void craetTitleComposites(Composite parent) {
        int TOTAL_SIZE = this.uiRsrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_VIEW_WIDTH);
        int SCROLL_SIZE = this.uiRsrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_SCROLLBAR_WIDTH);
        int COL_LICENSE_WIDTH = this.uiRsrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_COLUMN_LICENSE_WIDTH);
        int COL_UPDATABLE_WIDTH = this.uiRsrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_COLUMN_UPDATABLE_WIDTH);
        int COL_ACTION_STATUS_WIDTH = this.uiRsrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_COLUMN_ACTION_STATUS_WIDTH);
        int COL_ACTION_BUTTON_WIDTH = this.uiRsrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_COLUMN_ACTION_BUTTON_WIDTH);
        this.titleContainer = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.heightHint = 29;
        gridData.widthHint = TOTAL_SIZE;
        this.titleContainer.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(9, false);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.titleContainer.setLayout(gridLayout);
        this.titleContainer.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.titleContainer.setBackgroundMode(1);
        int SWT_OPTION = 0x1000000;
        Label dummy = new Label(this.titleContainer, SWT_OPTION);
        Label dummy1 = new Label(this.titleContainer, 0);
        Label license = new Label(this.titleContainer, SWT_OPTION);
        Label dummy2 = new Label(this.titleContainer, 0);
        Label updatable = new Label(this.titleContainer, SWT_OPTION);
        Label dummy3 = new Label(this.titleContainer, 0);
        Label status = new Label(this.titleContainer, SWT_OPTION);
        Label dummy4 = new Label(this.titleContainer, 0);
        Label action = new Label(this.titleContainer, SWT_OPTION);
        dummy1.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_222));
        dummy2.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_222));
        dummy3.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_222));
        dummy4.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_222));
        license.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        updatable.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        status.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        action.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        license.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_66));
        updatable.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_66));
        status.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_66));
        action.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_66));
        license.setText("License");
        updatable.setText("Update");
        status.setText("Status");
        action.setText("Action");
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = TOTAL_SIZE - SCROLL_SIZE - COL_LICENSE_WIDTH - COL_UPDATABLE_WIDTH - COL_ACTION_BUTTON_WIDTH - COL_ACTION_STATUS_WIDTH;
        dummy.setLayoutData(gd);
        gd = new GridData();
        gd.widthHint = 1;
        dummy1.setLayoutData(gd);
        gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = COL_LICENSE_WIDTH - 1;
        license.setLayoutData(gd);
        gd = new GridData();
        gd.widthHint = 1;
        dummy2.setLayoutData(gd);
        gd = new GridData();
        gd.widthHint = COL_UPDATABLE_WIDTH - 1;
        gd.grabExcessVerticalSpace = true;
        updatable.setLayoutData(gd);
        gd = new GridData();
        gd.widthHint = 1;
        dummy3.setLayoutData(gd);
        gd = new GridData();
        gd.widthHint = COL_ACTION_STATUS_WIDTH - 1;
        gd.grabExcessVerticalSpace = true;
        status.setLayoutData(gd);
        gd = new GridData();
        gd.widthHint = 1;
        dummy4.setLayoutData(gd);
        gd = new GridData();
        gd.widthHint = COL_ACTION_BUTTON_WIDTH - 1;
        gd.grabExcessVerticalSpace = true;
        action.setLayoutData(gd);
    }

    private void createMainComposites() {
        Rectangle mainBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TAB_VIEW_MAIN);
        Rectangle mainMargin = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_MARGIN_TAB_VIEW_MAIN);
        int TOTAL_SIZE = this.uiRsrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_VIEW_WIDTH);
        Composite baseContainer = new Composite(this, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = TOTAL_SIZE;
        gridData.heightHint = mainBounds.height;
        gridData.horizontalIndent = mainMargin.width;
        baseContainer.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        baseContainer.setLayout(gridLayout);
        baseContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.craetTitleComposites(baseContainer);
        this.mainContainer = new Composite(baseContainer, 0);
        gridData = new GridData();
        gridData.widthHint = TOTAL_SIZE;
        gridData.heightHint = mainBounds.height - 29;
        this.mainContainer.setLayoutData(gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mainContainer.setLayout(gridLayout);
        this.mainContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
    }

    private void createBottomComposites() {
        Rectangle bottomBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TAB_VIEW_BOTTOM);
        Rectangle bottomMargin = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_MARGIN_TAB_VIEW_BOTTOM);
        Composite viewContainer = new Composite(this, 2048);
        GridData gridData = new GridData();
        gridData.heightHint = bottomBounds.height;
        gridData.widthHint = bottomBounds.width;
        gridData.horizontalIndent = bottomMargin.width;
        gridData.verticalIndent = bottomMargin.x;
        viewContainer.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        viewContainer.setLayout(gridLayout);
        viewContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.componentDetailView = new ComponentDetailView(viewContainer, 0);
        GridData gd = new GridData(4, 4, true, true);
        this.componentDetailView.setLayoutData(gd);
        this.componentDetailView.setBackground(new Color(Display.getDefault(), new RGB(240, 240, 240)));
    }

    @Override
    public void reload(boolean isInit) {
        this.refresh(isInit);
        if (!RepositoryManager.getInstance().isNetworkOK()) {
            this.mainWindow.setDisconnected(true);
            RepositoryManager.getInstance().setpNetworkOK(false);
        } else {
            this.mainWindow.setDisconnected(false);
            RepositoryManager.getInstance().setpNetworkOK(true);
        }
    }

    @Override
    public void refresh(boolean isInit) {
        if (InstallController.getInstance().existsWorkingProcesses()) {
            this.mainPage.topMenuButtonSetEnable(false);
        } else {
            this.mainPage.topMenuButtonSetEnable(true);
        }
        switch (this.viewType) {
            case MAIN: {
                this.refreshProfileTypeButton();
                break;
            }
        }
        this.topButtonComposite.refreshButtonStates(!this.getUpdatableComponents().isEmpty());
        this.componentTreeView.refresh(isInit);
        if (isInit) {
            switch (this.viewType) {
                case MAIN: {
                    break;
                }
                case EXTEND: {
                    this.componentTreeView.expandFirst();
                }
            }
        }
    }

    protected void createTreeViewComposite() {
        switch (this.viewType) {
            case MAIN: {
                this.componentTreeView = new MainTreeView(this.mainContainer);
                break;
            }
            case EXTEND: {
                this.componentTreeView = new ExtendedTreeView(this.mainContainer);
                break;
            }
            default: {
                this.componentTreeView = new MainTreeView(this.mainContainer);
            }
        }
        GridData gd = new GridData(4, 4, true, true);
        this.componentTreeView.setLayoutData(gd);
        this.componentTreeView.addComponentChangeListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent evt) {
                Component selectedItem = (Component)((IStructuredSelection)evt.getSelection()).getFirstElement();
                BaseTabView.this.componentDetailView.updateComponentInformation(selectedItem);
            }
        });
    }

    private void createTopItems() {
        int leftMargin = 0;
        switch (this.viewType) {
            case MAIN: {
                leftMargin = 5;
                this.createProfileButtons(this.topContainer);
                break;
            }
        }
        this.createInstalledCheck(this.topContainer, leftMargin);
        Composite dummy = new Composite(this.topContainer, 0);
        dummy.setBackground(this.uiRsrcHandler.getBackGroundColor());
        dummy.setLayoutData(new GridData(4, 4, true, true));
        this.topButtonComposite = new TopButtonComposite(this.topContainer, this.uiRsrcHandler, this.componentTreeView);
        this.topButtonComposite.createButtons();
    }

    private void createInstalledCheck(Composite topContainer2, int leftMargin) {
        Image checkedImage = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CHECK_SEL);
        Image unCheckedImage = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CHECK_NORMAL);
        this.checkViewInstalled = new CustomCheckBoxButton(this.topContainer, 0x20004000, false, checkedImage, unCheckedImage, "View installed packages", 4, this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        GridData gd = new GridData();
        gd.heightHint = 30;
        gd.widthHint = 150;
        gd.verticalIndent = 15;
        gd.horizontalIndent = 20 - leftMargin;
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 16384;
        this.checkViewInstalled.setLayoutData(gd);
        this.checkViewInstalled.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.checkViewInstalled.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                BaseTabView.this.componentTreeView.showInstalledComponents(BaseTabView.this.checkViewInstalled.getSelection());
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    private void createProfileButtons(Composite parent) {
        Rectangle margin = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_MARGIN_DEVICE_FILTER);
        Point buttonSize = new Point(30, 30);
        this.profileButtonContainer = new Composite(parent, 0);
        this.profileButtonContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
        GridData gridData = new GridData(4, 4, false, false);
        gridData.verticalIndent = margin.y;
        gridData.horizontalIndent = margin.x;
        this.profileButtonContainer.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        this.profileButtonContainer.setLayout(gridLayout);
        CustomImageButton buttonMobile = new CustomImageButton(this.profileButtonContainer, 0);
        buttonMobile.setBackground(this.uiRsrcHandler.getBackGroundColor());
        buttonMobile.setData(PROFILE_BUTTON_KEY, (Object)Package.ProfileType.MOBILE);
        buttonMobile.setToggleButton(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_UNSEL_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_UNSEL_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_UNSEL_DIS), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_SEL_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_SEL_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_MOBILE_SEL_DIS), true);
        gridData = new GridData(4, 4, false, false);
        gridData.widthHint = buttonSize.x;
        gridData.heightHint = buttonSize.y;
        buttonMobile.setLayoutData(gridData);
        buttonMobile.removeAllChangeStateEventListeners();
        buttonMobile.addChangeStateEventListener(new CustomImageButton.IChangeStateEventListener(){

            @Override
            public void onChangeState(CustomImageButton button, boolean state) {
                BaseTabView.this.componentTreeView.showMobileComponents(state);
            }
        });
        CustomImageButton buttonWearable = new CustomImageButton(this.profileButtonContainer, 0);
        buttonWearable.setBackground(this.uiRsrcHandler.getBackGroundColor());
        buttonWearable.setData(PROFILE_BUTTON_KEY, (Object)Package.ProfileType.WEARABLE);
        buttonWearable.setToggleButton(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_UNSEL_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_UNSEL_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_UNSEL_DIS), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_SEL_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_SEL_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_WEARABLE_SEL_DIS), true);
        gridData = new GridData(4, 4, false, false);
        gridData.widthHint = buttonSize.x;
        gridData.heightHint = buttonSize.y;
        gridData.horizontalIndent = margin.width;
        buttonWearable.setLayoutData(gridData);
        buttonWearable.removeAllChangeStateEventListeners();
        buttonWearable.addChangeStateEventListener(new CustomImageButton.IChangeStateEventListener(){

            @Override
            public void onChangeState(CustomImageButton button, boolean state) {
                BaseTabView.this.componentTreeView.showWearableComponents(state);
            }
        });
        CustomImageButton buttonTV = new CustomImageButton(this.profileButtonContainer, 0);
        buttonTV.setBackground(this.uiRsrcHandler.getBackGroundColor());
        buttonTV.setData(PROFILE_BUTTON_KEY, (Object)Package.ProfileType.TV);
        buttonTV.setToggleButton(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_UNSEL_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_UNSEL_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_UNSEL_DIS), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_SEL_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_SEL_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_FILTER_ICON_TV_SEL_DIS), true);
        gridData = new GridData(4, 4, false, false);
        gridData.widthHint = buttonSize.x;
        gridData.heightHint = buttonSize.y;
        gridData.horizontalIndent = margin.width;
        buttonTV.setLayoutData(gridData);
        buttonTV.removeAllChangeStateEventListeners();
        buttonTV.addChangeStateEventListener(new CustomImageButton.IChangeStateEventListener(){

            @Override
            public void onChangeState(CustomImageButton button, boolean state) {
                BaseTabView.this.componentTreeView.showTVComponents(state);
            }
        });
    }

    protected void refreshProfileTypeButton() {
        Composite parentView = this.profileButtonContainer.getParent();
        Control[] controls = this.profileButtonContainer.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            CustomImageButton button = (CustomImageButton)controls[i];
            Package.ProfileType profileType = (Package.ProfileType)((Object)button.getData(PROFILE_BUTTON_KEY));
            boolean isExistProfileType = ComponentManager.getInstance().isExistProfileType(profileType);
            if (isExistProfileType) {
                ((GridData)button.getLayoutData()).widthHint = 35;
                button.setEnabled(true);
                continue;
            }
            ((GridData)button.getLayoutData()).widthHint = 0;
            button.setEnabled(false);
        }
        parentView.redraw();
        parentView.layout();
    }

    @Override
    public CommonTreeView getTreeView() {
        return this.componentTreeView;
    }

    protected ArrayList<Component> getUpdatableComponents() {
        ComponentManager compMgr = ComponentManager.getInstance();
        ArrayList<Component> updatableComps = new ArrayList<Component>();
        for (Component comp : compMgr.getComponentList()) {
            if (comp.hasChildren() || comp.getInstallState() != Component.InstallState.UPDATE) continue;
            updatableComps.add(comp);
        }
        return updatableComps;
    }

    @Override
    public void runUpdateAll() {
        this.topButtonComposite.updateAllClicked();
    }
}

