/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Tree;

public class TreeDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    static final int EXPAND_HYSTERESIS = 1000;
    int scrollIndex = -1;
    long scrollBeginTime;
    int expandIndex = -1;
    long expandBeginTime;

    public TreeDropTargetEffect(Tree tree) {
        super(tree);
    }

    int checkEffect(int n) {
        if ((n & 1) != 0) {
            n = n & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.expandBeginTime = 0L;
        this.expandIndex = -1;
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        Tree tree = (Tree)this.control;
        int n = tree.handle;
        OS.gtk_tree_view_set_drag_dest_row(n, 0, 0);
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
        this.expandBeginTime = 0L;
        this.expandIndex = -1;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        int[] nArray;
        int n;
        Tree tree = (Tree)this.control;
        int n2 = this.checkEffect(dropTargetEvent.feedback);
        int n3 = tree.handle;
        Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
        point = tree.toControl(point);
        int[] nArray2 = new int[1];
        OS.gtk_tree_view_get_path_at_pos(n3, point.x, point.y, nArray2, null, null, null);
        int n4 = -1;
        if (nArray2[0] != 0 && (n = OS.gtk_tree_path_get_indices(nArray2[0])) != 0) {
            int n5 = OS.gtk_tree_path_get_depth(nArray2[0]);
            nArray = new int[n5];
            OS.memmove(nArray, n, nArray.length * 4);
            n4 = nArray[nArray.length - 1];
        }
        if ((n2 & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (n4 != -1 && this.scrollIndex == n4 && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                GdkRectangle gdkRectangle = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area(n3, nArray2[0], 0, gdkRectangle);
                if (gdkRectangle.y < gdkRectangle.height) {
                    int[] nArray3 = new int[1];
                    nArray = new int[1];
                    if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
                        OS.gtk_tree_view_convert_widget_to_bin_window_coords(n3, gdkRectangle.x, gdkRectangle.y - gdkRectangle.height, nArray3, nArray);
                    } else {
                        OS.gtk_tree_view_widget_to_tree_coords(n3, gdkRectangle.x, gdkRectangle.y - gdkRectangle.height, nArray3, nArray);
                    }
                    OS.gtk_tree_view_scroll_to_point(n3, -1, nArray[0]);
                } else {
                    OS.gtk_tree_view_get_path_at_pos(n3, point.x, point.y + gdkRectangle.height, nArray2, null, null, null);
                    if (nArray2[0] != 0) {
                        OS.gtk_tree_view_scroll_to_cell(n3, nArray2[0], 0, false, 0.0f, 0.0f);
                        OS.gtk_tree_path_free(nArray2[0]);
                        nArray2[0] = 0;
                    }
                    OS.gtk_tree_view_get_path_at_pos(n3, point.x, point.y, nArray2, null, null, null);
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = n4;
        }
        if ((n2 & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandIndex = -1;
        } else if (n4 != -1 && this.expandIndex == n4 && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                OS.gtk_tree_view_expand_row(n3, nArray2[0], false);
                this.expandBeginTime = 0L;
                this.expandIndex = -1;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 1000L;
            this.expandIndex = n4;
        }
        if (nArray2[0] != 0) {
            n = -1;
            if ((n2 & 1) != 0) {
                n = 2;
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                n = 1;
            }
            if (n != -1) {
                OS.gtk_tree_view_set_drag_dest_row(n3, nArray2[0], n);
            } else {
                OS.gtk_tree_view_set_drag_dest_row(n3, 0, 0);
            }
        } else {
            OS.gtk_tree_view_set_drag_dest_row(n3, 0, 0);
        }
        if (nArray2[0] != 0) {
            OS.gtk_tree_path_free(nArray2[0]);
        }
    }
}

