/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.configuration.AddExtensionDialog;
import org.tizen.packagemanager.ui.configuration.ConfigurationDialog;
import org.tizen.packagemanager.ui.configuration.ExtRepoCheckboxColumnLabelProvider;
import org.tizen.packagemanager.ui.configuration.ExtRepoDetailView;
import org.tizen.packagemanager.ui.configuration.InstallOptionConfigView;
import org.tizen.packagemanager.ui.page.custom.CustomImageButton;
import org.tizen.packagemanager.ui.page.custom.CustomTableIconButton;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

class ExtensionConfigView
extends Composite {
    private static final Logger logger = Log.getLogger(ExtensionConfigView.class);
    private ArrayList<ExtensionInformation> extensionList;
    private WizardUIResourceHandler uiRsrcHandler;
    private final int COL_RESIZE_MIN_WIDTH = 1;
    private final int CHECK_COLUMN_INDEX = 2;
    private final int REPOSITORY_COLUMN_INDEX = 1;
    private HashMap<Item, CustomTableIconButton> checkButtons;
    private HashMap<String, Boolean> lastCheckButtonState;
    private String lastSelectedItemExtId;
    private String lastSelectedAboveItemExtId;
    private CustomImageButton addBtn;
    private CustomImageButton modifyBtn;
    private CustomImageButton removeBtn;
    private TableViewer repoTableViewer;
    private Table repoTable;
    private DefaultToolTip toolTip;
    private ConfigurationDialog configDialog;
    private ExtRepoDetailView extRepoDetailView;
    private Composite parent;
    private InstallOptionConfigView installOptionView;
    private boolean isFirst;
    private Button btnConfirm;

    ExtensionConfigView(ConfigurationDialog configDialog, InstallOptionConfigView instOption, Composite parent) {
        super(parent, 0);
        logger.info("Intializing...");
        this.parent = parent;
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        this.configDialog = configDialog;
        this.installOptionView = instOption;
        this.btnConfirm = configDialog.getConfirmButton();
        this.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.extensionList = new ArrayList();
        this.checkButtons = new HashMap();
        this.lastCheckButtonState = new HashMap();
        GridData gd = new GridData(4, 4, true, false);
        this.setLayoutData(gd);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginTop = 0;
        this.setLayout(gridLayout);
        this.createMiddleComposites(this);
        this.initializeData();
        this.setEventHandlers();
        this.cacheCheckButton();
        this.isFirst = true;
        this.repoTable.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent arg0) {
                if (ExtensionConfigView.this.isFirst) {
                    ExtensionConfigView.this.isFirst = false;
                    if (ExtensionConfigView.this.repoTable.getItemCount() > 2 && ExtensionConfigView.this.extensionList.size() > 2) {
                        ExtensionConfigView.this.setSelectItem(2);
                        ExtensionConfigView.this.setSelectItem(0);
                    } else {
                        ExtensionConfigView.this.setSelectItem(0);
                    }
                }
            }
        });
    }

    private void createMiddleComposites(Composite parent) {
        this.createExtensionRepoListComposites(parent);
        this.createExtensionRepoInfoComposites(parent);
    }

    private void createExtensionRepoListComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_GRID);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 0;
        gridLayout.verticalSpacing = rect.height;
        container.setLayout(gridLayout);
        this.createExtensionRepoListControlButtons(container);
        this.createRepositoryTableComposite(container);
    }

    private void createExtensionRepoListControlButtons(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(131072, 4, true, true);
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_IMG_BUTTON);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = rect.x;
        container.setLayout(gridLayout);
        this.addBtn = new CustomImageButton(container, 0);
        this.addBtn.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ADD_NORMAL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ADD_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ADD_SEL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ADD_DIS));
        gd = new GridData(131072, 0x1000000, true, true);
        gd.widthHint = rect.width;
        gd.heightHint = rect.height;
        this.addBtn.setLayoutData(gd);
        this.addBtn.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.modifyBtn = new CustomImageButton(container, 0);
        this.modifyBtn.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_EDIT_NORMAL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_EDIT_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_EDIT_SEL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_EDIT_DIS));
        gd = new GridData(131072, 0x1000000, true, true);
        gd.widthHint = rect.width;
        gd.heightHint = rect.height;
        this.modifyBtn.setLayoutData(gd);
        this.modifyBtn.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.modifyBtn.setEnabled(false);
        this.removeBtn = new CustomImageButton(container, 0);
        this.removeBtn.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_REMOVE_NORMAL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_REMOVE_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_REMOVE_SEL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_REMOVE_DIS));
        gd = new GridData(131072, 0x1000000, true, true);
        gd.widthHint = rect.width;
        gd.heightHint = rect.height;
        this.removeBtn.setLayoutData(gd);
        this.removeBtn.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.removeBtn.setEnabled(false);
    }

    private void createRepositoryTableComposite(Composite parent) {
        Composite repositoryTableRow = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, false, true);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_TABLE);
        gd.widthHint = rect.width;
        gd.heightHint = rect.height;
        repositoryTableRow.setLayoutData(gd);
        repositoryTableRow.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.repoTableViewer = new TableViewer(repositoryTableRow, 68352);
        this.repoTable = this.repoTableViewer.getTable();
        this.repoTableViewer.setUseHashlookup(true);
        this.repoTable.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.repoTableViewer.setContentProvider(new IStructuredContentProvider(){

            @Override
            public void dispose() {
            }

            @Override
            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }

            @Override
            public Object[] getElements(Object input) {
                ArrayList elements = (ArrayList)input;
                return elements.toArray();
            }
        });
        this.repoTable.setHeaderVisible(true);
        this.configureTableColumns(repositoryTableRow);
        this.toolTip = new DefaultToolTip(this.repoTableViewer.getControl());
        this.toolTip.setBackgroundColor(new Color(this.getDisplay(), 255, 255, 225));
        this.toolTip.setForegroundColor(new Color(this.getDisplay(), 0, 0, 0));
    }

    private void configureTableColumns(Composite parent) {
        TableColumnLayout columnLayout = new TableColumnLayout();
        parent.setLayout(columnLayout);
        Rectangle rectColumn = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_TABLE_COLUMN);
        TableViewerColumn nameClmn = new TableViewerColumn(this.repoTableViewer, 16384);
        nameClmn.getColumn().setWidth(rectColumn.y);
        nameClmn.getColumn().setText("Name");
        nameClmn.getColumn().setResizable(true);
        final TableColumn nameColumn = nameClmn.getColumn();
        nameClmn.getColumn().addListener(11, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                if (nameColumn.getWidth() < 1) {
                    nameColumn.setWidth(1);
                }
            }
        });
        nameClmn.setLabelProvider(new CellLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                TableItem tableItem = (TableItem)cell.getViewerRow().getItem();
                ExtensionInformation extRepo = (ExtensionInformation)tableItem.getData();
                cell.setText(extRepo.getName());
            }
        });
        columnLayout.setColumnData(nameClmn.getColumn(), new ColumnPixelData(rectColumn.y));
        TableViewerColumn repositoryClmn = new TableViewerColumn(this.repoTableViewer, 16384);
        int repoWidth = PlatformUtil.isWindows() ? rectColumn.width - 15 : rectColumn.width;
        repositoryClmn.getColumn().setWidth(repoWidth);
        repositoryClmn.getColumn().setText("Repository");
        repositoryClmn.getColumn().setResizable(true);
        final TableColumn repoColumn = repositoryClmn.getColumn();
        repositoryClmn.getColumn().addListener(11, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                if (repoColumn.getWidth() < 1) {
                    repoColumn.setWidth(1);
                }
            }
        });
        repositoryClmn.setLabelProvider(new CellLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                TableItem tableItem = (TableItem)cell.getViewerRow().getItem();
                ExtensionInformation extRepo = (ExtensionInformation)tableItem.getData();
                if (ExtRepositoryManager.getInstance().isLocalFileExtRepo(extRepo)) {
                    cell.setText("Local cached");
                } else {
                    cell.setText(extRepo.getRepository());
                }
                if (extRepo.getError() != null) {
                    cell.setBackground(Display.getDefault().getSystemColor(3));
                } else {
                    cell.setBackground(ExtensionConfigView.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
                }
            }
        });
        columnLayout.setColumnData(repositoryClmn.getColumn(), new ColumnPixelData(repoWidth));
        TableViewerColumn checkClmn = new TableViewerColumn(this.repoTableViewer, 0x1000000);
        checkClmn.getColumn().setText("Activation");
        checkClmn.getColumn().setWidth(rectColumn.x);
        checkClmn.getColumn().setResizable(false);
        checkClmn.setLabelProvider(new ExtRepoCheckboxColumnLabelProvider(this));
        if (PlatformUtil.isWindows()) {
            columnLayout.setColumnData(checkClmn.getColumn(), new ColumnPixelData(rectColumn.x));
        } else {
            columnLayout.setColumnData(checkClmn.getColumn(), new ColumnWeightData(100, rectColumn.x));
        }
    }

    private void createExtensionRepoInfoComposites(Composite parent) {
        Composite viewContainer = new Composite(parent, 0);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_INFO_BOX);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = rect.height;
        viewContainer.setLayoutData(gd);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = rect.y;
        viewContainer.setLayout(gridLayout);
        viewContainer.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.extRepoDetailView = new ExtRepoDetailView(viewContainer, 2048);
        gd = new GridData(4, 4, true, true);
        this.extRepoDetailView.setLayoutData(gd);
        this.extRepoDetailView.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
    }

    public void initializeData() {
        this.loadRepositoryInformations();
        this.setSelectItem(0);
    }

    private void setEventHandlers() {
        this.addBtn.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                ExtensionConfigView.this.onClickAddButton();
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.modifyBtn.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                if (ExtensionConfigView.this.modifyBtn.isEnabled()) {
                    ExtensionConfigView.this.onClickModifyButton();
                }
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.removeBtn.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                if (ExtensionConfigView.this.removeBtn.isEnabled()) {
                    ExtensionConfigView.this.onClickRemoveButton();
                }
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.setRepositoryTableEventListener();
    }

    private void setRepositoryTableEventListener() {
        this.repoTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                for (CustomTableIconButton button : ExtensionConfigView.this.getAllTableIconButtons()) {
                    Rectangle bounds = button.getBounds();
                    if (bounds == null || !bounds.contains(pt)) continue;
                    button.handleMouseUpEvent(event);
                    ExtensionConfigView.this.cacheCheckButton();
                    break;
                }
            }

            @Override
            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                for (CustomTableIconButton button : ExtensionConfigView.this.getAllTableIconButtons()) {
                    Rectangle bounds = button.getBounds();
                    if (bounds == null || !bounds.contains(pt)) continue;
                    button.handleMouseDownEvent(event);
                    break;
                }
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.repoTable.addMouseMoveListener(new MouseMoveListener(){

            @Override
            public void mouseMove(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                for (CustomTableIconButton button : ExtensionConfigView.this.getAllTableIconButtons()) {
                    button.handleMouseMoveEvent(pt);
                }
                ExtensionConfigView.this.handleMouseMoveEvent(pt);
            }
        });
        this.repoTable.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent e) {
                ExtensionConfigView.this.repoTable.setFocus();
            }

            @Override
            public void mouseExit(MouseEvent e) {
                if (!PlatformUtil.isMacOS()) {
                    ExtensionConfigView.this.handleMouseMoveEvent(null);
                }
                ExtensionConfigView.this.parent.setFocus();
            }

            @Override
            public void mouseEnter(MouseEvent e) {
                ExtensionConfigView.this.repoTable.setFocus();
            }
        });
        this.repoTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection sel = (IStructuredSelection)e.getSelection();
                ExtensionInformation selected = (ExtensionInformation)sel.getFirstElement();
                ExtensionConfigView.this.extRepoDetailView.updateRepositoryInformation(selected);
                if (selected != null && ExtRepositoryManager.getInstance().isRemoteExtensionRepository(selected.getId())) {
                    ExtensionConfigView.this.modifyBtn.setEnabled(false);
                    ExtensionConfigView.this.removeBtn.setEnabled(false);
                } else {
                    ExtensionConfigView.this.modifyBtn.setEnabled(true);
                    ExtensionConfigView.this.removeBtn.setEnabled(true);
                }
            }
        });
    }

    private void handleMouseMoveEvent(Point pt) {
        if (pt == null) {
            return;
        }
        TableItem tableItem = this.repoTable.getItem(pt);
        if (tableItem == null || tableItem.getData() == null) {
            this.toolTip.deactivate();
            return;
        }
        ExtensionInformation extRepo = (ExtensionInformation)tableItem.getData();
        Rectangle repoRect = tableItem.getBounds(1);
        if (repoRect.contains(pt) && extRepo != null && extRepo.getError() != null) {
            this.toolTip.activate();
            this.toolTip.setText(extRepo.getError().getMessage());
        } else {
            this.toolTip.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClickAddButton() {
        this.cacheLastStatus();
        AddExtensionDialog dialog = new AddExtensionDialog(this.getShell(), null, this.extensionList);
        this.parent.setEnabled(false);
        this.configDialog.setFileDialogOpened(true);
        try {
            dialog.open();
        }
        catch (Exception e) {
            logger.throwing(e);
        }
        finally {
            this.parent.setEnabled(true);
            this.configDialog.setFileDialogOpened(false);
        }
        this.repoTable.setRedraw(false);
        this.repoTableViewer.setInput(new ArrayList());
        this.repoTableViewer.setInput(this.extensionList);
        this.applyLastStatus();
        this.repoTable.setRedraw(true);
        this.btnConfirm.setEnabled(true);
        this.cacheCheckButton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClickModifyButton() {
        this.cacheLastStatus();
        ExtensionInformation selectedRepo = (ExtensionInformation)((IStructuredSelection)this.repoTableViewer.getSelection()).getFirstElement();
        AddExtensionDialog dialog = new AddExtensionDialog(this.getShell(), selectedRepo.getId(), this.extensionList);
        this.parent.setEnabled(false);
        this.configDialog.setFileDialogOpened(true);
        try {
            dialog.open();
        }
        catch (Exception e) {
            logger.throwing(e);
        }
        finally {
            this.parent.setEnabled(true);
            this.configDialog.setFileDialogOpened(false);
        }
        this.repoTable.setRedraw(false);
        this.repoTableViewer.setInput(new ArrayList());
        this.repoTableViewer.setInput(this.extensionList);
        this.applyLastStatus();
        this.repoTable.setRedraw(true);
        this.btnConfirm.setEnabled(true);
        this.cacheCheckButton();
    }

    private void onClickRemoveButton() {
        this.cacheLastStatus();
        ExtensionInformation extInfo = (ExtensionInformation)((IStructuredSelection)this.repoTableViewer.getSelection()).getFirstElement();
        this.extensionList.remove(extInfo);
        if (ExtRepositoryManager.getInstance().isLocalFileExtRepo(extInfo)) {
            ExtRepositoryManager.getInstance().removeFromCache(extInfo.getId());
        }
        this.repoTable.setRedraw(false);
        this.repoTableViewer.setInput(new ArrayList());
        this.repoTableViewer.setInput(this.extensionList);
        this.applyLastStatus();
        this.repoTable.setRedraw(true);
        this.btnConfirm.setEnabled(true);
        this.cacheCheckButton();
    }

    public void onClickConfirmButton() {
        for (ExtensionInformation extInfo : this.extensionList) {
            if (this.lastCheckButtonState.containsKey(extInfo.getId())) {
                Boolean isChecked = this.lastCheckButtonState.get(extInfo.getId());
                extInfo.setActivateStatus(isChecked);
                continue;
            }
            extInfo.setActivateStatus(false);
        }
        ExtRepositoryManager.getInstance().updateRepositories(this.extensionList);
        ExtRepositoryManager.getInstance().writeToFile(this.extensionList);
        this.configDialog.setCheckExtRepository(true);
        this.configDialog.setRefreshNeeded(true);
        this.configDialog.okPressed();
    }

    public void onClickCancleButton() {
        if (!this.installOptionView.isSameDistribution()) {
            try {
                ExtRepositoryManager.getInstance().init(true);
            }
            catch (UMException e) {
                e.printStackTrace();
            }
        }
    }

    public ArrayList<CustomTableIconButton> getAllTableIconButtons() {
        ArrayList<CustomTableIconButton> result = new ArrayList<CustomTableIconButton>();
        int count = this.repoTableViewer.getTable().getItemCount();
        for (int i = 0; i < count; ++i) {
            TableItem tableItem = this.repoTableViewer.getTable().getItem(i);
            result.add(this.getCheckButton(tableItem));
        }
        return result;
    }

    private void loadRepositoryInformations() {
        if (this.extensionList.size() > 0) {
            this.extensionList.clear();
        }
        for (ExtensionInformation extInfo : ExtRepositoryManager.getInstance().getCurrentExtensions()) {
            this.extensionList.add(extInfo);
        }
        this.repoTableViewer.setInput(this.extensionList);
    }

    private void cacheLastStatus() {
        this.cacheCheckButton();
        this.cacheLastSelectedItem();
    }

    private void applyLastStatus() {
        this.applyCachedCheckButton();
        this.applyCachedLastSelectedItem();
    }

    private void cacheLastSelectedItem() {
        this.lastSelectedItemExtId = null;
        this.lastSelectedAboveItemExtId = null;
        IStructuredSelection sel = (IStructuredSelection)this.repoTableViewer.getSelection();
        if (sel != null && sel.size() > 0) {
            TableItem tableItem;
            String itemId;
            ExtensionInformation selected = (ExtensionInformation)sel.getFirstElement();
            this.lastSelectedItemExtId = selected.getId();
            TableItem[] arr$ = this.repoTable.getItems();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !this.lastSelectedItemExtId.equals(itemId = ((ExtensionInformation)(tableItem = arr$[i$]).getData()).getId()); ++i$) {
                this.lastSelectedAboveItemExtId = itemId;
            }
        }
    }

    private void cacheCheckButton() {
        this.lastCheckButtonState.clear();
        for (ExtensionInformation extInfo : this.extensionList) {
            CustomTableIconButton button = null;
            for (TableItem tableItem : this.repoTable.getItems()) {
                if (!extInfo.getId().equals(((ExtensionInformation)tableItem.getData()).getId())) continue;
                button = this.getCheckButton(tableItem);
                break;
            }
            boolean isChecked = false;
            if (button != null && button.isChecked()) {
                isChecked = true;
            }
            this.lastCheckButtonState.put(extInfo.getId(), isChecked);
        }
    }

    private void applyCachedLastSelectedItem() {
        if (this.lastSelectedItemExtId != null && this.lastSelectedItemExtId.length() > 0) {
            TableItem selecItem = this.findItemFromExtId(this.lastSelectedItemExtId);
            if (selecItem != null) {
                this.setSelectItem(selecItem);
            } else if (this.lastSelectedAboveItemExtId != null && this.lastSelectedAboveItemExtId.length() > 0) {
                TableItem selecAboveItem = this.findItemFromExtId(this.lastSelectedAboveItemExtId);
                if (selecAboveItem != null) {
                    this.setSelectItem(selecAboveItem);
                } else {
                    this.setSelectItem(0);
                }
            } else {
                this.setSelectItem(0);
            }
        } else {
            this.setSelectItem(0);
        }
    }

    private void applyCachedCheckButton() {
        block0: for (ExtensionInformation extInfo : this.extensionList) {
            CustomTableIconButton button = null;
            for (TableItem tableItem : this.repoTable.getItems()) {
                if (!extInfo.getId().equals(((ExtensionInformation)tableItem.getData()).getId())) continue;
                Boolean isChecked = this.lastCheckButtonState.get(extInfo.getId());
                button = this.getCheckButton(tableItem);
                if (button == null || isChecked == null) continue block0;
                button.setChecked(isChecked);
                continue block0;
            }
        }
    }

    private void setSelectItem(int index) {
        if (this.repoTable.getItemCount() > index && this.extensionList.size() > index) {
            ExtensionInformation selExtInfo = this.extensionList.get(index);
            this.repoTable.setSelection(index);
            this.extRepoDetailView.updateRepositoryInformation(selExtInfo);
            if (selExtInfo != null && ExtRepositoryManager.getInstance().isRemoteExtensionRepository(selExtInfo.getId())) {
                this.modifyBtn.setEnabled(false);
                this.removeBtn.setEnabled(false);
            } else {
                this.modifyBtn.setEnabled(true);
                this.removeBtn.setEnabled(true);
            }
        } else {
            this.extRepoDetailView.updateRepositoryInformation(null);
            this.modifyBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
        }
    }

    private TableItem findItemFromExtId(String findExtId) {
        TableItem findItem = null;
        for (TableItem tableItem : this.repoTable.getItems()) {
            if (!findExtId.equals(((ExtensionInformation)tableItem.getData()).getId())) continue;
            findItem = tableItem;
            break;
        }
        return findItem;
    }

    private void setSelectItem(TableItem selItem) {
        if (selItem != null && this.repoTable.getItemCount() > 0 && this.extensionList.size() > 0) {
            ExtensionInformation selExtInfo = null;
            for (ExtensionInformation extInfo : this.extensionList) {
                if (!extInfo.getId().equals(((ExtensionInformation)selItem.getData()).getId())) continue;
                selExtInfo = extInfo;
                break;
            }
            if (selExtInfo != null) {
                this.repoTable.setSelection(selItem);
                this.extRepoDetailView.updateRepositoryInformation(selExtInfo);
                if (selExtInfo != null && ExtRepositoryManager.getInstance().isRemoteExtensionRepository(selExtInfo.getId())) {
                    this.modifyBtn.setEnabled(false);
                    this.removeBtn.setEnabled(false);
                } else {
                    this.modifyBtn.setEnabled(true);
                    this.removeBtn.setEnabled(true);
                }
            } else {
                this.setSelectItem(0);
            }
        } else {
            this.setSelectItem(0);
        }
    }

    public CustomTableIconButton getCheckButton(Item tableItem) {
        CustomTableIconButton button = this.checkButtons.get(tableItem);
        if (button == null) {
            button = new CustomTableIconButton(tableItem, 2, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_OFF, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_OFF, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_OFF, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_ON, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_ON, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_ON);
            this.checkButtons.put(tableItem, button);
            button.addMouseClickEventListener(new CustomTableIconButton.IClickEventListener(){

                @Override
                public void onClick(CustomTableIconButton parentBtn) {
                    ExtensionConfigView.this.btnConfirm.setEnabled(true);
                }
            });
        }
        return button;
    }
}

