/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.monitor;

import java.util.ArrayList;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.exception.ProgressLog;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.util.Log;
import org.tizen.packagemanager.ui.page.ProgressItem;
import org.tizen.packagemanager.ui.page.ProgressTabView;
import org.tizen.packagemanager.ui.page.ProgressTableView;
import org.tizen.packagemanager.ui.page.ViewController;
import org.tizen.packagemanager.ui.page.monitor.TotalProgressMonitor;

public class InstallProgressMonitor
implements ICommonProgressMonitor {
    private static final Logger logger = Log.getLogger(InstallProgressMonitor.class);
    private boolean isCanceled = false;
    private boolean isDone = false;
    private boolean isFailed = false;
    private boolean isPause = false;
    private ICommonProgressMonitor.ProgressMonitorType progressMonitorType = ICommonProgressMonitor.ProgressMonitorType.NONE;
    private ProgressTableView tableView = null;
    private ProgressItem progressItem = null;
    private Component component = null;
    private Exception error = null;
    private ArrayList<ICommonProgressMonitor> group = null;
    private int currentWorked = 0;
    private Long workingSize = 0L;
    private double rate = 0.0;
    private TotalProgressMonitor totalMonitor;

    public InstallProgressMonitor(ProgressItem progressItem, ProgressTabView parentView, ICommonProgressMonitor.ProgressMonitorType progressMonitorType) {
        assert (logger != null);
        this.progressItem = progressItem;
        this.tableView = parentView.getProgressTableView();
        this.component = progressItem.getComponent();
        this.workingSize = this.component.getInstallSize();
        this.totalMonitor = TotalProgressMonitor.getInstance(parentView);
        this.totalMonitor.addWorkingMonitor(this);
        this.group = new ArrayList();
        this.group.add(this);
        this.progressMonitorType = progressMonitorType;
    }

    @Override
    public void init() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TableItem tableItem = InstallProgressMonitor.this.tableView.getTableItemByComponent(InstallProgressMonitor.this.component);
                InstallProgressMonitor.this.tableView.setProgressText(tableItem, "");
            }
        });
    }

    @Override
    public void beginTask(String title, int totalWork) {
        this.totalMonitor.setRemainingTime();
    }

    @Override
    public synchronized void done() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                InstallProgressMonitor.this.isDone = true;
                TableItem tableItem = InstallProgressMonitor.this.tableView.getTableItemByComponent(InstallProgressMonitor.this.component);
                if (InstallProgressMonitor.this.component.getError() == null) {
                    InstallProgressMonitor.this.progressItem.setProgress(100);
                    InstallProgressMonitor.this.tableView.setItemProgress(tableItem);
                } else if (InstallProgressMonitor.this.isCanceled) {
                    InstallProgressMonitor.this.tableView.setItemCanceled(tableItem);
                } else {
                    InstallProgressMonitor.this.isFailed = true;
                    InstallProgressMonitor.this.tableView.setItemFailed(tableItem);
                }
                InstallProgressMonitor.this.totalMonitor.updateTotalWorked();
                ViewController.getInstance().getMainTabView().refresh(false);
                ViewController.getInstance().getExtendedTabView().refresh(false);
            }
        });
        this.totalMonitor.addDoneMonitor(this);
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean value) {
        if (!value || this.isCancelable()) {
            this.isCanceled = value;
            if (this.isCanceled) {
                this.progressItem.setProgress(0);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        InstallProgressMonitor.this.tableView.refreshTableItem(InstallProgressMonitor.this.progressItem);
                    }
                });
            }
        }
    }

    public InstallProgressMonitor getParentMonitor() {
        return null;
    }

    @Override
    public void worked(int work) {
        this.currentWorked = work;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TableItem tableItem = InstallProgressMonitor.this.tableView.getTableItemByComponent(InstallProgressMonitor.this.component);
                InstallProgressMonitor.this.totalMonitor.updateTotalWorked();
                if (InstallProgressMonitor.this.progressItem.getWorkType() == ProgressItem.WorkType.NONE && InstallProgressMonitor.this.component.getInstallState() == Component.InstallState.INSTALLING) {
                    InstallProgressMonitor.this.progressItem.setWorkingState(ProgressItem.WorkType.INSTALL);
                } else if (InstallProgressMonitor.this.progressItem.getWorkType() == ProgressItem.WorkType.NONE && InstallProgressMonitor.this.component.getInstallState() == Component.InstallState.UPDATING) {
                    InstallProgressMonitor.this.progressItem.setWorkingState(ProgressItem.WorkType.UPDATE);
                }
                InstallProgressMonitor.this.progressItem.setProgress(InstallProgressMonitor.this.currentWorked);
                InstallProgressMonitor.this.tableView.setItemProgress(tableItem);
            }
        });
    }

    @Override
    public void setError(Exception err) {
        if (this.error == null) {
            this.error = err;
        }
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    @Override
    public void setCancelable(boolean isCancelable) {
        this.progressItem.setCancelable(isCancelable);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                InstallProgressMonitor.this.tableView.refreshTableItem(InstallProgressMonitor.this.progressItem);
            }
        });
        if (!isCancelable) {
            for (ICommonProgressMonitor groupMonitor : this.getMonitorGroup()) {
                if (groupMonitor == this || !groupMonitor.isCancelable()) continue;
                groupMonitor.setCancelable(isCancelable);
            }
        }
    }

    @Override
    public boolean isCancelable() {
        return this.progressItem.isCancelable();
    }

    @Override
    public int getWorked() {
        return this.currentWorked;
    }

    @Override
    public void setProgress(String msg) {
        this.setProgress(msg, ProgressLog.LogType.INFO);
    }

    @Override
    public void setProgress(String msg, ProgressLog.LogType type) {
        if (type == ProgressLog.LogType.INFO) {
            logger.info(msg);
        } else if (type == ProgressLog.LogType.ERROR) {
            logger.error(msg);
        } else {
            logger.warn(msg);
        }
        this.component.addProgressLog(msg, type);
    }

    @Override
    public void setMonitorGroup(ArrayList<ICommonProgressMonitor> monitorGroup) {
        this.group = monitorGroup;
    }

    @Override
    public ArrayList<ICommonProgressMonitor> getMonitorGroup() {
        return this.group;
    }

    @Override
    public void setWorkingSize(Long size) {
        this.workingSize = size;
    }

    @Override
    public Long getWorkingSize() {
        return this.workingSize;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public double getRate() {
        return this.rate;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public boolean isFailed() {
        return this.isFailed;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public ICommonProgressMonitor.ProgressMonitorType getProgressMonitorType() {
        return this.progressMonitorType;
    }

    @Override
    public boolean isPause() {
        return this.isPause;
    }

    @Override
    public void setPause(boolean b) {
        this.isPause = b;
    }
}

