/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.Install;

import java.io.File;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.Install.IInstallUninstallPackageProgressMonitor;
import org.tizen.manager.core.Install.InstallUninstallPackageProgressMonitor;
import org.tizen.manager.core.Install.PackageInstaller;
import org.tizen.manager.core.Install.PackageUninstaller;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.core.UMNullProgressMonitor;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.exception.ProgressLog;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.ShellParser;
import org.tizen.manager.util.ShellUtil;

public class ManagerableInstallerCallable
implements Callable<Void> {
    private Package pkg;
    private String targetDir;
    private IInstallUninstallPackageProgressMonitor monitor;
    private Logger logger;
    private InstallController installController;
    private Thread workSmoothThread = null;
    private boolean success = false;

    public ManagerableInstallerCallable(Package pkg, String targetDir, IInstallUninstallPackageProgressMonitor installMonitor) {
        this.targetDir = targetDir;
        this.monitor = installMonitor;
        this.pkg = pkg;
        this.logger = Log.getLogger(ManagerableInstallerCallable.class);
        this.installController = InstallController.getInstance();
    }

    @Override
    public Void call() throws Exception {
        assert (this.monitor != null);
        try {
            PackageSet pkgSet;
            PackageManager packageManager = PackageManager.getInstance();
            PackageSet installedPkgs = packageManager.getInstalledPackages();
            if (!packageManager.isInstallablePackage(this.pkg.getPackageName())) {
                this.monitor.setProgress("This package is already installed by other thread!");
                Void void_ = null;
                return void_;
            }
            if (!this.pkg.isMeta()) {
                for (String depPkgName : this.pkg.getDependentPackageNames()) {
                    if (installedPkgs.getPackageByName(depPkgName) != null) continue;
                    throw new UMException(ErrorController.ErrorCode.DEPENDENT_PKGS_NOT_INSTALLED, depPkgName);
                }
            }
            if ((pkgSet = packageManager.getConflictPackages(this.pkg)).size() > 0) {
                this.monitor.setProgress("Removing the conflict package(s):\n" + pkgSet);
                for (Package pkgu : pkgSet) {
                    if (!installedPkgs.contains(pkgu)) continue;
                    PackageUninstaller pu = new PackageUninstaller();
                    InstallUninstallPackageProgressMonitor iupm = new InstallUninstallPackageProgressMonitor(pkgu, new UMNullProgressMonitor(){

                        @Override
                        public void setProgress(String msg, ProgressLog.LogType type) {
                            ManagerableInstallerCallable.this.monitor.setProgress(msg);
                        }
                    });
                    pu.uninstall(pkgu, iupm);
                }
            }
            this.monitor.removeOldWorked(100);
            this.logger.info("**** Install start => " + this.pkg + ", target => " + this.targetDir);
            String tempDir = PathUtil.get(this.targetDir, "temp", this.pkg.getPackageName());
            this.monitor.setProgress("Moving the files to the target directory...");
            PackageInstaller.moveToTargetDirectoryFromTempDirectory(tempDir, this.targetDir);
            if (!PackageInstaller.movePackageInstalledList(tempDir, this.pkg)) {
                throw new UMException(ErrorController.ErrorCode.FAILED_TO_WRITE_PACKAGE_INSTALL_LIST_FILE, this.pkg.getPackageName() + ".list");
            }
            this.monitor.setProgress("Checking the integrity of installed files...");
            PackageInstaller.checkAllFilesAreInstalledProperly(this.pkg, this.installController, this.monitor);
            this.monitor.moveFilesWorked(100);
            try {
                if (!this.executeInstallScript(this.pkg, this.monitor, tempDir)) {
                    this.logger.error("Fail to execute install script.");
                    PathUtil.remove(tempDir);
                    throw new UMException(ErrorController.ErrorCode.INSTALL_SCRIPT_ERROR, this.pkg.getPackageName());
                }
            }
            catch (UMException E) {
                throw new UMException(ErrorController.ErrorCode.INSTALL_SCRIPT_ERROR, this.pkg.getPackageName());
            }
            this.monitor.runScriptWorked(100);
            if (!PackageInstaller.moveRemoveScript(tempDir, this.pkg, this.monitor)) {
                PathUtil.remove(tempDir);
                throw new UMException(ErrorController.ErrorCode.SAVING_REMOVE_SCRIPT_FAILED, this.pkg.getPackageName());
            }
            PathUtil.remove(tempDir);
            this.monitor.setProgress("Updating the package's state to 'Installed'...");
            packageManager.addPackageToInstalledPackages(this.pkg);
            packageManager.saveInstalledList();
        }
        catch (Exception e) {
            this.logger.throwing(e);
            this.monitor.setError(e);
            ErrorController.setError(ErrorController.ErrorCode.FAILED_TO_INSTALL);
            throw e;
        }
        finally {
            this.removeTmpDir(this.targetDir);
            this.monitor.done();
        }
        return null;
    }

    private void removeTmpDir(String targetDir) {
        File tempFile;
        String tempDir = PathUtil.get(targetDir, "temp");
        if (tempDir != null && tempDir.length() > 0 && (tempFile = new File(tempDir)) != null && tempFile.isDirectory() && tempFile.list().length <= 0) {
            PathUtil.remove(tempDir);
        }
    }

    private boolean executeInstallScript(Package pack, final IInstallUninstallPackageProgressMonitor monitor, String tempDir) throws UMException {
        if (pack.getInstallScript() != null && !pack.getInstallScript().equals("")) {
            String command = PathUtil.get(tempDir, pack.getInstallScript());
            File scriptFile = new File(command);
            if (scriptFile.exists()) {
                this.logger.trace("\tExecute " + pack.getPackageName() + " install script");
                try {
                    monitor.setProgress("Executing the install-script...");
                    if (this.workSmoothThread == null) {
                        this.workSmoothThread = new Thread(){

                            @Override
                            public void run() {
                                int scriptWork = 0;
                                while (scriptWork < 90 && !ManagerableInstallerCallable.this.success && !monitor.getDone()) {
                                    monitor.runScriptWorked(scriptWork);
                                    scriptWork += 10;
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                ManagerableInstallerCallable.this.workSmoothThread = null;
                            }
                        };
                        this.workSmoothThread.start();
                    }
                    boolean result = false;
                    ShellParser parser = new ShellParser();
                    this.success = result = ShellUtil.executeScript(scriptFile, pack.getPackageName(), parser);
                    monitor.setProgress("Script Output:\n" + parser.getOutputMessage());
                    monitor.setProgress("Script ExitCode:\n" + parser.getExitCode());
                    boolean bl = result;
                    return bl;
                }
                catch (IMShellCommandFail e) {
                    this.logger.throwing(e);
                    throw new UMException(ErrorController.ErrorCode.INSTALL_SCRIPT_ERROR, pack.getPackageName());
                }
            }
            this.logger.trace("\t[" + pack.getPackageName() + "] does not have install script");
        }
        return true;
    }
}

