/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.Install;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.Install.IInstallUninstallPackageProgressMonitor;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageUtil;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ResourceUtil;
import org.tizen.manager.util.ShellParser;
import org.tizen.manager.util.ShellUtil;

public class PackageInstaller {
    private static Logger logger = Log.getLogger(PackageInstaller.class);

    public static void moveToTargetDirectoryFromTempDirectory(String tempDir, String targetDir) throws UMException {
        logger.trace("\tMove temp to target");
        logger.trace("FromDir : " + tempDir + "=> to dir : " + targetDir);
        File fromFile = new File(PathUtil.get(tempDir, File.separator, "data"));
        if (!fromFile.exists()) {
            logger.error("Data directory is not exist in package.");
            return;
        }
        File toFile = new File(targetDir);
        File[] fromList = fromFile.listFiles();
        if (fromList == null) {
            logger.error("Copying the files to target directory failed. Removing temp directory...");
            PathUtil.remove(tempDir);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL_FILES_TO_TARGET_FOLDER, "'data' is not directory type!");
        }
        for (int i = 0; i < fromList.length; ++i) {
            boolean ret = false;
            ret = PlatformUtil.isLinux() ? PathUtil.copyHardLink(fromList[i], toFile, false) : (PlatformUtil.isWindows() ? PathUtil.move(fromList[i], new File(toFile, fromList[i].getName())) : (PlatformUtil.isMacOS() ? PathUtil.move(fromList[i], new File(toFile, fromList[i].getName())) : PathUtil.copyHardLink(fromList[i], toFile, false)));
            if (ret) continue;
            logger.error("Copying the files to target directory failed. Removing temp directory...");
            PathUtil.remove(tempDir);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_INSTALL_FILES_TO_TARGET_FOLDER, fromList[i].getAbsolutePath());
        }
    }

    public static boolean movePackageInstalledList(String tempDir, Package pack) {
        File packageListFile = new File(tempDir + File.separator + pack.getPackageName() + ".list");
        if (packageListFile.exists()) {
            File packageListTo = new File(PackageUtil.getInstalledFileListPath(pack));
            packageListTo.getParentFile().mkdirs();
            if (packageListTo.exists() && !packageListTo.delete()) {
                logger.error("Fail to delete file ==> " + packageListTo);
            }
            if (!PathUtil.moveFile(packageListFile, packageListTo)) {
                logger.error("Cannot move the package file list to targetDir => " + pack.getPackageName());
                return false;
            }
        }
        return true;
    }

    public static void checkAllFilesAreInstalledProperly(Package pack, InstallController installController, IInstallUninstallPackageProgressMonitor monitor) throws UMException {
        FileInputStream is;
        ArrayList<String> missingFiles;
        block14: {
            missingFiles = new ArrayList<String>();
            if (pack == null) {
                return;
            }
            File listFile = new File(PackageUtil.getInstalledFileListPath(pack));
            is = null;
            BufferedReader in = null;
            try {
                String line;
                is = new FileInputStream(listFile);
                in = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                installController.getDownloadTargetPath(pack);
                while ((line = in.readLine()) != null) {
                    File tmp = new File(PathUtil.getFromInstalledPath(line));
                    if (tmp.exists()) continue;
                    if (PlatformUtil.isWindows()) {
                        missingFiles.add(line);
                        logger.warn("\t'" + tmp + "' does not exist!.");
                        continue;
                    }
                    try {
                        int exitCode = ShellUtil.execute("ls " + tmp, null);
                        if (exitCode == 0) {
                            logger.trace("\t'" + tmp + "' has broken link but no problem");
                            continue;
                        }
                        logger.warn("\t'" + tmp + "' does not exist!.");
                        missingFiles.add(line);
                    }
                    catch (IMShellCommandFail e) {
                        logger.error("Failed to check file exists");
                        logger.throwing(e);
                    }
                }
                if (in == null) break block14;
            }
            catch (IOException e) {
                try {
                    logger.error("Installer.findMissingFiles() Cannot check file list: " + listFile.getAbsolutePath());
                    throw new UMException(ErrorController.ErrorCode.PACKAGE_INSTALL_LIST_FILE_NOT_FOUND);
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        ResourceUtil.closeObjectSilently(in);
                    }
                    if (is != null) {
                        ResourceUtil.closeObjectSilently(is);
                    }
                    throw throwable;
                }
            }
            ResourceUtil.closeObjectSilently(in);
        }
        if (is != null) {
            ResourceUtil.closeObjectSilently(is);
        }
        if (missingFiles != null && missingFiles.size() > 0) {
            logger.error("Some files are not moved properly: " + missingFiles);
            throw new UMException(ErrorController.ErrorCode.MISSING_FILES_WHICH_ARE_NOT_INSTALLED_FOUND, missingFiles.toString());
        }
        logger.info("All files moved properly.");
    }

    public static boolean executeInstallScript(Package pack, String tempDir) throws UMException {
        if (pack.getInstallScript() != null && !pack.getInstallScript().equals("")) {
            String command = PathUtil.get(tempDir, pack.getInstallScript());
            File scriptFile = new File(command);
            if (scriptFile.exists()) {
                logger.trace("\tExecute " + pack.getPackageName() + " install script");
                try {
                    boolean result = false;
                    ShellParser parser = new ShellParser();
                    boolean bl = result = ShellUtil.executeScript(scriptFile, pack.getPackageName(), parser);
                    return bl;
                }
                catch (IMShellCommandFail e) {
                    logger.throwing(e);
                    throw new UMException(ErrorController.ErrorCode.INSTALL_SCRIPT_ERROR, pack.getPackageName());
                }
            }
            logger.trace("\t[" + pack.getPackageName() + "] does not have install script");
        }
        return true;
    }

    public static boolean moveRemoveScript(String tempDir, Package pack, IInstallUninstallPackageProgressMonitor monitor) {
        File removeScriptFrom = new File(tempDir + File.separator + pack.getRemoveScript());
        if (pack.getRemoveScript() != null && !pack.getRemoveScript().equals("") && removeScriptFrom.exists()) {
            monitor.setProgress("Moving the remove-script of the package to .info directory...");
            File removeScriptTo = new File(PackageUtil.getRemoveScriptLocalPath(pack));
            if (!PackageInstaller.createRemoveScriptDir(removeScriptTo)) {
                logger.error("Cannot create remove script directory in Info directory => " + pack.getPackageName());
                return false;
            }
            if (removeScriptTo.exists() && !removeScriptTo.delete()) {
                logger.error("Fail to delete file ==> " + removeScriptTo);
            }
            if (!PathUtil.moveFile(removeScriptFrom, removeScriptTo)) {
                logger.error("Cannot move removeScript to targetDir => " + pack.getPackageName());
                return false;
            }
        }
        return true;
    }

    private static boolean createRemoveScriptDir(File removeScript) {
        File parentDir = removeScript.getParentFile();
        if (!parentDir.exists()) {
            return parentDir.mkdirs();
        }
        return true;
    }
}

